/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

public final class BinaryParser {
    private static final int NUM_BYTES = 4;
    private static final int NUM_BITS = 8;
    private static final int SYNCHSAFE_BITS = 7;

    public static boolean bitSet(byte by, int n) {
        boolean bl = false;
        if (n >= 0 && n < 8) {
            bl = (by & (byte)(1 << n)) != 0;
        }
        return bl;
    }

    public static boolean matchPattern(byte by, String string) {
        boolean bl = true;
        for (int i = 0; i < 8 && i < string.length() && bl; ++i) {
            if (string.charAt(i) == '1') {
                bl = bl && BinaryParser.bitSet(by, 8 - i - 1);
                continue;
            }
            if (string.charAt(i) != '0') continue;
            bl = bl && !BinaryParser.bitSet(by, 8 - i - 1);
        }
        return bl;
    }

    public static int convertToDecimal(byte by, int n, int n2) {
        byte by2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n2;
        if (n < 0 || n >= 8) {
            n4 = 0;
        }
        if (n2 < 0 || n2 >= 8) {
            n5 = 7;
        }
        if (n > n2) {
            n4 = n2;
            n5 = n;
        }
        for (int i = n4; i <= n5; ++i) {
            if (BinaryParser.bitSet(by, i)) {
                by2 = BinaryParser.setBit(by2, n3);
            }
            ++n3;
        }
        return by2;
    }

    public static int convertToInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length - 1;
        if (n3 >= 4) {
            n3 = 3;
        }
        for (int i = n3; i >= 0; --i) {
            for (int j = 0; j < 8; ++j) {
                if (BinaryParser.bitSet(byArray[i], j)) {
                    n = (int)((double)n + Math.pow(2.0, n2));
                }
                ++n2;
            }
        }
        return n;
    }

    public static int convertToSynchsafeInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length - 1;
        if (n3 >= 4) {
            n3 = 3;
        }
        for (int i = n3; i >= 0; --i) {
            for (int j = 0; j < 7; ++j) {
                if (BinaryParser.bitSet(byArray[i], j)) {
                    n = (int)((double)n + Math.pow(2.0, n2));
                }
                ++n2;
            }
        }
        return n;
    }

    public static byte[] convertToBytes(int n) {
        byte[] byArray = new byte[4];
        int n2 = n;
        boolean bl = false;
        for (int i = byArray.length - 1; i >= 0 && !bl; --i) {
            for (int j = 0; j < 8 && !bl; ++j) {
                if (n2 % 2 == 1) {
                    byArray[i] = BinaryParser.setBit(byArray[i], j);
                }
                bl = (n2 /= 2) == 0;
            }
        }
        return byArray;
    }

    public static byte[] convertToSynchsafeBytes(int n) {
        byte[] byArray = new byte[4];
        int n2 = n;
        boolean bl = false;
        for (int i = byArray.length - 1; i >= 0 && !bl; --i) {
            for (int j = 0; j < 7 && !bl; ++j) {
                if (n2 % 2 == 1) {
                    byArray[i] = BinaryParser.setBit(byArray[i], j);
                }
                bl = (n2 /= 2) == 0;
            }
        }
        return byArray;
    }

    public static byte setBit(byte by, int n) {
        byte by2 = 0;
        if (n >= 0 && n < 8) {
            by2 = (byte)(by | (byte)(1 << n));
        }
        return by2;
    }
}

