/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlGui.tag.ui;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Vector;
import javazoom.jlGui.tag.OggVorbisInfo;

public class OggVorbisDialog
extends Dialog
implements ActionListener {
    private OggVorbisInfo _vorbisinfo = null;
    private Button _close = null;

    public OggVorbisDialog(String string, int n, int n2, int n3, int n4, OggVorbisInfo oggVorbisInfo) {
        super(new Frame(), string, true);
        this._vorbisinfo = oggVorbisInfo;
        this.setSize(n3, n4);
        this.setLocation(n, n2);
        this._close = new Button("Close");
        this._close.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setFont(new Font("Helvetica", 0, 11));
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        Label label = new Label("File/URL : " + this._vorbisinfo.getLocation());
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        Label label2 = new Label("Standard Tags");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        Label label3 = new Label("File/Stream info");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.add(label3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        Panel panel = new Panel();
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        Panel panel2 = new Panel();
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.add(panel2);
        panel.setLayout(new GridLayout(1, 2, 0, 1));
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 1, 0, 1));
        TextArea textArea = new TextArea();
        panel3.add(textArea);
        if (this._vorbisinfo.getTitle() != null && !this._vorbisinfo.getTitle().equals("")) {
            textArea.append("Title=" + this._vorbisinfo.getTitle() + "\n");
        }
        if (this._vorbisinfo.getArtist() != null && !this._vorbisinfo.getArtist().equals("")) {
            textArea.append("Artist=" + this._vorbisinfo.getArtist() + "\n");
        }
        if (this._vorbisinfo.getAlbum() != null && !this._vorbisinfo.getAlbum().equals("")) {
            textArea.append("Album=" + this._vorbisinfo.getAlbum() + "\n");
        }
        if (this._vorbisinfo.getTrack() > 0) {
            textArea.append("Track=" + this._vorbisinfo.getTrack() + "\n");
        }
        if (this._vorbisinfo.getYear() != null && !this._vorbisinfo.getYear().equals("")) {
            textArea.append("Year=" + this._vorbisinfo.getYear() + "\n");
        }
        if (this._vorbisinfo.getGenre() != null && !this._vorbisinfo.getGenre().equals("")) {
            textArea.append("Genre=" + this._vorbisinfo.getGenre() + "\n");
        }
        Vector vector = this._vorbisinfo.getComment();
        int n5 = 0;
        while (n5 < vector.size()) {
            textArea.append((String)vector.elementAt(n5) + "\n");
            ++n5;
        }
        Panel panel4 = new Panel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        panel4.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 2;
        Label label4 = null;
        int n6 = Math.round(this._vorbisinfo.getPlayTime());
        int n7 = n6 / 60;
        int n8 = n6 - n7 * 60;
        label4 = new Label("Length : " + n7 + ":" + n8);
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        label4 = new Label("Average bitrate : " + this._vorbisinfo.getAverageBitrate() / 1000 + " kbps");
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        DecimalFormat decimalFormat = new DecimalFormat("#,###,###");
        label4 = new Label("File size : " + decimalFormat.format(this._vorbisinfo.getSize()) + " bytes");
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        label4 = new Label("Nominal bitrate : " + this._vorbisinfo.getBitRate() / 1000 + " kbps");
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        label4 = new Label("Max bitrate : " + this._vorbisinfo.getMaxBitrate() / 1000 + " kbps");
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        label4 = new Label("Min bitrate : " + this._vorbisinfo.getMinBitrate() / 1000 + " kbps");
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        label4 = new Label("Channel : " + this._vorbisinfo.getChannels());
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        label4 = new Label("Sampling rate : " + this._vorbisinfo.getSamplingRate() + " Hz");
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        label4 = new Label("Serial number : " + this._vorbisinfo.getSerial());
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        label4 = new Label("Version : " + this._vorbisinfo.getVersion());
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        label4 = new Label("Vendor : " + this._vorbisinfo.getVendor());
        panel4.add(label4);
        gridBagLayout2.setConstraints(label4, gridBagConstraints2);
        panel.add(panel3);
        panel.add(panel4);
        panel2.setLayout(new FlowLayout(1, 2, 4));
        panel2.add(this._close);
    }

    public OggVorbisInfo getOggVorbisInfo() {
        return this._vorbisinfo;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._close) {
            this.dispose();
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        OggVorbisInfo oggVorbisInfo = null;
        try {
            oggVorbisInfo = new OggVorbisInfo(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        OggVorbisDialog oggVorbisDialog = new OggVorbisDialog("OggVorbis info", 0, 0, 470, 340, oggVorbisInfo);
        oggVorbisDialog.show();
    }
}

