/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import org.tritonus.sampled.file.MpegEncoding;
import org.tritonus.sampled.file.MpegFileFormatType;
import org.tritonus.sampled.file.TAudioFileFormat;
import org.tritonus.sampled.file.TAudioFileReader;

public class MpegAudioFileReader
extends TAudioFileReader {
    private final boolean DEBUG = false;
    private final int SYNC = -2097152;
    private final AudioFormat.Encoding[][] sm_aEncodings = new AudioFormat.Encoding[][]{{MpegEncoding.MPEG2L1, MpegEncoding.MPEG2L2, MpegEncoding.MPEG2L3}, {MpegEncoding.MPEG1L1, MpegEncoding.MPEG1L2, MpegEncoding.MPEG1L3}, {MpegEncoding.MPEG2DOT5L1, MpegEncoding.MPEG2DOT5L2, MpegEncoding.MPEG2DOT5L3}};

    public AudioFileFormat getAudioFileFormat(File file) throws IOException, UnsupportedAudioFileException {
        int filelength = (int)file.length();
        return this.getAudioFileFormat(new BufferedInputStream(new FileInputStream(file)), null, filelength);
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        return this.getAudioFileFormat(inputStream, null, -1);
    }

    private AudioFileFormat getAudioFileFormat(InputStream inputStream, byte[] abHeader, int mediaLength) throws IOException, UnsupportedAudioFileException {
        int cVersion;
        PushbackInputStream pis = new PushbackInputStream(inputStream, 4096);
        byte[] head = new byte[4];
        pis.read(head);
        if (!(head[0] == 73 | head[0] == 105 && head[1] == 67 | head[1] == 99 && head[2] == 89 | head[2] == 121)) {
            if (head[0] == 79 | head[0] == 111 && head[1] == 71 | head[1] == 103 && head[2] == 71 | head[2] == 103) {
                throw new UnsupportedAudioFileException("Ogg stream found");
            }
            pis.unread(head);
        }
        int nVersion = -1;
        int nLayer = -1;
        int nSFIndex = -1;
        int nMode = -1;
        int FrameSize = -1;
        int nFrameSize = -1;
        int nFrequency = -1;
        int nTotalFrames = -1;
        float FrameRate = -1.0f;
        int BitRate = -1;
        int nChannels = -1;
        int nHeader = -1;
        int nTotalMS = -1;
        AudioFormat.Encoding encoding = null;
        try {
            Bitstream m_bitstream = new Bitstream((InputStream)pis);
            Header m_header = m_bitstream.readFrame();
            nVersion = m_header.version();
            nLayer = m_header.layer();
            nSFIndex = m_header.sample_frequency();
            nMode = m_header.mode();
            nChannels = nMode == 3 ? 1 : 2;
            FrameSize = m_header.calculate_framesize();
            if (FrameSize < 0) {
                throw new UnsupportedAudioFileException("Invalid FrameSize : ".concat(String.valueOf(String.valueOf(FrameSize))));
            }
            nFrequency = m_header.frequency();
            FrameRate = (float)(1.0 / (double)m_header.ms_per_frame() * 1000.0);
            if (FrameRate < 0.0f) {
                throw new UnsupportedAudioFileException("Invalid FrameRate : ".concat(String.valueOf(String.valueOf(FrameRate))));
            }
            if (mediaLength != -1) {
                nTotalFrames = m_header.max_number_of_frames(mediaLength);
            }
            BitRate = Header.bitrates[nVersion][nLayer - 1][m_header.bitrate_index()];
            nHeader = m_header.getSyncHeader();
            encoding = this.sm_aEncodings[nVersion][nLayer - 1];
            if (mediaLength != -1) {
                nTotalMS = Math.round(m_header.total_ms(mediaLength));
            }
        }
        catch (Exception e) {
            throw new UnsupportedAudioFileException("not a MPEG stream:".concat(String.valueOf(String.valueOf(e.getMessage()))));
        }
        if (abHeader != null) {
            abHeader[3] = (byte)(nHeader & 0xFF);
            abHeader[2] = (byte)(nHeader >> 8 & 0xFF);
            abHeader[1] = (byte)(nHeader >> 16 & 0xFF);
            abHeader[0] = (byte)(nHeader >> 24 & 0xFF);
        }
        if ((cVersion = nHeader >> 19 & 3) == 1) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong version");
        }
        int cSFIndex = nHeader >> 10 & 3;
        if (cSFIndex == 3) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong sampling rate");
        }
        AudioFormat format = new AudioFormat(encoding, nFrequency, -1, nChannels, -1, FrameRate, true);
        return new TAudioFileFormat((AudioFileFormat.Type)new MpegFileFormatType(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(MpegFileFormatType.MP3))).append("x").append(BitRate).append("x").append(nTotalMS).append("x").append(FrameSize))), "mp3"), format, nTotalFrames, mediaLength);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws IOException, UnsupportedAudioFileException {
        BufferedInputStream BinputStream = new BufferedInputStream(inputStream);
        BinputStream.mark(4096);
        byte[] abHeader = new byte[4];
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(BinputStream, abHeader, -1);
        try {
            BinputStream.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new AudioInputStream(BinputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }
}

