/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JFileChooser;

public class Frames
extends Frame {
    Color bgcolor = Color.lightGray;
    static Label processedFile = null;
    TextField installPath = null;
    static int processBarValue = 0;
    boolean showProcessBar = false;
    Unpack unpack = new Unpack(this);
    WarningDialog wd = null;

    public Frames() {
        Conf.numFiles = this.unpack.getNumFiles();
        try {
            if (Conf.licenseText == null) {
                this.initPathFrame();
            } else {
                this.initLicenseFrame();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initLicenseFrame() {
        this.removeAll();
        this.setLayout(null);
        this.setTitle("XEP Setup: License Agreement");
        ((Component)this).setBackground(this.bgcolor);
        this.setResizable(false);
        Label label = new Label();
        label.setText("Please read the following license agreement.");
        label.setLocation(10, 25);
        label.setSize(400, 20);
        this.add(label);
        TextArea textArea = new TextArea();
        Font font = new Font("Monospaced", 0, 12);
        textArea.setFont(font);
        textArea.setBackground(Color.white);
        textArea.setText(Conf.licenseText);
        textArea.setLocation(10, 50);
        textArea.setSize(580, 300);
        this.add(textArea);
        Button button = new Button("Yes, I accept");
        button.setLocation(200, 365);
        button.setSize(90, 20);
        this.add(button);
        Button button2 = new Button("No, I decline");
        button2.setLocation(310, 365);
        button2.setSize(90, 20);
        this.add(button2);
        this.show();
    }

    public void initPathFrame() {
        this.removeAll();
        this.setLayout(null);
        this.setTitle("XEP Setup: Installation Directory");
        ((Component)this).setBackground(this.bgcolor);
        this.setResizable(false);
        Label label = new Label();
        Label label2 = new Label();
        label2.setText("This program installs XEP " + Conf.VERSION + " Edition on your computer.");
        label2.setLocation(20, 30);
        label2.setSize(400, 20);
        label.setText("Install XEP to the following directory:");
        label.setLocation(20, 60);
        label.setSize(200, 20);
        this.add(label);
        this.add(label2);
        int n = 87;
        this.installPath = new TextField(Conf.installPath, 40);
        this.installPath.setLocation(45, n);
        this.installPath.setSize(400, 20);
        this.add(this.installPath);
        if (Conf.hasSwing) {
            Button button = new Button("Browse");
            button.setLocation(465, n);
            button.setSize(60, 20);
            this.add(button);
            Button button2 = new Button("Ok");
            button2.setLocation(535, n);
            button2.setSize(40, 20);
            this.add(button2);
        } else {
            Button button = new Button("Ok");
            button.setLocation(495, n);
            button.setSize(60, 20);
            this.add(button);
        }
        this.show();
    }

    private void initInstallFrame() {
        this.removeAll();
        this.setLayout(null);
        this.setTitle("XEP Setup: Copying Files");
        ((Component)this).setBackground(this.bgcolor);
        this.setResizable(false);
        Label label = new Label();
        label.setText("Copying Files");
        label.setLocation(20, 60);
        label.setSize(200, 20);
        this.add(label);
        processedFile = new Label();
        processedFile.setText("");
        processedFile.setLocation(40, 80);
        processedFile.setSize(500, 20);
        this.add(processedFile);
    }

    public void paint(Graphics graphics) {
        if (this.showProcessBar) {
            graphics.setColor(Color.white);
            graphics.drawRect(20, 105, 560, 20);
            graphics.setColor(Color.darkGray);
            graphics.drawRect(20, 105, 559, 19);
            graphics.setColor(Color.gray);
            graphics.drawRect(21, 106, 558, 18);
            if (processBarValue != 0) {
                graphics.setColor(Color.blue);
                graphics.fillRect(22, 107, (int)((double)((float)processBarValue / (float)Conf.numFiles) * 556.0), 17);
            }
        }
    }

    private void initFinishMessages() {
        Label label = new Label();
        label.setText("XEP installation successful");
        label.setAlignment(1);
        label.setLocation(200, 320);
        label.setSize(200, 20);
        this.add(label);
        Button button = new Button("Finish");
        button.setLocation(270, 360);
        button.setSize(60, 20);
        this.add(button);
        this.show();
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof Button && event.arg != null) {
            if (event.arg.toString().startsWith("No") || event.arg.toString().equals("Finish")) {
                if (event.arg.toString().startsWith("No")) {
                    System.out.println("XEP setup cancelled");
                }
                System.exit(0);
            } else if (event.arg.toString().startsWith("Yes")) {
                try {
                    this.initPathFrame();
                }
                catch (Exception exception) {
                    System.out.println("Error: " + exception);
                }
            } else if (event.arg.toString().equals("Ok")) {
                Conf.installPath = this.installPath.getText();
                if (this.testInstallPath()) {
                    try {
                        this.initInstallFrame();
                        this.showProcessBar = true;
                        this.show();
                        this.repaint();
                        this.unpack.setPath(Conf.installPath);
                        this.unpack.start();
                    }
                    catch (Exception exception) {
                        System.out.println("Error: " + exception);
                    }
                }
            } else if (event.arg.toString().equals("Browse") && Conf.hasSwing) {
                this.initFileChooser();
            }
        }
        if (event.id == 201) {
            if (processBarValue != Conf.numFiles) {
                System.out.println("XEP setup cancelled");
            }
            System.exit(0);
        }
        return super.handleEvent(event);
    }

    private void initFileChooser() {
        JFileChooser jFileChooser = new JFileChooser(new File(Conf.installPath).getParent());
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            try {
                File file = new File(string);
                Conf.installPath = file.exists() && file.isFile() ? file.getParent() : string;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.installPath.setText(Conf.installPath);
            this.installPath.repaint();
            this.testInstallPath();
        }
        jFileChooser.show();
    }

    public Dimension minimumSize() {
        return new Dimension(600, 400);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    private boolean testInstallPath() {
        File file = new File(Conf.installPath);
        if (!file.isDirectory() && !file.mkdir()) {
            this.showWarning("Direcory '" + Conf.installPath + "' can not be created");
            return false;
        }
        return true;
    }

    static void processedFile(String string) {
        processedFile.setText(" " + string);
        processedFile.repaint();
    }

    void increaseProcessBar() {
        this.repaint();
        if (++processBarValue == Conf.numFiles) {
            this.initFinishMessages();
        }
    }

    public void showWarning(String string) {
        this.wd = null;
        this.wd = new WarningDialog(this, string);
        int n = (600 - this.wd.getBounds().width) / 2;
        int n2 = (400 - this.wd.getBounds().height) / 2;
        ((Component)this.wd).setLocation(this.getBounds().x + n, this.getBounds().y + n2);
        this.wd.show();
    }

    public static void main(String[] stringArray) {
        Frames frames = new Frames();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - 600) / 2;
        int n2 = (dimension.height - 400) / 2;
        ((Component)frames).setLocation(n, n2);
        frames.pack();
        frames.show();
    }

    class WarningDialog
    extends Dialog {
        Button okbutton;
        Label label;

        WarningDialog(Frame frame, String string) {
            super(frame, "Warning", true);
            this.setTitle("Warning");
            Panel panel = new Panel();
            this.label = new Label(string);
            panel.add(this.label);
            this.add("Center", panel);
            Panel panel2 = new Panel();
            panel2.setLayout(new FlowLayout(1));
            this.okbutton = new Button("OK");
            panel2.add(this.okbutton);
            this.add("South", panel2);
            this.pack();
        }

        public boolean handleEvent(Event event) {
            if (event.id == 1001 && event.target == this.okbutton) {
                ((Component)this).setVisible(false);
            }
            if (event.id == 201) {
                ((Component)this).setVisible(false);
            }
            return super.handleEvent(event);
        }
    }
}

