#!/usr/bin/perl

###############################################################################
#
# U_Init.pl - User editing functions
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: U_Init.pl,v 1.46.2.3 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if ($ARGV[0] eq "-v" || $ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

1;

############################################
#
# User Add Functions
#
############################################

sub addtodb {
	local($addid) = @_;
	local($status) = 0;
	local($dbfile, @errFileCont, $value, $errfile);
	
	# Make changes in database.
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/"  . $DBFILE_USERINFO;

	$dbphoto = $addid . ".gif";
	$dbphoto2 = $dbphoto;
	$dbphoto2 =~ s/\.gif$/\.jpg/i;

	# $U_ProfileText =~ s/\"/\&quot\;/g;
	$value = $U_SUID . "\\t" . $U_Pass . "\\t" . $U_NameFirst . "\\t" . $U_NameLast . "\\t" . $U_NamePref . "\\t" . $U_Email . "\\t" . $U_Phone . "\\t" . $U_Perms . "\\t" . $U_C_Sect . "\\t" . $dbphoto . "," . $dbphoto2 . "\\t" . $U_Classify . "\\t" . $U_ProfileText . "\\t" . $U_Sig . "\\t" . $U_HideEmail;
	
	$value = &Escape($value);
	
	$status = 0;
	if (-e $dbfile && ! -w $dbfile) {
		$status = "Error: Unable to write to file: $dbfile . Check file " .
					"permissions and try again.";
		return ($status);
	}

	$errfile = "./." . $addid . "." . time();
	if (!open(setDBf, "| $setDB $dbfile -thash -q -k \"$addid\" -o $errfile")) {
		$status = "Error: Unable to open file: $dbfile . Check file " .
					"permissions and try again.";
		return ($status);
	}
	
	print setDBf $value;
	
	if (!close(setDBf)) {
		#$status = "Error: Unable to close file: $dbfile . Check file " .
		#			"permissions and try again.";
	}
	
	# Check for error output from setDB
	if (-e $errfile) {
		open(errf, $errfile);
		@errFileCont = <errf>;
		close(errf);
		unlink($errfile);
		
		if ($errFileCont[0] =~ /^ERROR/) {
			if ($errFileCont[0] =~ /Max\ Users\ Exceeded/) {
				# Delete user that was just added
				# Actually the user should NOT have been added.
				# &delfromdb($addid);
			}
			return ($errFileCont[0]);
		}
	}
	
	# @retval = `$setDB $dbfile -thash -q -k \"$addid\" -d \"$value\"`;
	# $status = &dbErrorCheck($?, $retval[0]);
	# if ($status) {
	#	&showErrorBackHTML("$status<p>Unable to add $addid to Users database: $dbfile. Check file permissions and try again.", 1);
	#	exit();
	#}
	
	return ($status);
}

sub addtoht {
	local($newid, $U_C_Sect) = @_;
	local ($i, $j, $l, $found, $found2);
	
	if ($C_authtype =~ /cookies/i) {
		# Using cookies. return
		return(1);
	}
	
	# this doesn't work correctly.
	return(1);
	
	###################################################################
	# Get the .htgroup file info
	
	if ($C_authtype =~ /webauth/ || $C_authtype =~ /apache/) {
		push(@htfiles, $C_rootpath . "/.htgroup");
		if ($C_Public && $C_authtype =~ /webauth/) {
			push(@accfiles, $C_rootpath . "/.webauth.priv");
		} else {
			push(@accfiles, $C_rootpath . "/.htaccess");
		}
	}
	
	if ($C_authtype =~ /webauth/ && $C_authtype =~ /apache/) {
		# push(@htfiles, $C_rootpath . "/.bagroup");
		push(@accfiles, $C_rootpath . "/.baaccess");
	}
	
	# Get the section number
	($junk, $sectnum) = split(/\:/, $U_C_Sect);
	$sectnamenum = $C_Sects{$sectnum}{"name"};
	($junk, $sectnamenum) = split(/\s+/, $sectnamenum);
	
	$sectname = $C_Sects{$sectnum}{"name"};
	$sectname = "Section_" . $sectnum;
	($junk, $origsectnum) = split(/\:/, $origsect);
	$origsectname = "Section_" . $origsectnum;
	$origsectname =~ s/\s/_/;
	
	for ($l=0; $l < @htfiles; $l++) {
		# $htgroup = $C_rootpath . "/.htgroup";
		$htgroup = $htfiles[$l];
		
		$fh = &lockFileRead($htgroup);
		open(ht, $htgroup);
		@groups = <ht>;
		close(ht);
		&lockFileUn($fh);

		$found = 0;
		for ($i=0; $i < @groups; $i++) {
			($thegroup, $users) = split(/\:/, $groups[$i]);
			$users =~ s/\s+/ /g;
			if ($thegroup eq $sectname) {
				$found = 1;
				if($groups[$i] !~ /\s$newid\s/) {
					$groups[$i] = $thegroup . ":" . " $newid " . $users;
				}
			} elsif ($thegroup eq $origsectname) {
				# Remove the user from this group
				$groups[$i] =~ s/\s$getuser(\s)/$1/;
			}
		}
	
		$found = 0;
		if (!$found) {
			$len = @groups;
			$groups[$len] = "Section_" . $sectnum . ": " . $newid . " ";
		
			# Have to modify .htaccess too
			$accf = $accfiles[$l];
			$fh = &lockFileRead($accf);
			open(a, "$accf");
			@allowed = <a>;
			close(a);
			&lockFileUn($fh);
		
			$found2 = 0;
			for ($i=0; $i < @allowed; $i++) {
				if ($allowed[$i] =~ $sectname) {
					$found2 = 1;
				}
				if ($allowed[$i] =~ /^require/i) {
					$lastindex = $i;
				}
			}
		
			if (!$found2) {
				$allowed[$lastindex] .= "require group $sectname\n";
			
				$fh = &lockFileWrite($accf);
				open (a, ">$accf");
				print a @allowed;
				close (a);
				&lockFileUn($fh);
			}
		
		}
	
		# Output the new htgroup file
		$fh = &lockFileWrite($htgroup);
		open(ht, ">$htgroup");
		for ($j=0; $j < @groups; $j++) {
			if ($groups[$j] =~ /\n$/) {
				print ht $groups[$j];
			} else {
				print ht $groups[$j], "\n";
			}
		}
		close(ht);
		&lockFileUn($fh);
	}
	
	# Now edit the .htpasswd file
	if ($C_authtype =~ /apache/) {
		#if ($C_authtype =~ /webauth/) {
		#	$U_Passfile = $C_rootpath . "/.bapasswd";
		#} else {
			$U_Passfile = $C_rootpath . "/.htpasswd";
		#}
		
		$fh = &lockFileRead($U_Passfile);
		open(pwf, $U_Passfile);
		@ul = <pwf>;
		close(pwf);
		&lockFileUn($fh);
		
		# crypt the password.
		if (($isWin && $isApache) || $C_EncryptUserPass) {
			$crypted = $U_Pass;
		} else {
			$crypted = &cryptPass($U_Pass);
		}
		
		$found = 0;
		for ($i=0; $i < @ul; $i++) {
			if ($ul[$i] =~ /$newid\:/) {
				$ul[$i] = $newid . ":" . $crypted . "\n";
				$found=1;
			}
		}
		
		if (!$found) {
			push(@ul, $newid . ":" . $crypted . "\n");
		}
		
		$fh = &lockFileWrite($U_Passfile);
		open(pwf, ">$U_Passfile");
		for ($j=0; $j < @ul; $j++) {
			if ($ul[$j] =~ /\n$/) {
				print pwf $ul[$j];
			} else {
				print pwf $ul[$j], "\n";
			}
		}
		close(pwf);
		&lockFileUn($fh);
	}
	
	return(1);
	
	#
	##########################################################
}

sub addphoto {
	##########################################################
	# Add user photo
	
	local($newid, $dontoverwrite) = @_;
	
	&procUserPhoto;
	
	$gif = $C_photodir . $U_PhotoName;
	$jpg = $C_photodir . $U_PhotoNameLarge;
	
	$linktogif = $C_photodir . "Tester_" . $sectnamenum . ".gif";
	$linktojpg = $C_photodir . "Tester_" . $sectnamenum . ".jpg";
	if (! -e $linktogif) {
		$linktogif = $C_photodir . "Guest.gif";
	}
	if (! -e $linktojpg) {
		$linktojpg = $C_photodir . "Guest.jpg";
	}
	
	if (! -e $gif) {
		$gif = $linktogif;
	}
	if (! -e $jpg) {
		$jpg = $linktojpg;
	}
	
	# So now what is the new name of this image?
	$newg = $C_photodir . $newid . ".gif";
	$newj = $C_photodir . $newid . ".jpg";
	
	if ($dontoverwrite) {
		if (! -e $newg) {
			&copy($gif, $newg);
		}
		if (! -e $newj) {
			&copy($jpg, $newj);
		}
	} else {
		&copy($gif, $newg);
		&copy($jpg, $newj);
	}

	#
	##########################################################	
}

sub addtomail {
	local ($newid) = @_;
	local($j);

	if ($U_Classify =~ /student/i || $U_Classify == 1) {
		$listfile = $C_listdir . "/" . $C_Sects{$sectnum}{"email"};
		if (-e $listfile && $newid ne "Anonymous" && $newid ne "Guest") {
			open(mf, $listfile);
			@mlist = <mf>;
			close(mf);
		
			$mfound = 0;
			for ($j=0; $j < @mlist; $j++) {
				if ($mlist[$j] =~ /$U_Email/) {
					$mfound = 1;
				}
			}
		
			if (!$mfound) {
				$len = @mlist;
				if ($U_NamePref eq "") { $U_NamePref = $U_NameFirst; }
				$mlist[$len] = "$U_NamePref $U_NameLast <$U_Email>\n";
			}	
			
			# Rewrite mailing list file		
			open (mf, ">$listfile");
			for ($j=0; $j < @mlist; $j++) {
				if ($mlist[$j] =~ /\n/) {
					print mf $mlist[$j];
				} else {
					print mf $mlist[$j], "\n";
				}
			}
			close(mf);
	
		} elsif (-e $C_listdir) {
			# Mailing list does not exist, but directory does. Create file
			open (mf, ">$listfile");
			print mf "$U_NamePref $U_NameLast <$U_Email>\n";
			close (mf);
		}

	}
	
	
	# If the user changed sections, remove them from the old section
	# mailing list. Also remove anyone without student classification
	
	if (($origsect ne $U_C_Sect || $origemail ne $U_Email || ($U_Classify !~ /student/i && $U_Classify != 1))) {
		$listfile = $C_listdir . "/" . $C_Sects{$origsectnum}{"email"};
		if (-e $listfile) {
			open(mf, $listfile);
			@oldlist = <mf>;
			close(mf);
			
			open(mf, ">$listfile");
			for ($j=0; $j < @oldlist; $j++) {
				if ($oldlist[$j] !~ /$origemail/) {
					if ($oldlist[$j] =~ /\n/) {
						print mf $oldlist[$j];
					} else {
						print mf $oldlist[$j], "\n";
					}
				}
			}
		}
	}
}

sub addToClassFac {
	local($facuser) = @_;
	local($dbfile, $j, $found, $status, $key, $value);
	
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;

	$found = 0;
	for ($j=1; $j <= $C_Fac_n; $j++) {
		if ($C_Sects{$j}{"login"} eq $facuser) {
			$found = 1;
		}
	}
	
	if (!$found) {
		$C_Fac_n++;
		
		@retval = `$setDB $dbfile -thash -k \"C_Fac_n\" -d \"$C_Fac_n\"`;
		$status = &dbErrorCheck($?, $retval[0]);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to update $dbfile. Check file permissions and try again.", 1);
			exit();
		}
		
		$key = "C_Fac_" . $C_Fac_n;
		if ($U_NamePref eq "") { $U_NamePref = $U_NameFirst; }
		$value = "$facuser\\t$U_NameFirst\\t$U_NameLast\\t$U_NamePref\\t";
	
		$retval = `$setDB $dbfile -thash -q -k \"$key\" -d \"$value\"`;
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to update $dbfile. Check file permissions and try again.", 1);
			exit();
		}
	}
}

sub userDBError {
	local ($errmsg) = @_;
	
	&showErrorBackHTML();
	
	if ($errmsg =~ /^ERROR/) {
		print "<b>", $FontSize2, $errmsg, "</font></b><p>\n";
		if ($errmsg =~ /License/ || $errmsg =~ /Address/ ||
								($errmsg =~ /Max/ && $errmsg =~ /Exceeded/)) {
		# License Error. Give links
		print "To upgrade or purchase a panFora license, go to ",
			"<a href=http://www.withinc.com target=_blank>",
			"http://www.withinc.com</a> .<p>\n";
		print "If you have a valid panFora license key, you can enter it in ",
			"the <a href=\"", $CGI_License, "?fid=", $Class, "\" target=_blank>",
			"License Key Entry Form</a>.<p>\n";
		print "If you are having problems with your license key, contact ",
			"wiTHinc technical support at: ",
			"<a href=\"mailto:$TechSupport\">$TechSupport</a>.<p>\n";
		}
	} else {
		print $errmsg, "<p>\n";
	}
	
	print "<p><a href=javascript:history.go(-1)>[Back]</a>\n";
	
	exit();
}
	
############################################
#
# User Delete Functions
#
############################################

sub delfromdb {
	local($deluser) = @_;
	local($status, $dbfile);
	
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;

	@retval = `$delDB $dbfile -thash -k \"$deluser\"`;
	$status = &dbErrorCheck($?, $retval[0]);
	if ($status) {
		&showErrorBackHTML("$status<p>Unable to delete $deluser from Users database: $dbfile.");
		exit();
	}
	
	return ($status);
}

sub delfromht {
	local($deluser) = @_;
	local ($i, $j);

	# Get the .htgroup file info
	$htgroup = $C_rootpath . "/.htgroup";
	if (-e $htgroup) {
		$fh = &lockFileRead($htgroup);
		open(ht, $htgroup);
		@groups = <ht>;
		close(ht);
		&lockFileUn($fh);
	
		$found = 0;
		for ($i=0; $i < @groups; $i++) {
			$groups[$i] =~ s/\s+$deluser(\s)/$1/g;
			$groups[$i] =~ s/\s+/ /g;
		}
	
		# Output the new htgroup file
	
		$fh = &lockFileWrite($htgroup);
		open(ht, ">$htgroup");
		for ($j=0; $j < @groups; $j++) {
			if ($groups[$j] =~ /\n/) {
				print ht $groups[$j];
			} else {
				print ht $groups[$j], "\n";
			}
		}
		close(ht);
		&lockFileUn($fh);
	}
	
	# Get the .htgroup file info
	$htpasswd = $C_rootpath . "/.htpasswd";
	if (-e $htpasswd) {
		$fh = &lockFileRead($htpasswd);
		open(ht, $htpasswd);
		@groups = <ht>;
		close(ht);
		&lockFileUn($fh);
	
		$found = 0;
		for ($i=0; $i < @groups; $i++) {
			if ($groups[$i] !~ /^$deluser\:/) {
				push(@newlist, $groups[$i]);
			}
		}
	
		$fh = &lockFileWrite($htpasswd);
		open(ht, ">$htpasswd");
		for ($j=0; $j < @newlist; $j++) {
			if ($newlist[$j] =~ /\n/) {
				print ht $newlist[$j];
			} else {
				print ht $newlist[$j], "\n";
			}
		}
		close(ht);
		&lockFileUn($fh);
	}
}

sub delphoto {
	local($deluser) = @_;
	$gif = $C_photodir . $U_PhotoName;
	$jpg = $C_photodir . $U_PhotoNameLarge;
	
	unlink($gif);
	unlink($jpg);	
}

sub delfrommail {
	local($deluser) = @_;
	local($j);

	($junk, $sectnum) = split(/\:/, $U_C_Sect);
	$listfile = $C_listdir . "/" . $C_Sects{$sectnum}{"email"};
	if (-e $listfile) {
		open(mf, $listfile);
		@mlist = <mf>;
		close(mf);

		$foundindex = -1;
		for ($j=0; $j < @mlist; $j++) {
			if ($mlist[$j] =~ /$U_Email/) {
				$foundindex = $j;
			}
		}
		
		if ($foundindex == -1) {
			# &showErrorHTML("User not found in Mailinglist file - $listfile");
		} else {
					
			splice(@mlist, $foundindex, 1);

			# Rewrite mailing list file		
			open (mf, ">$listfile");
			for ($j=0; $j < @mlist; $j++) {
				if ($mlist[$j] =~ /\n/) {
					print mf $mlist[$j];
				} else {
					print mf $mlist[$j], "\n";
				}
			}
			close(mf);
		}
	} 
}

sub delFromClassFac {
	local($facuser) = @_;
	local($dbfile, $j, $found, $status, $key, $value, $lastvalue);
	local($junk, @value);
	
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_CLASSINFO;

	for ($j=1; $j <= $C_Fac_n; $j++) {
		if ($C_Sects{$j}{"login"} eq $facuser) {
			# Need to replace this entry with the last entry.
			if ($j < $C_Fac_n) {
				$lastkey = "C_Fac_" . $C_Fac_n;
				
				($retval, @value) = split(/\t/, `$prtDB $dbfile -thash -k \"$lastkey\"`);
				$status = &dbErrorCheck($?, $retval);
				if ($status) {
					&showErrorBackHTML("$status<p>Unable to get $lastkey from $dbfile.");
					exit();
				}
				
				$lastvalue = join("\\t", @value);
			
				$C_Fac_n -= 1;
				$key = "C_Fac_" . $j;
				
				@retval = `$setDB $dbfile -thash -q -k \"$key\" -d \"$lastvalue\"`;
				$status = &dbErrorCheck($?, $retval[0]);
				if ($status) {
					&showErrorBackHTML("$status<p>Unable to put $key in $dbfile. Check file permissions and try again.", 1);
					exit();
				}
			
				# Now delete the last key
				@retval = `$delDB $dbfile -thash -k \"$lastkey\"`;
				$status = &dbErrorCheck($?, $retval[0]);
				if ($status) {
					&showErrorBackHTML("$status<p>Unable to delete $lastkey from $dbfile. Check file permissions and try again.", 1);
					exit();
				}
			} else {
				$C_Fac_n -= 1;
				$key = "C_Fac_" . $j;
				
				@retval = `$delDB $dbfile -thash -k \"$key\"`;
				$status = &dbErrorCheck($?, $retval[0]);
				if ($status) {
					&showErrorBackHTML("$status<p>Unable to delete $key from $dbfile. Check file permissions and try again.", 1);
					exit();
				}
			}
			last;
		}
	}
	
	@retval = `$setDB $dbfile -thash -k \"C_Fac_n\" -d \"$C_Fac_n\"`;
	$status = &dbErrorCheck($?, $retval[0]);
	if ($status) {
		&showErrorBackHTML("$status<p>Unable to put C_Fac_n in $dbfile. Check file permissions and try again.", 1);
		exit();
	}
}

###########################################################
#
# Rebuild Mailing Lists
#
###########################################################
#
# Mailing List handling isn't working properly, so rebuild all mailing lists
# After a user is changed.
#
# Also rebuild .htgroup file while we are at it

sub rebuildmailOLD {
	local($j, $DB_Key, $j, $f, $junk, $dbfile, $sectid, @elist);
	local($U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email);
	local($U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, @junk);
	local(@htg, $htfile, $htfile2);

	# Get the list of users
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
	
	if (! -e $dbfile) {
		return;
	}
	
	foreach (`$prtDB $dbfile -thash -a -q`) {
		($DB_Key, $U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email, $U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, @junk) = split(/\t/, &UnEscape($_));
		# Ignore errors. It just means there are no users.

		($junk, $sectid) = split(/\:/, $U_C_Sect);
		if (($U_Classify =~ /student/i || $U_Classify == 1) && $DB_Key ne "Anonymous" && $DB_Key ne "Guest") {
			push (@elist, $sectid . ":" . $U_NameFirst . " " . $U_NameLast . " <" . $U_Email . ">");
		}
		
		# Push the user into the htgroup list
		$htg[$sectid] .= " " . $DB_Key;
	}
	
	# Delete all existing section email lists
	for ($k=1; $k <= $C_Sect_n; $k++) {
		$f = $C_listdir . "/" . $C_Sects{$k}{"email"};
		unlink($f);
	}
	
	@elist = sort(@elist);
	@elist = &unique(@elist);
	
	for ($j=0; $j < @elist; $j++) {
		($sectnum, $addr) = split(/\:/, $elist[$j]);
		if ($j > 0) {
			($prevsectnum, $junk) = split(/\:/, $elist[$j-1]);
		}
		if ($j < @elist - 1) {
			($nextsectnum, $junk) = split(/\:/, $elist[$j+1]);
		}
		if ($j == 0 || $sectnum != $prevsectnum) {
			$listfile = $C_listdir . "/" . $C_Sects{$sectnum}{"email"};
		
			open(mf, ">$listfile");
		}
		
		print mf $addr, "\n";
		
		if ($j == @elist - 1 || $sectnum != $nextsectnum) {
			close(mf);
		}
	}
	
	# Now output the htgroup file.
	if ($C_authtype =~ /webauth/ || $C_authtype =~ /apache/) {
		$htfile = $C_rootpath . "/.htgroup";
		
		$fh = &lockFileWrite($htfile);
		open(f, ">$htfile");
		for ($j=0; $j < @htg; $j++) {
			if ($htg[$j] ne "") {
				print f "Section_" . $j . ":", $htg[$j], "\n";
			}
		}
		close(f);
		&lockFileUn($fh);
		
		#if ($C_authtype =~ /webauth/ && $C_authtype =~ /apache/) {
		#	$htfile2 = $C_rootpath . "/.bagroup";
		#	&copy($htfile, $htfile2);
		#}
	}
}

sub rebuildmail {
	&rebuildAllMailAndHT();
}

sub rebuildAllMailAndHT {
	local($j, $DB_Key, $f, $junk, $dbfile, $sectid, @elist);
	local($U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email);
	local($U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, @junk);
	local(@htg, $htfile, $htfile2, $i, @allUsers, $user);

	# Get the list of users
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
	
	if (! -e $dbfile) {
		return;
	}
	
	foreach (`$prtDB $dbfile -thash -a -q`) {
		($DB_Key, $U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email, $U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, @junk) = split(/\t/, &UnEscape($_));
		# Ignore errors. It just means there are no users.

		($junk, $sectid) = split(/\:/, $U_C_Sect);
		if (($U_Classify =~ /student/i || $U_Classify == 1) && $DB_Key ne "Anonymous" && $DB_Key ne "Guest") {
			push (@elist, $sectid . ":" . $U_NameFirst . " " . $U_NameLast . " <" . $U_Email . ">");
		}
		
		# Push the user into the htgroup list
		$htg[$sectid] .= " " . $DB_Key;
		
		# Push all users but Anonymous into htpasswd list
		if ($DB_Key ne "Anonymous") {
			push(@allUsers, $DB_Key);
			$allUsersPass{$DB_Key} = $U_Pass;
		}
	}
	
	# Delete all existing section email lists
	for ($k=1; $k <= $C_Sect_n; $k++) {
		$f = $C_listdir . "/" . $C_Sects{$k}{"email"};
		unlink($f);
	}
	
	@elist = sort(@elist);
	@elist = &unique(@elist);
	
	for ($j=0; $j < @elist; $j++) {
		($sectnum, $addr) = split(/\:/, $elist[$j]);
		if ($j > 0) {
			($prevsectnum, $junk) = split(/\:/, $elist[$j-1]);
		}
		if ($j < @elist - 1) {
			($nextsectnum, $junk) = split(/\:/, $elist[$j+1]);
		}
		if ($j == 0 || $sectnum != $prevsectnum) {
			$listfile = $C_listdir . "/" . $C_Sects{$sectnum}{"email"};
		
			open(mf, ">$listfile");
		}
		
		print mf $addr, "\n";
		
		if ($j == @elist - 1 || $sectnum != $nextsectnum) {
			close(mf);
		}
	}
	
	# Now output the htgroup file.
	if ($C_authtype =~ /webauth/ || $C_authtype =~ /apache/) {
		$htfile = $C_rootpath . "/.htgroup";
		
		$fh = &lockFileWrite($htfile);
		open(f, ">$htfile");
		for ($j=0; $j < @htg; $j++) {
			if ($htg[$j] ne "") {
				print f "Section_" . $j . ":", $htg[$j], "\n";
			}
		}
		close(f);
		&lockFileUn($fh);
	}
	
	# htaccess - No database lookups required, so just call function
	&rebuildhtaccess(".htaccess");
	if ($C_authtype =~ /apache/ && $C_authtype =~ /webauth/) {
		&rebuildhtaccess(".baaccess");
	}
	
	# htpasswd
	$fh = &lockFileWrite($C_rootpath . "/.htpasswd");
	open (hf, ">" . $C_rootpath . "/.htpasswd");
	
	@allUsers = sort(@allUsers);
	foreach $user (@allUsers) {
		if ($C_EncryptUserPass) {
			print hf $user, ":", $allUsersPass{$user}, "\n";
		} else {
			print hf $user, ":", &cryptPass($allUsersPass{$user}), "\n";
		}
	}
	
	close (hf);
	&lockFileUn($fh);
}

sub rebuildhtaccess {
	local($hta, $called) = @_;
	local($i, @hfd, $printed, $j);
	
	if (! -e $C_rootpath . "/" . $hta) {
		# Copy over blank ht file.
		if ($C_authtype =~ /cookie/i) {
			open (hf, "./$DIR_NEWCLASS/htcookies");
			@hfd = <hf>;
			close (hf);
		} elsif ($C_authtype =~ /webauth/i) {
			open (hf, "./$DIR_NEWCLASS/webauth");
			@hfd = <hf>;
			close (hf);
		} elsif ($C_authtype =~ /apache/i) {
			open (hf, "./$DIR_NEWCLASS/htaccess");
			@hfd = <hf>;
			close (hf);
		}
		
		@hfd = subhtStrings($Class, ".htgroup", ".htpasswd", @hfd);
		
		$fh = &lockFileWrite($C_rootpath . "/" . $hta);
		open (hf, ">" . $C_rootpath . "/" . $hta);
		print hf @hfd;
		close (hf);
		lockFileUn($fh);
	}
	
	$fh = &lockFileRead($C_rootpath . "/" . $hta);
	open (hf, $C_rootpath . "/" . $hta);
	@hfd = <hf>;
	close (hf);
	&lockFileUn($fh);
	
	$fh = &lockFileWrite($C_rootpath . "/" . $hta);
	open (hf, ">" . $C_rootpath . "/" . $hta);
	
	$printed = 0;
	for ($i=0; $i < @hfd; $i++) {
		if ($hfd[$i] =~ /^require/) {
			if (!$printed) {
				for ($j=1; $j <= $C_Sect_n; $j++) {
					print hf "require group Section_", $j, "\n";
				}
				$printed = 1;
			}
		} else {
			print hf $hfd[$i];
		}
	}

	close (hf);
	&lockFileUn($fh);
	
	if (!$printed && $C_authtype !~ /cookie/i && !$called) {
		# This can happen if the cookies .htaccess is still in place for
		# some reason
		if ($C_authtype =~ /webauth/) {
			open (hf, "./$DIR_NEWCLASS/webauth");
			@hfd = <hf>;
			close (hf);
		} else {
			open (hf, "./$DIR_NEWCLASS/htaccess");
			@hfd = <hf>;
			close (hf);
		}
		
		@hfd = subhtStrings($Class, ".htgroup", ".htpasswd", @hfd);
		
		$fh = &lockFileWrite($C_rootpath . "/" . $hta);
		open (hf, ">" . $C_rootpath . "/" . $hta);
		print hf @hfd;
		close (hf);
		lockFileUn($fh);
		
		&rebuildhtaccess($hta, 1);
	}
}

sub subhtStrings {
	local($Class, $htg, $htp, @hfd) = @_;
	local($i, $panForaURL);
	
	$panForaURL = &lookuppanForaURL;
	
	for ($i=0; $i < @hfd; $i++) {
		$hfd[$i] =~ s/GROUPS_FILE/$C_rootpath\/$htg/;
		$hfd[$i] =~ s/CLASS_TITLE/$C_title/;
		$hfd[$i] =~ s/PASSWD_FILE/$C_rootpath\/$htp/;
		$hfd[$i] =~ s/CLASS_ID/$Class/;
		$hfd[$i] =~ s/SELF_ADD_SCRIPT/$panForaURL\/$CGI_ForumUserAddSelf/;
	}
	
	return(@hfd);
}

sub rebuildhtpasswd {
	local($DB_Key, $U_SUID, $U_Pass, @junk);
	local($dbfile) = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
	
	$fh = &lockFileWrite($C_rootpath . "/.htpasswd");
	open (hf, ">" . $C_rootpath . "/.htpasswd");
	
	foreach (`$prtDB $dbfile -thash -a -q`) {
		($DB_Key, $U_SUID, $U_Pass, @junk) = split(/\t/, &UnEscape($_));
		# Ignore errors. It just means there are no users.

		if ($C_EncryptUserPass) {
			print hf $DB_Key, ":", $U_Pass, "\n";
		} else {
			print hf $DB_Key, ":", &cryptPass($U_Pass), "\n";
		}
	}
	
	close (hf);
	&lockFileUn($fh);
}

###########################################################
# Email account information to a new user or new password information
# to an existing user

sub emailUserAccountInfo {
	local($DB_Key, $admin) = @_;
	local($sendmail) = &lookupSendMail;
	local($FURLHOME);
	
	&lookupUser($DB_Key);
	
	$FURL = "http://" . $ENV{'SERVER_NAME'};
	if ($ENV{'SERVER_PORT'} ne "" && $ENV{'SERVER_PORT'} != 80) {
		$FURL .= ":" . $ENV{'SERVER_PORT'};
	}
	if (!$isWin) {
		$FURL .= $C_rooturl . "/";
		$FURLHOME = $FURL;
	} else {
		$FURLHOME = $FURL . $C_rooturl . "/";
	}
	$FURL .= $DIR_CGI . "/";
	$FURL .= $CGI_Forum . "?fid=" . $Class;

	open (M, "| $sendmail ");
	print M "To: $U_NameFirst $U_NameLast <$U_Email>\n";
	if ($admin eq "") {
		print M "From: panFora Administrator\n";
	} else {
		print M "From: panFora Administrator <$admin>\n";
	}
	print M "Subject: Your Account for $C_title\n";
	print M "MIME-Version: 1.0\n";
	print M "X-Mailer: panFora $Version\n";
	print M "Content-Type: multipart/alternative; ";
	print M "boundary=\"------------1234567890987654321\"\n\n";

	print M "This is a multi-part message in MIME format.\n\n";

	print M "--------------1234567890987654321\n";
	print M "Content-Type: text/plain; charset=us-ascii\n";
	print M "Content-Transfer-Encoding: 7bit\n\n";

	print M "Your login information for accessing the $Class Forum is:\n";
	print M "Login: $DB_Key\n";
	if ($C_authtype =~ /webauth/ && ($ENV{'SERVER_PORT'} == 80 || $ENV{'SERVER_PORT'} eq "")) {
		print M "Your password is your university account password.\n";
	} else {
		if ($C_EncryptUserPass) {
			if ($newpass ne "") {
				print M "Password: $newpass\n";
			} else {
				print M "Password: Your password is encrypted, and can not be sent via email.\n";
			}
		} else {
			print M "Password: $U_Pass\n";
		}
	}
	print M "\n";

	print M "Note that your username and password are both case sensitive.\n\n";

	print M "You can access the Forum Website using Netscape 4.0 or greater, ";
	print M "or \nMicrosoft Internet Explorer 4.0 or greater at:\n\n";

	print M $FURLHOME, "\n\n";

	print M "and the Forum, directly, at:\n\n";

	print M $FURL, "\n\n";

	print M "BE SURE TO READ THE HELP FILE!\n";
	print M "There are buttons for help in the Forum. Please use them, \n";
	print M "to take best advantage of all the available features!\n\n";
	
	print M "________________________________\n";
	print M "panFora - http://www.withinc.com\n\n";
	
	print M "--------------1234567890987654321\n";
	print M "Content-Type: text/html; charset=us-ascii\n";
	print M "Content-Transfer-Encoding: 7bit\n\n";

	print M "<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n";
	print M "<html>\n";
	print M "Your login information for accessing the $Class Forum is:<p>\n";
	print M "Login: <b>$DB_Key</b><br>\n";
	if ($C_authtype =~ /webauth/ && ($ENV{'SERVER_PORT'} == 80 || $ENV{'SERVER_PORT'} eq "")) {
		print M "Your password is <b>your university account password</b>.\n";
	} else {
		if ($C_EncryptUserPass) {
			if ($newpass ne "") {
				print M "Password: <b>$newpass</b>\n";
			} else {
				print M "Password: Your password is encrypted, and can not be sent via email.\n";
			}
		} else {
			print M "Password: <b>$U_Pass</b>\n";
		}
	}
	print M "<p>\n";

	print M "Note that your username and password are both case sensitive.<p>\n\n";

	print M "You can access the Forum Website using Netscape 4.0 or greater, ";
	print M "or \nMicrosoft Internet Explorer 4.0 or greater at:<p>\n\n";

	print M "&nbsp;&nbsp;&nbsp;<a href=\"$FURLHOME\">$FURLHOME</a><p>\n\n";

	print M "and the Forum, directly, at:<p>\n\n";

	print M "&nbsp;&nbsp;&nbsp;<a href=\"$FURL\">$FURL</a><p>\n\n";

	print M "BE SURE TO READ THE HELP FILE!<br>\n";
	print M "There are buttons for help in the Forum. Please use them, \n";
	print M "to take best advantage of all the available features!<p>\n\n";
	
	print M "________________________________<br>\n";
	print M "panFora - ";
	print M "<a href=\"http://www.withinc.com/\">http://www.withinc.com/</a><br>\n";
	print M "</html>\n\n";
	print M "--------------1234567890987654321--\n\n";
	
	
	close(M);
}

###########################################################

###########################################################
# Password generator

sub genPass {
	local($i, $p);
	# Generate a random 8 character password
	# The range of numbers and letters in ascii is 48-57, 65-90 and 97-122 
	srand();
	for ($i=0; $i < 8; $i++) {
		$num = rand(122);
		while($num < 48 || ($num > 57 && $num < 65) || ($num > 90 && $num < 97)) {
			$num = rand(122);
		}
		$p .= chr($num);
	}
	return($p);
}

###########################################################

###########################################################
# Clear out global user variables
sub clearUserData {
	$U_SUID = $U_Pass = $U_NameFirst = $U_NameLast = $U_NamePref = $U_Email = $U_Phone = $U_Perms = $U_C_Sect = $U_Photo = $U_PhotoLarge = $U_Classify = $U_ProfileText = $U_Sig = $U_EmailHide = "";
}
###########################################################

###########################################################
#
# Printing functions
#
###########################################################

# This is actually obsolete, but still called in _AFEdUserDel.cgi
# I'm too lazy to figure out if it is safe to delete.
sub printuserlist {
	local($sorting) = @_;
	local($i, $dbfile);
	local($U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email);
	local($U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, @junk);
	
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
	
	if (! -e $dbfile) {
		return;
	}
	
	foreach (`$prtDB $dbfile -thash -q -a`) {
		($DB_Key, $U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email, $U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, @junk) = split(/\t/, &UnEscape($_));
		
		push(@userids, $DB_Key);
		$CGIEnvUserlist{"$DB_Key"} = $DB_Key;
		
		$U_SUIDlist{"$U_SUID"} = $DB_Key;
		push(@allSUID, $U_SUID);
		
		$firstlist{"$U_NameFirst"} = $DB_Key;
		push(@allfirst, $U_NameFirst);
		
		$lastlist{"$U_NameLast"} = $DB_Key;
		push(@alllast, $U_NameLast);
		
		$allall{"$DB_Key"}{"SUID"} = $U_SUID;
		$allall{"$DB_Key"}{"firstname"} = $U_NameFirst;
		$allall{"$DB_Key"}{"lastname"} = $U_NameLast;
	}
	
	if ($sorting eq "" || $sorting eq "userid") {
		@thelist = sort(@userids);
		%showlist = %useridlist;
	} elsif ($sorting eq "SUID") {
		@thelist = sort(@allSUID);
		%showlist = %SUIDlist;
	} elsif ($sorting eq "firstname") {
		@thelist = sort(@allfirst);
		%showlist = %firstlist;
	} elsif ($sorting eq "lastname") {
		@thelist = sort(@alllast);
		%showlist = %lastlist;
	}
	
	$listlimit = 25;
	if ($menulimit ne "") { $listlimit = $menulimit;}
	$start = 0;
	$end = $start + $listlimit - 1;
	$listnum = 0;
	$listlen = @thelist;
		
	for ($i=0; $i < @thelist; $i++) {
		if ($i == $start) {
			if ($i != 0 ) {print "</select><br>\n";}
			print "<select name=getuser" , $listnum, ">\n";
			$listnum++;
			print "<option value=\"(NULL)\">";
			print "(", $thelist[$i], " - ";
			if ($end >= $listlen) { $end = $listlen - 1;}
			print $thelist[$end], ")\n";
			
			$start = $end + 1;
			$end = $start + $listlimit - 1;
		}
		
		print "<option value=\"", $showlist{"$thelist[$i]"}, "\"> ";
		if ($sorting eq "SUID") {
			print  $thelist[$i], " (", $showlist{"$thelist[$i]"}, ")\n";
		} elsif ($sorting eq "firstname") {
			print  $thelist[$i], " ", $allall{$showlist{"$thelist[$i]"}}{"lastname"}, "\n";
		} elsif ($sorting eq "lastname") {
			print  $thelist[$i], ", ", $allall{$showlist{"$thelist[$i]"}}{"firstname"}, "\n";
		} else {
			print  $thelist[$i];
		}
	}
}

sub printWarnChgEncrypted {
	print <<end_print;
	<script language=javascript>
	<!--
	var warned = 0;
	function warnEncryptedNewPass(field, user) {
		if (warned == 0) {
			var options = \"location=0,toolbar=0,menubar=0,resizable=1,scrollbars=1,width=250,height=150\";
			warnWin = window.open(\"\",\"Win\",options);
			warnWin.document.writeln(\'<html>$BodyTag\');
			warnWin.document.writeln(\"$FontSize $FontFace\");
			warnWin.document.writeln(\'$FontRed $FontSize2 Warning:</font></font>\');
			warnWin.document.writeln(\'You are changing the password for user: \' + user + \'.\');
			warnWin.document.writeln(\'The user will not be able to log in without the new password you are providing.\');
			warnWin.document.writeln(\'The \"Email Account Information\" checkbox has been checked, so that the user will be emailed the new password.<p>\');
			warnWin.document.writeln(\'The user\\\'s current password does not appear in the textbox because the password is encrypted.\');
			warnWin.document.writeln(\'To leave the current password unchanged, leave the password field empty.\');
			warnWin.document.writeln(\"<p><a href=# onClick=window.close()>$BtnClose</a>\");
			warnWin.document.close();
			warned = 1;
		}
		if (field.name.indexOf(".newpass") == -1) {
			document.forms[0].emailpassword.checked = true;
		} else {
			// var ind = field.name.indexOf(".newpass");
			// var user = field.name.substring(0, ind);
			var newfield = user + ".emailpassword";
			document.forms[0].elements[newfield].checked = true;
		}
	}
	// -->
	</script>
	
end_print
}

sub printphotochooser {
	print "<script language=javascript>\n";
	print "function PhotoChooser(user, size, mult) {\n";
	print " var theurl = \"$CGI_ForumEditUserPhoto\" + \"?getuser=\" + user + ";
	print "\"&smalllarge=\" + size + \"&fid=$Class\";\n";
	print "	if (mult == 1) { theurl += '&multiple=1';}\n";
	print "	var wid = 560;\n";
	print "	var hei = 460;\n";
	print "	var options = \"location=0,toolbar=0,menubar=0,resizable=1,scrollbars=1,width=\" + wid + \",height=\" + hei;\n";
	print "	photowin = window.open(theurl, 'photowin', options);\n";
	print "	photowin.focus();\n";
	print "}\n";
	print "</script>\n\n";

}

sub printuserdel {
	local($action) = @_;

	# Start Form
	print "<form action=$action method=POST>\n";
	
	# Special flag so we know what we are doing
	print "<input type=hidden name=func value=\"doedit\">\n\n";
	
	print "<input type=hidden name=fid value=\"$Class\">";
	print "<input type=hidden name=getuser value=\"$getuser\">\n\n";

	
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	
	print "<tr><td colspan=2>",$FontFace, $FontSize2;
	print "<b>Options for User: $U_NameFirst $U_NameLast ($getuser)</b>";
	print "</td></tr>\n";
	
	print "<tr><td colspan=2>$ImgClear88</td></tr>\n\n";
	
	print "<tr>";
	print "<td>";
	if ($Demo) {
		print $BtnFormUserCpDemo;
	} else {
		print $BtnFormUserCp;
	}
	print "</td>\n";
	print "<td>", $FontFace, $FontSize;
	print "$FontRed $getuser</font> to $corf: ";
	print "<select name=copyto onChange=resetmoveto()>\n";
	@classes = &lookupClassList;
	&printSelOptions($Class, \@classes);
	print "</select></td>\n";
	print"</tr>\n\n";
	
	print "<tr>";
	print "<td>";
	if ($Demo) {
		print $BtnFormUserMvDemo;
	} else {
		print $BtnFormUserMv;
	}
	print "</td>\n";
	print "<td>", $FontFace, $FontSize;
	print "$FontRed $getuser</font> to $corf: ";
	print "<select name=moveto onChange=resetcopyto()>\n";
	&printSelOptions($Class, \@classes);
	print "</select></td>\n";
	print "</tr>\n\n";
	
	print "<tr>";
	print "<td>\n";
	if ($Demo) {
		print $BtnFormUserDelDemo;
	} else {
		print $BtnFormUserDel;
	}
	print "</td>\n";
	print "<td>", $FontFace, $FontSize;
	print "$FontRed $getuser</font> from $corf: <b>$Class</b></td>";
	#print "<input type=submit name=submit value=\"Delete User\"><br>";
	print "</tr>\n\n";
	print "</table>\n";
	
	print "</form>";
	
	print "<script language=javascript>\n";
	print "var origcopy = document.forms[1].copyto.options.selectedIndex;\n";
	print "var origmove = document.forms[1].moveto.options.selectedIndex;\n";
	print "function resetcopyto() {\n";
	print "	document.forms[1].copyto.options.selectedIndex = origcopy;\n";
	print "}\n";
	print "function resetmoveto() {\n";
	print "	document.forms[1].moveto.options.selectedIndex = origmove;\n";
	print "}\n";
	print "</script>\n\n";
}

sub printuserstatic {

	#####################################################################
	# Give the user a reply page.
	print "<table cellpadding=3 border=0>\n";
	# Print out all database fields
	print "<tr><td>", $FontFace, $FontSize, "User ID</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	print $DB_Key;
	print "</td></tr>\n\n";
	
	if ($Edu) {
		print "<tr><td>", $FontFace, $FontSize, "SUID</td>\n";
		print "<td colspan=2>", $FontFace, $FontSize;
		print $U_SUID;
		print "</td></tr>\n\n";
	}
	
	print "<tr><td>", $FontFace, $FontSize;
	if ($C_EncryptUserPass) {
		print "Encrypted ";
	}
	print "Password</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	print $U_Pass;
	print "</td></tr>\n\n";
	
	print "<tr><td>", $FontFace, $FontSize, "First Name</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	print $U_NameFirst;
	print "</td></tr>\n\n";
	
	print "<tr><td>", $FontFace, $FontSize, "Last Name</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	print $U_NameLast;
	print "</td></tr>\n\n";
	
	print "<tr><td>", $FontFace, $FontSize, "Preferred Name</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	print $U_NamePref;
	print "</td></tr>\n\n";
	
	print "<tr><td>", $FontFace, $FontSize, "Email Address</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	print $U_Email;
	print "</td></tr>\n\n";

	print "<tr><td>", $FontFace, $FontSize, "Phone Number</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	print $U_Phone;
	print "</td></tr>\n\n";

	#### Permissions
	$U_Perms = $U_Perms;

	print "<tr><td>", $FontFace, $FontSize, "Permissions</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	if (&HAS_READ($U_Perms)) {
		print "&nbsp; <b>X</b> ";
	} else {
		print "&nbsp; <b>O</b> ";
	}
	print "Read ";
		
	if (&HAS_WRITE($U_Perms)) {
		print "&nbsp; <b>X</b> ";
	} else {
		print "&nbsp; <b>O</b> ";
	}
	print "Write ";

	if (&IS_FAC($U_Perms)) {
		print "&nbsp; <b>X</b> ";
	} else {
		print "&nbsp; <b>O</b> ";
	}
	print $ForM. " ";

	if (&IS_ADMIN($U_Perms)) {
		print "&nbsp; <b>X</b> ";
	} else {
		print "&nbsp; <b>O</b> ";
	}
	print "Admin ";
	print "</td></tr>\n\n";
	######

	print "<tr><td>", $FontFace, $FontSize, "$CorF $SorG</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	# print $U_C_Sect;
	($junk, $sectnum) = split(/\:/, $U_C_Sect);
	print $C_Sects{$sectnum}{"name"};
	print "</td></tr>\n\n";

	if (&IS_FAC($U_Perms)) {
		$highlight = $Ffacultyhilight;
	} else {
		$highlight = $Fstudenthilight;
	}

	print "<tr><td>", $FontFace, $FontSize, "Small Photo</td>\n";
	print "<td>", $FontFace, $FontSize;
	print $U_PhotoName;
	print "</td><td>";
	print "<table cellpadding=0 cellspacing=0 border=0 width=20><tr>";
	print "<td valign=middle align=center height=25 width=20 bgcolor=$highlight nowrap>";
	# $absphoto = $C_rootpath . "/" . $U_Photo;
	print "<img src=", $U_Photo, "?", time(), " border=0 align=absmiddle width=16 height=21>";

	print "</td></tr></table>";
	print "</td></tr>\n\n";
	
	print "<tr><td>", $FontFace, $FontSize, "Large Photo</td>\n";
	print "<td>", $FontFace, $FontSize;
	print $U_PhotoNameLarge;
	print "</td><td>";
	print "<table cellpadding=0 cellspacing=0 border=0 width=36><tr>";
	print "<td valign=middle align=center height=46 width=36 bgcolor=$highlight nowrap>";
	# $absphoto = $C_rootpath . "/" . $U_Photo;
	print "<img src=", $U_PhotoLarge, "?", time(), " border=0 align=absmiddle width=32 height=42>";

	print "</td></tr></table>";
	print "</td></tr>\n\n";
	
	print "<tr><td valign=top>", $FontFace, $FontSize, "Put User on Section Email List</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	if ($U_Classify == 1 || $U_Classify =~ /student/i) {
		print "Yes";
	} else {
		print "No";
	}
	print "</td></tr>\n\n";
	
	print "<tr><td valign=top>", $FontFace, $FontSize, "User Profile</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	print "<table border=0 cellpadding=0 cellspacing=0><tr>";
	print "<td>", $FontSize, $FontFace;
	print &makeHTML($U_ProfileText);
	print "</td></tr></table>\n";
	print "</td></tr>\n\n";
	
	print "<tr><td valign=top>", $FontFace, $FontSize, "Signature</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	print "$U_Sig";
	print "</td></tr>\n\n";
	
	print "<tr><td valign=top>", $FontFace, $FontSize, "Hide User's Email Address</td>\n";
	print "<td colspan=2>", $FontFace, $FontSize;
	if ($U_HideEmail eq "1") {
		print "Yes";
	} else {
		print "No";
	}
	print "</td></tr>\n\n";
	
	print "</table>";
}

sub printUserAddSelf {
	local($showPass) = @_;

	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	# Print out all database fields
	print "<tr><td>", $FontFace, $FontSize;
	
	# Print inner table for first row
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	# First row of headings
	print "<tr>";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
	print "User ID &nbsp;&nbsp;</td>\n";
	
	if ($showPass) {
		print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
		print "Password</td>\n";
	}

	print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;	
	print "Email Address</td>\n";
	
	if ($ENV{'SU_AUTH_USER'} ne "" && $C_authtype =~ /webauth/i) {
		print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
		print "SUID &nbsp;&nbsp;</td>\n";
	}
		
	print "</tr>\n";
	
	print "<tr>";
	print "<td valign=middle nowrap>", $FontFace,$FontSize;
	if ($ENV{'SU_AUTH_USER'} eq "") {
		print "<input type=text name=adduser size=12 maxlength=16 value=\"$adduser\">\n";
	} else {
		print "<input type=hidden name=adduser value=\"";
		print $ENV{'SU_AUTH_USER'}, "\">\n";
		print $ENV{'SU_AUTH_USER'};
	}
	print "&nbsp;";
	print "</td>\n";
	
	if ($showPass) {
		print "<td valign=middle nowrap>", $FontFace,$FontSize;
		print "<input type=text name=U_Pass size=10 value=\"$U_Pass\">\n";
		print "&nbsp;";
		print "</td>\n";
	}
	
	print "<td valign=middle nowrap>", $FontFace,$FontSize;
	if ($ENV{'SU_AUTH_DIRMAIL'} eq "") {
		print "<input type=text name=email size=30 value=\"$U_Email\">";
	} else {
		print "<input type=text name=email size=30 value=\"";
		print $ENV{'SU_AUTH_DIRMAIL'}, "\">";
	}
	print "&nbsp;";
	print "</td>\n";
	
	if ($ENV{'SU_AUTH_USER'} ne "" && $C_authtype =~ /webauth/i) {
		print "<td valign=middle nowrap>", $FontFace,$FontSize;
		print "<input type=text name=SUID size=10 value=\"$U_SUID\" maxlength=8>";
		print "&nbsp;";
		print "</td>\n";
	}
	
	print "</tr></table></td></tr>\n\n";

	# Second row of headings
	print "<tr><td>";
	print "<table cellpadding=0 cellspacing=0 border=0>\n";
	print "<tr>";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
	print "First Name</td>\n";
	print "<td valign=bottom nowrap>", $FontFace,$FontSize, $FontRed;
	print "Last Name</td>\n";
	print "</tr>";

	# Second row of input fields
	print "<tr>";
	print "<td valign=top nowrap>", $FontFace,$FontSize;
	if ($ENV{'SU_AUTH_DIRNAME'} eq "") {
		print "<input type=text name=firstname size=16 value=\"$U_NameFirst\">";
	} else {
		($fn, @ln) = split(/\s/, $ENV{'SU_AUTH_DIRNAME'});
		$ln = join(" ", @ln);
		print "<input type=text name=firstname size=16 value=\"";
		print $fn, "\">";
	}
	print "&nbsp;";
	print "</td>\n";

	print "<td valign=top nowrap>", $FontFace,$FontSize;
	if ($ENV{'SU_AUTH_DIRNAME'} eq "") {
		print "<input type=text name=lastname size=16 value=\"$U_NameLast\">";
	} else {
		print "<input type=text name=lastname size=16 value=\"";
		print $ln, "\">";
	}
	print "&nbsp;";
	print "</td>\n";
	
	print "</tr></table></td></tr>\n\n";
	
	#### Permissions

	print "<input type=hidden name=U_Perms value=$U_Perms>\n";

	######

	print "<input type=hidden name=classification value=\"$U_Classify\">\n";
	if ($C_authtype =~ /webauth/i && $ENV{'SU_AUTH_USER'} ne "") {
		# Allow user to select section
		print "<tr><td valign=middle>", $FontFace,$FontSize;
		print "<input type=hidden name=classsection value=\"$Class:1\">\n";
		print "<select name=section>";
		print "<option value=\"\"> -- Select your $CorF $SorG --\n";
		for ($j=1; $j <= $C_Sect_n; $j++) {
			print "<option value='", $Class, ":", $C_Sects{$j}{"num"}, "'";
			print ">";
			print $C_Sects{$j}{"name"}, "\n";
		}
		print "</select>";
		print "&nbsp;</td></tr>\n";
	} else {
		print "<input type=hidden name=classsection value=\"$Class:1\">\n";
	}

	print "<input type=hidden name=profile value=\"$U_ProfileText\">\n";

	$highlight = $Fstudenthilight;
	
	print "<input type=hidden name=photo value=\"$U_Photo\">\n";
	print "<input type=hidden name=photo2 value=\"$U_PhotoLarge\">\n";
		

	# Print dividing line
	print "<tr><td valign=middle>", $FontFace,$FontSize;
	print "&nbsp;</td></tr>\n";
	print "</table>\n\n";
}
