#!/usr/bin/perl

###############################################################################
#
# _AFEdUserMult.cgi - Edit Multiple Users
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/29 23:28:32 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _AFEdUserMult.cgi,v 1.48.2.4 2001/08/29 23:28:32 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

require "F_Init.pl";
require "U_Init.pl";

$Class = $CGIQuery->param('fid');
# $getuser = $CGIQuery->param('getuser');
$adduser = $CGIQuery->param('adduser');
$what = $CGIQuery->param('what');
$mode = $CGIQuery->param('mode');
$sorting = $CGIQuery->param('sorting');
@filter = $CGIQuery->param('filter');
$cols = $CGIQuery->param('cols');
$menulimit = $CGIQuery->param('menulimit');

# Process lists to get $getuser
if ($adduser eq "") {
	$founduser = 0;
	@names = $CGIQuery->param;
	for ($i=0; $i < @names; $i++) {
		$thename = @names[$i];
		if ($thename =~ /^getuser/) {
			$theval = $CGIQuery->param("$thename");
			if ($theval ne "(NULL)") {
				$founduser++;
				if ($founduser > 1) {
					&showErrorHTML("Please select only ONE user.");
					exit();
				}
				$getuser = $theval;
			}
		}
	}
}

########## Special handling to rebuild mailing lists/htgroup
$upd = $CGIQuery->param("htupdate");
if ($upd ne "") {
	if ($upd eq "ALL") {
		# Update all classes
		@allclasses = &lookupClassList;
		for ($i=0; $i < @allclasses; $i++) {
			&lookupClass(@allclasses[$i]);
			&rebuildmail;
		}
		&lookupClass($Class);
		&loadColors($ColorQueryString);
		
		&showHeaderBackHTML("Update Complete");
		print "Mailing Lists and htgroup filed Updated for:<p>";
		for ($i=0; $i < @allclasses; $i++) {
			print @allclasses[$i], "<br>\n";
		}
		exit();
	} else {
		# Update this class
		if ($Class eq "") {
			&showErrorBackHTML("Please Specify a $CorF.");
			exit();
		}
		
		&lookupClass;
		&loadColors($ColorQueryString);
		&rebuildmail;
		
		&showHeaderBackHTML("Update Complete");
		print "Mailing Lists and htgroup file Updated for $Class";
		exit();
	}
}
########## End Special handling to rebuild mailing lists/htgroup

$foundclass = &lookupClass;
if (! $foundclass) {
	&showErrorBackHTML("You must specify a $CorF.");
	exit();
}

# Load up color variables
&loadColors($ColorQueryString);

$func = $CGIQuery->param('func');

if ($func eq "menu") {
	$BodyTag = &makeBodyTag("Threads");
} else {
	$BodyTag = &makeBodyTag("Content");
}

$adminpass = $CGIQuery->cookie('panForaAdmin');
$forumadmin = &checkAdminPass($adminpass);

if ($CGIEnvUser eq "" && !$forumadmin) {
	$nexturl = escape(&buildNextURL);
	print $CGIQuery->redirect("$CGI_ClassCreate?what=login&fid=$Class&nexturl=$nexturl");
	#&showErrorBackHTML("You are not properly logged in. Please log in and come back.");
	exit();
}

&lookupUser($CGIEnvUser);

if ($CGIEnvUser ne "Guest" && $CGIEnvUser ne "") {
	&checkCookieGuest($CGIEnvUser, $C_authtype);
}

# Kick the user out if they have the wrong permissions
if (!&IS_ADMIN($U_Perms) && !$forumadmin) {
	&showErrorBackHTML("You do not have permission to access this resource or are not logged in properly.");
	exit();
}

$adminemail = $U_Email;

###############################################################################
#
# Process submitted data

if ($func eq "showedit") {	
	if ($CGIQuery->param('copyuser.x') ne "") {
		if ($Demo) {
			print $CGIQuery->redirect("Demo.html");
			exit();
		}
		&copyUsers;
	} elsif ($CGIQuery->param('deleteuser.x') ne "") {
		if ($Demo) {
			print $CGIQuery->redirect("Demo.html");
			exit();
		}
		&deleteUsers;
	} elsif ($CGIQuery->param('assign.x') ne "") {
		if ($Demo) {
			print $CGIQuery->redirect("Demo.html");
			exit();
		}
		&assignsect;
	} else {
		&showmuseredit;
	}
	exit();
} elsif ($func eq "doedit") {
	if ($Demo) {
		print $CGIQuery->redirect("Demo.html");
		exit();
	}
	&domuseredit;
	exit();
} elsif ($func eq "select" || $func eq "search") {
	# Class and user chosen, print out user editing page.
	
	$numfound = &getmuserselection($sorting, @filter);
	if ($numfound == 1) {
		$redir = $CGI_ForumEditUserSingle . "?fid=$Class";
		$redir .= "&func=chooseuser&getuser=" . $CGIEnvUser;
		print $CGIQuery->redirect($redir);
		exit();
	}
	
	$header = "Users Selection for $CorF - $Class";
	
	$helplink = "file=UsersEditCORP_Admin.html&anchor=EditMultipleUserListEdtFSummary";
	$helplink .= "&helptitle=Edit%20Users%20Editing%20Frame";
	&showHeaderBackHTML("$header", "<br>", 0, 0, 0, $helplink);
	&printmuserselection;
	
} elsif ($func eq "menu") {
	# Filter users to view

	# Add
	if ($mode eq "add") {
		$helplink = "file=UsersAddCORP_Admin.html&anchor=AddUserTskFSummary";
		$helplink .= "&helptitle=Add%20User%20Task%20Frame";
		&showHeaderBackHTML("Add User for $CorF - $Class",
			"<br>", 0, 1, 0, $helplink);
	} else {
		$helplink = "file=UsersEditCORP_Admin.html&anchor=EditUserTskFSummary";
		$helplink .= "&helptitle=Edit%20User%20Task%20Frame";
		&showHeaderBackHTML("Edit/Delete Users for $CorF - $Class",
			"<br>", 0, 1, 0, $helplink);
	}
	
	&printResetJavascript;
	
	print "<table border=0 cellpadding=0 cellspacing=0>\n";
	
	print "<tr>";
	
	print "<td rowspan=15>&nbsp;&nbsp;</td>";
	
	# Add
	if ($mode eq "add") {
		print "<td valign=top colspan=2>", $FontFace, $FontSize2;
		print "<b>Add New User</b>";
		print "</td>\n";
		print "<td><img src=", $ImgSrcClearDot, " width=1 height=2></td>\n";
		print "<td>$ImgIndent</td>\n";
	}
	
	print "<td valign=top colspan=6>",$FontFace, $FontSize2;
	if ($mode eq "add") {
		print "<b>Display Exisiting Users</b>";
	} else {
		print "<b>Select Users</b>";
	}
	print "</td>\n";
	
	print "<td><img src=", $ImgSrcClearDot, " width=1 height=2></td>\n";
	print "</tr>\n\n";
	
	### End first row
	
	### Divider Row
	
	print "<tr>";
	
	# Add
	if ($mode eq "add") {
		print "<td bgcolor=$FTheaderback>";
		print "<img src=", $ImgSrcClearDot, " width=1 height=1></td>\n";
		print "<td valign=top bgcolor=$FTheaderback colspan=2 height=1>";
		print "<img src=", $ImgSrcClearDot, " width=2 height=1>";
		print "</td>\n";
	
		print "<td valign=top colspan=1 height=1>";
		print "<img src=", $ImgSrcClearDot, " width=2 height=1>";
		print "</td>\n";
	}
	
	print "<td valign=top bgcolor=$FTheaderback colspan=7 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=20 height=1>";
	print "</td>\n";
	
	print "</tr>\n\n";
	
	### End divider row.
	
	print "<tr>";
	
	# Add
	if ($mode eq "add") {
		print "<td bgcolor=$FTheaderback>";
		print "<img src=", $ImgSrcClearDot, " width=1 height=2></td>\n";
		print "<td valign=middle nowrap>",$FontFace, $FontSize;
		print "&nbsp;New User ID&nbsp;";
		print "</td>\n";
		print "<td valign=middle bgcolor=$FTheaderback>",$FontFace, $FontSize;
		print "<img src=", $ImgSrcClearDot, " width=1 height=2></td>";
		print "<td>$ImgIndent</td>\n";
	}
	
	print "<td valign=top bgcolor=$FTheaderback>";
	print $FontFace, $FontSize;
	print "<img src=", $ImgSrcClearDot, " width=1 height=2>";
	print "</td>\n";
	
	print "<td valign=middle>",$FontFace, $FontSize;
	print "&nbsp;Choose users from:";
	print "</td>\n";
	print "<td>$ImgIndent</td>\n";
	print "<td valign=middle>",$FontFace, $FontSize;
	print "Show in:&nbsp;";
	print "</td>\n";
	print "<td>$ImgIndent</td>\n";
	print "<td valign=middle>",$FontFace, $FontSize;
	print "Show Photos?&nbsp;";
	print "</td>\n";
	
	# Over submit button
	# print "<td>$ImgIndent</td>\n";
	
	print "<td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=2></td>\n";
		
	print "</tr>\n\n";
	
	### End second row
	
	print "<tr>";
	
	# Add
	if ($mode eq "add") {
		########################################
		# Now for the user add section
		print "<td bgcolor=$FTheaderback>";
		print "<img src=", $ImgSrcClearDot, " width=1 height=2></td>\n";
		print "<form action=$CGI_ForumEditUserSingle method=POST target=useredit>\n";
		print "<td valign=top align=left nowrap>", $FontFace, $FontSize;
		print "<input type=hidden name=fid value=\"$Class\">\n";
		print "<input type=hidden name=func value=chooseuser>\n";
		print "&nbsp;<input type=text size=12 name='adduser' maxlength=16>&nbsp;<br>\n";
		# print "</td>\n<td valign=top align=left>", $FontFace, $FontSize;
		print "&nbsp;", $BtnFormAdd;
		print $BtnFormClear;
		print "&nbsp;</td>\n";
		print "<td bgcolor=$FTheaderback>";
		print "<img src=", $ImgSrcClearDot, " width=1 height=2></td>\n";
		print "</form>\n";
		print "<td>$ImgIndent</td>\n";
		########################################
	}
	
	
	print "<form action=$CGIEnvScript method=POST target=useredit name=selectform>\n";
	print "<td valign=top bgcolor=$FTheaderback>";
	print $FontFace, $FontSize;
	print "<img src=", $ImgSrcClearDot, " width=1 height=2>";
	print "</td>\n";
	
	print "<td valign=top>",$FontFace, $FontSize;
		
	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=func value=select>\n";
	
	print "&nbsp;&nbsp;<select name=filter size=4 multiple>\n";
	print "<option value=\"class\"> All $SorGs\n";
	for ($i=1; $i <= $C_Sect_n; $i++) {
		print "<option value=$Class",":", $C_Sects{$i}{"num"};
		print "> ", $C_Sects{$i}{"name"}, "\n";
	}
	print "</select>\n";
	print "</td>\n";
	
	print "<td>$ImgIndent</td>\n";

	print "<td valign=top>",$FontFace, $FontSize;	
	print "<select name=cols onChange='document.searchform.cols.selectedIndex=this.selectedIndex'>\n";
	print "<option value=1";
	if ($cols == 1) { print " selected";}
	print "> 1 Column\n";
	print "<option value=2";
	if ($cols == 2 || $cols eq "") { print " selected";}
	print "> 2 Columns\n";
	print "<option value=3";
	if ($cols == 3) { print " selected";}
	print "> 3 Columns\n";
	print "</select>\n";
	print "</td>\n";
	
	print "<td>$ImgIndent</td>\n";
	
	
	print "<td valign=top align=right nowrap>",$FontFace, $FontSize;
	print "<input type=radio name=showphotos value=none checked ";
	print "onClick='document.searchform.showphotos[0].checked=true'";
	print "> No\n";
	print "<input type=radio name=showphotos value=small ";
	print "onClick='document.searchform.showphotos[1].checked=true'";
	print "> Small\n";
	print "<input type=radio name=showphotos value=large ";
	print "onClick='document.searchform.showphotos[2].checked=true'";
	print "> Large&nbsp;&nbsp;";
	print "<br><br>\n";
	
	print $BtnFormSubmit;
		
	print "&nbsp;</td>\n";
	print "</form>\n";
	
	print "<td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=2></td>\n";
	
	print "</tr>\n\n";
	
	### End third row.

	### 4 Divider Rows
	
	print "<tr>";
	# Add
	if ($mode eq "add") {
		print "<td bgcolor=$FTheaderback>\n";
		print "<img src=", $ImgSrcClearDot, " width=1 height=1></td>";
		print "<td>\n";
		print "<img src=", $ImgSrcClearDot, " width=1 height=1></td>";
		print "<td bgcolor=$FTheaderback>\n";
		print "<img src=", $ImgSrcClearDot, " width=1 height=1></td>";
		print "<td>\n";
		print "<img src=", $ImgSrcClearDot, " width=10 height=1></td>";
	}
	
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4>";
	print "</td>\n";
	print "<td valign=top colspan=5 >";
	print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=1>";
	print "</td>\n";
	print "</tr>\n\n";
	
	
	print "<tr>";
	# Add
	if ($mode eq "add") {
		print "<td colspan=3 bgcolor=$FTheaderback height=1>\n";
		print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
		print "<td height=1>\n";
		print "<img src=", $ImgSrcClearDot, " width=10 height=1></td>";
	}
	
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=1>";
	print "</td>\n";
	
	print "<td valign=top bgcolor=$FTheaderback colspan=6 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
	print "</tr>\n\n";
	
	
	print "<tr>";
	
	# Add
	if ($mode eq "add") {
		print "<td colspan=4 height=1>\n";
		print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
	}
	
	print "<td valign=top colspan=7>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=10>";
	print "</td>\n";
	print "</tr>\n";
	
	### End row
	
	print "<tr>";
	# Add
	if ($mode eq "add") {
		print "<td valign=top  colspan=4>";
		print "<img src=", $ImgSrcClearDot, " width=1 height=1></td>\n";
	}
	
	print "<td valign=top colspan=7 height=1>";
	print $FontFace, $FontSize, $FontSize2;
	print "<b>Search for Users</b></font> &nbsp; ";
	print "(wild cards such as * and ? are allowed)";
	print "</td>";
	print "</tr>\n\n";
	
	print "<tr>";
	# Add
	if ($mode eq "add") {
		print "<td valign=top  colspan=4>";
		print "<img src=", $ImgSrcClearDot, " width=1 height=1></td>\n";
	}
	
	print "<td valign=top bgcolor=$FTheaderback colspan=7 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
	print "</tr>\n\n";
	
	# spacer Row
	print "<tr>";
	# Add
	if ($mode eq "add") {
		print "<td colspan=4>\n";
		print "<img src=", $ImgSrcClearDot, " width=1 height=1></td>";
	}
	
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4>";
	print "</td>\n";
	print "<td valign=top colspan=5 >";
	print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=1>";
	print "</td>\n";
	print "</tr>\n\n";
	
	### End divider row.
	
	# User Search
	print "<form action=$CGIEnvScript method=GET target=useredit name=searchform>\n";
	
	print "<tr>";
	
	# Add
	if ($mode eq "add") {
		print "<td colspan=4>$ImgIndent</td>\n";
	}
	
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=2>";
	print "</td>\n";
	
	print "<td valign=top colspan=5 nowrap>",$FontFace, $FontSize;
	
	print "<input type=hidden name=fid value=\"$Class\">\n";
	print "<input type=hidden name=func value=search>\n";
	
	print "&nbsp;&nbsp;<select name=searchin>\n";
	print "<option value='userid'> User ID\n";
	print "<option value='lastname'> Last Name\n";
	print "<option value='firstname'> First Name\n";
	print "<option value='email'> Email Address\n";
	print "</select>\n";
	
	print "<select name=searchhow>\n";
	print "<option value='is'> Equals\n";
	print "<option value='contains'> Contains\n";
	print "<option value='startswith'> Starts With\n";
	print "<option value='endswith'> Ends With\n";
	print "</select>\n";
	
	print "<input type=text size=10 name=username>";
	print $BtnFormSearch;
	print "&nbsp;&nbsp;</td>\n";
	
	print "<td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=2></td>\n";
	print "</tr>\n\n";

	# spacer Row
	print "<tr>";
	# Add
	if ($mode eq "add") {
		print "<td colspan=4>\n";
		print "<img src=", $ImgSrcClearDot, " width=1 height=1></td>";
	}
	
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4>";
	print "</td>\n";
	print "<td valign=top colspan=5 >";
	print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=1>";
	print "</td>\n";
	print "</tr>\n\n";
	# End Spacer Row

	print "<tr>";
	# Add
	if ($mode eq "add") {
		print "<td colspan=4>$ImgIndent</td>\n";
	}
	
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=2>";
	print "</td>\n";
	
	print "<td valign=top colspan=5 nowrap>",$FontFace, $FontSize;
	print "&nbsp;&nbsp;Show in: ";
	print "<select name=cols onChange='document.selectform.cols.selectedIndex=this.selectedIndex'>\n";
	print "<option value=1";
	if ($cols == 1) { print " selected";}
	print "> 1 Column\n";
	print "<option value=2";
	if ($cols == 2 || $cols eq "") { print " selected";}
	print "> 2 Columns\n";
	print "<option value=3";
	if ($cols == 3) { print " selected";}
	print "> 3 Columns\n";
	print "</select>\n";
	
	print " Show Photos? ";
	
	print "<input type=radio name=showphotos value=none checked ";
	print "onClick='document.selectform.showphotos[0].checked=true'";
	print "> No\n";
	print "<input type=radio name=showphotos value=small ";
	print "onClick='document.selectform.showphotos[1].checked=true'";
	print "> Small\n";
	print "<input type=radio name=showphotos value=large ";
	print "onClick='document.selectform.showphotos[2].checked=true'";
	print "> Large&nbsp;";
	
	print "</td>\n";
	
	print "<td bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=2></td>\n";
	print "</tr>\n\n";
	
	### End Fifth row

	# spacer Row
	print "<tr>";
	# Add
	if ($mode eq "add") {
		print "<td colspan=4>\n";
		print "<img src=", $ImgSrcClearDot, " width=1 height=1></td>";
	}
	
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=4>";
	print "</td>\n";
	print "<td valign=top colspan=5 >";
	print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=1>";
	print "</td>\n";
	print "</tr>\n\n";
	
	print "<tr>";
	
	# Add
	if ($mode eq "add") {
		print "<td colspan=4 height=1>\n";
		print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
	}
	
	print "<td valign=top bgcolor=$FTheaderback>";
	print "<img src=", $ImgSrcClearDot, " width=1 height=1>";
	print "</td>\n";
	
	print "<td valign=top bgcolor=$FTheaderback colspan=6 height=1>";
	print "<img src=", $ImgSrcClearDot, " width=2 height=1></td>";
	print "</tr>\n\n";

	print "</form>\n";

	print "</table>\n";
	print "</body></html>\n";
	
} elsif ($func eq "nothing") {
	# Show the lower frame, no user selected.

	&printEmptyTaskFrame("Select and action in the frame above.");

} else {
	# No function chosen. Print out frameset
	# print $CGIQuery->header(-expires=>'-1d');
	print $CGIQuery->header;
	print "<html><head><title>$Class Forum User Editing</title>\n";
	&printJavascript();
	print "</head>\n";
	print "<frameset rows='240,*' border=2>\n";
	print "	<frame name=usermenu src=$CGIEnvScript?fid=$Class&func=menu&mode=$mode ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "	<frame name=useredit src=$CGIEnvScript?fid=$Class&func=nothing&mode=$mode ";
	print "frameborder=1 marginheight=0 marginwidth=0>\n";
	print "</frameset>\n";
}

sub getmuserselection {
	local ($sorting, @filter) = @_;
	local($howmany) = 0;
	
	if ($func eq "search") {
		$searchin = $CGIQuery->param('searchin');
		$searchhow = $CGIQuery->param('searchhow');
		$username = $CGIQuery->param('username');
		
		$cols = $CGIQuery->param('cols');
		
		$username =~ s/\./\\\./g;
		$username =~ s/\*/\.\*/g;
		$username =~ s/\?/\./g;
		
		if ($username eq "") {
			$username = ".";
		}
	}
	
	&clearUserData;
	
	# Get a list of users to show, based on chosen filters
	
	if ($sorting eq "") {
		$sorting = "userid";
	}
	
	if (@filter > 1) {
		for ($i=0; $i < @filter; $i++) {
			if (@filter[$i] eq "class") {
				$filter = "class";
				$i = 10000;
			} else {
				$filter .= "," . @filter[$i];
			}
		}
	} elsif (@filter == 1) {
		$filter = @filter[0];
	} else {
		$filter = "class";
	}
	
	# First get the list of users
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
	
	foreach (`$prtDB $dbfile -thash -q -a`) {
		($DB_Key, $U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email, $U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, $U_ProfileText, $U_Sig, $U_HideEmail) = split(/\t/, &UnEscape($_));
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			&showErrorBackHTML("$status<p>Unable to read from $dbfile.");
			exit();
		}
		
		&procUserPhoto;
		
		# Get raw section numbers
		$U_num = -1;
		$F_num = -2;
		($junk, $U_num) = split(/:/, $U_C_Sect);
		($junk, $F_num) = split(/:/, $filter);
		
		# Check all filter and search conditions
		$filtermet = 0;
		
		# Select by section or by search
		if ($func ne "search") {
			if ($filter eq "class" || $filter =~ /$U_C_Sect$|$U_C_Sect\,/ 
						|| ($F_num ne "" && $U_num eq $F_num)) {
				$filtermet = 1;
			}
		} else {
			$frontanchor = $endanchor = "";
			if ($searchhow eq "is" || $searchhow eq "startswith") {
				$frontanchor = '^';
			}
			if ($searchhow eq "is" || $searchhow eq "endswith") {
				$endanchor = '$';
			}
			$searchstring = $frontanchor . $username . $endanchor;
			
			if ($searchin eq "lastname") {
				$searchkey = $U_NameLast;
			} elsif ($searchin eq "firstname") {
				$searchkey = $U_NameFirst;
			} elsif ($searchin eq "email") {
				$searchkey = $U_Email;
			} else {
				$searchkey = $DB_Key;
			}
			
			if ($searchkey =~ /$searchstring/i) {
				$filtermet = 1;
			}
		}
		
		# If some filter condition is met
		if ($filtermet) {
			$howmany++;
			
			($junk, $sectnum) = split(/\:/, $U_C_Sect);
			$sectname = $C_Sects{$sectnum}{"name"};
		
			$CGIEnvUser = $DB_Key;
			
			if ($U_NamePref eq "") {
				$U_NamePref = $U_NameFirst;
			}
			$fullname = $U_NamePref . " " . $U_NameLast;
			$U_Perms = $U_Perms;
		
			if ($sorting eq "userid") {
				$sortkey = $CGIEnvUser;
				$sortkey2 = $U_NameLast;
			} elsif ($sorting eq "lastname") {
				$sortkey = $U_NameLast;
				$sortkey2 = $CGIEnvUser;
			} elsif ($sorting eq "firstname") {
				$sortkey = $U_NameFirst;
				$sortkey2 = $CGIEnvUser;
			# } elsif ($sorting eq "SUID") {
			#	$sortkey = $U_SUID;
			#	$sortkey2 = $CGIEnvUser;
			} elsif ($sorting eq "email") {
				$sortkey = $U_Email;
				$sortkey2 = $CGIEnvUser;
			} elsif ($sorting eq "classsection") {
				$sortkey = $U_C_Sect;
				$sortkey2 = $CGIEnvUser;
			} 
			
			# Check for duplicate sortkey
			for ($j=0; $j < @sortmusers; $j++) {
				if (@sortmusers[$j] eq $sortkey) {
					$sortkey .= $sortkey2;
				}
			}
			
			# Get photos
			if ($U_Photo =~ /\,/) {
				($smallphoto, $largephoto) =split(/\,/, $U_Photo);
			} elsif ($U_PhotoLarge eq ""){
				$smallphoto = $U_Photo;
				$largephoto = $U_Photo;
				$largephoto =~ s/\.gif$/\.jpg/i;
			} else {
				$smallphoto = $U_Photo;
				$largephoto = $U_PhotoLarge;
			}
			
			$smallphoto = "<img src=$smallphoto?" . time() . " width=16 height=22>";
			$largephoto = "<img src=$largephoto?" . time() . " width=32 height=42>";
	
			if (&IS_FAC($U_Perms)) {
				$highlight = $Ffacultyhilight;
			} else {
				$highlight = $Fstudenthilight;
			}
			
			# Add the table to the photo
			$smallphoto = "<table cellpadding=0 cellspacing=0 border=0 width=20><tr>" . "<td valign=middle align=center height=26 width=20 bgcolor=$highlight nowrap>" . $smallphoto;
			$smallphoto .= "</td></tr></table>";
			
			$largephoto = "<table cellpadding=0 cellspacing=0 border=0 width=36><tr>" . "<td valign=middle align=center height=46 width=36 bgcolor=$highlight nowrap>" . $largephoto;
			$largephoto .= "</td></tr></table>";
			
			push(@sortmusers, $sortkey);
			$musers{$sortkey}{'userid'} = $DB_Key;
			# $musers{$sortkey}{'SUID'} = $U_SUID;
			$musers{$sortkey}{'firstname'} = $U_NamePref;
			$musers{$sortkey}{'lastname'} = $U_NameLast;
			$musers{$sortkey}{'email'} = $U_Email;
			$musers{$sortkey}{'classsection'} = $sectname;
			$musers{$sortkey}{'smallphoto'} = $smallphoto;
			$musers{$sortkey}{'largephoto'} = $largephoto;
		}
	}
	
	@sortmusers = sort(@sortmusers);
	
	return($howmany);
}

sub printmuserselection {
	# Print out list of users, to be selected for editing.

	$showphotos = $CGIQuery->param('showphotos');

	# @heads = ("userid", "lastname", "firstname", "SUID", "email", "classsection");
	if ($showphotos eq "large") {
		@heads = ("largephoto", "userid", "lastname", "firstname", "classsection");
	} elsif ($showphotos eq "small") {
		@heads = ("smallphoto", "userid", "lastname", "firstname", "classsection");
	} else {
		@heads = ("userid", "lastname", "firstname", "classsection");
	}

	if (@sortmusers == 0) {
		print $FontSize2, $ImgIndent, "<b>No users found</b>";
		return();
	}

	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	print "<tr>";
	
	for ($k=0; $k < $cols; $k++) {
	
		print "<td valign=middle bgcolor=$FCheaderback>";
		print $FontSize2, $ImgIndent, "&nbsp;</td>";
	
		if ($showphotos ne "" && $showphotos ne "none") {
			print "<td valign=middle bgcolor=$FCheaderback nowrap>";	
			print $FontFace, $FontSize, "<font color=$FCheadertext><b>";
			print "Photo &nbsp;</b></a></font></td>\n";		
		}
	
		print "<td valign=middle bgcolor=$FCheaderback nowrap>";	
		print "<a href=$CGIEnvScript?fid=$Class&func=select&filter=$filter";
		print "&sorting=userid&cols=$cols&showphotos=$showphotos>";
		print $FontFace, $FontSize, "<font color=$FCheadertext><b>";
		print "User ID &nbsp;</b></a></font></td>\n";
	
		print "<td valign=middle bgcolor=$FCheaderback nowrap>";
		print "<a href=$CGIEnvScript?fid=$Class&func=select&filter=$filter";
		print "&sorting=lastname&cols=$cols&showphotos=$showphotos>";
		print $FontFace, $FontSize, "<font color=$FCheadertext><b>";
		print "Last Name &nbsp;</b></a></font></td>\n";

		print "<td valign=middle bgcolor=$FCheaderback nowrap>";
		print "<a href=$CGIEnvScript?fid=$Class&func=select&filter=$filter";
		print "&sorting=firstname&cols=$cols&showphotos=$showphotos>";
		print $FontFace, $FontSize, "<font color=$FCheadertext><b>";
		print "First Name &nbsp;</b></a></font></td>\n";
		
		print "<td valign=middle bgcolor=$FCheaderback nowrap>";
		print "<a href=$CGIEnvScript?fid=$Class&func=select&filter=$filter";
		print "&sorting=classsection&cols=$cols&showphotos=$showphotos>";
		print $FontFace, $FontSize, "<font color=$FCheadertext><b>";
		print "$SorG &nbsp;</b></a></font></td>\n";

		print "<td>$ImgIndent</td>";

	}
		
	print "</tr>\n\n";
	
	print "<form action=$CGIEnvScript method=POST>";
	print "<input type=hidden name=fid value=$Class>";
	print "<input type=hidden name=func value=showedit>";
	
	$cells = @sortmusers;
	if ($cols == 0) {
		$rows = 0;
	} else {
		$rows = $cells / $cols;
	}
	if ($rows =~ /\./) {
		($rows, $junk) = split(/\./, $rows);
		$rows += 1;
	}
	
	# Split sortmusers into columns
	$j = 0;
	for ($k=0; $k < $rows; $k++) {
		for ($i = 0; $i < ($cols * $rows); $i += $rows) {
			@testsort[$j] = @sortmusers[$i + $k];
			$j++;
		}
	}
	
	@sortmusers = @testsort;
	
	for ($i=0; $i < @sortmusers; $i++) {
		$DB_Key = @sortmusers[$i];
		
		if (($i % $cols) == 0) {
			print "<tr>\n";
		}
		
		print "<td align=left valign=middle nowrap";
		if (!(($i / $cols) % 2)) {
			print " bgcolor=", $FCmsghilight;
		}
		# print " bgcolor=", $FCheaderback;
		print ">";
		print $FontFace, $FontSize;
		if ($DB_Key ne "") {
			print "<input type=checkbox name=selusers value=\"";
			print $musers{$DB_Key}{"userid"}, "\">";
		} else {
			print "&nbsp;";
		}
		print "</td>";
		
		for ($j=0; $j < @heads; $j++) {
			$DB_Key2 = @heads[$j];
			print "<td align=left valign=middle nowrap";
			if (!(($i / $cols) % 2)) {
				print " bgcolor=", $FCmsghilight;
			}
			print ">";
			print $FontFace, $FontSize;
			
			if (@heads[$j] eq "userid" && $musers{$DB_Key}{$DB_Key2} ne "") {
				print "<a href=$CGI_ForumEditUserSingle", "?getuser=", ;
				print $musers{$DB_Key}{$DB_Key2}, "&fid=$Class&func=chooseuser>";
			}

			if ($musers{$DB_Key}{$DB_Key2} ne "") {
				print $musers{$DB_Key}{$DB_Key2};
			} else {
				print "&nbsp;";
			}
			
			if ($j == 0) {
				print "</a>";
			}
			
			print "</td>\n";
		}
		
		print "<td>$ImgIndent</td>\n";
		
		if ((($i + 1) % $cols) == 0) {
			print "</tr>\n";
		}
	}
	
	$spcols = (@heads) + 1;
	
	print "<tr>";
	for ($i=0; $i < $cols; $i++) {
		print "<td valign=middle bgcolor=$FCheaderback colspan=$spcols>";
		print "$ImgClear88</td>\n";
		print "<td>$ImgIndent</td>\n";
	}
	print "</tr>\n";

	$spcols *= $cols;
	$spcols += 2;
	print "<tr><td colspan=$spcols>", $FontFace, $FontSize;
	print "<br>\n&nbsp;<a href=javascript:selectAll('selusers')>Select All</a>";
	print $ImgIndent;
	print "&nbsp;<a href=javascript:deselectAll('selusers')>Deselect All</a>";
	print $ImgIndent;
	print "&nbsp;<a href=javascript:selectInverse('selusers')>Select Inverse</a><br><br>\n";
	print "</td></tr>\n";

	print "<tr><td valign=middle colspan=$spcols>";
	print "$ImgIndentSmall</td></tr>\n";
	print "<tr><td valign=middle bgcolor=$FCheaderback colspan=$spcols>";
	print "<img src=$ImgSrcClearDot width=20 height=2></td></tr>\n";
	print "<tr><td valign=middle colspan=$spcols>";
	print "$ImgIndentSmall</td></tr>\n\n";

	print "<tr><td align=left valign=middle colspan=$spcols>", $FontFace, $FontSize;
	print $BtnFormEdit, "Selected Users\n";
	print "</td></tr>\n\n";

	print "<tr><td valign=middle colspan=$spcols>";
	print "$ImgIndentSmall</td></tr>\n";
	
	print "<tr><td align=left valign=middle colspan=$spcols>", $FontFace, $FontSize;
	if ($Demo) {
		print $BtnFormAssignDemo;
	} else {
		print $BtnFormAssign;
	}
	print " Selected Users to $SorG: \n";
	print "<select name=section>";
	print "<option value=\"\"> -- Click to Select --\n";
	for ($j=1; $j <= $C_Sect_n; $j++) {
		print "<option value='", $Class, ":", $C_Sects{$j}{"num"}, "'";
		print ">";
		print $C_Sects{$j}{"name"}, "\n";
	}
	print "</select>\n";
	print "</td></tr>\n";
	
	print "<tr><td align=left valign=middle colspan=$spcols>", $FontFace, $FontSize;
	if ($Demo) {
		print $BtnFormUserCpDemo;
	} else {
		print $BtnFormUserCp;
	}
	print " Selected Users to $corf: ";
	# print "<select name=copyto onChange=\"resetmoveto()\">\n";
	print "<select name=copyto>\n";
	@classes = &lookupClassList;
	&printSelOptions($Class, \@classes);
	print "</select>\n";
	print "</td></tr>\n\n";
	
	print "<tr><td align=left valign=middle colspan=$spcols>", $FontFace, $FontSize;
	if ($Demo) {
		print $BtnFormUserDelDemo;
	} else {
		print $BtnFormUserDel;
	}
	print " Selected Users from $corf: <b>$Class</b> &nbsp;";
	print "</td></tr>\n\n";

	print "</form>";
	print "</table>";
	
	&printCheckSelJS;
}

sub showmuseredit {
	# Print the actual editing page for the selected users.
	
	&clearUserData;

	@selusers = $CGIQuery->param('selusers');
	
	@selusers = sort(@selusers);
	
	if (@selusers == 0) {
		# No users selected
		&showErrorBackHTML("You must select at least one user to edit.", 1);
		exit();
	} elsif (@selusers == 1) {
		$getuser = @selusers[0];
		$redir = $CGI_ForumEditUserSingle . "?getuser=$getuser&fid=$Class";
		$redir .= "&func=chooseuser";
		print $CGIQuery->redirect($redir);
		exit();
	}
	
	
	$helplink = "file=UsersEditCORP_Admin.html&anchor=EditMultipleUserEdtFSummary";
	$helplink .= "&helptitle=Edit%20Users%20Editing%20Frame";
	&showHeaderBackHTML("Editing Users for $CorF - $Class",
		"", 0, 0, 0, $helplink);

	# Print out photo chooser javascript
	&printphotochooser;
	
	@heads = ("User ID", "University ID", "Password", "First Name", "Last Name", "Preferred Name", "Email Address", "Phone Number", "Permissions", "$CorF $SorG", "Put User on $SorG Email List", "Hide User's Email", "Small Photo", "&nbsp;", "Large Photo", "&nbsp;");
	if ($C_authtype =~ /external/i) {
		@heads[1] = "";
	} elsif (! $Edu){
		@heads[1] = "Password Hint";
	}
	
	if ($C_EncryptUserPass) {
		# @heads[2] = "";
		&printWarnChgEncrypted;
	}

	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	print "<form action=$CGIEnvScript method=POST>";
	
	print "<input type=hidden name=func value=\"doedit\">\n";	
	print "<input type=hidden name=fid value=\"$Class\">\n";
	
	print "<tr><td valign=middle bgcolor=$FCheaderback colspan=2>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n";
	
	for ($i=0; $i < @selusers; $i++) {
		$getuser = @selusers[$i];
		&lookupUser(@selusers[$i]);
		
		# Print dividing line
		# print "<tr><td valign=middle bgcolor=$FCheaderback colspan=2>";
		# print "$ImgClear88</td></tr>";		
			
		# Print headings for first user editing row.
		print "<tr>";
		print "<td>";
		
		print "<table cellpadding=0 cellspacing=0 border=0>\n";
		print "<tr>";
		for ($j=0; $j < 3; $j++) {
			if (@heads[$j] ne "") {
				print "<td valign=bottom nowrap>";	
				print $FontFace, $FontSize;
				if ($j < 5 && $j != 1) {
					print $FontRed;
				}
				print @heads[$j], "&nbsp;</font></td>\n";
			}
		}
		print "<td valign=bottom nowrap>&nbsp;</td>\n";
		print "</tr>\n";
		
		# Print user editing fields, first row
		print "<tr>";	

		# print hidden fields
		print "<input type=hidden name=", $getuser, ".origsect value=\"$U_C_Sect\">\n";
		print "<input type=hidden name=", $getuser, ".origemail value=\"$U_Email\">\n";
		
		# User ID
		print "<input type=hidden name=",$getuser,".getuser value=$getuser>\n";
		
		print "<td align=left valign=top>";
		print $FontFace, $FontSize;
		print "<input type=text name=", $getuser, ".newid size=12 maxlength=16 value=\"$getuser\">";
		print "&nbsp;";
		print "</td>\n";

		# SUID
		if ($Edu || $C_authtype !~ /external/i) {
			print "<td align=left valign=top>", $FontFace, $FontSize;
			print "<input type=text name=", $getuser, ".SUID size=10 value=\"$U_SUID\" maxlength=8>";
			print "&nbsp;";
			print "</td>\n";
		}

		# Password
		if ($C_EncryptUserPass) {
			print "<input type=hidden name=", $getuser, ".pass value=\"$U_Pass\">";
			
			print "<td align=left valign=top>", $FontFace, $FontSize;
			print "<input type=text name=", $getuser, ".newpass size=10 value=\"\" maxlength=8 ";
			print "onFocus=\"warnEncryptedNewPass(this, \'$getuser\')\"";
			print ">";
			print "&nbsp;";
			print "</td>\n";
		} else {
			print "<td align=left valign=top>", $FontFace, $FontSize;
			print "<input type=text name=", $getuser, ".pass size=10 value=\"$U_Pass\" maxlength=8>";
			print "&nbsp;";
			print "</td>\n";
		}
		
		# Email password to user
		print "<td align=left valign=top>", $FontFace, $FontSize;
		print "<input type=checkbox name=\"", $getuser;
		print ".emailpassword\" value=YES>";
		print "Email Account Information to this User";
		print "</td>\n";
		
		print "</tr></table>\n";
		print "</td>";

			
		if (&IS_FAC($U_Perms)) {
			$highlight = $Ffacultyhilight;
		} else {
			$highlight = $Fstudenthilight;
		}
		
		# Special photo area
		print "<td rowspan=5 nowrap align=left>";
		# Small Photo
		print "<table cellspacing=2 cellpadding=0 border=0>";
		print "<tr>";
		print "<td align=right valign=bottom>";
		print "<table cellpadding=0 cellspacing=0 border=0 width=20><tr>";
		print "<td valign=middle align=center height=26 width=20 bgcolor=$highlight nowrap>";
		$absphoto = $C_photodir . $U_PhotoName;
		print "<a href=javascript:PhotoChooser(\'$getuser\','small','1')>";
		if (-e $absphoto) {
			print "<img src=", $U_Photo, "?", time(), " border=0 name=$getuser", "_small width=16 height=22>";
		} else {
			print "<img src=", $C_photourl, "Guest.gif border=0 name=$getuser", "_small width=16 height=22>";
		}
		print "</a>";
		print "</td></tr></table>";	
		print "</td>\n";
		print "<td align=left valign=bottom>", $FontFace, $FontSize;
		print $FontRed, "Small Photo</font><br>\n";
		print "(click photo to change)\n";
		print "<input type=hidden name=", $getuser, "_photo size=16 value=\"$U_PhotoName\">";
		print "</td>\n";
		print "</tr>\n";

		# Large Photo
		print "<tr>";
		print "<td align=right valign=bottom>";
		print "<table cellpadding=0 cellspacing=0 border=0 width=36><tr>";
		print "<td valign=middle align=center height=46 width=36 bgcolor=$highlight nowrap>";
		$absphoto = $C_photodir . $U_PhotoNameLarge;
		print "<a href=javascript:PhotoChooser(\'$getuser\','large','1')>";
		if (-e $absphoto) {
			print "<img src=", $U_PhotoLarge, "?", time(), " border=0 name=", $getuser, "_large width=32 height=42>";
		} else {
			print "<img src=", $C_photourl, "Guest.jpg border=0 name=$getuser", "_large width=32 height=42>";
		}
		print "</a>";
		print "</td></tr></table>";	
		print "</td>\n";
		print "<td align=left valign=bottom>", $FontFace, $FontSize;
		print $FontRed, "Large Photo</font><br>\n";
		print "(click photo to change)\n";
		print "<input type=hidden name=", $getuser, "_photo2 size=16 value=\"$U_PhotoNameLarge\">";
		print "</td>\n";	
		print "</tr>\n";
		
		# Spacer
		print "<tr><td nowrap colspan=2>$ImgIndent</td></tr>\n";
		
		# User Profile
		print "<tr><td nowrap colspan=2>", $FontFace, $FontSize;
		print "Personal Information<br>";
		print "<textarea name=", $getuser;
		print ".profile rows=4 cols=40 wrap=virtual>$U_ProfileText</textarea>";
		print "</td>\n";
		print "</tr>\n";
		
		# User Signature
		print "<tr><td nowrap colspan=2>", $FontFace, $FontSize;
		print "Signature<br>";
		print "<input type=text name=", $getuser;
		$U_Sig =~ s/\"/\&quot\;/g;
		print ".sig size=40 maxlength=200 value=\"", $U_Sig, "\">";
		print "</td>\n";
		print "</tr>\n";
		
		print "</table>\n";
		# End of photos cell
		print "</td>";
		

		print "</tr>\n\n";

		# Second row
		print "<tr><td>";
		print "<table cellpadding=0 cellspacing=0 border=0>\n";
		print "<tr>";
		for ($j=3; $j < 6; $j++) {
			print "<td valign=bottom nowrap>";	
			print $FontFace, $FontSize;
			if ($j < 5) {
				print $FontRed;
			}
			print @heads[$j], "&nbsp;</font></td>\n";
		}
		print "</tr>\n";
		print "<tr>";
	
		# First Name
		print "<td align=left valign=top>", $FontFace, $FontSize;
		print "<input type=text name=", $getuser, ".firstname size=16 value=\"$U_NameFirst\">";
		print "&nbsp;";
		print "</td>\n";
		
		# Last Name
		print "<td align=left valign=top>", $FontFace, $FontSize;
		print "<input type=text name=", $getuser, ".lastname size=16 value=\"$U_NameLast\">";
		print "&nbsp;";
		print "</td>\n";

		# Preferred Name
		print "<td align=left valign=top>", $FontFace, $FontSize;
		print "<input type=text name=", $getuser, ".prefname size=16 value=\"$U_NamePref\">";
		print "&nbsp;";
		print "</td>\n";

		# Start third editing row.
		print "</tr></table>\n";
		print "</td></tr></tr>\n\n";
		
		print "<tr>";	
		print "<td>";
		print "<table cellpadding=0 cellspacing=0 border=0>\n";
		print "<tr>";
		for ($j=6; $j < 8; $j++) {
			print "<td valign=middle nowrap>";	
			print $FontFace, $FontSize;
			if ($j == 6) { print $FontRed; }
			print @heads[$j], "&nbsp;</font></td>\n";
		}
		print "</tr>\n";
	
		print "<tr>";
		# Email
		print "<td>", $FontFace, $FontSize;
		print "<input type=text name=", $getuser, ".email size=30 value=\"$U_Email\">";
		print "&nbsp;";
		print "</td>\n";
		
		# Phone
		print "<td>", $FontFace, $FontSize;
		print "<input type=text name=", $getuser, ".phone size=16 value=\"$U_Phone\">";
		print "&nbsp;";
		print "</td>\n";
		
		print "</tr></table>\n";
		print "</td></tr></tr>\n\n";
		
		#fourth row	
		print "<tr>";	
		print "<td>";
		print "<table cellpadding=0 cellspacing=0 border=0>\n";
		print "<tr>";
		print "<td valign=middle nowrap>";	
		print $FontFace, $FontSize;
		print $FontRed;
		print @heads[8], "</font></td>\n";
		print "</tr>\n";		
				
		##### Permissions
		print "<td nowrap>", $FontFace, $FontSize;
		print "<input type=checkbox name=", $getuser, ".permread value=2";
		if (&HAS_READ($U_Perms)) {
			print " checked";
		}
		print ">Read ";
		
		print "<input type=checkbox name=", $getuser, ".permwrite value=1";
		if (&HAS_WRITE($U_Perms)) {
			print " checked";
		}
		print ">Write ";
		
		print "<input type=checkbox name=", $getuser, ".permfac value=4";
		if (&IS_FAC($U_Perms)) {
			print " checked";
		}
		print ">$ForM ";

		if ($CGIEnvUser eq $getuser) {
			print "&nbsp; <b>X</b> Admin";
			print "<input type=hidden name=", $getuser, ".permadmin value=8>";
		} else {
			print "<input type=checkbox name=", $getuser, ".permadmin value=8";
			if (&IS_ADMIN($U_Perms)) {
				print " checked";
			}
			print ">Admin ";
		}

		print "</td>\n";
		######

		print "</tr></table>\n";
		print "</td>";
		print "</tr>\n\n";
		
		#fourth row	
		print "<tr>";	
		print "<td>";
		print "<table cellpadding=0 cellspacing=0 border=0>\n";
		print "<tr>";
		for ($j=9; $j < 12; $j++) {
			print "<td valign=middle nowrap>";	
			print $FontFace, $FontSize;
			print $FontRed;
			print @heads[$j], "&nbsp;&nbsp;&nbsp;&nbsp;</font></td>\n";
		}
		print "</tr>\n";
		print "<tr>";
		
		# Class Section
		print "<td>", $FontFace, $FontSize;
		($junk, $sectnum) = split(/\:/, $U_C_Sect);
		print "<select name=", $getuser, ".classsection>";
		for ($j=1; $j <= $C_Sect_n; $j++) {
			print "<option value='", $Class, ":", $C_Sects{$j}{"num"}, "'";
			if ($sectnum == $C_Sects{$j}{"num"}) {
				print " selected";
			}
			print ">";
			print $C_Sects{$j}{"name"}, "\n";
		}
		print "</select>";
		print "</td>\n";
		
		# Classification - Now Email List
		print "<td nowrap>", $FontFace, $FontSize;	
		
		print "<input type=radio name=\"", $getuser, ".classification\"";
		$onlist = 0;
		if ($U_Classify == 1 || $U_Classify =~ /student/i) {
			print " checked";
			$onlist = 1;
		}
		print " value='1'>";
		print "Yes \n";
		
		print "<input type=radio name=\"", $getuser, ".classification\"";
		if (! $onlist) {
			print " checked";
		}
		print " value='0'>";
		print "No \n";
		
		print "</td>\n";
		
		# Hide User's Email
		print "<td nowrap>", $FontFace, $FontSize;	
		
		print "<input type=radio name=\"", $getuser, ".hideemail\"";
		if ($U_HideEmail =~ /^1/) {
			print " checked";
		}
		print " value='1'>";
		print "Yes \n";
		
		print "<input type=radio name=\"", $getuser, ".hideemail\"";
		if ($U_HideEmail !~ /^1/) {
			print " checked";
		}
		print " value='0'>";
		print "No \n";
		
		print "</td>\n";
		
		print "</tr></table>";
		print "</td></tr>\n\n";
		
		print "<tr><td valign=middle bgcolor=$FCheaderback colspan=2>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n";
	}
	
	print "<tr><td valign=middle colspan=2>", $FontFace, $FontSize2;
	if ($Demo) {
		print $BtnFormSubmitDemo;
	} else {
		print $BtnFormSubmit;
	}
	print " User Changes";
	print "</td></tr>\n";
	
	print "</form>\n";
	print "</table>\n";
}

sub domuseredit {
	local($retval);
	# Read in the submitted data and make changes to users.
	
	# Get the names of all submitted parameters
	@names = $CGIQuery->param;
	
	# Get original user names
	for ($i=0; $i < @names; $i++) {
		if (@names[$i] =~ /\.getuser/) {
			($tmp, $junk) = split(/\./, @names[$i]);
			push(@musers, $tmp);
		}
	}

	
	&showHeaderBackHTML("Users Changed for $CorF - $Class", "<br>");
	
	print "<table border=0 cellpadding=0 cellspacing=0 width=100%>";
	print "<tr><td bgcolor=$FCheaderback>";
	print "<img src=$ImgSrcClearDot width=20 height=2>";
	print "</td></tr>\n\n";
	print "</table>\n\n";
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	# Loop through all users, reading in data and shoving it into the db.
	for ($i=0; $i < @musers; $i++) {
		$getuser = @musers[$i];
		
		# Read in existing user data
		&lookupUser($getuser);
		
		# Load up an associative array with the existing user data
		$dat{"SUID"} = $U_SUID;
		$dat{"pass"} = $U_Pass;
		$dat{"firstname"} = $U_NameFirst;
		$dat{"lastname"} = $U_NameLast;
		$dat{"prefname"} = $U_NamePref;
		$dat{"email"} = $U_Email;
		$dat{"phone"} = $U_Phone;
		# $dat{"permissions"} = $U_Perms;
		$dat{"classsection"} = $U_C_Sect;
		# $dat{"photo"} = $U_Photo;
		$dat{"classification"} = $U_Classify;
		$dat{"profile"} = $U_ProfileText;
		$dat{"sig"} = $U_Sig;
		$dat{"hideemail"} = $U_HideEmail;
		
		$origPerms = $U_Perms;
		
		$U_Perms = 0;
	
		# Read in all submitted data for this user.
		for ($j=0; $j < @names; $j++) {
			if (@names[$j] =~ /$getuser\.|$getuser\_/) {
				if (@names[$j] =~ /$getuser\./) {
					($junk, $name) = split(/\./, @names[$j]);
				} elsif (@names[$j] =~ /$getuser\_/) {
					($junk, $name) = split(/\_/, @names[$j]);
				}
				
				if ($name =~ /^perm/) {
					if ($CGIQuery->param("@names[$j]") ne "") {
						$U_Perms += $CGIQuery->param("@names[$j]");
					}
				} elsif ($name eq "photo2") {
					$U_PhotoLarge = $CGIQuery->param("@names[$j]");
				} else {
					$dat{$name} = &cleanTabs($CGIQuery->param("@names[$j]"));
				}
			}
		}
		
		$dat{"permissions"} = $U_Perms;
		
		$dat{"photo"} .= "," . $U_PhotoLarge;

		if ($dat{"otherclassification"} ne "" && $dat{"classification"} eq "Other") {
			$dat{"classification"} = $dat{"otherclassification"};
		}
		
		# Now reload the variables with the new ones.
		$U_SUID = $dat{"SUID"};
		$U_Pass = $dat{"pass"};
		$U_NameFirst = $dat{"firstname"};
		$U_NameLast = $dat{"lastname"};
		$U_NamePref = $dat{"prefname"};
		$U_Email = $dat{"email"};
		$U_Phone = $dat{"phone"};
		# $U_Perms = $dat{"permissions"};
		$U_C_Sect = $dat{"classsection"};
		$U_Photo = $dat{"photo"};
		$U_Classify = $dat{"classification"};
		$U_ProfileText = $dat{"profile"};
		$U_Sig = &cleanHTML($dat{"sig"});
		$U_Sig =~ s/\"/\&quot\;/g;
		$U_HideEmail = $dat{"hideemail"};
		
		if ($C_EncryptUserPass) {
			$newpass = &replaceWhiteSpace($dat{"newpass"});
			if ($newpass ne "") {
				$U_Pass = &cryptPass($newpass);
			}
		}
		
		# Done getting user data changes. Now put them into the database,
		# And make sure to correctly modify mailinglists and allow for
		# userid changes.
	
		if ($dat{"newid"} eq "") {
			&showErrorBackHTML("You must provide a user ID.",1);
			exit();
		}
		$dat{"newid"} = &maxLength(&cleanNonAlpha($dat{"newid"}), 16);
		if ($U_Photo eq "") {
			$U_Photo = "Guest.gif,Guest.jpg";
		}
		if ($dat{"firstname"} eq "" && $dat{"lastname"} eq "") {
			&showErrorBackHTML("You must provide a name.",1);
			exit();
		}

		if ($dat{"newid"} ne $getuser && $getuser ne "" && $getuser ne "Anonymous" && $getuser ne "Guest") {
			# this is an id change
			# we need to make sure that the new one doesn't already exist...
			$status = &lookupUser($dat{"newid"});
			if ($status == 0) {
				&showErrorBackHTML("The new user name you have chosen, $dat{'newid'}, already exists. If you would like to overwrite this one, you must first delete it.",1);
				exit();
			}
		}
	
		$DB_Key = $dat{"newid"};

		##########################################################
		# Add user to database
		$retval = &addtodb($DB_Key);
		if ($retval) {
			&userDBError($retval);
		}
		#
		##########################################################
	
		if ($DB_Key ne $getuser && $getuser ne "" && $getuser ne "Anonymous" && $getuser ne "Guest") {
			# if this is an id change, need to delete the old one.
			$status = &delfromdb($getuser);
			if ($status != 0) {
				&showErrorBackHTML("User deletion failure!!! User = $DB_Key",1);
				exit();
			}
			# Delete from htgroup file
			#&delfromht($getuser);
			# Delete photo
			# Don't delete photo or it disappears from their posts
			# &delphoto($getuser);
			# Delete from mailing list
			#&delfrommail($getuser);
		}
		
		#if ($dat{'origemail'} ne $U_Email) {
		#	&delfrommail($getuser);
		#}
		
		#if ($dat{'origsect'} ne $U_C_Sect) {
		#	&delfromht($getuser);
		#	&delfrommail($getuser);
		#}
	
		if ($status != 0) {
			&showErrorBackHTML("Database write failure!!! User = $DB_Key",1);
			exit();
		}
	
		##########################################################
		# Add user to htgroup
		#if ($DB_Key ne "Anonymous") {
		#	&addtoht($DB_Key, $U_C_Sect);
		#}
		#
		##########################################################
	
		##########################################################
		# Add user photos
		if ($DB_Key ne "Anonymous" && $DB_Key ne "Guest") {
			&addphoto($DB_Key);
		}
		#
		##########################################################
	
		##########################################################
		# Modify mailing lists as needed	
		#if ($DB_Key ne "Anonymous" && $DB_Key ne "Guest") {
		#	&addtomail($DB_Key);
		#}
		#
		##########################################################
		
		# If this is a faculty user, put the user in the class database as
		# a faculty member.
		if (&IS_FAC($U_Perms)) {
			&addToClassFac($DB_Key);
		}
		
		# If they were a faculty member, but are no longer, remove them from
		# The class db as faculty
		# if (!&IS_FAC($U_Perms) && &IS_FAC($origPerms)) {
		if (!&IS_FAC($U_Perms)) {
			&delFromClassFac($DB_Key);
		}
		
		# Email the user his account information, if requested
		if ($dat{"emailpassword"} eq "YES") {
			&emailUserAccountInfo($DB_Key, $adminemail);
		}
	
		# Show the results to the Admin
		&lookupUser($DB_Key);
		&printuserstatic;
		print "<table border=0 cellpadding=0 cellspacing=0 width=100%>";
		print "<tr><td bgcolor=$FCheaderback>";
		print "<img src=$ImgSrcClearDot width=20 height=2>";
		print "</td></tr>\n\n";
		print "</table>\n\n";
	}
	
	# rebuild mailing lists and .ht files from scratch
	&rebuildAllMailAndHT();
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	print "Completed";
}

sub copyUsers {
	local($i, $retval);

	$copyto = $CGIQuery->param('copyto');
	$copyorskip = $CGIQuery->param('copyorskip');
	$assigned = $CGIQuery->param('assigned');
	
	if ($copyto eq "" || $copyto eq $Class) {
		&showErrorBackHTML("You must choose a $CorF to copy the selected users.", 1);
		exit();
	}
	
	# Check for selected users
	@selusers = $CGIQuery->param('selusers');
	@selusers = sort(@selusers);
	
	# Check for superuser
	if (!$forumadmin) {
		$nexturl = $CGIEnvScript . "?fid=" . $Class . "&copyto=" . $copyto;
		$nexturl .= "&copyorskip=" . $copyorskip . "&assigned=" . $assigned;
		$nexturl .= "&func=showedit&copyuser.x=1";
		for ($i=0; $i < @selusers; $i++) {
			$nexturl .= "&selusers=" . @selusers[$i];
		}
		$nexturl = escape($nexturl);
		
		print $CGIQuery->redirect("$CGI_ClassCreate?what=login&fid=$Class&nexturl=$nexturl");
		exit();
	}
	
	# filter out Guest and Anonymous
	@tmp = @selusers;
	splice(@selusers,0);
	for ($i=0; $i < @tmp; $i++) {
		if (@tmp[$i] ne "Guest" && @tmp[$i] ne "Anonymous") {
			push(@selusers, @tmp[$i]);
		} else {
			$msg = "Note that you can't copy Guest or Anonymous.";
		}
	}
	
	if (@selusers == 0) {
		&showErrorBackHTML("You must select some users to copy. $msg", 1);
		exit();
	}
		
	# Now look up the class we are copying to
	&lookupClass($copyto);
	
	# Check for duplicate users in other class
	$foundusers = "";
	for ($i=0; $i < @selusers; $i++) {
		if (&lookupUser(@selusers[$i]) == 0) {
			# User found. Ask admin what to do
			$foundusers .= @selusers[$i] . ",";
		}
	}
	chop($foundusers);
	
	if ($foundusers ne "" && $copyorskip eq "") {
		# Ask admin what to do.
		&copyOrSkip($foundusers);
	}
	
	if ($copyorskip eq "SKIP") {
		# Modify user list
		@tmp = @selusers;
		@skip = split(/\,/, $foundusers);
		splice(@selusers,0);
		for ($i=0; $i < @tmp; $i++) {
			$found = 0;
			for ($j=0; $j < @skip; $j++) {
				if (@tmp[$i] eq @skip[$j]) {
					$found = 1;
				}
			}
			if (! $found) {
				push(@selusers, @tmp[$i]);
			}
		}
		
		if (@selusers == 0) {
			&showErrorBackHTML("You opted to skip all selected users. No copying has been performed.", 1);
			exit();
		}
	}
	
	# Check for existence of sections
	
	# Get section list from copyto class.
	for ($i=1; $i <= $C_Sect_n; $i++) {
		@existsections[$i] = $C_Sects{$i}{"num"};
		@existsectnames[$i] = $C_Sects{$i}{"name"};
	}
	
	&lookupClass($Class);
	
	for ($i=0; $i < @selusers; $i++) {
		$notfound = 0;
		&lookupUser(@selusers[$i]);

		if ($U_C_Sect =~ /\:/) {
			($junk, $U_C_Sect) = split(/\:/, $U_C_Sect);
		}
		if (@existsections[$U_C_Sect] eq "") {
			# Section does not exist
			$notfound = 1;
			push(@needsections, @selusers[$i]);
		}

		if ($notfound) {
			$U_C_Sect = $CGIQuery->param("@selusers[$i]");
		} else {
			$U_C_Sect = $copyto . ":" . $U_C_Sect;
		}
		@selstrings[$i] = "$U_SUID\t$U_Pass\t$U_NameFirst\t$U_NameLast\t$U_NamePref\t$U_Email\t$U_Phone\t$U_Perms\t$U_C_Sect\t$U_Photo,$U_PhotoLarge\t$U_Classify\t$U_ProfileText\t$U_Sig\t$U_HideEmail";
	}
	
	if (@needsections > 0 && $assigned eq "") {
		&pickSections;
		exit();
	}
	
	# finally, now we can just dump the users into the database.
	# Build a big string to put in.
	$origphotodir = $C_photodir;
	
	$origclass = $Class;
	$Class = $copyto;
	&lookupClass($Class);
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	for ($i=0; $i < @selusers; $i++) {
		$DB_Key = @selusers[$i];
		($U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email, $U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, $U_ProfileText, $U_Sig, $U_HideEmail) = split(/\t/, @selstrings[$i]);
		
		##########################################################
		# Add user to database
		$retval = &addtodb($DB_Key);
		if ($retval) {
			&userDBError($retval);
		}
		#
		##########################################################
	
		if ($status != 0) {
			&showErrorBackHTML("Database write failure!!! User = $DB_Key",1);
			exit();
		}
	
		##########################################################
		# Copy user photos
		if (-e $origphotodir . $DB_Key . ".gif" && -e $origphotodir . $DB_Key . ".jpg") {
			&copy($origphotodir . $DB_Key . ".gif", $C_photodir . $DB_Key . ".gif");
			&copy($origphotodir . $DB_Key . ".jpg", $C_photodir . $DB_Key . ".jpg");
		} else {
			&addphoto($DB_Key);
		}
		#
		##########################################################
		
		# If this is a faculty user, put the user in the class database as
		# a faculty member.
		if (&IS_FAC($U_Perms)) {
			&addToClassFac($DB_Key);
		}
	}
	
	# rebuild mailing lists and .ht files from scratch
	&rebuildAllMailAndHT();
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
	
	# Show results to the admin
	&showHeaderBackHTML("Finished Copying Users","<br>");
	
	print "The Following users have been copied from $origclass to $copyto:<br>\n";
	print "<ul>\n";
	for ($i=0; $i < @selusers; $i++) {
		print "<li>", @selusers[$i], "\n";
	}
	print "</ul>\n";
}

sub deleteUsers {
	# Check for selected users
	@selusers = $CGIQuery->param('selusers');
	@selusers = sort(@selusers);
	
	# filter out Guest and Anonymous and self
	@tmp = @selusers;
	splice(@selusers,0);
	for ($i=0; $i < @tmp; $i++) {
		if (@tmp[$i] ne "Guest" && @tmp[$i] ne "Anonymous" && @tmp[$i] ne $CGIEnvUser) {
			push(@selusers, @tmp[$i]);
		} else {
			$msg = "Note that you can't delete yourself, Guest or Anonymous.";
		}
	}
	
	if (@selusers == 0) {
		&showErrorBackHTML("You must select some users to copy. $msg", 1);
		exit();
	}
	
	$confirm = $CGIQuery->param('confirm');
	if ($confirm eq "") {
		&confirmDel;
		exit();
	} elsif ($confirm ne "YES") {
		&showHeaderBackHTML("User Deletion Cancelled","<br>");
		print "You cancelled deletion of all selected users.";
		exit();
	}
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	# Admin confirmed deletion. Delete users.
	for ($i=0; $i < @selusers; $i++) {
		&delfromdb(@selusers[$i]);
		#&delfromht(@selusers[$i]);
		# Leave photo for existing posts.
		# &delphoto(@selusers[$i]);
		#&delfrommail(@selusers[$i]);
	}
				
	# rebuild mailing lists and .ht files from scratch
	&rebuildAllMailAndHT();
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
		
	&showHeaderBackHTML("Users Deleted", "", 0);
	print "The Following users have been deleted from $Class<br>\n";
	print "<ul>\n";
	for ($i=0; $i < @selusers; $i++) {
		print "<li>", @selusers[$i], "\n";
	}
	print "</ul>\n";
	exit();
}

sub assignsect {
	local($i, $retval);

	&clearUserData;

	@selusers = $CGIQuery->param('selusers');
	$section = $CGIQuery->param('section');
	
	@selusers = sort(@selusers);
	
	if (@selusers == 0) {
		# No users selected
		&showErrorBackHTML("You must select at least one user to edit.", 1);
		exit();
	}
	if ($section eq "") {
		# No section selected
		&showErrorBackHTML("You must select a section.", 1);
		exit();
	}

	&showHeaderBackHTML("Changing User $SorGs");
	
	($junk, $sectnum) = split(/\:/, $section);
	$Msectname = $C_Sects{$sectnum}{"name"};
	
	# Turn on signal Handling
	$trapSignals = 1;
	
	for ($i=0; $i < @selusers; $i++) {
		&lookupUser(@selusers[$i]);
		@data = (@selusers[$i], $U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email, $U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_PhotoLarge, $U_Classify, $U_Sig, $U_HideEmail);
		
		if ($U_C_Sect ne $section && @selusers[$i] ne "Anonymous" && @selusers[$i] ne "Guest") {
			($junk, $Usectnum) = split(/\:/, $U_C_Sect);
			$Usectname = $C_Sects{$Usectnum}{"name"};
		
			print "User $selusers[$i] moved from $Usectname to $Msectname<br>\n";
		
			$U_C_Sect = $section;
		
			$retval = &addtodb(@selusers[$i]);
			if ($retval) {
				&userDBError($retval);
			}
		
			#&delfromht(@selusers[$i]);
			#&delfrommail(@selusers[$i]);
			
			#&addtoht(@selusers[$i], $U_C_Sect);
			#&addtomail(@selusers[$i]);
		} else {
			print "User $selusers[$i] unchanged<br>\n";
		}
	}
	
	# rebuild mailing lists and .ht files from scratch
	&rebuildAllMailAndHT();
	
	# If we got a signal, exit here.
	if ($gotSignal) {
		close(DEVNULL);
		exit(0);
	}
}

sub copyOrSkip {
	# What to do with existing users?
	local($users) = @_;
	local($i);
	
	$helplink = "file=UsersEditCORP_Admin.html&anchor=EditMultipleUserListEdtFSummary";
	$helplink .= "&helptitle=Edit%20Users%20Editing%20Frame";
	
	&showHeaderBackHTML("Existing Users","<br>", 0, 0, 0, $helplink);
	
	print "The following users already exist in the $copyto $CorF: ";
	print $FontRed, $users, "</font>.<p>";
	print "You can either overwrite these users, or skip these users.<p>";
	
	print "<form action=$CGIEnvScript method=POST>";
	print "<input type=hidden name=fid value=$Class>";
	print "<input type=hidden name=copyto value=$copyto>";
	print "<input type=hidden name=func value=showedit>";
	print "<input type=radio name=copyorskip value=\"OVER\" checked> Overwrite &nbsp;\n";
	print "<input type=radio name=copyorskip value=\"SKIP\"> Skip<p>\n";
	print $BtnFormUserCp;
	
	for ($i=0; $i < @selusers; $i++) {
		print "<input type=hidden name=selusers value=\"";
		print @selusers[$i], "\">\n";
	}
	
	print "</form>";
	exit();
}

sub pickSections {
	local($i, $j);

	&showHeaderBackHTML("Choose $SorGs");
	
	print "The $sorgs for these users do not exist in the $corf ";
	print "to which the users are being copied. Please select the target ";
	print "$sorgs for these users.<br>";
	print "<form action=$CGIEnvScript methind=POST>\n";
	print "<input type=hidden name=copyto value=$copyto>\n";
	print "<input type=hidden name=fid value=$Class>\n";
	print "<input type=hidden name=func value=showedit>\n";
	print "<input type=hidden name=assigned value=true>\n";
	print "<input type=hidden name=copyorskip value=$copyorskip>\n";	
	for ($i=0; $i < @selusers; $i++) {
		print "<input type=hidden name=selusers value=\"";
		print @selusers[$i], "\">\n";
	}
	
	for ($i=0; $i < @needsections; $i++) {
		print @needsections[$i], " &nbsp; ";
		print "<select name=\"", @needsections[$i], "\">\n";
		for ($j=1; $j <= @existsections; $j++) {
			if (@existsectnames[$j] ne "" && @existsections[$j] ne "") {
				print "<option value='", $copyto, ":", @existsections[$j], "'";
				print ">";
				print @existsectnames[$j], "\n";
			}
		}
		print "</select><br>\n";
	}
	print "<br>\n";
	print $BtnFormUserCp;
	print "\n</form>";	
}

sub confirmDel {
	# Print user deletion confirmation page.
	
	&showHeaderBackHTML("Are you Sure?");
	
	print $FontSize2, "$FontRed<b>Are you sure you want to ";
	print "permanently delete the following users?</font></font><p>\n";
	
	print "<ul>\n";
	for ($i=0; $i < @selusers; $i++) {
		print "<li>", @selusers[$i], "\n";
	}
	print "</ul>\n";
	
	print "<form action=$CGIEnvScript method=POST>";
	print "<input type=hidden name=fid value=$Class>";
	print "<input type=hidden name=func value=showedit>";
	print "<input type=radio name=confirm value=\"YES\"> Yes\n";
	print "<input type=radio name=confirm value=\"NO\" checked> No<br>\n";
	print $BtnFormUserDel;
	
	for ($i=0; $i < @selusers; $i++) {
		print "<input type=hidden name=selusers value=\"";
		print @selusers[$i], "\">\n";
	}
	
	print "</form>";
	
}
