<%
//	Created by:	Lineasoft Sagl
//	Web site:	www.lineasoft.ch
//	Version:	1.2  (01.10.2002)
//	File:		contentHTML.inc
//
//	Copyright  2002, Lineasoft Sagl (Switzerland)
%>	

<%
	////////////////////////////////////////////////////////////////////////////////////////////
	// Class ContentHTML
	////////////////////////////////////////////////////////////////////////////////////////////
	function ContentHTML( recordSet, from, to )
	{	
		// Properties 
		this.EOF				= true;
		this.BOF				= true;
		this.RecordCount		= 0;
		this.RecordPos			= -1;


		// Methods for navigation;
		this.MoveFirst			= MoveFirst001;
		this.MoveLast			= MoveLast001;
		this.Move				= Move001;
		this.MoveNext			= MoveNext001;
		this.MovePrev			= MovePrev001;		

		// Methods for values;
		this.GetValue				= Get001Value;
		
		this.GetId					= Get001Id;
		this.GetTitle				= Get001Title;
		this.GetBody				= Get001Body;		
		this.GetCreationDate		= Get001CreationDate;
		this.GetModificationDate	= Get001ModificationDate;	

		// Constructor
		this.rst = recordSet;
		
		if (from == null || from < 0)
			from = 0;
		
		if (from >= recordSet.RecordCount)
			from = recordSet.RecordCount-1;
		
		this.from = from;
		
		if (to == null || to == -1)
			this.to = recordSet.RecordCount-1;
		else
		{
			if (to < this.from)
				to = this.from;
			
			if (to >= recordSet.RecordCount)
				to = recordSet.RecordCount-1;
				
			this.to = to;
		}
		
		if (this.from == -1)
		{
			this.RecordCount = 0;
			this.BOF = true;
			this.EOF = true;
		}
		else	
		{
			this.RecordCount = this.to - this.from + 1;
			this.MoveFirst();
		}
	}
	
	
	function MoveFirst001()
	{
		if (this.RecordCount > 0)
		{
			this.rst.Move(this.from, adBookmarkFirst);
			this.RecordPos = 0;
			this.BOF = false;
			this.EOF = false;
		}
	}
	
	
	function MoveLast001()
	{
		if (this.RecordCount > 0)
		{
			this.rst.Move(this.to, adBookmarkFirst);
			this.RecordPos = this.RecordCount-1;
			this.BOF = false;
			this.EOF = false;
		}
	}

	function Move001(pos)
	{
		if (pos < 0)
			this.BOF = true;
		else if (pos >= this.RecordCount)
			this.EOF = true;
		else
		{
			this.rst.Move(this.from + pos, adBookmarkFirst);
			this.BOF = false;
			this.EOF = false;
		}
	}

	function MoveNext001()
	{
		if (this.RecordPos == this.RecordCount-1)
			this.EOF = true;
		else
		{
			this.RecordPos++;
			this.rst.Move(1, adBookmarkCurrent);
			this.BOF = false;
		}
	}
	
	function MovePrev001()
	{
		if (this.RecordCount == 0 || this.RecordPos == 0)
			this.BOF = true;
		else
		{
			this.RecordPos--;
			this.rst.Move(-1, adBookmarkCurrent);
			this.EOF = false;
		}
	}

	function Get001Value(fieldDb, defaultValue)
	{
		if (this.rst == null || this.EOF == true || this.BOF == true)	
			return defaultValue;		

		return this.rst(fieldDb).value != null ? this.rst(fieldDb).value : defaultValue;					
	}
	
	function Get001Id()					{ return this.GetValue("list_id", 1);}
	function Get001Title()				{ return this.GetValue("title", "");}
	function Get001Body()				{ return Parser(this.GetValue("body", ""));}
	function Get001CreationDate()		{ return GetFormattedDate(this.GetValue("creation_date", ""), false);}
	function Get001ModificationDate()	{ return GetFormattedDate(this.GetValue("modification_date", ""), false);}
	
%>