unit QzHtmlScrollBox2;
{*********************************************************}
{*                  QzHTMLScrollBox2.pas                 *}
{*            Quick Zip HTML Scrollable Control          *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}

interface

uses
  Forms, SysUtils, Classes, Controls, QzMiniHtml2, StdCtrls, Graphics, Messages, Windows;


type
  TQzHtmlScrollBox2 = class(TScrollBox)
 private
    { Private declarations }
     InputHtml : TQzHtmlRec;
     Input : string;
     Canvas :  TControlCanvas;
     procedure SetCaption(Value : TQzHtmlRec);
     function GetCaption : TQzHtmlRec;
     procedure SetInput(Value : string);
     function GetInput : string;
  protected
    { Protected declarations }
  public
    { Public declarations }
    QzMiniHtml2 : TQzMiniHtml2;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    procedure PaintWindow(DC: HDC); override;
    procedure Paint; dynamic;
//    procedure Repaint; override;
    procedure updatecaption;
    procedure OnHtmlUpdate(Sender: TObject; newHtml : string; newHKey : char);
  published
    { Published declarations }
    property HtmlEditor : TQzHtmlRec read getCaption write setcaption;
    property Html : String read GetInput write SetInput;
  end;

procedure Register;

implementation

destructor TQzHtmlScrollBox2.Destroy;
begin
  QzMiniHtml2.free;
  Canvas.Free;
  Inherited Destroy;
end;

procedure TQzHtmlScrollBox2.OnHtmlUpdate(Sender: TObject; newHtml : string; newHKey : char);
begin
  Input := newHtml;
  if newHkey <> ' ' then
  Caption := '&' + newHKey else
  Caption := '';
  Invalidate;
end;

constructor TQzHtmlScrollBox2.Create(AOwner:TComponent);
begin

  Inherited Create(AOwner);
  AutoSize := False;
  ParentColor := True;
  QzMiniHtml2 := TQzMiniHtml2.Create(Self);
  QzMiniHtml2.MouseKBHandler1 := TNormalHandler.Create(Self,QzMiniHtml2);
  Canvas :=  TControlCanvas.Create;
  Canvas.Control := Self;
  QzMiniHtml2.Canvas := Canvas;
  QzMiniHtml2.Owner := Self;
  QzMiniHtml2.Indent := 0;
  QzMiniHtml2.Top := 0;
  QzMiniHtml2.Left := 0;
  QzMiniHtml2.Height := Height;

  InputHtml := QzMiniHtml2.Caption;
  OnMouseMove := QzMiniHtml2.MouseMove;
  OnMouseDown := QzMiniHtml2.MouseDown;
  OnMouseUp := QzMiniHtml2.MouseUp;
  QzMiniHtml2.Caption.Html := Html;
  QzMiniHtml2.Caption.FHtmlUpdate := OnHtmlUpdate;
  HtmlEditor.Html := Html;
end;

procedure TQzHtmlScrollBox2.updatecaption;
begin

  QzMiniHtml2.Width := Width-12;
  QzMiniHtml2.Height := Height;
  QzMiniHtml2.LoadFromCaption;
end;



procedure TQzHtmlScrollBox2.WMPaint(var Message: TWMPaint);
begin
  PaintHandler(Message);
end;


procedure TQzHtmlScrollBox2.PaintWindow(DC: HDC);
begin
  inherited paintWindow(DC);
  Paint;
end;


procedure TQzHtmlScrollBox2.paint;
begin
  QzMiniHtml2.Width := Width-12;
  QzMiniHtml2.Height := Height;

     QzMiniHtml2.ScrollTop := VertScrollBar.Position;
     Canvas.Brush.Color := Color;
     QzMiniHtml2.Color := Color;
     Canvas.FillRect(Rect(11,0,Width,Height));
     if QzMiniHtml2.CacheBitmap.Width = 0 then
       begin
        InputHtml.Html := Html;
        QzMiniHtml2.LoadFromCaption;
       end else
        QzMiniHtml2.ReDraw;
     VertScrollBar.Range := QzMiniHtml2.CacheBitmap.Height;

end;


procedure TQzHtmlScrollBox2.SetCaption(Value : TQzHtmlRec);
begin
  Html := Value.Html;
  InputHtml.Html := Html;
  QzMiniHtml2.Color := Color;
  QzMiniHtml2.LoadFromCaption;
end;

procedure TQzHtmlScrollBox2.SetInput(Value : string);
begin
  input := Value;
  InputHtml.Html := input;
  QzMiniHtml2.Color := Color;
  QzMiniHtml2.LoadFromCaption;
end;

function TQzHtmlScrollBox2.GetInput : string;
begin
  result := InputHtml.Html;
end;


function TQzHtmlScrollBox2.GetCaption : TQzHtmlRec;
begin
  Result := InputHtml;
end;

procedure Register;
begin
  RegisterComponents('QZip', [TQzHtmlScrollBox2]);
end;

end.
