/*
	JMessengerServer.java
*/
import java.net.*;
import java.io.*;
import java.util.*;

public class JMessengerServer {
	private static ServerSocket jserverSocket;
	private static int port;

	private Hashtable ht = new Hashtable();

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: java ChatServer [port]");
            System.exit(1);
        }
		port = Integer.parseInt(args[0]) ;

		new JMessengerServer();
	}

	public JMessengerServer() throws IOException {
		Socket jclientSocket;

		try {
			jserverSocket = new ServerSocket(port);

			System.out.println("Chat Server started at: " + jserverSocket.getInetAddress().getLocalHost() + ":" + jserverSocket.getLocalPort());

			while (true) {
				jclientSocket = jserverSocket.accept();

				System.out.println("Connection from: " + jclientSocket);

				DataOutputStream outData = new DataOutputStream(jclientSocket.getOutputStream());

				ht.put(jclientSocket, outData);

				Thread thread = new Thread(new ServerThread(jclientSocket, ht));

				thread.start();
			}
		}
	    catch (IOException ex) {
			ex.printStackTrace();
	    }
	}
}

class ServerThread extends Thread implements Runnable {
	private Socket jclientSocket;
	private Hashtable ht;

	public ServerThread(Socket jclientSocket, Hashtable ht) {
		this.jclientSocket = jclientSocket;
		this.ht = ht;
	}

	public void run() {
		DataInputStream inData;

		try {
			inData = new DataInputStream(jclientSocket.getInputStream());

			while (true) {
				String message = inData.readUTF();

				System.out.println("Message from: " + message);

				synchronized(ht) {
					for (Enumeration e = ht.elements(); e.hasMoreElements(); ) {
						DataOutputStream outData = (DataOutputStream)e.nextElement();

						try {
							outData.writeUTF(message);
						}
					    catch (IOException ex) {
							ex.printStackTrace();
					    }
					}
				}
			}
		}
	    catch (IOException ex) {
	    }
		finally {
			synchronized(ht) {
				System.out.println("Disconnection: " + jclientSocket);

				ht.remove(jclientSocket);

				try {
					jclientSocket.close();
				}
			    catch (IOException ex) {
			    }
			}
		}
	}
}