VERSION 5.00
Begin VB.Form fMainForm 
   Caption         =   "VFW Sample Program"
   ClientHeight    =   3375
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   7530
   LinkTopic       =   "Form1"
   ScaleHeight     =   3375
   ScaleWidth      =   7530
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame kCaptureFrame 
      Height          =   495
      Left            =   3000
      TabIndex        =   9
      Top             =   2520
      Width           =   2175
      Begin VB.ComboBox kCaptureRate 
         Appearance      =   0  'Flat
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   330
         Left            =   1200
         Style           =   2  'Dropdown List
         TabIndex        =   11
         Top             =   120
         Width           =   615
      End
      Begin VB.CheckBox kCapture 
         Caption         =   "Capture"
         Height          =   255
         Left            =   120
         TabIndex        =   10
         Top             =   120
         Width           =   855
      End
      Begin VB.Label kCaptureLabel1 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "at "
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   960
         TabIndex        =   13
         Top             =   120
         Width           =   255
      End
      Begin VB.Label kCaptureLabel2 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "fps"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1800
         TabIndex        =   12
         Top             =   120
         Width           =   255
      End
   End
   Begin VB.Frame kStreamFrame 
      Height          =   495
      Left            =   240
      TabIndex        =   7
      Top             =   2520
      Width           =   2655
      Begin VB.ComboBox kStreamRate 
         Appearance      =   0  'Flat
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   330
         Left            =   1680
         Style           =   2  'Dropdown List
         TabIndex        =   14
         Top             =   120
         Width           =   615
      End
      Begin VB.CheckBox kStream 
         Caption         =   "Stream Video"
         Height          =   255
         Left            =   120
         TabIndex        =   8
         Top             =   120
         Width           =   1335
      End
      Begin VB.Label kStreamLabel2 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "fps"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   2280
         TabIndex        =   16
         Top             =   120
         Width           =   255
      End
      Begin VB.Label kStreamLabel1 
         Alignment       =   2  'Center
         Appearance      =   0  'Flat
         BackColor       =   &H80000005&
         BackStyle       =   0  'Transparent
         BorderStyle     =   1  'Fixed Single
         Caption         =   "at "
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1440
         TabIndex        =   15
         Top             =   120
         Width           =   255
      End
   End
   Begin VB.Frame kDlgButtonFrame 
      Caption         =   "Settings"
      Height          =   1815
      Left            =   5040
      TabIndex        =   3
      Top             =   840
      Width           =   1455
      Begin VB.CommandButton kSourceDlgButton 
         Caption         =   "Video Source"
         Height          =   375
         Left            =   120
         TabIndex        =   6
         Top             =   360
         Width           =   1215
      End
      Begin VB.CommandButton kFormatDlgButton 
         Caption         =   "Video Format"
         Height          =   375
         Left            =   120
         TabIndex        =   5
         Top             =   840
         Width           =   1215
      End
      Begin VB.CommandButton kDisplayDlgButton 
         Caption         =   "Video Display"
         Height          =   375
         Left            =   120
         TabIndex        =   4
         Top             =   1320
         Width           =   1215
      End
   End
   Begin VB.Timer kCaptureTimer 
      Left            =   5760
      Top             =   240
   End
   Begin VB.PictureBox kStreamWindow 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   1335
      Left            =   120
      ScaleHeight     =   1335
      ScaleWidth      =   1935
      TabIndex        =   2
      Top             =   960
      Visible         =   0   'False
      Width           =   1935
   End
   Begin VB.ComboBox kCameraList 
      Height          =   315
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   0
      Top             =   480
      Width           =   5175
   End
   Begin VB.Image kCaptureWindow 
      Appearance      =   0  'Flat
      BorderStyle     =   1  'Fixed Single
      Height          =   1335
      Left            =   2160
      Stretch         =   -1  'True
      Top             =   960
      Visible         =   0   'False
      Width           =   2295
   End
   Begin VB.Label kCameraListTitle 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Available Video for Windows [VFW] Cameras"
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Width           =   4815
   End
End
Attribute VB_Name = "fMainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
DefLng A-Z

'PinState constants
Private Const psOff  As Long = 0
Private Const psWarm As Long = 1
Private Const psOn   As Long = 2
'Variables
Private mMargin         As Single
Private mkVFW           As Tsaxvfwa 'This is the VFW AX control
Private mPins           As Long
Private mCurrentPin     As Long
Private Sub initialize_controls()
 kCameraListTitle.BorderStyle = 0
 kStreamFrame.BorderStyle = 0
 kStreamLabel1.BorderStyle = 0
 kStreamLabel2.BorderStyle = 0
 kStream_Click
 With kStreamRate
  .Clear
  .AddItem "0"
  .AddItem "2"
  .AddItem "5"
  .AddItem "10"
  .AddItem "15"
  .AddItem "20"
  .AddItem "30"
  .ListIndex = 4
 End With
 kCaptureFrame.BorderStyle = 0
 kCaptureLabel1.BorderStyle = 0
 kCaptureLabel2.BorderStyle = 0
 kCapture_Click
 With kCaptureRate
  .Clear
  .AddItem "1"
  .AddItem "2"
  .AddItem "5"
  .AddItem "10"
  .ListIndex = 1
 End With
End Sub
Private Sub set_pin_state()
 If valid_pin(mCurrentPin) Then
  With mkVFW
   '----------------------------------------------------'
   ' If either Stream or Capture are requested, set the '
   ' PinState to 'On'. Otherwise, drop to 'Warm'. Note  '
   ' that 'Warm' is the minimum state for the dialog    '
   ' boxes to be detected/activated.                    '
   '----------------------------------------------------'
   If kCapture.Value <> 0 Or _
      kStream.Value <> 0 Then
    .PinState(mCurrentPin) = psOn
   Else
    .PinState(mCurrentPin) = psWarm
   End If
  End With
 End If
End Sub
Private Sub size_image_boxes()
Dim maxwidth!, maxheight!, maxaspect!
Dim l!, t!, w!, h!
Dim myaspect!
Dim w1!, w2!, h1!, h2!
 '---------------------------------------------
 'Max dimensions for each window area.
 maxheight = kStreamFrame.Top - _
            (kCameraList.Top + kCameraList.Height) - _
             mMargin
 maxwidth = (kDlgButtonFrame.Left / 2!) - (2! * mMargin)
 maxaspect = maxwidth / maxheight
 '---------------------------------------------
 l = mMargin
 t = kCameraList.Top + kCameraList.Height + mMargin
 w = mkVFW.ImageWidth(mCurrentPin)
 If w > 1! Then
  h = mkVFW.ImageHeight(mCurrentPin)
  myaspect = w / h
  If myaspect > maxaspect Then
   w = maxwidth
   h = w / myaspect
  Else
   h = maxheight
   w = h * myaspect
  End If
  kStreamWindow.Move l, t, w, h
  mkVFW.StreamWindow(mCurrentPin) = mkVFW.StreamWindow(mCurrentPin)
  l = l + (kDlgButtonFrame.Left / 2!)
  kCaptureWindow.Move l, t, w, h
 End If
End Sub
Private Sub set_dlg_buttons()
 With mkVFW
  kSourceDlgButton.Enabled = .HasVideoSourceDlg(mCurrentPin)
  kFormatDlgButton.Enabled = .HasVideoFormatDlg(mCurrentPin)
  kDisplayDlgButton.Enabled = .HasVideoDisplayDlg(mCurrentPin)
 End With
End Sub

Private Function valid_pin(ByVal lPin&) As Boolean
Dim ret As Boolean
 ret = False
 If lPin >= 0 And _
    lPin < mPins Then
  ret = True
 End If
valid_pin = ret
End Function

Private Sub Form_Initialize()
 mMargin = 3! * Screen.TwipsPerPixelX
 mCurrentPin = -1&
 Load fTSAXForm
 Set mkVFW = fTSAXForm.kVfw
 mPins = mkVFW.Pins
 If mPins = 0 Then
  MsgBox "No Video for Windows video devices detected."
  Unload fTSAXForm
  End
 End If
End Sub
Private Sub Form_Load()
Dim myctr&
Dim l!, t!
 initialize_controls
 'Load the camera list
 With mkVFW
  For myctr = 0 To .Pins - 1
   kCameraList.AddItem .PinName(myctr)
  Next myctr
 End With
 kCameraList.ListIndex = 0
 DoEvents
 'Center the form
 l = (Screen.Width - Width) / 2!
 t = (Screen.Height - Height) / 2!
 Move l, t
End Sub
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
 Unload fTSAXForm
End Sub


Private Sub Form_Resize()
Dim l!, t!, w!, h!
Dim midpoint!
 '----------------------------------------------------------------'
 ' First, place the camera list at the top.                       '
 '----------------------------------------------------------------'
 l = mMargin
 t = mMargin
 w = ScaleWidth - mMargin - l
 kCameraListTitle.Move l, t, w
 t = t + kCameraListTitle.Height - mMargin
 kCameraList.Move l, t, w
 '----------------------------------------------------------------'
 ' Now, set the dialog button frame on the right.                 '
 '----------------------------------------------------------------'
 l = ScaleWidth - kDlgButtonFrame.Width - mMargin
 t = kCameraList.Top + kCameraList.Height
 kDlgButtonFrame.Move l, t
 '----------------------------------------------------------------'
 ' Place the stream and capture check-box frames.                 '
 '----------------------------------------------------------------'
 midpoint = kDlgButtonFrame.Left / 2!
 l = (midpoint - kStreamFrame.Width) / 2!
 t = ScaleHeight - kStreamFrame.Height
 kStreamFrame.Move l, t
 l = midpoint + ((kDlgButtonFrame.Left - midpoint - kCaptureFrame.Width) / 2!)
 kCaptureFrame.Move l, t
 '----------------------------------------------------------------'
 ' Now deal with the image controls.                              '
 '----------------------------------------------------------------'
 size_image_boxes
 '----------------------------------------------------------------'
End Sub
Private Sub kCameraList_Click()
Dim was_pin&
 was_pin = mCurrentPin
 If kCameraList.ListIndex <> was_pin Then
  MousePointer = vbHourglass
  With mkVFW
   If was_pin >= 0& Then
    .PinState(was_pin) = psOff
   End If
   kStream.Value = 0
   kCapture.Value = 0
   mCurrentPin = kCameraList.ListIndex
   .CaptureFile(mCurrentPin) = ""
   .PinState(mCurrentPin) = psWarm
  End With
  set_pin_state
  size_image_boxes
  set_dlg_buttons
  MousePointer = vbDefault
 End If
End Sub

Private Sub kCapture_Click()
Dim set_to As Boolean
 If kCapture.Value = 0 Then
  set_to = False
 Else
  set_to = True
 End If
 kCaptureLabel1.Visible = set_to
 kCaptureRate.Visible = set_to
 kCaptureLabel2.Visible = set_to
 kCaptureTimer.Enabled = set_to
 kCaptureWindow.Visible = set_to
 set_pin_state
End Sub

Private Sub kDisplayDlgButton_Click()
 mkVFW.ShowVideoDisplayDlg mCurrentPin
End Sub

Private Sub kFormatDlgButton_Click()
 mkVFW.ShowVideoFormatDlg mCurrentPin
End Sub

Private Sub kCaptureRate_Click()
Dim myint&
 kCaptureTimer.Interval = 1000 / kCaptureRate.List(kCaptureRate.ListIndex)
End Sub


Private Sub kSourceDlgButton_Click()
 mkVFW.ShowVideoSourceDlg mCurrentPin
End Sub

Private Sub kStream_Click()
Dim set_to As Boolean
 With mkVFW
  If kStream.Value = 0 Then
   If valid_pin(mCurrentPin) Then
    .StreamWindow(mCurrentPin) = 0&
   End If
   set_to = False
  Else
   If valid_pin(mCurrentPin) Then
    .StreamWindow(mCurrentPin) = kStreamWindow.hWnd
   End If
   set_to = True
  End If
 End With
 kStreamLabel1.Visible = set_to
 kStreamRate.Visible = set_to
 kStreamLabel2.Visible = set_to
 kStreamWindow.Visible = set_to
 set_pin_state
End Sub

Private Sub kStreamRate_Click()
 If valid_pin(mCurrentPin) Then
  mkVFW.StreamRate(mCurrentPin) = kStreamRate.List(kStreamRate.ListIndex)
 End If
End Sub


Private Sub kCaptureTimer_Timer()
 kCaptureWindow.Picture = mkVFW.Picture(mCurrentPin)
End Sub


