;========================================================================

; Copyright (C) 1991-95 by Jan.Engvald@ldc.lu.se, see file COPYING.

if TBLBUILD

;************************************************************************
;*		ThisIpFirst
;*	Input:		CS:DI = addr of length prepended IP list
;*			DS:BX = IP description buffer pointer
;*	Output: 	Moves source IP # to front of IP list
;*	Destroys:	AX, CX, DX, SI, DI and flags
;************************************************************************

ThisIpFirst	proc	near
		assume	ds:nothing
		push	es
		push	cs
		pop	es
		mov	si,[bx].dPtrIp
		mov	dx,[si].iIpSrc
		mov	ax,[si].iIpSrc+2
		mov	cl,-1
		mov	ch,cs:[di] 		; list length
  ThisIpNext2:
		inc	di
		inc	di
  ThisIpNext4:
		inc	cl
		cmp	cl,ch			; more entries in list?
		jae	ThisIpRet

		xchg	ax,dx
		scasw				; first IP word match?
		xchg	ax,dx
		jne	ThisIpNext2

		scasw				; second IP word match?
		jne	ThisIpNext4

		dec	di
		lea	si,[di-4]
		xor	ch,ch
		shl	cx,1
		jcxz	ThisIpL1e

		cli				; needed due to int routine bug
		std				; move entries downlist
		rep	movs word ptr es:[DefNS],cs:[DefNS]
		cld
		sti
  ThisIpL1e:
		inc	si
		mov	cs:[si],dx 		; insert src IP in front
		mov	cs:[si+2],ax
  ThisIpRet:
		pop	es
		ret
ThisIpFirst	endp

endif ; TBLBUILD


		assume	ds:nothing

;************************************************************************
;*		SendUdpFind
;*
;*	Input:		DS:BX = IP description buffer ptr (saved)
;*			DS:[BX].dPktLen = IP data byte length
;*			CS:DX = addr of length prepended IP list to send to
;*				 until reply received
;*	Output: 	Zero and CX = 0 if OK
;*			non-zero and CX = errorcode if error 
;*	Destroys:	AX, CX, DX, SI, DI, ES and flags
;************************************************************************

SendUdpFind	proc	near
		mov	[bx].dTimoutMsg,0	; continue even if no reply
		mov	ah,2			; do 2 turns over all IP #s
  Send2ndTurn:
		mov	si,dx			; get IP list addr
		lods	byte ptr cs:[TservNum]	; # of IP numbers to al
		mov	cx,SERRNOIP
		or	al,al
		jz	SendUdpFindRet

		inc	si
  SendNextIP:
		push	ds
		pop	es
		mov	di,[bx].dPtrIp
		lea	di,[di].iIpDst		 ; put next IP number
		movs	es:[iIpDst],word ptr cs:[TimeServIpNr]
		movs	es:[iIpDst+2],word ptr cs:[TimeServIpNr]

		cmp	ax,0101h		; last IP last turn?
		jne	Send2orMore
		mov	di,[bx].dTimOut2Msg
		mov	[bx].dTimoutMsg,di	; -yes, terminate if no reply
  Send2orMore:
		push	ax
		push	dx
		push	si
		call	SendUdpPkt		; send udp packet
		pop	si
		pop	dx
		pop	ax
		jz	SendUdpFindRet		; done if reply

		dec	al
		jnz	SendNextIP		; more IP numbers this turn?

		mov	di,[bx].dTick2Timeout	; -no, use longer timeout
		mov	[bx].dTickTimeout,di	;   for 2nd turn
		dec	ah
		jnz	Send2ndTurn		; both turns done?

  SendUdpFindRet:
		or	cx,cx
		ret
SendUdpFind	endp



;************************************************************************
;*		SendUdpPkt
;*
;*	Input:		DS:BX = IP description buffer ptr (saved)
;*			DS:[BX].dPktLen = IP data byte length
;*	Output: 	Zero and CX = 0 if OK
;*			non-zero and CX = errorcode if error 
;*	Destroys:	AX, CX, DX, SI, DI, ES and flags
;************************************************************************

SendUdpPkt	proc	near
		mov	dx,cs:MyIpNr		; fill in my IP # (used
		mov	di,[bx].dPtrIp		;   in udp chksum!)
		mov	[di].iIpSrc,dx
		mov	dx,cs:MyIpNr+2
		mov	[di].iIpSrc+2,dx

		mov	ax,[bx].dPktLen
		xchg	ah,al
		mov	si,[bx].dPtrUdp
		mov	[si].uUdpLen,ax 	; fill in UDP total length

		mov	[si].uUdpXsum,ax	; ensure chksum is calculated

		mov	[di].iIpProt,UDP_PROT	; set UDP protocol

		call	UdpChkSum		; calculate UDP checksum

		jmp	short SendIpPkt		; send UDP packet
SendUdpPkt	endp



;************************************************************************
;*		SendIcmpPkt
;*
;*	Input:		DS:BX = IP description buffer ptr (saved)
;*			DS:[BX].dPktLen = IP data byte length
;*	Output: 	Zero and CX = 0 if OK
;*			non-zero and CX = errorcode if error 
;*	Destroys:	AX, CX, DX, SI, DI, ES and flags
;************************************************************************

SendIcmpPkt	proc	near
		call	IcmpChkSum		; calculate icmp checksum

		mov	di,[bx].dPtrIp
		mov	[di].iIpProt,ICMP_PROT
SendIcmpReply:
		mov	[bx].dWaitEvent,0	; don't wait for answer

;		call	SendIpPkt
;		ret
SendIcmpPkt	endp



;************************************************************************
;*		SendIpPkt
;*
;*	Input:		DS:BX = IP description buffer ptr (saved)
;*			DS:[BX].dPktLen = IP data byte length
;*	Output: 	Zero and CX = 0 if OK
;*			non-zero and CX = errorcode if error 
;*	Destroys:	AX, CX, DX, SI, DI, ES and flags
;************************************************************************

SendIpPkt	proc	near
		mov	di,[bx].dPtrIp		; calculate IP hdr length
		mov	cx,[bx].dPtrUdp
		sub	cx,di

		mov	dx,cs:MyIpNr		; my IP # to IP src
		mov	[di].iIpSrc,dx
		mov	dx,cs:MyIpNr+2
		mov	[di].iIpSrc+2,dx

		mov	ax,[bx].dPktLen
		push	ax
		add	ax,cx			; add hdr length to data length
		mov	[bx].dPktLen,ax 	;   and save it

		xchg	ah,al
		mov	[di].iIpLen,ax		; fill in IP length

		mov	dx,cs:IpIdCounter
		mov	[di].iIpId,dx		; unique id for frag reassembly
		inc	dx
		mov	cs:IpIdCounter,dx

		call	IpChkSum		; calculate checksum

		cmp	byte ptr cs:ArpBuf.iArpHtype+1,0 ; slip?
		je	SendIpAndWait

		call	PutPhysDst		; do we have HW dest addr?
		jnz	SendIpRet		; -no, ARP timed out

		call	PutPhysSrc		; put my HW src addr

		add	[bx].dPktLen,cx 	; pkt length (HW addr part)
  SendIpAndWait:
		call	SendAndWait		; -yes, send packet
  SendIpRet:
		pop	[bx].dPktLen
		ret
SendIpPkt	endp



;************************************************************************
;*		PutPhysDst
;*
;*	Input:		DS:BX = IP description buffer ptr (saved)
;*	Output: 	Zero and CX = 0 if OK
;*			non-zero and CX = errorcode if error 
;*			ES = DS
;*	Destroys:	AX, CX, DX, SI, DI, ES, flags
;************************************************************************

PutPhysDst	proc	near
		mov	ax,cs:DefGwyNum		; # of default gwys we have
		mov	[bx].dGwys2Chk,al	; gwys still left to check
  PutPhysAgain:

		mov	di,[bx].dPtrIp
		mov	al,[di].iIpTos		; get type of service
		xor	ah,ah
		mov	si,ax

		mov	dx,[di].iIpDst		; set dx,ax = dst IP #
		mov	ax,[di].iIpDst+2

		call	ArpPutHwDst		; do we know dst phys addr?
		jz	FoundArpEntry		; - yes, copied hw addr

		call	MyNetChk		; - no. Is dst on my net?
		jz	PutMynetArp		;   - yes, don't use gwy
						;	   and ARP dst
		call	UseGwy			;   - no, use a gateway
		jcxz	PutArp			; destination unreachable?
		jmp	short PutPhysRet

  PutMynetArp:
		mov	[bx].dGwys2Chk,1
  PutArp:
		call	ArpPutHwDst		; have hw addr for this IP # ?
		jz	FoundArpEntry		; - yes, copied hw addr to pkt

		call	SendArpReq		; - no, arp for it
		jz	PutPhysAgain		; if reply, put in hw addr

		call	SwitchGwy		;   else try next gwy

		mov	cx,SERRNOARP
		dec	[bx].dGwys2Chk		; any more default gwys?
		jnz	PutPhysAgain

  PutPhysRet:
		or	cx,cx
  FoundArpEntry:
		ret
PutPhysDst	endp



;************************************************************************
;*		RouteFind
;*
;*	Input:		DX = first word of dst IP # (saved if not found)
;*			AX = second word of dst IP # (saved if not found)
;*			SI = IP type of service
;*			A PushfDI must be done before calling
;*	Output: 	if found: zero and DI = route table index
;*				  DX = first word of gwy IP #
;*				  AX = second word of gwy IP #
;*				  CX = net/host unreachable code
;*	Destroys:	CX, DI, ES, flags
;************************************************************************

RouteFindUtos	proc	near
		assume	ds:nothing
		mov	cl,[si].uIcmpIpHdr.iIpTos
RouteFindCl:
		xor	ch,ch
		mov	si,cx
RouteFind:
		mov	es,cs:MySegm
		mov	di,offset RouteTabIpD2
		mov	cx,ROUTESLOTS
  RouteFindNext:				; look for matching slot
		repne	scasw
		jnz	RouteFindRet

		cmp	dx,cs:2*RouteSLOTS-2[di] ; does dst IP first part match?
		jne	RouteFindNext		; - no, look further

		cmp	si,cs:4*RouteSLOTS-2[di] ; does dst tos	match?
		jne	RouteFindNext		; - no, look further

		sub	di,offset RouteTabIpD2+2 ;- yes, compute slot index

		mov	dx,cs:RouteTabIpG1[di]	; get gwy IP #
		mov	ax,cs:RouteTabIpG2[di]	;

		mov	cx,cs:RouteTabUnreach[di] ; get unreachable code
		mov	cs:RouteTabUnreach[di],0 ;   and clear it

		cmp	di,di			; set zero flag
  RouteFindRet:
		ret
RouteFindUtos	endp



;************************************************************************
;*		MyNetChk
;*
;*	Input:		DX = first word of IP # (saved)
;*			AX = second word of IP # (saved)
;*	Output: 	zero if same net else non-zero 
;*	Destroys:	CX, flags
;************************************************************************

MyNetChk	proc	near
		mov	cx,dx
		and	cx,cs:MyMask		; check if my net
		cmp	cx,cs:MyNet
		jne	MyNetRet
		mov	cx,ax
		and	cx,cs:MyMask+2
		cmp	cx,cs:MyNet+2
  MyNetRet:
		ret
MyNetChk	endp



;************************************************************************
;*		UseGwy
;*
;*	Input:		DX = first word of destination IP #
;*			AX = second word of destination IP #
;*			SI = IP type of service
;*			ES:BX = IP descriptor buffer ptr (saved)
;*	Output: 	DX = first word of gateway IP #
;*			AX = second part of gateway IP #
;*			CX = net/host unreachable code
;*	Destroys:	CX, SI, DI, flags
;************************************************************************

UseGwy		proc	near
		assume	ds:nothing
		push	ds
		mov	ds,cs:MySegm
		assume	ds:code_s
		push	es
		cli
		call	RouteFind		; is dst in route tbl?
		pop	es
		jz	UseGwyKnown		; - yes, have gwy IP #
						; - no, use default gwy
		dec	cx
		cmp	dl,127			; don't send to 127.x.x.x
		je	UseGwyRet

		mov	di,RoutePutSlot
		scasw				; advance index two bytes
		cmp	di,ROUTESLOTS*2 	; at end of table?
		jb	UseRouteSlot

		xor	di,di			; - yes, wrap around
  UseRouteSlot:
		mov	RoutePutSlot,di
		mov	RouteTabIpD1[di],dx	; put destination IP #
		mov	RouteTabIpD2[di],ax
		mov	RouteTabTos[di],si

		mov	si,DefGwyIndex
		shl	si,1
		shl	si,1
		mov	dx,DefGwys[si]
		mov	ax,DefGwys+2[si]
		mov	RouteTabIpG1[di],dx	;   and default gwy IP #
		mov	RouteTabIpG2[di],ax	;   into route table

		mov	cx,SavedTicks
		mov	RouteTabTrRx[di],cx	; put current time

		xor	cx,cx			; initialize other fields
		mov	RouteTabUnreach[di],cx	;   clear unreachable
		mov	RouteTabFlags[di],cx
		mov	RouteTabSqDelay[di],cx

		or	si,dx
		or	si,ax			; any non-zero gwy IP #?
		jz	UseGwyNone		; - yes
  UseGwyKnown:
if RFCC
		push	cx
		push	ax
		mov	cx,SavedTicks
		mov	RouteTabTrTx[di],cx	; transmit time

		mov	ax,RouteTabSqDelay[di]	; move sq delay to descriptor
		mov	es:[bx].dSqDelay,ax
		dec	ax			; any delay?
		js	UseNoSqDelay
		mov	ax,RouteTabTrSq[di]	; - yes
		add	ax,18			; has one second passed
		cmp	ax,cx			;   since we last decremented
		jns	UseNoSqDelay		;   the delay value?
		mov	RouteTabTrSq[di],cx
		dec	RouteTabSqDelay[di]	; - yes, one millisecond off
  UseNoSqDelay:
		pop	ax
		pop	cx
endif ; RFCC
  UsegwyRet:
		pop	ds
		assume	ds:nothing
		sti
		ret

  UseGwyNone:
		assume	ds:code_s
		mov	dx,offset NoGwyMsg	; - no, print error msg in dx
		mov	al,08			; error code 8
		call	PrTerminate
		assume	ds:nothing
UseGwy		endp



;************************************************************************
;*		SwitchGwy
;*
;*	Input:		DX = first word of gateway IP # (saved)
;*			AX = second word of gateway IP # (saved)
;*	Destroys:	CX, DI, ES, flags
;************************************************************************

SwitchGwy	proc	near
		push	ds
		mov	ds,cs:MySegm
		assume	ds:code_s
		mov	es,MySegm
		PushfDI
		mov	di,DefGwyIndex		; if current default gateway
		shl	di,1
		shl	di,1

		cmp	dx,DefGwys[di]		;   is the one
		jne	SwitchNotThis
		cmp	ax,DefGwys+2[di]	;   that failed
		jne	SwitchNotThis

		shr	di,1
		shr	di,1
		inc	di			;   then switch to
		cmp	di,DefGwyNum
		jb	SwitchNextGwy
		xor	di,di
  SwitchNextGwy:
		mov	DefGwyIndex,di		;   next default gateway
  SwitchNotThis:
		PopfEI

		mov	di,offset RouteTabIpG2	; remove failing gateway
		mov	cx,ROUTESLOTS		;   from all route slots
		PushfDI
  SwitchRouteNext:				; look for matching slot
		repne	scasw
		jnz	SwitchGwyRet		; all entries searched

		cmp	dx,2*ROUTESLOTS-2[di]	; does gwy IP 2nd part match?
		jne	SwitchRouteNext 	; - no, look further

		sub	di,offset RouteTabIpG2+2 ;- yes, clear this route
		mov	RouteTabIpD1[di],0
		mov	RouteTabIpD2[di],0
		mov	RouteTabIpG1[di],0
		mov	RouteTabIpG2[di],0
		add	di,offset RouteTabIpG2+2
		jmp	short SwitchRouteNext	; more routes using this gwy?

  SwitchGwyRet:
		PopfEI
		pop	ds
		assume	ds:nothing
		ret
SwitchGwy	endp



;************************************************************************
;*		ChkSum
;*	Input:		DS:SI = start addr
;*			CX = # of bytes (at least 6)
;*	Output: 	AX = 1-complement checksum
;*			DS:SI = addr of next byte
;*	Destroys:	AX, CX, SI, Flags
;************************************************************************

ChkSum		proc	near
if PINGCLIENT
		test	cs:GenFlags,IS_A_386
		jz	ChkSum8086

		.386
		push	edx			; save 386 registers
		push	eax
		xor	edx,edx			; clear edx
		.8086
		shr	cx,1			; divide by two, round down
		pushf				; keep odd bit in carry

		test	si,2			; double-word aligned?
		jz	ChkAligned
		lodsw
		mov	dx,ax
		dec	cx
  ChkAligned:
		shr	cx,1			; divide by two, round down
		pushf				; keep odd bit in carry

		shr	cx,1			; divide by two, round down
		jnc	ChkLoop386
		.386
		lodsd				; process 4 bytes
		add	edx,eax
		jcxz	ChkLoopEnd
  ChkLoop386:
		lodsd				; process n*8 bytes
		adc	edx,eax
		lodsd
		adc	edx,eax
		loopw	ChkLoop386
  ChkLoopEnd:
		adc	edx,0			; add the last carry in again

		mov	eax,edx			; add double word parts
		shr	eax,16
		.8086
		add	dx,ax
		adc	dx,0

		popf				; odd # of words?
		jnc	NotOddWords

		lodsw
		add	dx,ax
		adc	dx,0
  NotOddWords:
		popf				; odd # of bytes?
		jnc	NotOddBytes

		lodsb				; get that last byte
		xor	ah,ah			; clear carry and the high portion
		add	dx,ax			; add the last one in
		adc	dx,0			; add the carry in, too
  NotOddBytes:
		.386
		pop	eax			; restore saved regs
		mov	ax,dx
		pop	edx

		not	ax			; take one more 1-complement
		ret

		.8086
endif ; PINGCLIENT

  ChkSum8086:
		push	dx
		shr	cx,1			; divide by two, round down
		pushf				; keep odd bit in carry
		xor	dx,dx			; clear dx and carry

		shr	cx,1			; divide by two, round down
		jnc	ChkLoop
		lodsw				; process odd word
		add	dx,ax
  ChkLoop:
		lodsw				; process even # of words
		adc	dx,ax
		lodsw
		adc	dx,ax
		loop	ChkLoop

		adc	dx,0			; add the last carry in again

		popf				; odd # of bytes?
		jnc	NotOdd

		lodsb				; get that last byte
		xor	ah,ah			; clear carry and the high portion
		add	dx,ax			; add the last one in
		adc	dx,0			; add the carry in, too
  NotOdd:
		mov	ax,dx			; restore saved regs
		pop	dx

		not	ax			; take one more 1-complement
		ret
ChkSum		endp



;************************************************************************
;*		UdpChkSum (both for generate and check!)
;*
;*	Input:		DS:BX = IP description buffer ptr (saved)
;*			DS:DI = IP ptr
;*			DS:SI = UDP ptr
;*	Output: 	Zero if OK; checksum filled in
;*			DS:SI = addr of next byte
;*			DS:DI = IP Ptr
;*	Destroys:	AX, CX, DX, SI, flags
;************************************************************************

UdpChkSum	proc	near
		xchg	di,si

		xor	dx,dx
		push	word ptr [si].iIpTtl	; save ttl for pseudo hdr
		mov	[si].iIpTtl,dl		;   usage

		xchg	dx,[di].uUdpXsum	; save and clear checksum

                push    [si].iIpXsum            ; save IP chksum for ps-hdr use
		mov	cx,[di].uUdpLen 	; put UDP length into ps-hdr
		mov	[si].iIpXsum,cx
		xchg	ch,cl

		mov	ax,di
		add	ax,cx
		or	dx,dx			; is there a checksum?
		mov	si,ax			; - no, not available/wanted
		jz	UdpNoSum		;   but set si to end of data

		push	cx			; - yes
		mov	cx,12			; checksum pseudo hdr
		mov	si,[bx].dPtrIp
		add	si,iIpTtl
		call	ChkSum

		not	ax			; move partial checksum
		mov	[di].uUdpXsum,ax	;   into udp hdr
		pop	cx			; checksum udp hdr+data
		mov	si,di
		call	ChkSum
		jnz	UdpNotZero		; checksum is zero?
		not	ax			; - yes, make it FFFFh
  UdpNotZero:
		mov	[di].uUdpXsum,ax

		cmp	ax,dx			; does checksums match?
  UdpNoSum:
		mov	di,[bx].dPtrIp
                pop     [di].iIpXsum            ; restore IP chksum
		pop	word ptr [di].iIpTtl	; restore ttl

		ret
UdpChkSum	endp



;************************************************************************
;*		IpChkSum (both for generate and check!)
;*
;*	Input:		DS:BX = IP description buffer ptr (saved)
;*			DS:DI = IpPtr
;*			CX = IP hdr length
;*	Output: 	Zero if OK; checksum filled in
;*	Destroys:	AX, CX, DX, SI, flags
;************************************************************************

IpChkSum	proc	near
		mov	si,di
		xor	dx,dx
		xchg	dx,[di].iIpXsum 	; save and clear checksum

		call	ChkSum			; calculate new checksum
		mov	[di].iIpXsum,ax

		cmp	ax,dx			; does checksums match?
		ret
IpChkSum	endp



;************************************************************************
;*		IcmpChkSum (both for generate and check!)
;*
;*	Input:		DS:BX = IP description buffer ptr (saved)
;*	Output: 	Zero if OK; checksum filled in
;*			DI = dPtrUdp
;*	Destroys:	AX, CX, DX, SI, DI, flags
;************************************************************************

IcmpChkSum	proc	near
		mov	cx,[bx].dPktlen
		mov	si,[bx].dPtrUdp
IcmpChkSum2:
		mov	di,si
		xor	dx,dx
		xchg	dx,[di].uIcmpXsum	; save and clear checksum

		call	ChkSum			; calculate new checksum
		mov	[di].uIcmpXsum,ax

		cmp	ax,dx			; does checksums match?
		ret
IcmpChkSum	endp



;************************************************************************
;*		Ageing of ARP and Route tables and the fragment queue
;*		Also handle name server request resends
;*
;*	Destroys:	AX, BX, CX, DX, SI, DI, ES, flags
;************************************************************************

Ageing		proc	near
		assume	ds:code_s
;*test*		call	HardwareTicks
;		mov	cx,dx
		call	CurrentTicks		; get current ticks value
if RFCC
		cmp	cx,AgeNext		; time to do route/arp ageing?
		jns	AgeNow

		cmp	cx,AgeFragsNext		; time to age frags yet?
		jns	AgeFrags
endif ; RFCC
		ret


if RFCC

AgeFrags:
		mov	dx,cx
		add	cx,5*18+1 		; check next in 5 seconds
		mov	AgeFragsNext,cx

		push	ds
		cli
		mov	cx,Fraglist.lBufsAvail
  AgeLook4Buf:
		mov	di,offset FragList
		call	GetFromList
		assume	ds:nothing
		jz	AgeNoMoreFrags		; any reassembly buffers?

		mov	si,offset FragList
		cmp	dx,[bx].dTickTimeout	; too old?
		js	AgePutBack		; - no, put it back
				
		call	BufRelease		; - yes, release it
		SHOW_EVENT	'Q'
		jmp	short AgeNextBuf
  AgePutBack:
		call	AddToList	        
  AgeNextBuf:
		dec	cl
		jnz	AgeLook4Buf		; any more reassembly bufs?
  AgeNoMoreFrags:
		sti
		pop	ds
		ret


  AgeNow:
		assume	ds:code_s
		mov	di,cx
		mov	dx,cx
		mov	bx,cx
		add	cx,2*18 		; chk next 2 seconds from now
		mov	AgeNext,cx

		sub	dx,70*18		; clear what is older than 1 min
		sub	bx,140*18

		mov	cx,ARPSLOTS-3
		mov	si,offset ArpTabTr+6
		cli
  AgeArpLoop:
		and	word ptr [si+2*ARPSLOTS],not SQ_UPDATED ; clr every 2 s

		lodsw
		cmp	ax,dx
		jns	AgeArpYoung		; not touched in a minute?

		push	si
		sub	si,offset ArpTabTr+2
		mov	ArpTabTr[si],bx 	; set 2 min old time
		cmp	ax,bx			; already cleared?
		js	AgeArpEmpty

		push	cx
		push	di
		push	dx
		mov	dx,ArpTabIp1[si]
		mov	ax,ArpTabIp2[si]
		call	SwitchGwy		; in case it's a gwy: switch
		pop	dx
		pop	di
		pop	cx

		xor	ax,ax
if DEBUG ge 2
		cmp	ArpTabIp1[si],ax
		je	AgeUnused
		SHOW_EVENT	'T'
  AgeUnused:
endif ; DEBUG ge 2
		mov	ArpTabIp1[si],ax	; clear old entries
		mov	ArpTabIp2[si],ax

		rept	HWLENPWR-1
		shl	si,1
		endm

		mov	word ptr ArpTabHwAdr[si],ax
		mov	word ptr ArpTabHwAdr[si+2],ax
		mov	word ptr ArpTabHwAdr[si+4],ax
  AgeArpEmpty:
		pop	si
  AgeArpYoung:
		loop	AgeArpLoop
		sti

		add	dx,10*18		; need to age RoutTab sooner
		mov	cx,ROUTESLOTS		;   than ArpTab
		mov	si,offset RouteTabTrRx
		cli
  AgeRouteLoop:
		and	word ptr [si+2*ROUTESLOTS],not SQ_UPDATED ; clr every 2 s

		lodsw
		cmp	ax,dx			; old slot?
		jns	AgeRouteYoung

		sub	si,offset RouteTabTrRx+2
		mov	RouteTabTrRx[si],di
		xor	ax,ax
		cmp	RouteTabUnreach[si],ax	; any error code?
		jne	AgeRouteUnr

		cmp	dx,RouteTabTrTx[si]	; - no. Sent anything lately?
		jns	AgeRouteEnd		;	- no, that's why

		mov	RouteTabUnreach[si],SERRNOTRAF ;- yes, somebody is dead
		jmp	short AgeRouteEnd
  AgeRouteUnr:					; - yes, remove slot
		mov	RouteTabIpD1[si],ax
		mov	RouteTabIpD2[si],ax
		mov	RouteTabIpG1[si],ax
		mov	RouteTabIpG2[si],ax
  AgeRouteEnd:
		add	si,offset RouteTabTrRx+2
  AgeRouteYoung:
		loop	AgeRouteLoop

		sti
if TBLBUILD
		call	NsResend
endif ; TBLBUILD
		ret
endif ; RFCC
Ageing		endp



if RFCC
;************************************************************************
;*		VerifyIpHdr (RFC1122 requirements)
;*
;* verify IP dst = me or bcast, [process IP options,] verify IPver=4,
;* verify IP src not bcast, set timer value in ArpTab and RouteTab.
;* Process IP fragments.
;************************************************************************

holeStruc	struc
holeNext	dw	0
holeFirst	dw	0
holeLast	dw	0
holeStruc	ends
HOLEDESCRLEN	equ	SIZE holeStruc

k18		db	18

VerifyIpHdr	proc	near
		assume	ds:nothing
		mov	al,[di].iIpVerHlen
		and	al,0f0h
		cmp	al,040h 		; IP version 4?
		jne	VerifyErr1

		mov	ax,[bx].dPtrPhys
		call	ArpFindHw		; find Hw Dst arp index
		mov	[bx].dIdxHwDst,di	;   0 = bcast, 4 = me

		cmp	di,ARPMYIDX		; is Hw addr to me or bcast?
		ja	VerifyErr1

		mov	ax,[bx].dPtrPhys
		call	ArpFindHwHl		; is Hw Src in arp table?
		jz	VerifyChkBcast		; - yes

		cmp	[bx].dIdxHwDst,ARPMYIDX	; - no. Addressed to me?
		jne	VerifyIpDst		; 

		mov	di,[bx].dPtrIp		; - yes
		mov	dx,[di].iIpSrc
		mov	ax,[di].iIpSrc+2

		call	MyNetChk		; if he is on my net
		jnz	VerifyIpDst

		call	ArpPutNewSiHl		;   add him to arp table
		jmp	short VerifyIpDst

  VerifyChkIp:
		cmp	cs:MyIpNr,0		; do I know who I am?
		je	VerifyIpUnknown
  VerifyErr1:
		jmp	short VerifyErr

  VerifyChkBcast:
		cmp	di,ARPMYIDX		; from me or broadcast?
		jbe	VerifyErr		; - yes, ignore packet

		mov	cx,cs:SavedTicks	; get current ticks value
		mov	cs:ArpTabTr[di],cx
  VerifyIpDst:
		mov	si,[bx].dPtrIp
		mov	dx,[si].iIpDst		; check IP dst
		mov	ax,[si].iIpDst+2
		call	ArpFindIp
		mov	[bx].dIdxIpDst,di
		cmp	di,ARPMYIDX		; is it to me or broadcast?
		ja	VerifyChkIp		; - no, ignore packet
  VerifyIpUnknown:
		mov	dx,[si].iIpSrc
		mov	ax,[si].iIpSrc+2
		call	ArpFindIp		; check IP src addr
		jnz	VerifyNoArp
if TBLBUILD
		mov	cx,cs:SavedTicks	; get current ticks value
		mov	cs:ArpTabTr[di],cx
endif ; TBLBUILD
		cmp	di,ARPMYIDX		; from IP broadcast?
		jb	VerifyErr		; -yes, ignore packet
  VerifyOK:
		mov	di,[bx].dPtrIp
		test	[di].iIpFlFrag,0ff3fh	; is this a fragment?
		jnz	VerifyFrag
		clc				; - no, use as is
  VerifyRet:
		mov	si,[bx].dPtrUdp
		ret

  VerifyNoArp:
		mov	cl,[si].iIpTos
		call	RouteFindCl		; is he in route table?
		jnz	VerifyNoRoute

		mov	cx,cs:SavedTicks
		mov	cs:RouteTabTrRx[di],cx	; note we've got pkts from him


		call	ArpFindIp		; find its gateway
		jnz	VerifyNoRoute

		mov	cx,cs:SavedTicks	; get current ticks value
		mov	cs:ArpTabTr[di],cx
  VerifyNoRoute:
		jmp	short VerifyOK

  FragAddAndErr:
		SHOW_EVENT	'Y'
		mov	si,offset FragList
		push	es
		call	AddToList
		pop	es
  VerifyFragErr:
		mov	bx,bp
		push	es
		pop	ds
  VerifyErr:
		call	BufRelease
  VerifyKeep:
		stc
		mov	di,[bx].dPtrIp
		jmp	short VerifyRet


  VerifyFrag:		; RFC 815 fragment reassembly:
		SHOW_EVENT	'R'
		mov	bp,bx			; addr of fragment buffer
		push	ds
		pop	es
		mov	dx,[di].iIpSrc		; get IP # / IP id / IP prot
		mov	ax,[di].iIpSrc+2
		mov	si,[di].iIpId
		mov	cx,cs:Fraglist.lBufsAvail
		mov	ch,[di].iIpProt
  FragLook4Buf:
		mov	di,offset FragList
		push	es
		push	si
		call	GetFromList
		pop	si
		pop	es
		jz	FragEarliest		; any reassembly buffers?

		SHOW_EVENT	'S'
		mov	di,[bx].dPtrIp		; match IP#/Id/Prot
		cmp	dx,[di].iIpSrc
		jne	FragNextBuf
		cmp	ax,[di].iIpSrc+2
		jne	FragNextBuf
		cmp	si,[di].iIpId
		jne	FragNextBuf
		cmp	ch,[di].iIpProt
		je	FragBufFound
  FragNextBuf:
		push	si			; irrelevant buf, put it back
		mov	si,offset FragList
		push	es
		call	AddToList
		pop	es
		pop	si
		dec	cl
		jnz	FragLook4Buf
  FragEarliest:
		call	FragFirstLast		; compute addr of fragment
		ja	VerifyFragErr		; too big pkt?
		or	ax,ax			; first part earliest?
		jnz	FragOffset

		SHOW_EVENT	'U'
		mov	bx,bp	        
		push	es
		pop	ds
		mov	di,[bx].dPtrUdp
		add	di,dx
		cmp	[bx].dHomeList,offset FreeBufs ;   and a big buffer?
		je	FragFirstHole		; - yes, no extra buffer needed
  FragOffset:
		SHOW_EVENT	'V'
		push	es
		call	BufAlloc		; - no, create empty buffer
		pop	es
		jz	VerifyFragErr

		add	di,HWHDRLEN	;*test
		mov	[bx].dPtrIp,di

		mov	si,es:[bp].dPtrIP
		mov	cx,es:[bp].dPtrUdp 	; copy IP header
		sub	cx,si
		call	MovesbEsToDs
		mov	[bx].dPtrUdp,di
  FragFirstHole:
		xor	ax,ax
		mov	[di].holeNext,ax 	; create first hole descriptor
		mov	[di].holeFirst,ax
                mov     ax,cs:MyGiant
                mov     [di].holeLast,ax
		mov	[bx].dPtrFrag,di

		add	di,HOLEDESCRLEN 	; mark end of info
		mov	[bx].dPktEnd,di
  FragBufFound:
		call	FragFirstLast		; compute addr of fragment
		jbe	$+5
		jmp	FragAddAndErr		; too big pkt?

		lea	di,[bx].dPtrFrag
  FragNextHole: 				; 1. select next hole descr
		mov	si,di
		mov	di,[si].holeNext
		or	di,di			;    any more descriptors?
		jz	FragEndHoles

		cmp	ax,[di].holeLast	; 2. frag.first > hole.last?
		jae	FragNextHole

		cmp	dx,[di].holeFirst	; 3. frag.last < hole.first?
		jbe	FragNextHole

		mov	cx,[di].holeNext	; 4. delete current hole descr
		mov	[si].holeNext,cx

		mov	cx,[di].holeLast
		cmp	ax,[di].holeFirst	; 5. frag.first > hole.first?
		jbe	FragNoNew1
		mov	[si].holeNext,di	;    create new hole descr
		mov	[di].holeLast,ax
  FragNoNew1:
		mov	si,es:[bp].dPtrIp	; 6. if frag.more
		test	es:[si].iIpFlFrag,0020h
		jz	FragLastFrag

		cmp	dx,cx			;    and frag.last < hole.last?
		jae	FragNextHole

		mov	si,[bx].dPtrUdp
		add	si,dx
		mov	[si].holeFirst,dx	;    create new hole descr
		mov	[si].holeLast,cx
		mov	cx,[bx].dPtrFrag
		mov	[si].holeNext,cx
		mov	[bx].dPtrFrag,si

		add	si,HOLEDESCRLEN
		cmp	si,[bx].dPktEnd
		jbe	FragNextHole
  FragPktEnd:
		mov	[bx].dPktEnd,si
		jmp	short FragNextHole

  FragLastFrag: 				; when last frag
		mov	si,[bx].dPtrUdp 	;   prepare IP length
		add	si,dx
		jmp	short FragPktEnd

  FragEndHoles: 				; 8. copy data to assembly buf
		cmp	bx,bp			; do we need to copy?
		jne	FragDoCopy
		mov	cx,es
		mov	si,ds
		cmp	cx,si
		je	FragTimeUpd
  FragDoCopy:
		SHOW_EVENT	'W'
		or	ax,ax			; if first frag
		jnz	FragNotFirst

		SHOW_EVENT	'X'
		mov	si,[bx].dPtrUdp 	;   retain this IP header
		mov	di,es:[bp].dPtrUdp 	;   and copy assembled data
		mov	cx,[bx].dPktEnd 	;   to frag buffer
		sub	cx,si
		add	si,dx			;   skip over first fragment
		add	di,dx
		sub	cx,dx
		call	Movesb
		mov	es:[bp].dPktEnd,di

		mov	cx,[bx].dPtrFrag
		mov	es:[bp].dPtrFrag,cx

		xchg	bx,bp			;   and switch buffers
		push	ds
		push	es
		pop	ds
		pop	es

		mov	cx,di
		sub	cx,si			;   hole ptr adjustment
		lea	di,[bx].dPtrFrag
  FragUpdLoop:
		mov	si,di
		mov	di,[si].holeNext
		or	di,di
		jz	FragRelBuf		;   end of hole list 

		add	di,cx
		mov	[si].holeNext,di	;   new pointer address
		jmp	short FragUpdLoop

  FragNotFirst:
		mov	si,es:[bp].dPtrUdp 	; copy this frag to asm buf
		mov	cx,dx
		sub	cx,ax
		mov	di,[bx].dPtrUdp
		add	di,ax
		call	MovesbEsToDs
  FragRelBuf:
		push	bx			; release frag buf
		push	ds
		mov	bx,bp
		push	es
		pop	ds
		call	BufRelease
		pop	ds
		pop	bx
  FragTimeUpd:
		push	ds
		pop	es
		mov	cx,cs:SavedTicks	; update timer entry
		mov	di,[bx].dPtrIp
		mov	al,[di].iIpTtl
		mul	cs:k18
		add	cx,ax
		mov	[bx].dTickTimeout,cx

		mov	di,[bx].dPtrIp
		mov	si,[bx].dPtrUdp
		cmp	[bx].dPtrFrag,0 	; any holes?
		jne	FragKeep		; - yes, wait for more pkts

		mov	cx,[bx].dPktEnd 	; - no
		mov	ax,cx			; compute IP length
		sub	cx,[bx].dPtrIp
		xchg	ch,cl
		mov	[di].iIpLen,cx
		ret

  FragKeep:
		mov	cx,cs:FreeBufs.lBufsAvail
		cmp	cx,5			; prevent starving
		jge	FragKeep2
		jmp	VerifyErr
  FragKeep2:
		mov	si,offset FragList	; keep buf a while
		call	AddToList
		jmp	VerifyKeep
VerifyIpHdr	endp



;************************************************************************
;*		FragFirstLast
;************************************************************************

FragFirstLast	proc	near
		mov	di,es:[bp].dPtrIp		; compute frag.first
		mov	ax,es:[di].iIpFlFrag
		xchg	ah,al
		and	ax,1fffh
		shl	ax,1
		shl	ax,1
		shl	ax,1
		mov	dx,es:[di].iIpLen		; compute frag.last (+1)
		xchg	dh,dl
		add	dx,es:[bp].dPtrIp
		sub	dx,es:[bp].dPtrUdp
		add	dx,ax
		cmp	dx,GIANTTR-IPHDRLEN-HWHDRLEN ; fits in buffer?
		ret	;*test GIANT
FragFirstLast	endp

endif ; RFCC



;************************************************************************
;*		SwitchIpDst
;************************************************************************

GetIpSrc	proc	near
		mov	si,[bx].dPtrIp		; get his IP #
		mov	dx,[si].iIpSrc
		mov	ax,[si].iIpSrc+2
		ret
GetIpSrc	endp


SwitchIpDst	proc	near			; mov his IP # to IP dst
		call	GetIpSrc
SetIpDst:
		mov	di,[bx].dPtrIp
		mov	[di].iIpDst,dx		; set IP dst
		mov	[di].iIpDst+2,ax
		ret
SwitchIpDst	endp



;************************************************************************
;*		MakeMynet
;************************************************************************

MakeMynet	proc	near
		assume	ds:code_s
		mov	dx,MyIpNr
		mov	ax,MyIpNr+2

		mov	ArpTabIp1+ARPMYIDX,dx	; third arp slot = me
		mov	ArpTabIp2+ARPMYIDX,ax

		mov	si,MyMask
		mov	di,MyMask+2
		and	dx,si			; calculate network #
		and	ax,di
		mov	MyNet,dx
		mov	MyNet+2,ax

		not	si			; second arp slot =
		not	di			;   subnet broadcast
		or	dx,si
		or	ax,di
		mov	ArpTabIp1+2,dx
		mov	ArpTabIp2+2,ax
		ret
MakeMynet	endp



;************************************************************************
;*		ValidateIpNr
;************************************************************************

ValidateIpNr	proc	near
		assume	ds:code_s
		mov	dx,MyIpNr
		mov	ax,MyIpNr+2
if PINGCLIENT
		cmp	dx,EchoTarget		; is it loopback test?
		jne	ValidateIP2
		cmp	ax,EchoTarget+2
		jne	ValidateIP2
		or	MoreFlags,LOOP_BACK
		ret
  ValidateIP2:
endif ; PINGCLIENT
		push	es
		push	ds
		call	BufAlloc
		assume	ds:nothing
		mov	[bx].dTimOutMsg,0	; we SHOULD get no answer
		mov	[bx].dTickTimeout,10	; give them half a second
		or	MoreFlags,LOOP_BACK
		call	SendArpReq		; send arp to our Ip #
		call	BufRelease
		pop	ds
		assume	ds:code_s
		pop	es
		jz	ValConflict		; someone else has our IP # ?

		and	MoreFlags,not LOOP_BACK
		ret				; - no, return

  ValConflict:					; - yes, error termination
		call	ArpFindIp
		mov	cl,HWLENPWR-1
		shl	di,cl
		lea	si,ArpTabHwAdr[di]	; get HW addr of arp reply

		mov	di,offset OccupiedHw
		call	PutHwNum		; put offending HW addr

		mov	dx,offset OccupiedMsg	; display IP occupied msg
		mov	al,09			; error code 9
		call	PrTerminate
ValidateIpNr	endp



;************************************************************************
;*		DoBootpPkt
;************************************************************************

DoBootpPkt	proc	near
		assume	ds:code_s
		push	ds
		call	BufAlloc		; get a buffer
		call	MakeSendDescr

		push	di			; preclear udp hdr and data
		xor	ax,ax
		mov	cx,(BPDATALEN+ICMPHDRLEN)/2
		rep	stosw
		pop	di

		mov	[di].uUdpSrc,4400h	; udp hdr info
		mov	[di].uUdpDst,4300h

		mov	[di].uBotOp,1		; bootp info
		mov	al,byte ptr ArpBuf.iArpHtype+1
		mov	[di].uBotHtype,al	;   put my HW type
		mov	[di].uBotMagNum,8263h
		mov	[di].uBotMagNum+2,6353h
		mov	ax,BootpXid
		mov	[di].uBotXid,ax

		mov	cx,Hlen
		mov	[di].uBotHlen,cl
		mov	si,offset MyHwAd
		lea	di,[di].uBotCliHwAd
		rep	movsb			;   copy my HW addr

		xor	ax,ax			; IP hdr info
		mov	si,[bx].dPtrIp
		dec	ax
		mov	[si].iIpDst,ax
		mov	[si].iIpDst+2,ax

		mov	[bx].dWaitEvent,GOT_BOOTP	; event to wait for
		mov	[bx].dTimOutMsg,offset NoBotReplyMsg ; error msg
		mov	ax,BPDATALEN+UDPHDRLEN		; bootp pkt length
		mov	[bx].dPktLen,ax
		call	SendUdpPkt			; send bootp request
		call	BufRelease
		push	cs
		pop	es
		pop	ds
		ret
DoBootpPkt	endp



;************************************************************************
;*		InterpBootp according to RFC 1084 and RFC1048
;************************************************************************

InterpBootp	proc	near
		assume	ds:code_s
		or	Flagword,HAVE_MYIPNR	; note what we've got

		push	es
		push	ds
		lds	bx,AdrBootpReply
		assume	ds:nothing

		mov	di,[bx].dPtrUdp
		mov	dx,[di].uBotYourIp	; save my IP #
		mov	cs:MyIpNr,dx
		mov	ax,[di].uBotYourIp+2
		mov	cs:MyIpNr+2,ax

		cmp	word ptr [di].uBotMagNum,8263h	; RFC 1084 type of
		jne	VendEnd 			;   vendor area?
		cmp	word ptr [di].uBotMagNum+2,6353h
		jne	VendEnd

		lea	si,[di].uBotVend	; start of "vendor area"
		lea	bp,[si]+64-4		; end of "vendor area"
		push	cs
		pop	es
  VendLoop:
		cmp	si,bp			; beyond vendor area?
		jb	VendNext

  VendEnd:
		call	BufRelease		; release bootp reply buf
		pop	ds
		pop	es
		ret

  VendNext:
		lodsb				; get field type:

		or	al,al			; filler
		jz	VendLoop

		cmp	al,1			; netmask
		jne	NotMask
		mov	di,offset MyMask
		call	Xtract4Bytes
		jmp	short VendLoop
  NotMask:
		cmp	al,2			; zone/time (?) offset
		jne	NotTimeOffs
		test	cs:Flagword,HAVE_TIMEOFFSET
		jnz	VendDefault
		mov	di,offset tzoffset
		call	Xtract4Bytes
		or	cs:Flagword,HAVE_TIMEOFFSET
		jmp	short VendLoop
  NotTimeOffs:
		cmp	al,3			; default gateways
		jne	NotDefGwys
		mov	di,offset DefGwys
		mov	cx,MAXDEFGWYS
		mov	ax,cs:DefGwyNum
		call	XtractIpNums
		add	cs:DefGwyNum,cx
		jmp	short VendLoop
  NotDefGwys:
		cmp	al,4			; time servers
		jne	NotTimeserv
		or	cs:Flagword,HAVE_TIMESERVER
		mov	di,offset TimeServIpNr
		mov	cx,MAXTSERVS
		mov	ax,cs:TservNum
		call	XtractIpNums
		add	cs:TservNum,cx
		jmp	short VendLoop
  NotTimeserv:
if TBLBUILD or PINGCLIENT
		cmp	al,6			; default nameservers
		jne	NotDefNS
		mov	di,offset DefNS
		mov	cx,MAXDEFNS
		mov	ax,cs:DefNSnum
		call	XtractIpNums
		add	cs:DefNSnum,cx
		jmp	VendLoop
  NotDefNS:
endif ; TBLBUILD or PINGCLIENT
		cmp	al,0ffh 		; end
		jne	VendDefault
		jmp	VendEnd
  VendDefault:					; everything else
		lodsb
		xor	ah,ah
		add	si,ax			; skip field
		jmp	Vendloop

InterpBootp	endp



;************************************************************************
;*		XtractIpNums
;************************************************************************

XtractIpNums	proc	near
		assume	ds:nothing
		sub	cx,ax			; wanted - already got

		shl	ax,1
		shl	ax,1
		add	di,ax			; append to what we got
		shl	cx,1
		shl	cx,1
		jmp	short XtractNBytes
Xtract4Bytes:
		mov	cl,4
XtractNBytes:
		lodsb
		cmp	cl,al			; as many as we want?
		jbe	XtractOkLen

		mov	cl,al			; - no, take what there is
  XtractOkLen:
		xor	ch,ch
		xor	ah,ah
		push	cx
		push	ax
		push	si
		rep	movsb			; copy field
		pop	si

		pop	ax
		add	si,ax			; advance field ptr

		pop	cx
		shr	cx,1
		shr	cx,1			; cx = IP #'s read

		ret
XtractIpNums	endp



if TBLBUILD or PINGCLIENT

NsStruc 	struc
uNsUdpHdr	UdpStruc	<>
uNsId		dw	0
uNsOpwd 	dw	0001h			; do recursion
uNsQdcount	dw	0100h			; one question
uNsAncount	dw	0
uNsNscount	dw	0
uNsArcount	dw	0
uNsQuest	equ	$-uNsUdpHdr
NsStruc 	ends

;************************************************************************
;*		NameDecode
;*
;*	Find end of name and change length bytes to dots
;************************************************************************

NameDecode	proc	near
		assume	ds:nothing
		lodsb
		mov     byte ptr [si-1],' '     ; blank 1st length byte
		jmp	short NameDcTst
  NameDcLoop:
		lodsb
		mov	byte ptr [si-1],'.'	; change length byte to dot
  NameDcTst:
		cmp	al,0c0h 		; compressed?
		jb	NameDcNorm
		mov     byte ptr [si],' '
		inc	si
		ret
  NameDcNorm:
		mov	ah,al
		or	al,al			; end of name?
		jz	NameDcRet		; -yes, return
  NameDcSkip:
		lodsb				; -no, skip over string
		or	al,al			; bad syntax?
		jz	NameDcRet		; -yes, better return now
		dec	ah			; -no, continue skiping
		jnz	NameDcSkip      
		jmp	short NameDcLoop
  NameDcRet:
		ret
NameDecode	endp



;************************************************************************
;*		NsResolve
;*
;*	Input:		DX = my udp port
;*			AX = Ns Id
;*			CS:SI = address of querry string
;************************************************************************

MsgResolve	db	"no response.$"

NsResolveEcho	proc	near
		assume	ds:nothing
		mov	dx,2345h		; ping udp src port
NsResolve:
		push	es
		push	bx
		push	ds

		push	si
		call	BufAlloc		; get a big buf
		pop	si
		mov	cx,SERRNOBUF
		jz	NsResErr

		call	MakeSendDescr
		mov	[di].uUdpDst,3500h
		mov	[di].uUdpSrc,dx
		mov	[di].uNsId,ax
		xor	ax,ax
		mov	[di].uNsOpwd,1		; recursion desired
		mov	[di].uNsQdcount,0100h	; 1 question
		mov	[di].uNsAncount,ax
		mov	[di].uNsNscount,ax
		mov	[di].uNsArcount,ax
		mov	[bx].dTick2Timeout,14*18 ; give him 14 seconds 2nd turn
		mov	[bx].dTimOut2Msg,ax
if HOPCHK
		test	cs:MoreFlags,HOP_CHK
		jnz	NsHopChk
endif ; HOPCHK
		mov	[bx].dWaitEvent,GOT_NSREPLY
  NsHopChk:
		cmp	dx,1234h
		je	NsTableBuild

		mov	[bx].dWaitEvent,GOT_NSREPLY
		mov	[bx].dTickResend,4*18	; resend after 4 seconds
		mov	[bx].dTickTimeout,2*18	; give him 2 seconds 1st turn
		mov	[bx].dTimOut2Msg,offset MsgResolve
  NsTableBuild:
		lea	di,[di].uNsQuest	; copy question
  NsQloop:
		lods	byte ptr cs:[EchoNameBuf]
		stosb
		or	al,al
		jnz	NsQloop

		movs	word ptr es:[uNsQuest],word ptr cs:[EchoNameBuf] ; copy type
		movs	word ptr es:[uNsQuest],word ptr cs:[EchoNameBuf] ; and class

		push	si
		mov	ax,di			; compute ip data length
		mov	si,[bx].dPtrUdp
		sub	ax,si
		mov	[bx].dPktLen,ax

		SHOW_EVENT	'I'
		mov	dx,offset DefNsNum
		call	SendUdpFind		; send pkt
		call	BufRelease
		SHOW_EVENT	'J'
		pop	si
  NsResErr:
		or	cx,cx
		pop	ds
		pop	bx
		pop	es
		ret
NsResolveEcho	endp



;************************************************************************
;*		DoNsInterp
;************************************************************************

DoNsInterp	 proc	 near
		assume	ds:nothing
		cld
		push	cs
		pop	es
		mov	di,[bx].dPtrUdp
		test	[di].uNsOpwd,0080h	; reply?
		jnz	NameResReply
  DoNsIntRet:
		ret

  NameResReply:
if TBLBUILD
		cmp	[di].uUdpDst,2345h	; the ping ns port?
		je	DoNsIntPing
		jmp	DoName			; to the tblbuilder
endif ; TBLBUILD
  DoNsIntPing:
		mov	cx,cs:EchoNamePtr
		cmp	[di].uNsId,cx		; reply we are looking for?
		jne	DoNsIntRet

		mov	cx,[di].uNsAncount
		xchg	ch,cl
		cmp	cx,1			; any answers?
		jb	NameResNoAnswer

		lea	si,[di].uNsQuest
		call	NameDecode		; decode question string
		add	si,4			; skip over type and class
  NsAnsLoop:
		call	NameDecode		; decode answer string
		mov	ax,[si] 		; get type
		add	si,9			; skip over junk
		cmp	ax,0100h		; address?
		je	NsAnsAddr

		lodsb
		xor	ah,ah
		add	si,ax			; skip over data bytes
		loop	NsAnsLoop

		jmp	short NameResNoAnswer
  NsAnsAddr:
		cmp	byte ptr [si],4 	; 4 IP bytes here?
		jne	NameResNoAnswer

		inc	si			; copy IP number
		push	cs
		pop	es
		mov	di, EchoTargetPtr
if MULTIPING gt 1
		cmp	di,offset EchoTargetEnd
		jae	NameResNoAnswer
endif ; MULTIPING
		movsw
		movsw
  NameResNoAnswer:
		or	cs:Events,GOT_NSREPLY	; note we've got ns reply
if TBLBUILD
		mov	di,offset DefNsNum
		call	ThisIpFirst		; stick to this nameserver
endif ; TBLBUILD
		ret
DoNsInterp	endp

endif ; TBLBUILD or PINGCLIENT



;************************************************************************
;*		ARP and IP receiver
;************************************************************************

		assume	ds:nothing

Receiver:
		pushf
		push	ds			; save segment register
		cld

if DEBUG
		test	cs:GenFlags,DBGSTOP
		jnz	IpRecTooBig
endif ; DEBUG
		or	ax,ax			; first or second call?
		jne	IpRecv_1		; - second, we've got data
						; - first, they want a buf
		SHOW_EVENT	'A'
		cmp	cx,cs:MyGiant		; packet too long?
		ja	IpRecTooBig
if PINGCLIENT
ifdef SMALLBUFS
		cmp	cx,BUFBODYSML
		ja	IpRecBig

		call	BufAlSml
		jz	IpRecBig

		pop	ds
		popf
		retf

  IpRecBig:
endif ; SMALLBUFS
endif ; PINGCLIENT
		call	BufAlloc		; get a receive buffer
		jz	IpRecNoBuf

  IpRecRet0:
		pop	ds
		popf
		retf				; return to pkt drvr

if DEBUG
  DbgIpRecv:
		or	cs:GenFlags,DBGINTERR
endif ; DEBUG

  IpRecNoBuf:

if PINGCLIENT
		cmp	bx,cs:IpHandle
		jne	IpRecTooBig
		inc	cs:EchoDrop
endif ; PINGCLIENT
  IpRecTooBig:
		xor	di,di			; no buffer available
		mov	es,di
		jmp	short IpRecRet0


  IpRecv_1:
		mov	word ptr cs:SaveSS,ss	; switch to our
		mov	word ptr cs:SaveSP,sp	;   interrupt stack
		cli			
		mov	ss,cs:MySegm
		mov	sp,offset StackEnd
		sti				; allow interrupts

if DEBUG ge 2
		mov	dx,ds
		cmp	dx,cs:MySegm
		je	IpRecvCs
		SHOW_EVENT	'B'
  IprecvCs:
endif ; DEBUG ge 2
if DEBUG
		dec	cs:DbgIntCnt		; double interrupt?
		jnz	DbgIpRecv
endif ; DEBUG

if PINGCLIENT
		mov	ax,cx			; pkt length
		add	ax,8+4+12		; preamble, crc, intergap
		add	cs:EchoLoad+2,ax
		adc	cs:EchoLoad,0
endif ; PINGCLIENT
		mov	ax,si
		add	ax,cx			; end of packet limit
		mov	bx,[si-2] 		; addr of descriptor

		mov	[bx].dPktLen,cx 	; fill in descriptor info
		mov	[bx].dPktEnd,ax

		add	si,cs:H2Len
		mov	ax,[si] 		; type/length field
		xchg	ah,al

		xor	dl,dl
		cmp	ax,GIANT		; if 802.3 pkt
		jbe	BuildSnap		;   do special handling
  BuildNotSnap:
		mov	[bx].dSnap,dl
		lea	di,[si+2]
		mov	[bx].dPtrIp,di		; di must point to IP hdr

		cmp	ax,0806h		; ARP protocol?
		je	ArpRecvCont0

		mov	cl,[di].iIpVerHlen 	; get version+length byte
		and	cx,0fh			; length (32 bit words)
		shl	cx,1			; convert to
		shl	cx,1			;   byte length

		call	IpChkSum		; only accept a correct
		jne	IpRecErr		;   IP checksum

		mov	[bx].dPtrUdp,si
		SHOW_EVENT	'H'
if RFCC
		call	VerifyIpHdr		; verify and process IP hdr
		jc	IpRecKeepBuf
endif ; RFCC
		SHOW_EVENT	'H'

		mov	cx,[di].iIpLen		; calculate IP data length
		xchg	ch,cl
		add	cx,di
		sub	cx,si
		mov	[bx].dPktLen,cx 	; save IP data length

		mov	al,[di].iIpProt
		cmp	al,ICMP_PROT		; ICMP protocol?
		jne	IpNotIcmp

		call	IcmpChkSum2		; valid ICMP checksum?
		jne	IpRecErr

		jmp	IpRecIcmp


  BuildSnap:
		inc	dl			; -no, assumed to be snap
		add	si,SNAPLEN		; skip over snap bytes
		jmp	short BuildNotSnap


  ArpRecvCont0:
		cmp	[di].iArpProt,0008h	; arp IP protocol?
		jne	IpRecRet
		jmp	ArpRecvCont


  IpNotIcmp:
		cmp	al,UDP_PROT		; UDP protocol?
		jne	IpProtUnr

		call	UdpChkSum		; if available, test 
		jne	IpRecErr		;   UDP checksum

		cmp	si,[bx].dPktEnd 	; still within packet limit?
		jbe	IpRecUdp

  IpRecErr:
		SHOW_EVENT	'Y'
if PINGCLIENT
		inc	cs:EchoChkErr
endif ; PINGCLIENT
  IpRecRet:
		SHOW_EVENT	'Z'
		call	BufRelease		; release receive buffer
  IPRecKeepBuf:

if DEBUG ge 2
		cmp	sp,offset StackEnd
		call	TstEqual
endif ; DEBUG ge 2
if DEBUG
		inc	cs:DbgIntCnt
endif ; DEBUG
		cli				; restore previous stack
		mov	ss, word ptr cs:SaveSS
		mov	sp, word ptr cs:SaveSP

		pop	ds
		popf
		retf				; return to pkt drvr


if TBLBUILD
  ArpRecBld0:
		jmp	ArpRecTbl
endif ; TBLBUILD

  IpProtUnr:
		mov	ah,2			; protocol unreachable
		jmp	short IpUnr
  IpPortUnr:
		mov	ah,3			; port unreachable
  IpUnr:
if RFCC
		mov	al,3			; destination unreachable

		cmp	[bx].dIdxIpDst,ARPMYIDX ; was it specifically to me?
if TBLBUILD
                jne     ArpRecBld0		; -no, collect his address
else
                jne     IpRecRet
endif ; TBLBUILD

		push	bx
		push	ds
		push	ax
		call	GetIpSrc		; -yes, mov his IP # to IP dst
		mov	cx,[bx].dPtrUdp		; copy IP header
		add	cx,8			;   + 8 bytes
		sub	cx,si

		push	si
		call	BufAlloc
		pop	si
		jz	UnrEnd

		call	MakeSendDescr
		push	di
		call	SetIpDst		; return to sender

		pop	di
		pop	ax
		mov	[di].uIcmpTypecode,ax ; set type and code

		pop	es
		push	es
		push	ax

		add	di,8
		call	MovesbEsToDs

		mov	si,[bx].dPtrUdp
		sub	di,si
		mov	[bx].dPktLen,di 	; set IP data length

		mov	si,offset IcmpToDo	; put buf on the ICMP send list
		call	AddToList
  UnrEnd:
		pop	ax
		pop	ds
		pop	bx
endif ; RFCC
  IpRecRet3:
		jmp	IpRecRet


  IpRecUdp:		; -------------	UDP --------------------
		mov	[bx].dPktEnd,si 	; end of logical pkt

		mov	di,[bx].dPtrUdp
		mov	ax,word ptr [di].uUdpSrc
		mov	dx,word ptr [di].uUdpDst
if TBLBUILD or PINGCLIENT
		cmp	dx,0703h		; Udp Echo reply?
		jne	$+5
		jmp	IpEchoReply
		cmp	dx,0700h		; Udp Echo request?
		jne	$+5
		jmp	IpEchoRequest
		cmp	dx,0900h		; Udp Discard request?
		jne	$+5
		jmp	IpDiscard
		cmp	ax,3500h		; Name server (53)?
		jne	$+5
		jmp	IpRecvName
endif ; TBLBUILD or PINGCLIENT
		cmp	ax,2500h		; Src port 0025 = 37 ?
		je	IpRecvTime		; - must be time reply

		cmp	dx,4400h		; Dst port 0044 = 68
		jne	IpPortUnr

		SHOW_EVENT	'k'
		cmp	byte ptr [di].uBotOp,2	; bootp reply?
		jne	IpRecRet3

  IpRecBootp:		; -------------	UDP BOOTP REPLY -------------------
		push	cs
		pop	es
		push	di			; - must be bootp reply
		lea	si,[di].uBotCliHwAd
		mov	di,offset MyHwAd
		mov	cx,cs:Hlen
		repe	cmpsb			; our Ethernet addr?
		pop	di
		jne	IpRecRet2

		mov	cx,cs:BootpXid
		cmp	cx,[di].uBotXid
		jne	IpRecRet2
		SHOW_EVENT	'l'
						; yes, it's about me!
		mov	dx,[di].uBotGwyIp	; saves an ARP request
		mov	ax,[di].uBotGwyIp+2	;   in many cases
						
		and     dx,dx			; well, maybe we didn't go
		jz      NoValidGwyIp		; through a gateway...
						; test for non-zero IP number
                call    ArpPutNewSiHl
  NoValidGwyIp:
		test	cs:Events,GOT_BOOTP	; if first answer
		jnz	IpRecRet2		;   save bootp answer

		mov	cs:AdrBootpReply.offs,bx ;  for further study 
		mov	cs:AdrBootpReply.segm,ds
		or	cs:Events,GOT_BOOTP
		jmp	IpRecKeepBuf

  IpRecvTime:		; -------------	UDP TIME REPLY --------------------
		test	cs:Events,GOT_TIMEREPLY	; already got reply?
		jnz	IpRecRet2

		mov	ax,[di].uUdpData	; save seconds
		mov	cs:cTime,ax		;   since year 1900
		mov	ax,[di].uUdpData+2
		mov	cs:cTime+2,ax

		mov	di,[bx].dPtrIp		; save who was answering
		mov	dx,[di].iIpSrc
		mov	ax,[di].iIpSrc+2
		mov	cs:RespondingIpNr,dx
		mov	cs:RespondingIpNr+2,ax
		or	cs:Events,GOT_TIMEREPLY
  IpRecRet2:
		jmp	IpRecRet

if TBLBUILD or PINGCLIENT
  IpRecvName:		; -------------	UDP NAME REPLY -----------------
		SHOW_EVENT	'K'
		mov	si,offset NameToDo	; process nameserver reply
		call	AddToList
		jmp	IpRecKeepBuf
endif ; TBLBUILD or PINGCLIENT


if RFCC
  IpEchoRequest:	; -------------	UDP ECHO REQ ----------------
		call	SwitchIpDst

		mov	si,[bx].dPtrUdp

		mov	dx,[si].uUdpDst 	; swap udp src and dst ports
		mov	ax,[si].uUdpSrc
		mov	[si].uUdpDst,ax
		mov	[si].uUdpSrc,dx
		jmp	short IpQueReply

  IpDiscard:		; -------------	UDP DISCARD ------------------
		xor	ax,ax
		cmp	cs:EchoTarget,ax
		jne	IpRecRet4
		add	cs:Echo.RxLo,1		; increment receive counters
		adc	cs:Echo.RxHi,ax
  IpRecRet4:
		jmp	IpRecRet
endif ; RFCC



  IpRecIcmp:		; -------------	ICMP --------------------------------
		mov	cx,[di].uIcmpTypecode	; get type and code

if PINGCLIENT
		cmp	cl,0			; echo reply?
		jne	IpNotEchoReply
  IpEchoReply:		; -------------	ICMP PING/UDP REPLY ------------
		SHOW_EVENT	'L'
if HOPCHK
		test	cs:MoreFlags,HOP_CHK
		jnz	IpRecRet2
endif ; HOPCHK
		call	EchoCalc
		SHOW_EVENT	'l'
		jmp	IpRecRet
  IpNotEchoReply:
endif ; PINGCLIENT

		call	SwitchIpDst		; in case we want to return it
		mov	si,[bx].dPtrUdp 	; point to ICMP header
if RFCC
		cmp	cl,8			; echo request?
		jne	IpNotEchoReq
;			---------------	ICMP PING REQ ---------------
		SHOW_EVENT	'M'
		mov	byte ptr [si].uIcmpTypecode,0 ; put echo reply value
  IpQueReply:
		cmp	[bx].dIdxIpDst,ARPMYIDX ; broadcast?
		jb	IpRecRet4		; - yes, don't echo

		test	cs:ArgFlags,UPCALL_SEND	; want to stress the driver?
		jnz	IpUpcallSend

		mov	si,offset IcmpToDo	; put buf on the ICMP send list
		call	AddToList
		jmp	IpRecKeepBuf

  IpUpcallSend:
		mov	di,[bx].dPtrIp
		cmp	[di].iIpProt,UDP_PROT	; UDP protocol?
		je	IpUdp2Do

		call	SendIcmpPkt
  IpRecRet5:
		jmp	IpRecRet
  IpUdp2Do:
		mov	[bx].dWaitEvent,0	; don't wait for answer
		call	SendUdpPkt
		jmp	short IpRecRet5

  IpNotEchoReq:
endif ; RFCC

		mov	dx,[si].uIcmpIpHdr.iIpDst	; get original IP hdr
		mov	ax,[si].uIcmpIpHdr.iIpDst+2	;   dst IP #

		cmp	cx,11			; TTL exceeded?
		je	IpIcmpUnreach
		cmp	cl,3			; unreachable?
		je	IpIcmpUnreach
		jmp	IpNotUnreach

if HOPCHK
HopAdj		db	1
HopLastCycle	db	3
HopLastPunr	db	63
endif ; HOPCHK


  IpIcmpUnreach:

if HOPCHK
		test	cs:MoreFlags,HOP_CHK	; hopcheck going on?
		jz	IpIcmpNotHop1
;		SHOW_TRACE	'M'
		cmp	byte ptr [di].iIpLen+1,2*IPHDRLEN+ICMPHDRLEN
		jb	IpRecRet5		; too short for any info

;			--------------- HOPCHECK "REPLY" ---------------
		cmp	dx,cs:EchoTarget	; from current hop check dst?
		jne	IpRecRet5
		cmp	ax,cs:EchoTarget+2
		jne	IpRecRet5

		mov	ax,[si].uIcmpIpHdr.iIpId
if 0
		cmp	ax,cs:BootpXid		; from a previous session?
		js	IpRecRet5
else	; Code below needed because many Unixes byteswap IpId in returned pkts!
		mov	dx,cs:IpIdCounter
		cmp	ax,cs:BootpXid
		js	IpIcmpHopSwap
		cmp	dx,ax
		jns	IpIcmpHopCur
  IpIcmpHopSwap:
		xchg	ah,al			; silly Unix, why the h#%%!??
		cmp	ax,cs:BootpXid
		js	IpRecRet5
		cmp	dx,ax
		js	IpRecRet5
;		SHOW_TRACE	'B'
  IpIcmpHopCur:
endif ; 0
		cmp	byte ptr [di].iIpLen+1,2*IPHDRLEN+ICMPHDRLEN+4
		jb	IpIcmpHopAux		; long enough for UDP info?

		cmp	byte ptr [si].uIcmpUdpHdr.uUdpSrc,80h ; from hopcheck?
		je	IpIcmpHopYes
  IpIcmpNotHop1:
		jmp	IpIcmpNotHop

  IpIcmpHopAux:
;		SHOW_TRACE	'C'
		push	cx			; -no, match with sent IpId
		push	di			;   and get saved UDP info
		push	cs
		pop	es
		mov	cx,HOPAUXLEN
		sub	cx,cs:HopAuxBeg
		mov	di,offset HopAuxIpId+HOPAUXLEN
		sub	di,cx
		shr	cx,1
		repne	scasw

		mov	al,cs:[di+HopAuxCyTtl-HopAuxIpId-2+1]
		mov	dx,word ptr cs:[di+HopAuxTime-HopAuxIpId-2]
		pop	di
		pop	cx
		jnz	IpIcmpNotHop1

;		SHOW_TRACE	'D'
		jmp	short IpIcmpFinalTtl

  IpIcmpHopYes:
		mov	al,byte ptr [si].uIcmpUdpHdr.uUdpSrc+1 ; orig cycle+ttl-1
		cmp	al,3*MAXHOP		; within allowable range?
		jb	IpIcmpAlRange
  IpIcmpRet6:
		jmp	IpRecRet

  IpIcmpAlRange:
		mov	dx,[si].uIcmpUdpHdr.uUdpDst ; 15 bits of time stamp
  IpIcmpFinalTtl:
		mov	ah,[si].uIcmpIpHdr.iIpTtl ; final ttl
		SHOW_EVENT	'N'
		cmp	cl,11			; TTL exceeded?
		je	IpIcmpHopEx

		sub	al,ah			; subtract overshoot
		or	ah,ah
		jnz	IpIcmpTtl1		; do they decr ttl for unr?
		mov	cs:HopAdj,ah
  IpIcmpTtl1:
		add	al,cs:HopAdj		; adjust overshoot
  IpIcmpHopEx:
		xor	ah,ah			; compute HopTab index
		mov	si,ax
		shl	si,1
		shl	si,1

		cmp	cl,3			; unreachable something?
		jne	IpIcmpHopOth

		mov	cs:HopStopThis,al	; limit this cycle

		cmp	ch,2			; protocol unr?
		je	IpIcmpHopProt
		cmp	ch,3			; port unr?
		jne	IpIcmpHopUnr
  IpIcmpHopProt:
		mov	ah,al
		and	ah,64+128		; extract cycle
		and	al,MAXHOP-1		; extract hop count
		cmp	ah,cs:HopLastCycle	; same cycle?
		je	IpIcmpHopSame

		mov	cs:HopLastPunr,MAXHOP-1	; - no, reset for next cycle
		mov	cs:HopLastCycle,ah
  IpIcmpHopSame:
		cmp	al,cs:HopLastPunr	; got p unr with fewer hops?
		jae	IpIcmpRet6

		mov	cs:HopLastPunr,al
		add	al,3			; alow for 3 more hops next time
		mov	cs:HopMaxAll,al		; limit all 3 cycles
		cmp	word ptr cs:HopTabOth+2[si],cx ; already got p unr?
		je	IpIcmpHopUnr
		mov	word ptr cs:HopTabOth+2[si],0
  IpIcmpHopUnr:
  IpIcmpHopOth:
		cmp	word ptr cs:HopTabOth+2[si],0 ; already got it?
		jne	IpIcmpRet6

		mov	word ptr cs:HopTabOth+2[si],cx ; save icmp type in HopTab

		push	dx
		push	si
		call	HardwareTicks		; get current time
		pop	si
		mov	cs:Echo.RxTime,dx

		mov	cl,7			; compute delay
		call	DblShl
		pop	ax
		xchg	ah,al
		shl	ax,1
		sub	dx,ax
if 1 ; *test*
		cmp	dh,0ffh
		jne	IpIcmpHopPos
		add	dx,256	; *test*	; HardwareTicks err in MS-Win?
  IpIcmpHopPos:
endif ; *test*
		mov	word ptr cs:HopTabOth[si],dx ; save in HopTab

		shr	dx,1
		cmp	dx,cs:Echo.MaxDly		; adjust max delay
		jbe	IpIcmpHopLess
		mov	cs:Echo.MaxDly,dx
  IpIcmpHopLess:
		mov	dx,[di].iIpSrc
		mov	ax,[di].iIpSrc+2
		mov	word ptr cs:HopTabIp[si],dx ; save IP # in HopTab
		mov	word ptr cs:HopTabIp+2[si],ax
		and	si,MAXHOP*4-1
		cmp	si,cs:HopBxMax
		jbe	IpIcmpBxDone
		mov	cs:HopBxMax,si		; highest non-zero entry
  IpIcmpBxDone:

		jmp	ArpRecBld2		; collect IP adress info

  IpIcmpNotHop:
endif ; HOPCHK
;			---------------	ICMP UNREACHABLE ---------
		cmp	cl,11			; TTL exceeded?
		je	IpIcmpUnr2
		cmp	ch,12			; net or host unreachable?
		ja	IpIcmpRet2
		cmp	ch,6
		ja	IpIcmpUnr2
		cmp	ch,1
		ja	IpIcmpRet2
  IpIcmpUnr2:				; codes 0 - 1, 6 - 12 go here
		SHOW_EVENT	'N'
		push	si
		call	RouteFindUtos		; this host in route table?
		pop	si
		jnz	IpIcmpUnfound

		mov	al,byte ptr [si].uIcmpTypeCode+1 ; icmp code
		xor	ah,ah
		inc	al			; ensure non zero error code
		mov	cs:RouteTabUnreach[di],ax ; mark it unreachable

		mov	cx,cs:SavedTicks	; get current ticks value
		mov	cs:RouteTabTrRx[di],cx	; set timer
  IpIcmpUnfound:
  IpIcmpRet2:
		jmp	IpIcmpRet

  IpNotUnreach:
if RFCC
		cmp	cl,4			; source quench?
		jne	IpIcmpNotQuench
;			---------------	ICMP SRC QUENCH ----------
		SHOW_EVENT	'O'
		call	RouteFindUtos		; this host in route table?
		push	ds
		push	cs
		pop	ds
		jnz	IpIcmpNotRoute

		mov	dx,RouteTabFlags[di]
		or	RouteTabFlags[di],SQ_UPDATED
		lea	si,RouteTabTrSq[di]
		lea	di,RouteTabSqDelay[di]
		jmp	short IpIcmpSq
  IpIcmpNotRoute:
		call	ArpFindIp		; this host in ARP table?
		jnz	IpIcmpSqEnd

		mov	dx,ArpTabFlags[di]
		or	ArpTabFlags[di],SQ_UPDATED
		lea	si,ArpTabTrSq[di]
		lea	di,ArpTabSqDelay[di]
  IpIcmpSq:
		mov	ax,[di] 		; get current sq delay
		or	ax,ax
		jnz	IpIcmpAddDelay
		mov	cx,SavedTicks
		mov	[si],cx 		; initialize sq timer
		mov	ax,100			; initial sq delay 100 ms
  IpIcmpAddDelay:
		add	ax,28			; increase delay by 28 ms
		test	dx,SQ_UPDATED		;   unless already done in
		jnz	IpIcmpSqEnd		;   the last two seconds
		mov	[di],ax
  IpIcmpSqEnd:
		pop	ds
		jmp	short IpIcmpRet

  IpIcmpNotQuench:
endif ; RFCC
		cmp	cl,5			; redirect?
		jne	IpNotRedirect
;			---------------	ICMP REDIRECT ------------
		SHOW_EVENT	'P'
		push	si
		call	RouteFindUtos		; this host in route table?
		pop	si
		jnz	IpIcmpDisfound

		mov	dx,cs:RouteTabIpG1[di]	; icmp from the gwy used?
		mov	ax,cs:RouteTabIpG2[di]
		mov	cx,di
		mov	di,[bx].dPtrIp
		cmp	dx,[di].iIpSrc
		jne	IpIcmpDisfound
		cmp	ax,[di].iIpSrc+2
		jne	IpIcmpDisfound
		mov	di,cx

		mov	dx,[si].uIcmpData	; new gateway IP #
		mov	ax,[si].uIcmpData+2

		call	MyNetChk		; is he on my net?
		jnz	IpIcmpDisfound

		mov	cs:RouteTabIpG1[di],dx	; put it into route table
		mov	cs:RouteTabIpG2[di],ax
  IpIcmpDisfound:
		jmp	short IpIcmpRet

  IpNotRedirect:
  IpIcmpRet:
		jmp	IpRecRet

;========================================================================
;		endinclude

