Unit MKAvt102;
{$I-}
{$I MKB.Def}

Interface

{$IFDEF WINDOWS}
Uses MKWCrt;
{$ELSE}
	{$IfDef OPRO}
		Uses OpCrt,
	{$ELSE}
		Uses Crt,
	{$EndIf}
  DOS,           {For use of TextRec}
  MKString,
  MKScrn;
{$EndIF}

CONST  TabSetting = 8;


TYPE
  tEmulations = (
         mkAVATAR,
         mkANSI,
         mkVT102,
         mkVT52,
         mk3270
   );

VAR
  AvtEolCRLF      : Boolean;
  AvtEcho         : Boolean;
  ApplicationMode : Boolean;
  PrinterName     : String;
  PrinterFiletext : text;
  AutoPrint       : Boolean;
  PrintCntrl      : Boolean;
  InsertMode      : Boolean;
  PrintFullScreen : Boolean;
  PrintScreenFF   : Boolean;
  AutoWrap        : Boolean;
  AutoRepeat      : Boolean;
  DWMode          : Boolean;
  TabMap          : Array[1..132] of Boolean;
  VTLED           : Array[1..8] of Boolean;
  DoAnswerBack    : Boolean;                  {replace with a ANSI/VT102 mode}
  AnswerBack      : String[132];
  PvtANSI         : String[132];
  ClearOnExit     : Boolean;
  LastUnknownSeq  : String[132];
  LastUnknownValid: Boolean;
  vtSend    : Function( ToSend:String):Boolean;    {True = Error}
  Emulation : set of tEmulations;
  OldEmulation : set of tEmulations;

Function InAvatar: Boolean;

Function AnsiColor (Fore:Byte;Back:Byte):String;
	{return Ansi String to set color}

Function AnsiAttr(AA: Byte): String;
	{return ansi string for attribute}

Function AnsiAttrDiff(OldA: Byte; NewA: Byte): String;
	{return minimal ansi string to update attribute}

Procedure AvatarChar (ch:Char);
	{interpret Ansi/Avatar codes and display to screen}

Function CvtColor(colr:Byte):String;
	{Convert attr color codes to ansi numbers}

Procedure AVReset;

Procedure PrintThisString(ToPrint:String);
Procedure SetVTScroll(X1,Y1,X2,Y2:Byte);

Implementation



Const
	ControlCh: Set of Char = ['A','B','C','D','f','s','u','H','J','K','m',';',
                            'n','h','l','r','g','R','L','M','i','c',
                            'y','q','x'];

Const
	MaxParms = 200;

Var
	AvState: Word;						{0=normal, 1=esc, 2=esc[} 			 {Ansi}
														{5=^Y, 6=^Y#, 7=^V, 8=^V^A} 		 {Avatar}
														{9=^V^H 10=^V^H#}
														{11=Collect Parameters}
														{12=#}	 {vt102}
  StdOut:text;
  SaveExitProc : Pointer;
  AvAttr: Byte;
	AnsiParm: Array [1..MaxParms] of Byte;
	AnsiParmQ: Array [1..MaxParms] of Char;
  AnsiParmNo: Byte;
	SaveX: Byte;
	SaveY: Byte;
  VTSaveX: Byte;
  VTSaveY: Byte;
  VTSaveTextAttr: Byte;
  VTScrollRegionX1: Byte;
	VTScrollRegionX2: Byte;
	VTScrollRegionY1: Byte;
	VTScrollRegionY2: Byte;
	CommandType: Word;
	RemainingParms: Byte;
	RepCount: Byte;
  Regs:Registers;

Procedure SetVTScroll(X1,Y1,X2,Y2:Byte);
Begin
 VTScrollRegionX1:=X1;   VTScrollRegionY1:=Y1;
 VTScrollRegionX2:=X2;   VTScrollRegionY2:=Y2;
End;

Function InAvatar: Boolean;
	Begin
	InAvatar := (AvState > 0);
	End;

function  ISTOPEN (var filePointer : text) : boolean;
begin
 istopen := TextRec(filePointer).mode <> FmClosed;
end;
Procedure PrintThisString(ToPrint:String);
Begin
 If ISTOPEN(PrinterFiletext) then Write(PrinterFiletext,ToPrint);
End;

Function CvtColor(colr:Byte):String;
	Begin
	Colr := Colr mod 8;
	Case Colr of
		0: cvtcolor := '0';
		1: cvtcolor := '4';
		2: cvtcolor := '2';
		3: cvtcolor := '6';
		4: cvtcolor := '1';
		5: cvtcolor := '5';
		6: cvtcolor := '3';
		7: cvtcolor := '7';
		End;
	End;


Function AnsiAttrDiff(OldA: Byte; NewA: Byte): String;
	Var
		DoReset: Boolean;
		DoBlink: Boolean;
		DoHigh: Boolean;
		DoFore: Boolean;
		DoBack: Boolean;
		TmpStr: String;

	Begin
	If OldA = NewA Then
		AnsiAttrDiff := ''
	Else
		Begin
		DoReset := ((OldA and $88) and (Not (NewA and $88))) <> 0;
		DoBlink := ((NewA and $80) <> 0) And (DoReset or (OldA and $80 = 0));
		DoHigh	:= ((NewA and $08) <> 0) and (DoReset or (OldA and $08 = 0));
		DoFore	:= (((NewA and $07) <> (OldA and $07)) or (DoReset and ((NewA and $07) <> 7)));
		DoBack	:= (((NewA and $70) <> (OldA and $70)) or (DoReset and ((NewA and $70) <> 0)));
		TmpStr := #27 + '[';
		If DoReset Then
			TmpStr := TmpStr + '0;';
		If DoBlink Then
			TmpStr := TmpStr + '5;';
		If DoHigh Then
			TmpStr := TmpStr + '1;';
		If DoFore Then
			TmpStr := TmpStr + '3' + CvtColor(NewA and $07) + ';';
		If DoBack Then
			TmpStr := TmpStr + '4' + CvtColor((NewA shr 4) and $07) + ';';
		TmpStr[Length(TmpStr)] := 'm';
		AnsiAttrDiff := TmpStr;
		End;
	End;


Function AnsiColor(Fore:Byte;Back:Byte):String;
	Var
		TempStr:		String;

	Begin
	TempStr := #027;
	TempStr := TempStr +'['+ '0;';
	If Fore > 7 Then
		Begin
		TempStr := TempStr + '1;';
		Fore := Fore - 8;
		End;
	If Back > 7 Then
		Begin
		TempStr := TempStr + '5;';
		Back := Back - 8;
		End;
	TempStr := TempStr + '3';
	TempStr := TempStr + CvtColor(Fore) + ';' + '4' + CvtColor(Back) + 'm';
	AnsiColor := TempStr;
	End;


Function AnsiAttr(AA: Byte): String;
	Begin
	AnsiAttr := AnsiColor(AA and $0f, AA shr 4);
	End;


Procedure AVReset;
	Begin
	AvState := 0;
	AvAttr := 3;
	TextAttr := AvAttr;
  For RepCount:=1 to 132 do  TabMap[RepCount]:=False;
  RepCount:=9;
   While RepCount<133 do
     begin
       TabMap[RepCount]:=True;
       RepCount:=RepCount+TabSetting;
     end;
  Window(1,1,80,25);
  ClrScr;
  Window(1,1,80,24);
  If DWMode then Window(1,1,80,25);
  InsertMode := False;
	ApplicationMode := False;
{  DWMode:=False; }
  AvtEolCRLF := False;
	AvtEcho := False;
	AutoWrap := True;
	AutoRepeat := False;
  PrintScreenFF := True;    {helps with viewing output of PrintCntrl}
	PrintFullScreen := True;
	AutoPrint :=False;
	PrintCntrl:=False;
	VTScrollRegionX1:=1;
	VTScrollRegionY1:=1;
	VTScrollRegionX2:=ScrnWidth;
  VTScrollRegionY2:=ScrnHeight;
  VTSaveX:=1;  VTSaveY:=1;  VTSaveTextAttr:=AvAttr;
  If mkVT102 in Emulation then AutoWrap:=False;
{  Emulation:=[mkAVATAR] + [mkANSI] + [mkVT102]; }
	End;

{$F+}
Function DefaultVTSend( ToSend:String):Boolean;
var I: Integer;
Begin
  DefaultVTSend:=False;
  For I:=1 to Length(ToSend) do Write(StdOut,ToSend[I]);
End;
{$F-}

Procedure AVInit;
	Begin
{$F+}
  @vtSend := @DefaultVTSend;
  Assign(StdOut,'');
  Reset(StdOut);
{$F-}
  ClearOnExit   :=False;
  VTScrollRegionX1 := 1;
  VTScrollRegionY1 := 1;
  VTScrollRegionX2 := 80;
  VTScrollRegionY2 := 24;
	SaveX := 0;
	SaveY := 0;
	AvState := 0;
	AvAttr := 3;
	TextAttr := AvAttr;
	InsertMode := False;
  DWMode := False;
  ApplicationMode := False;

  For RepCount:=1 to 132 do  TabMap[RepCount]:=False;
  RepCount:=9;
   While RepCount<133 do
     begin
       TabMap[RepCount]:=True;
       RepCount:=RepCount+TabSetting;
     end;

  For RepCount:=1 to 8 do VTLED[RepCount]:=False;
  AvtEcho         := False;
  AutoWrap        := True;
  AutoRepeat      := False;
  PrintScreenFF   := True;
	PrintFullScreen := True;
  AutoPrint       := False;
  PrintCntrl      := False;
  AvtEolCRLF      := False;
  DoAnswerBack    := False;
  AnswerBack      := '';
  PvtANSI         := '';
  PrinterName     := 'XF102.PRN';
  TextAttr        := AvAttr;
	ClrScr;
  Emulation:=[mkAVATAR] + [mkANSI] + [mkVT102];
  If mkVT102 in Emulation then AutoWrap:=False;
	End;


Procedure ColorParm(Parm:Byte);
	Var
		Temp: Word;

	Begin
	Case parm of
		00: AvAttr := LightGray;
		01: AvAttr := AvAttr or $08;						 {Hi intensity}
		04: AvAttr := (AvAttr and $F8) or Blue;
		05: AvAttr := AvAttr or $80;						 {Blink}
    06: AvAttr := AvAttr or $80;             {Rapid Blink}
    07: Begin
				Temp := AvAttr and $77;
				AvAttr := (AvAttr and $88) or ((Temp shr 4) and $07);
				AvAttr := AvAttr or ((Temp shl 4) and $70);
				End;
		08: AvAttr := AvAttr and $88; 		 {black on black}
    21: AvAttr := AvAttr and ($FF-$08);
    22: AvAttr := AvAttr and ($FF-$08);
    24: AvAttr := (AvAttr and $F8) or LightGray;
    25: AvAttr := AvAttr and ($FF-$80);
    26: AvAttr := AvAttr and ($FF-$80);
    27: AvAttr := ((AvAttr and $F8) and $8F) or LightGray;
    30: Begin
          AvAttr:=(AvAttr and $F8) or Black;
          If AdapterType=1 then
            begin
               AvAttr:=(AvAttr and $F8) or LightGray;
               If (AvAttr and $07)=7 then AvAttr := (AvAttr and ($FF-$08));
            end;
        End;
		31: AvAttr := (AvAttr and $F8) or Red;
		32: AvAttr := (AvAttr and $F8) or Green;
		33: AvAttr := (AvAttr and $F8) or Brown;
		34: AvAttr := (AvAttr and $F8) or Blue;
		35: AvAttr := (AvAttr and $F8) or Magenta;
		36: AvAttr := (AvAttr and $F8) or Cyan;
		37: AvAttr := (AvAttr and $F8) or LightGray;
		40: AvAttr := (AvAttr and $8F) or (Black shl 4);
		41: AvAttr := (AvAttr and $8F) or (Red shl 4);
		42: AvAttr := (AvAttr and $8F) or (Green shl 4);
		43: AvAttr := (AvAttr and $8F) or (Brown shl 4);
		44: AvAttr := (AvAttr and $8F) or (Blue shl 4);
		45: AvAttr := (AvAttr and $8F) or (Magenta shl 4);
		46: AvAttr := (AvAttr and $8F) or (Cyan shl 4);
    47: Begin
            If ((AvAttr and 7)=7) and (AdapterType=1) then
                                 AvAttr:=(AvAttr and $F8) or Black;
            AvAttr := (AvAttr and $8F) or (LightGray shl 4);
        End;
		End;
	End;


Procedure hlModes(ModeByte:Byte; ModeChar:Char; hl:Char);
 begin
 Case ModeByte of
	 1 : begin
				If ModeChar='?' then ApplicationMode:=False;
				If (hl='h') and (ModeChar='?') then ApplicationMode:=True;
				If (hl='l') and (ModeChar='?') then ApplicationMode:=False;
			 end;
	 2 : begin
				If (hl='h') and (ModeChar<>'?') then Write('[KEYB=LOCK]');
				If (hl='l') and (ModeChar<>'?') then Write('[KEYB=UNLOCK]');
				If (hl='h') and (ModeChar='?') then Write('[ANSI=TRUE(NOVT52)]');
				If (hl='l') and (ModeChar='?') then Write('[ANSI=FALSE(VT52)]');
			 end;
	 4 : begin
				If (hl='h') and (ModeChar<>'?') then InsertMode:=True;
				If (hl='l') and (ModeChar<>'?') then InsertMode:=False;
			 end;
   7 : begin
        If (hl='h') and (ModeChar='?') then AutoWrap:=True;
        If (hl='l') and (ModeChar='?') then AutoWrap:=False;
			 end;
	 8 : begin
        If (hl='h') and (ModeChar='?') then AutoRepeat:=True;
        If (hl='l') and (ModeChar='?') then AutoRepeat:=False;
			 end;
  12 : begin
				If (hl='h') and (ModeChar<>'?') then AvtEcho:=True;
				If (hl='l') and (ModeChar<>'?') then AvtEcho:=False;
			 end;
	18 : begin
        If (hl='h') and (ModeChar='?') then PrintScreenFF:=True;
        If (hl='l') and (ModeChar='?') then PrintScreenFF:=False;
			 end;
	19 : begin
        If (hl='h') and (ModeChar='?') then PrintFullScreen:=True;   {Screen}
        If (hl='l') and (ModeChar='?') then PrintFullScreen:=False;  {Region}
			 end;
	20 : begin
				If (hl='h') and (ModeChar<>'?') then AvtEolCRLF:=True;
				If (hl='l') and (ModeChar<>'?') then AvtEolCRLF:=False;
			 end;
	25 : begin
        If (hl='h') and (ModeChar='?') then {Cursor ON}
          begin
            Regs.AX:= $0100;
            if (AdapterType=1) then
              begin
                Regs.CL:= 13;
                Regs.CH:= 12;
             end else begin
                Regs.CL:= 7;
                Regs.CH:= 6;
              end;
            Intr($10, Regs);
          end;
        If (hl='l') and (ModeChar='?') then {Cursor OFF}
          begin
             Regs.AX:=$0100;
             Regs.CL:=$20;  Regs.CH:=$20;
             Intr($10, Regs);
          end;
       end;
 255 : begin
        If (hl='h') and (ModeChar='=') then
            begin
               DWMode:=True;
               OldEmulation:=Emulation;
               Exclude(Emulation, mkAVATAR);
            end;
        If (hl='l') and (ModeChar='=') then
            begin
               DWMode:=False;
               Emulation:=OldEmulation;
            end;
       end
  else
	 AvState:=0;
 end;
 end;


Procedure PrinterFunc(ModeByte:Byte; ModeChar:Char);

			 Procedure PrintRegion(xl,yl,xh,yh,opt:Byte);  {opt 0 = ascii print}
				 var
					 W:Word;
					 tX,tY:Byte;
				 begin
					 For tY:=yl to yh do
						begin
						 For tX:=xl to xh do
							begin
								 W:=GetScrnWord(tX, tY);
                 PrintThisString(Chr(Lo(W)));
							end;
             PrintThisString(#13+#10);
						end;
				 end;
 begin
 Case ModeByte of
	 0 : begin
				If (ModeChar<>'?') then    {PRINT_SCRN}
						 begin
							 If PrintFullScreen then PrintRegion(1,1,ScrnWidth,ScrnHeight,0)
																	else PrintRegion(VTScrollRegionX1,
																									 VTScrollRegionY1,
																									 VTScrollRegionX2,
																									 VTScrollRegionY2,
																									 0);
               If PrintScreenFF then PrintThisString(#12);
             end;
			 end;
	 1 : begin
				If (ModeChar='?') then     {PRINT_LINE}
						 begin
							 PrintRegion(1,WHEREY,ScrnWidth,WHEREY,0);
						 end;
			 end;
	 4 : begin
        If (ModeChar<>'?') then PrintCntrl:=False;
        If (ModeChar='?') then AutoPrint:=False;
        If (ModeChar='?') and PrintScreenFF then PrintThisString(#12);
			 end;
	 5 : begin
        If (ModeChar<>'?') then PrintCntrl:=True;
				If (ModeChar='?') then AutoPrint:=True; {Write('[AUTO_PRINT=ON]');}

			 end
	else
	 AvState:=0;
 end;
 end;


Procedure ProcCtl(ch:Char);
	Var
    i:  integer;   {was word}
   tX,tY:Byte;
   tStr:String;
  Begin
	Case ch of
		';': Begin
				 Ansiparmno := Ansiparmno + 1;
				 if Ansiparmno > 10 Then
					 Ansiparmno := 10;
				 End;
		'A': Begin
				 If Ansiparm[1] = 0 Then
					 Ansiparm[1] := 1;
				 i := WhereY;
				 Dec(i,AnsiParm[1]);
         If i < VTScrollRegionX1 Then  i := VTScrollRegionX1;           {was 0}
				 GoToXy(WhereX, i);
				 AvState := 0;
				 End;
		'B': Begin
				 If Ansiparm[1] = 0 Then
					 AnsiParm[1] := 1;
         If (WhereY+AnsiParm[1])>VTScrollRegionY2 then AnsiParm[1]:=VTScrollRegionY2-WhereY;
         GoToXy(WhereX, WhereY + AnsiParm[1]);
				 AvState := 0;
				 End;
		'C': Begin
				 If Ansiparm[1] = 0 Then
					 Ansiparm[1] := 1;
         If (WhereX+AnsiParm[1]) > ScrnWidth then AnsiParm[1]:=ScrnWidth-WhereX;
         GoToXy(WhereX + AnsiParm[1], WhereY);
				 AvState := 0;
				 End;
		'D': Begin
				 If AnsiParm[1] = 0 Then
						AnsiParm[1] := 1;
         i := WhereX;
         If (i-AnsiParm[1])<VTScrollRegionY1 then i:=VTScrollRegionY1;
         Dec(i, AnsiParm[1]);
         If i<1 then i:=1;
         GoToXy(i, WhereY);
				 AvState := 0;
				 End;
		'H','f':
				 Begin
				 if Ansiparm[1] = 0 Then
					 Ansiparm[1] := 1;
				 If Ansiparm[2] = 0 Then
						Ansiparm[2] := 1;
				 GoToXy(Ansiparm[2],Ansiparm[1]);
				 AvState := 0;
				 End;
		'J': Begin
				 AvState := 0;
         If AnsiParm[1] = 0 then
           Begin
            tX:=WhereX;  tY:=WhereY;
            ClrScr;
            GotoXY(tX,tY);
           End;
         If AnsiParm[1] = 1 then
           Begin
            tX:=WhereX;  tY:=WhereY;
            ClrScr;
            GotoXY(tX,tY);
           End;
         If AnsiParm[1] = 2 Then
					 Begin
					 TextAttr := AvAttr;
					 ClrScr;
					 End;
				 End;
		'K': Begin
				 AvState := 0;
				 ClrEol;
				 End;
		's': Begin
				 SaveX := WhereX;
				 SaveY := WhereY;
				 AvState := 0;
				 End;
		'u': Begin
				 GoToXy(SaveX, SaveY);
         AvState := 0;
				 End;
		'm': Begin
				 AvState := 0;
				 If AnsiParmNo > 0 Then
					 For i := 1 to AnsiParmNo Do
						 ColorParm(AnsiParm[i]);
				 TextAttr := AvAttr;
				 End;
    {*CONSTRUCTION*}
    'L': Begin                              {Jeff Patterson}
				 AvState:=0;
				 If AnsiParm[1]=0 then AnsiParm[1]:=1;
         GetCursorPosition(tX, tY);
         ScrollScrnRegionDown(VTScrollRegionX1, VTScrollRegionY1,
                              VTScrollRegionX2, VTScrollRegionY2,AnsiParm[1]);
         InitializeScrnRegion(1,tY,ScrnWidth,tY, ' ');
         End;
    'M': Begin                              {Jeff Patterson}
				 AvState:=0;
				 If AnsiParm[1]=0 then AnsiParm[1]:=1;
         GetCursorPosition(tX, tY);
         ScrollScrnRegionUp(VTScrollRegionX1, VTScrollRegionY1,
                            VTScrollRegionX2, VTScrollRegionY2,AnsiParm[1]);
         End;
    'r': Begin                              {Jeff Patterson}
					avState := 0;
           If AnsiParm[1]=0 then AnsiParm[1]:=1;
           If AnsiParm[2]=0 then AnsiParm[2]:=1;
           If (AnsiParmNo = 2) then
								 begin
                   VTScrollRegionX1:=1;
                   If (AnsiParm[1]<AnsiParm[2]) and (AnsiParm[1]<ScrnHeight)
                      and (AnsiParm[1]>0) then VTScrollRegionY1:=AnsiParm[1]
                                          else VTScrollRegionY1:=1;
									 VTScrollRegionX2:=80; VTScrollRegionY2:=AnsiParm[2];
                   If (AnsiParm[2]>AnsiParm[1]) and (AnsiParm[2]<ScrnHeight)
                      and (AnsiParm[2]>0) then VTScrollRegionY2:=AnsiParm[2]
                                          else VTScrollRegionY2:=ScrnHeight;
                end else begin
									 VTScrollRegionX1:=1;  VTScrollRegionY1:=1;
                   VTScrollRegionX2:=ScrnWidth; VTScrollRegionY2:=ScrnHeight;
								 end;
           If DWMode then
                begin
									 VTScrollRegionX1:=1;  VTScrollRegionY1:=1;
                   VTScrollRegionX2:=ScrnWidth; VTScrollRegionY2:=ScrnHeight;
                end;
         End;
    'i': Begin                              {Jeff Patterson}
				 AvState := 0;
				 If AnsiParmNo > 0 Then
					 For i := 1 to AnsiParmNo Do
							PrinterFunc(AnsiParm[i],AnsiParmQ[i]);
				 End;
    'g': Begin
           If (AnsiParmNo=1) and (AnsiParmQ[1]='>') and (AnsiParm[1]>0) then
             begin
               For I:=1 to 132 do
                 begin
                   if (I/AnsiParm[1]) = Trunc(I/AnsiParm[1]) then TabMap[I]:=True
                                                            else TabMap[I]:=False;
                 end;
             end;
           If (AnsiParmNo=1) and (AnsiParmQ[1]<>'>') and (AnsiParm[1]=0) then
             begin
               TabMap[WhereX]:=False;
             end;
{
           If (AnsiParmNo=1) and (AnsiParmQ[1]<>'>') and (AnsiParm[1]=3) then
             begin
               For I:=1 to 132 do TabMap[I]:=False;
             end;
}
         End;
    'c': Begin                              {Jeff Patterson}
          AvState := 0;
          tStr := #27+'[?6c';
          If vtSend(tStr) then Write('[ERR;MKAVT102:c]');
         End;
    'n': Begin                              {Jeff Patterson}
          AvState := 0;
          For I:= 1 to AnsiParmNo Do
           begin
             tStr:='';
             Case AnsiParm[i] of
              5 : Begin
                    tStr:=#27+'[3n';   {Terminal Status;  Response=Malfunction}
                    tStr:=#27+'[0n';   {Terminal Status;  Response=OK}
                  End;
              6 : tStr:=#27+'['+Long2Str(LongInt(WHEREY))+';'+Long2Str(LongInt(WHEREX))+'R';
              15: Begin
                    tStr:=#27+'[?13n';     {Printer Status; Response=No Printer}
                    If ISTOPEN(PrinterFiletext) then tStr:=#27+'[?10n'   {Ready}
                                                else tStr:=#27+'[?11n'; {Not Ready}
                  End;
              25: tStr:=#27+'[?21n';       { UserDefinableKeys Locked }
              26: tStr:=#27+'[?27;1n';      { US ASCII }
             End;
             If tStr<>'' then
               begin
                  If vtSend(tStr) then Write('[ERR;MKAVT102:n]');
               end;
           end;
         End;
    'q': Begin                              {Jeff Patterson}
          AvState := 0;
          For i := 1 to AnsiParmNo Do
            Begin
              If AnsiParm[i]=0 then
                    Begin
                      For RepCount:=1 to 8 do VTLED[RepCount]:=False;
                  end else begin
                           { There is actually only 4 but who cares :) }
                      If AnsiParm[i]<9 then VTLED[i]:=True;
                    End;
            End;
         End;
    'x': Begin                              {Jeff Patterson}
          AvState := 0;
          tStr:='';
          If AnsiParm[1]=0 then tStr:=#27+'[2;1;8;120;112;1;0x';     {9600}
          If AnsiParm[1]=1 then tStr:=#27+'[3;1;8;120;112;1;0x';     {9600}
          If vtSend(tStr) then Write('[ERR;MKAVT102:x]');
         End;
    'l': Begin                              {Jeff Patterson}
				 AvState := 0;
				 If AnsiParmNo > 0 Then
					 For i := 1 to AnsiParmNo Do
							 hlModes(AnsiParm[i],AnsiParmQ[i],'l');
				 End;
		'h': Begin                              {Jeff Patterson}
				 AvState := 0;
				 If AnsiParmNo > 0 Then
					 For i := 1 to AnsiParmNo Do
							 hlModes(AnsiParm[i],AnsiParmQ[i],'h');
				 End
			Else
        LastUnknownValid:=True;
        AvState := 0;
		End;
	End;


Procedure Accum(ch: Char);
	Begin
	AnsiParm[AnsiParmNo] := (AnsiParm[AnsiParmNo] * 10)  + (Ord(ch) - 48);
	End;

Procedure DoDisplay(ch: Char);
 Begin
					 If InsertMode Then
						 InsCharInLine(WhereX, WhereY, ch);
           If ch<>#0 then
                begin
                   If (WhereX=ScrnWidth) and ((not AutoWrap) or (WhereY=VTScrollRegionY2)) and
                      ((ch=#13) or (ch=#10)) then Write(ch);
                   If (WhereX=ScrnWidth) and ((not AutoWrap) or (WhereY=VTScrollRegionY2)) then
                      begin
                         PutScrnWord(WhereX, WhereY, Ord(ch)+(TextAttr shl 8));
                     end else begin
                         Write(ch);
                      end;
                end;
           If PrintCntrl then PrintThisString(ch);
 End;

Procedure AvatarChar(ch:Char);
	Var
		i: Word;
		tX,tY:Byte;
		wX1,wY1,wX2,wY2:Byte;
	Begin
	Case AvState of
		0: Begin
			 Case ch of
				 #027: AvState := 1;
         #005: Begin
                If DoAnswerBack then
                  begin
                    AvState:=0;
                    If Length(AnswerBack)>0 then vtSend(AnswerBack);
                  end else DoDisplay(ch);
               End;
         #009: Begin                                          {Horizontal Tab}
                 GetCursorPosition(tX, tY);
                 If TabMap[tX] then Inc(tX);
                 While (not TabMap[tX]) and (tX<132) do Inc(tX);
                 If tX>ScrnWidth then tX:=ScrnWidth;
                 SetCursorPosition(tX, tY);
               End;
         #010: Begin                                     { LineFeed }
								 GetCursorPosition(tX, tY);
                 If PrintCntrl then PrintThisString(#10);
                If (tY < VTScrollRegionY2) then
										begin
										 Write(#10);
                    end;
                If (tY >= VTScrollRegionY2) then
                 begin
                      ScrollScrnRegionUp(VTScrollRegionX1, VTScrollRegionY1,
																				 VTScrollRegionX2, VTScrollRegionY2,1);
                      SetCursorPosition(tX, VTScrollRegionY2);
								 end;
							 End;
				 #012: AvReset; 										 {^L - Avatar}
         #015: Begin
                 If not (mkAVATAR in Emulation) then asm nop end; {stupid VT100 conflict}
                 If mkAVATAR in Emulation then DoDisplay(#15);
               End;
         #025: If mkAVATAR in Emulation then AvState := 5      {^Y - Avatar}
                                        else DoDisplay(ch);
         #022: If mkAVATAR in Emulation then AvState := 7      {^V - Avatar}
                                        else DoDisplay(ch);
				 Else
            DoDisplay(ch);
         End;
			 End;
		1: Begin
			 Case ch of
				 #27: Begin
							AvState := 1;
              {If InsertMode Then
                InsCharInLine(WhereX, WhereY, #27); }
							{ Write(#27); }
							AvState:=0;
							End;
         '7': Begin
                VTSaveX:=WhereX;  VTSaveY:=WhereY;
                VTSaveTextAttr:=TextAttr;
                AvState:=0;
              End;
         '8': Begin
                GotoXY(VTSaveX, VTSaveY);
                TextAttr:=VTSaveTextAttr;
                AvState:=0;
              End;
         '(': AvState := 14;
         ')': AvState := 15;
         '#': AvState := 12;
         '<': Begin
               asm nop end;               { set terminal emulation to ANSI }
               AvState:=0;
              End;
         '=': Begin
               ApplicationMode:=True;     { set keypad application mode }
               AvState:=0;
              End;
         '>': Begin
               ApplicationMode:=False;    { set keypad numeric mode }
               AvState:=0;
              End;
         'D': Begin                      { "index"  (kinda like linefeed) }
                AvState:=0;
								 GetCursorPosition(tX, tY);
                 If PrintCntrl then PrintThisString(#10);
                If (tY < VTScrollRegionY2) then
										begin
										 Write(#10);
                    end;
                If (tY >= VTScrollRegionY2) then
                 begin
                      ScrollScrnRegionUp(VTScrollRegionX1, VTScrollRegionY1,
																				 VTScrollRegionX2, VTScrollRegionY2,1);
                      SetCursorPosition(tX, VTScrollRegionY2);
								 end;
							 End;
         'H': TabMap[WhereX]:=True;  {Set Tab, or $88}
         'M': Begin             { "reverse index" (reverse linefeed) }
                AvState:=0;
                If (WhereY > VTScrollRegionY1) then
                  begin
                    GoToXy(WhereX, WhereY - 1);
                    { If PrintCntrl then Write(PrinterFiletext,#27+'M'); }
                 end else begin
                     GetCursorPosition(tX, tY);
                     ScrollScrnRegionDown(VTScrollRegionX1, VTScrollRegionY1,
                                          VTScrollRegionX2, VTScrollRegionY2,1);
                  end;
              End;
         '[': Begin
							AvState := 2;
							AnsiParmNo := 1;
              For i := 1 To 10 Do
								 Begin
									 Ansiparm[i] := 0;
									 AnsiparmQ[i] :=#0;
								 end;
              LastUnknownValid:=False;
              LastUnknownSeq:='';
              End;
				 #12: Begin
               ClrScr;
               If mkAVATAR in Emulation then AvReset;
               AvState := 0;
							End;
				 #25: Begin
              If mkAVATAR in Emulation then
                begin
                  DoDisplay(#27);
 {                 AvState:=5; }
                end else begin
                  AvState:=0;
                end;
              End;
				 #22: Begin
              If mkAVATAR in Emulation then
                begin
                  DoDisplay(#27);
{                  AvState:=6;}
                end else begin
                  AvState:=0;
                end;
              End
         Else
          begin
           DoDisplay(#27);
           DoDisplay(ch);
           AvState := 0;
          end;
				 End;
			 End;
		2: Begin
       LastUnknownSeq:=LastUnknownSeq+ch;
       Case ch of
				 #27: Begin
							AvState := 1;
              DoDisplay(#27);
              DoDisplay('[');
							End;
				 '0' .. '9': Accum(ch);
				 '?'       : AnsiParmQ[AnsiParmNo] := ch;
         '='       : AnsiParmQ[AnsiParmNo] := ch;
         '>'       : AnsiParmQ[AnsiParmNo] := ch;
         Else
            ProcCtl(ch);
{           If ch in ControlCh Then
						 ProcCtl(ch)
            Else
             AvState :=0;
}
         End;
			 End;
		5: Begin
			 AnsiParm[1] := Ord(ch);
			 AvState := 6;
			 End;
		6: Begin
			 AvState := 0;
			 i := 1;
			 While i <= Ord(ch) Do
				 Begin
				 If InsertMode Then
					 InsCharInLine(WhereX, WhereY, Chr(AnsiParm[1]));
				 Write(Chr(AnsiParm[1]));
				 Inc(i);
				 End;
			 End;
		7: Begin
			 Case ch of
				 #001: AvState := 8;								 {^V^A}
				 #002: Begin
							 AvAttr := AvAttr or Blink; 	 {^B}
							 InsertMode := False;
							 AvState := 0;
							 End;
				 #003: Begin
							 If WhereY > 1 Then 					 {^C}
								 GoToXy(WhereX, WhereY - 1);
							 InsertMode := False;
							 AvState := 0;
							 End;
				 #004: Begin
							 GoToXy(WhereX, WhereY + 1);	 {^D}
							 InsertMode := False;
							 AvState := 0;
							 End;
				 #005: Begin
							 GoToXy(WhereX + 1, WhereY);	 {^E}
							 InsertMode := False;
							 AvState := 0;
							 End;
				 #006: Begin
							 If WhereX > 1 Then 					 {^F}
								 GoToXy(WhereX - 1, WhereY);
							 InsertMode := False;
							 AvState := 0;
							 End;
				 #007: Begin
							 ClrEol;											 {^G}
							 InsertMode := False;
							 AvState := 0;
							 End;
				 #008: AvState := 9;								 {^H}
				 #009: Begin
							 InsertMode := True;					 {^I}
							 AvState := 0;
							 End;
				 #010: Begin												 {^J}
							 AvState := 11;
							 RemainingParms := 5;
							 CommandType := 1;
							 InsertMode := False;
							 AnsiParmNo := 1;
							 End;
				 #011: Begin												 {^K}
							 AvState := 11;
							 RemainingParms := 5;
							 CommandType := 2;
							 InsertMode := False;
							 AnsiParmNo := 1;
							 End;
				 #012: Begin												 {^L}
							 AvState := 11;
							 RemainingParms := 3;
							 CommandType := 3;
							 InsertMode := False;
							 AnsiParmNo := 1;
							 End;
				 #013: Begin												 {^M}
							 AvState := 11;
							 RemainingParms := 4;
							 CommandType := 4;
							 InsertMode := False;
							 AnsiParmNo := 1;
							 End;
				 #014: Begin
							 DelCharInLine(WhereX, WhereY);{^N}
							 InsertMode := False;
							 AvState := 0;
							 End;
     {   #017: AvState := 13; }     {For Avatar Detection}
         #025: Begin                         {^Y}
							 AvState := 11;
							 RemainingParms := 1;
							 CommandType := 5;
							 AnsiParmNo := 1;
							 End;
				 End;
			 End;
		8: Begin																 {^V^A}
			 AvAttr := Ord(ch);
			 TextAttr := AvAttr;
			 AvState := 0;
			 InsertMode := False;
			 End;
		9: Begin																 {^V^H}
			 AvState := 10;
			 AnsiParm[1] := Ord(ch);
			 End;
		10:Begin																 {^V^H#}
			 AvState := 0;
			 GoToXy(Ord(ch), AnsiParm[1]);
			 InsertMode := False;
			 End;
		11:Begin
			 AnsiParm[AnsiParmNo] := Ord(ch);
			 Inc(AnsiParmNo);
			 If AnsiParmNo > MaxParms Then
				 AnsiParmNo := MaxParms;
			 Dec(RemainingParms);
			 If RemainingParms < 1 Then
				 Begin
				 Case CommandType of
					 1: Begin 												{^V^J}
							ScrollScrnRegionUp(AnsiParm[3], AnsiParm[2], AnsiParm[5],
								AnsiParm[4], AnsiParm[1]);
							AvState := 0;
							End;
					 2: Begin 												{^V^K}
							ScrollScrnRegionDown(AnsiParm[3], AnsiParm[2], AnsiParm[5],
								AnsiParm[4], AnsiParm[1]);
							AvState := 0;
							End;
					 3: Begin 												{^V^L}
							TextAttr := AnsiParm[1];
							InitializeScrnRegion(WhereX, WhereY, WhereX + AnsiParm[3],
								WhereY + AnsiParm[2], ' ');
							AvState := 0;
							End;
					 4: Begin 												{^V^M}
							TextAttr := AnsiParm[1];
							InitializeScrnRegion(WhereX, WhereY, WhereX + AnsiParm[4],
								WhereY + AnsiParm[3], Chr(AnsiParm[2]));
							AvState := 0;
							End;
					 5: Begin 												{Have num chars swith to 6}
							RemainingParms := Ord(Ch) + 2;
							CommandType := 6;
							End;
					 6: Begin 												{^V^Y}
							RepCount := AnsiParm[AnsiParmNo - 1];
							While RepCount > 0 Do
								Begin
								AnsiParmNo := 2;
								While AnsiParmNo < (AnsiParm[1]+ 3) Do
									Begin
									Write(Chr(AnsiParm[AnsiParmNo]));
                  If PrintCntrl then PrintThisString(Chr(AnsiParm[AnsiParmNo]));
									Inc(AnsiParmNo);
									End;
								Dec(RepCount);
								End;
							AvState := 0;
							End;
					 End;
				 End;
			 End;

    12 : Begin                    { ESC # }
					 AvState :=0;
					 Case Ch of
             '8' : InitializeScrnRegion(1,1,80,24,'E');
						 '3' : Write('[Double-Height:TopHalf]');
						 '4' : Write('[Double-Height:BottomHalf]');
						 '5' : Write('[Single-Width:SingleHeight]');
						 '6' : Write('[Double-Width]');
					 End;
        End;
    14,15 : Begin

              AvState:=0;
            End;
		End;
	End;


{$F+}
procedure OurExitProc;
var
  Index:Byte;
begin                      {OurExitProc}
  ExitProc := SaveExitProc;
  If ClearOnExit then ClrScr;
  Close(StdOut);
end;                       {OurExitProc}
{$F-}

Begin
ClearOnExit := False;
AvInit;
SaveExitProc := ExitProc;
ExitProc := @OurExitProc;
End.


