	PAGE	60,132
	TITLE	Tandy 1000 BIOS Graphics Functions Speedup Utility
	NAME	FASTGRAF

;------------------------------------------------------------------------------;
;									       ;
;				 FASTGRAF 1.0				       ;
;									       ;
;	      Tandy 1000 BIOS Graphics Functions Speedup Utility	       ;
;									       ;
;									       ;
;				  Written By:				       ;
;			      Joseph A. Albrecht			       ;
;			 9250 Old Cedar Ave  Apt. 215			       ;
;			    Bloomington, MN  55425			       ;
;									       ;
;			      GEnie Mail Address:			       ;
;				  A.ALBRECHT				       ;
;									       ;
;------------------------------------------------------------------------------;

;*******************************************************************************
Code	SEGMENT PARA PUBLIC 'CODE'	;Code segment

	ASSUME	CS:Code,DS:Code,ES:Code,SS:Code

		ORG	100H

Begin:
		JMP	Initialize	;Go to the initializing routine

PUSHR		MACRO

	PUSH	AX		;Save registers
	PUSH	BX		; ..
	PUSH	CX		; ..
	PUSH	DX		; ..
	PUSH	SI		; ..
	PUSH	DI		; ..
	PUSH	BP		; ..
	PUSH	DS		; ..
	PUSH	ES		; ..

		ENDM

POPR		MACRO

	POP	ES		;Restore registers
	POP	DS		; ..
	POP	BP		; ..
	POP	DI		; ..
	POP	SI		; ..
	POP	DX		; ..
	POP	CX		; ..
	POP	BX		; ..
	POP	AX		; ..

		ENDM

;Self modifying code equates
PlotPoint	EQU	WORD PTR DS:[PlotPt+1]
GetPoint	EQU	WORD PTR DS:[GetPt+1]

Mode		DB	?		;Current video mode number

EVEN

OldINT10H	EQU	DWORD PTR CS:[INT10H]
INT10H		DW	2 DUP(?)	;Storage for old video interrupt
NewINT10H	DW	2 DUP(?)	;Store for new INT 10H address
VideoSeg	DW	?		;Address of video segment

;Scan line address table
ScanLine	DW	200 DUP(?)

;-------------------------------------------------------------------------------

;
;Execution begins here on any INT 10H
;

Video		PROC	NEAR

	CMP	AH,12			;Plot a point
	JNE	Video1			; ..
PlotPt: JMP	ExecINT10H		; ..
Video1:
	CMP	AH,13			;Get a point
	JNE	Video2			; ..
GetPt:	JMP	ExecINT10H		; ..
Video2:
	OR	AH,AH			;Set video mode
	JZ	SetMode			; ..
	CMP	AH,10H			;Palette registers functions?
	JNE	Video3			; ..
	PUSHR				; ..
	CALL	DoPalette		; ..
	POPR				; ..
	IRET
Video3:
	CMP	AH,255			;Special program request
	JNE	Video4			; ..
	JMP	Special			; ..
Video4:
	JMP	OldINT10H		;Execute normal video BIOS

;
;Check which video mode is being entered
;

SetMode:
	MOV	CS:[Mode],AL		;Save mode number
	AND	CS:[Mode],7FH		; ..
	PUSHR				;Save registers
	PUSHF				;Execute normal video BIOS call
	CALL	OldINT10H		; ..
	PUSH	CS			;Point DS at current data segment
	POP	DS			; ..
	MOV	AX,40H			;Get current video mode
	MOV	ES,AX			; ..
	MOV	AL,ES:[49H]		; ..
	CMP	AL,[Mode]		;See if video mode number changed
	JE	SetMode1		; ..
	JMP	SetModeExit		; ..

;Modify instructions for 320x200x4 color graphics mode
SetMode1:
	MOV	[VideoSeg],0B800H	;Setup video segment
	CMP	AL,4			;Check if mode number is 4 or 5
	JB	SetMode1A		; ..
	CMP	AL,5			; ..
	JA	SetMode1A		; ..
	MOV	DS:[PlotPoint],(OFFSET Plot320_4 - OFFSET PlotPt) - 3
	MOV	DS:[GetPoint],(OFFSET Get320_4 - OFFSET GetPt) - 3
	JMP	Make16K

;Modify instructions for 640x200x2 color graphics mode
SetMode1A:
	CMP	AL,6			;Check if mode number is 6
	JNE	SetMode1B		; ..
	MOV	DS:[PlotPoint],(OFFSET Plot640_2 - OFFSET PlotPt) - 3
	MOV	DS:[GetPoint],(OFFSET Get640_2 - OFFSET GetPt) - 3
	JMP	Make16K

;Modify instructions for 160x200x16 color graphics mode
SetMode1B:
	CMP	AL,8			;Check if mode number is 8
	JNE	SetMode2		; ..
	MOV	DS:[PlotPoint],(OFFSET Plot16 - OFFSET PlotPt) - 3
	MOV	DS:[GetPoint],(OFFSET Get16 - OFFSET GetPt) - 3
	MOV	AX,159
	MOV	WORD PTR DS:[Plot16+2],AX
	MOV	WORD PTR DS:[Get16+2],AX
	JMP	Make16K

;Modify instructions for 320x200x16 color graphics mode
SetMode2:
	CMP	AL,9			;Check if mode number is 9
	JNE	SetMode3		; ..
	MOV	DS:[PlotPoint],(OFFSET Plot16 - OFFSET PlotPt) - 3
	MOV	DS:[GetPoint],(OFFSET Get16 - OFFSET GetPt) - 3
	MOV	AX,319
	MOV	WORD PTR DS:[Plot16+2],AX
	MOV	WORD PTR DS:[Get16+2],AX
	JMP	Make32K

;Modify instructions for 640x200x4 color graphics mode
SetMode3:
	CMP	AL,10			;Check if mode number is 10
	JNE	SetMode4		; ..
	MOV	DS:[PlotPoint],(OFFSET Plot640_4 - OFFSET PlotPt) - 3
	MOV	DS:[GetPoint],(OFFSET Get640_4 - OFFSET GetPt) - 3

;Remap colors 1-3 for better display
	MOV	BX,0B01H		;Color 1 = Light Cyan
	CALL	SetPalette		; ..
	MOV	BX,0D02H		;Color 2 = Light Magenta
	CALL	SetPalette		; ..
	MOV	BX,0F03H		;Color 3 = Bright White
	CALL	SetPalette		; ..
	JMP	Make32K

;Modify instructions for 640x200x16 color graphics mode
SetMode4:
	CMP	AL,11			;Check if mode number is 11
	JNE	SetMode5		; ..
	MOV	DS:[PlotPoint],(OFFSET Plot16 - OFFSET PlotPt) - 3
	MOV	DS:[GetPoint],(OFFSET Get16 - OFFSET GetPt) - 3
	MOV	[VideoSeg],0A000H	;Setup video segment
	MOV	AX,639
	MOV	WORD PTR DS:[Plot16+2],AX
	MOV	WORD PTR DS:[Get16+2],AX
	JMP	Make64K

;Modify JMP instructions to default state
SetMode5:
	MOV	PlotPoint,(OFFSET ExecINT10H - OFFSET PlotPt) - 3
	MOV	GetPoint,(OFFSET ExecINT10H - OFFSET GetPt) - 3
	JMP	SetModeExit

;Generate 16K scan line address table
Make16K:
	CALL	Common			;Setup common register values
	SHR	SI,1			;Get scan line in bytes
Make16K1:
	MOV	AX,BX			;S = S / 2
	SHR	AX,1			; ..
	MUL	SI			;S = S / 2 * 80
	MOV	DX,BX			;S = S / 2 * 80 + ((S MOD 2) * 8192)
	AND	DX,1			; ..
	SHL	DX,CL			; ..
	ADD	AX,DX			; ..
	STOSW				;Store table entry
	INC	BX			;Increment to next table entry
	DEC	BP			;Do next entry
	JNZ	Make16K1		; ..
	JMP	SetModeExit

;Generate 32K scan line address table
Make32K:
	CALL	Common			;Setup common register values
Make32K1:
	MOV	AX,BX			;S = S / 4
	SHR	AX,1			; ..
	SHR	AX,1			; ..
	MUL	SI			;S = S / 4 * 160
	MOV	DX,BX			;S = S / 4 * 160 + ((S MOD 4) * 8192)
	AND	DX,3			; ..
	SHL	DX,CL			; ..
	ADD	AX,DX			; ..
	STOSW				;Store table entry
	INC	BX			;Increment to next table entry
	DEC	BP			;Do next entry
	JNZ	Make32K1		; ..
	JMP	SetModeExit

;Generate 64K scan line address table
Make64K:
	CALL	Common			;Setup common register values
	SHL	SI,1			;Get scan line in bytes
Make64K1:
	MOV	AX,BX			;S = S * 320
	MUL	SI			; ..
	STOSW				;Store table entry
	INC	BX			;Increment to next table entry
	DEC	BP			;Do next entry
	JNZ	Make64K1		; ..

SetModeExit:
	POPR				;Restore registers
	IRET				;Return from interrupt

;Set up common register values for scan line table generation
Common:
	PUSH	CS			;Point ES at current data segment
	POP	ES			; ..
	MOV	DI,OFFSET ScanLine	;Point to scanline address table
	MOV	SI,160			;Get number of bytes per scanline
	MOV	BP,200			;Get number tables entries
	XOR	BX,BX			;Initialize scan line counter
	MOV	CL,13			;Get shift count for MOD operation
	CLD				;Make sure string op's go forward
	RET

;Set palette register functions
DoPalette:
	CMP	CS:[Mode],7		;Check for Tandy 1000 specifiec modes
	JA	DoPaletteOK		; ..
	PUSHF				;Fake a INT 10H call
	CALL	OldINT10H		; ..
	RET				; ..
DoPaletteOK:
	OR	AL,AL			;Set a palette register
	JNZ	DoPalette1		; ..
	CALL	SetPalette		; ..
	RET				; ..
DoPalette1:
	CMP	AL,1			;Set border register
	JNE	DoPalette2		; ..
	XOR	BL,BL			; ..
	MOV	DI,2			; ..
	CALL	SetPalette1		; ..
	RET				; ..
DoPalette2:
	CMP	AL,2			;Loading palette registers?
	JNE	DoPalette3		; ..
	CALL	LoadPalette		; ..
DoPalette3:
	RET

;Change all 17 palette registers using elements of a byte array
LoadPalette:
	MOV	SI,DX		;OFFSET address in SI
	XOR	BL,BL		;Palette register number in BL
	MOV	CX,16		;Set count for colors 0-15
LoadPalette1:
	MOV	BH,ES:[SI]	;Color to store in BH
;	CALL	ConvertEGA	;Convert EGA -> Tandy 1000 format
	CALL	SetPalette	;Set the palette register color
	INC	BL		;Bump up to next palette register number
	INC	SI		;Point to next color in the array
	LOOP	LoadPalette1	;Do next palette register
	XOR	BL,BL		;Border register is 0
	MOV	DI,2		;Border register offset is 2
	MOV	BH,ES:[SI]	;Get border color
	CALL	SetPalette1	;Set the border color
	RET

;Change a palette register color
SetPalette:
	MOV	DI,16		;Port offset for palette registers

;Entered here to set border register
SetPalette1:
	CMP	BL,15		;Validate palette register number
	JA	SetPalette3	; ..
	CMP	BH,15		;Validate color
	JA	SetPalette3	; ..
	MOV	DX,3DAH		;Address & status register
	CLI			;Clear interrupts
SetPalette2:
	IN	AL,DX		;Get status register
	AND	AL,8		;Look for bit 3
	JZ	SetPalette2	;Wait for vertical retrace
	MOV	AL,BL		;Get palette number
	CBW			; ..
	ADD	AX,DI		;ADD offset for palette or border
	OUT	DX,AL		;Set palette
	MOV	AL,BH		;Get color to store
	MOV	DX,3DEH		;Palette data register
	OUT	DX,AL		;Set palette color
	MOV	DX,3DAH		;Address & status register
	XOR	AL,AL		;AL = 0 to reset address register
	OUT	DX,AL		;Reset it
	STI			;Re-enable interrupts
SetPalette3:
	RET

COMMENT !

;Convert EGA rgbRGB format palette to Tandy 1000 IRGB format
ConvertEGA:
	MOV	AL,BH		;Save original palette
	SHR	BH,1		;Shift rgb bits to proper position
	SHR	BH,1		; ..
	SHR	BH,1		; ..
	AND	AL,7		;See if intensity bit should be set
	CMP	AL,3		; ..
	JLE	ConvertEGA1	; ..
	OR	BH,8		;Set the intensity bit
ConvertEGA1:
	RET

	!

;
;Execute normal video BIOS call
;

ExecINT10H:
	JMP	OldINT10H		;Execute normal video BIOS

;
;Plot a point on 320x200x4 color graphics screen
;

Plot320_4:
	CMP	CX,319			;Validate X
	JA	Plot320_4B		; ..
	CMP	DX,199			;Validate Y
	JA	Plot320_4B		; ..
	PUSH	CX			;Save registers
	PUSH	SI			; ..
	PUSH	DS			; ..
	MOV	SI,0B800H		;Point DS at video buffer
	MOV	DS,SI			; ..
	MOV	SI,DX			;Get scan line address
	SHL	SI,1			; ..
	MOV	SI,CS:ScanLine[SI]	; ..
	MOV	AH,CL			;Save low byte of column
	SHR	CX,1			;Get column offset
	SHR	CX,1			; ..
	ADD	SI,CX			;Add column offset to address
	NOT	AH			;Get shift count
	AND	AH,3			; ..
	SHL	AH,1			; ..
	MOV	CL,AH			; ..
	OR	AL,AL			;See if pixel should be XOR'ed
	JS	Xor320_4		; ..
	AND	AL,3			;Get OR mask
	ROL	AL,CL			; ..
	MOV	AH,0FCH			;Get AND mask
	ROL	AH,CL			; ..
	MOV	CL,[SI]			;Plot the point
	AND	CL,AH			; ..
	OR	CL,AL			; ..
	MOV	[SI],CL			; ..
Plot320_4A:
	POP	DS			;Restore registers
	POP	SI			; ..
	POP	CX			; ..
Plot320_4B:
	IRET

;
;Xor a point on 320x200x4 color graphics screen
;

Xor320_4:
	AND	AL,3			;Get XOR mask
	ROL	AL,CL			; ..
	XOR	[SI],AL			;XOR the point
	JMP	Plot320_4A

;
;Return a point from 320x200x4 color graphics screen
;

Get320_4:
	CMP	CX,319			;Validate X
	JA	Get320_4A		; ..
	CMP	DX,199			;Validate Y
	JA	Get320_4A		; ..
	PUSH	CX			;Save registers
	PUSH	SI			; ..
	PUSH	DS			; ..
	MOV	SI,0B800H		;Point DS at video buffer
	MOV	DS,SI			; ..
	MOV	SI,DX			;Get scan line address
	SHL	SI,1			; ..
	MOV	SI,CS:ScanLine[SI]	; ..
	MOV	AX,CX			;Save column
	SHR	AX,1			;Get column offset
	SHR	AX,1			; ..
	ADD	SI,AX			;Add column offset to address
	NOT	CL			;Get shift count
	AND	CL,3			; ..
	SHL	CL,1			; ..
	MOV	AL,[SI]			;Return the point
	ROR	AL,CL			; ..
	AND	AL,3			; ..
	POP	DS			;Restore registers
	POP	SI			; ..
	POP	CX			; ..
Get320_4A:
	IRET

;
;Plot a point on 640x200x2 color graphics screen
;

Plot640_2:
	CMP	CX,639			;Validate X
	JA	Plot640_2B		; ..
	CMP	DX,199			;Validate Y
	JA	Plot640_2B		; ..
	PUSH	CX			;Save registers
	PUSH	SI			; ..
	PUSH	DS			; ..
	MOV	SI,0B800H		;Point DS at video buffer
	MOV	DS,SI			; ..
	MOV	SI,DX			;Get scan line address
	SHL	SI,1			; ..
	MOV	SI,CS:ScanLine[SI]	; ..
	MOV	AH,CL			;Save low order byte of column
	SHR	CX,1			;Get column offset
	SHR	CX,1			; ..
	SHR	CX,1			; ..
	ADD	SI,CX			;Add column offset to address
	NOT	AH			;Get shift count
	AND	AH,7			; ..
	MOV	CL,AH			; ..
	OR	AL,AL			;Set if pixel should be XOR'ed
	JS	Xor640_2		; ..
	AND	AL,1			;Get OR mask
	ROL	AL,CL			; ..
	MOV	AH,0FEH			;Get AND mask
	ROL	AH,CL			; ..
	MOV	CL,[SI]			;Plot the point
	AND	CL,AH			; ..
	OR	CL,AL			; ..
	MOV	[SI],CL			; ..
Plot640_2A:
	POP	DS			;Restore registers
	POP	SI			; ..
	POP	CX			; ..
Plot640_2B:
	IRET

;
;Xor a point on 640x200x2 color graphics screen
;

Xor640_2:
	AND	AL,1			;Get XOR mask
	ROL	AL,CL			; ..
	XOR	[SI],AL			;XOR the point
	JMP	Plot640_2A

;
;Return a point from 640x200x2 color graphics screen
;

Get640_2:
	CMP	CX,639			;Validate X
	JA	Get640_2A		; ..
	CMP	DX,199			;Validate Y
	JA	Get640_2A		; ..
	PUSH	CX			;Save registers
	PUSH	SI			; ..
	PUSH	DS			; ..
	MOV	SI,0B800H		;Point DS at video buffer
	MOV	DS,SI			; ..
	MOV	SI,DX			;Get scan line address
	SHL	SI,1			; ..
	MOV	SI,CS:ScanLine[SI]	; ..
	MOV	AX,CX			;Save column
	SHR	AX,1			;Get column offset
	SHR	AX,1			; ..
	SHR	AX,1			; ..
	ADD	SI,AX			;Add column offset to address
	NOT	CL			;Get shift count
	AND	CL,7			; ..
	MOV	AL,[SI]			;Return the point
	ROR	AL,CL			; ..
	AND	AL,1			; ..
	POP	DS			;Restore registers
	POP	SI			; ..
	POP	CX			; ..
Get640_2A:
	IRET

;
;Plot a point on 640x200x4 color graphics screen
;

Plot640_4:
	CMP	CX,639			;Validate X
	JA	Plot640_4B		; ..
	CMP	DX,199			;Validate Y
	JA	Plot640_4B		; ..
	PUSH	CX			;Save registers
	PUSH	DX			; ..
	PUSH	SI			; ..
	PUSH	DS			; ..
	MOV	SI,0B800H		;Point DS at video segment
	MOV	DS,SI			; ..
	MOV	SI,DX			;Get scan line address
	SHL	SI,1			; ..
	MOV	SI,CS:ScanLine[SI]	; ..
	MOV	DX,CX			;Save column
	SHR	DX,1			;Get column offset
	SHR	DX,1			; ..
	AND	DL,0FEH			; ..
	ADD	SI,DX			;Add column offset to address
	NOT	CL			;Get shift count
	AND	CL,7			; ..
	OR	AL,AL			;See if pixel should be XOR'ed
	JS	Xor640_4		; ..
	MOV	AH,AL			;Form OR mask
	ROR	AH,1			; ..
	AND	AX,101H			; ..
	ROL	AX,CL			; ..
	MOV	DX,0FEFEH		;Form AND mask
	ROL	DX,CL			; ..
	MOV	CX,[SI]			;Plot the point
	AND	CX,DX			; ..
	OR	CX,AX			; ..
	MOV	[SI],CX			; ..
Plot640_4A:
	POP	DS			;Restore registers
	POP	SI			; ..
	POP	DX			; ..
	POP	CX			; ..
Plot640_4B:
	IRET

;
;Xor a point on 640x200x4 color graphics screen
;

Xor640_4:
	MOV	AH,AL			;Form OR mask
	ROL	AH,1			; ..
	AND	AX,101H			; ..
	ROL	AX,CL			; ..
	XOR	[SI],AX			;XOR the point
	JMP	Plot640_4A

;
;Return a point from 640x200x4 color graphics screen
;

Get640_4:
	CMP	CX,639			;Validate X
	JA	Get640_4A		; ..
	CMP	DX,199			;Validate Y
	JA	Get640_4A		; ..
	PUSH	CX			;Save registers
	PUSH	SI			; ..
	PUSH	DS			; ..
	MOV	SI,0B800H		;Point DS at video segment
	MOV	DS,SI			; ..
	MOV	SI,DX			;Get scan line address
	SHL	SI,1			; ..
	MOV	SI,CS:ScanLine[SI]	; ..
	MOV	AX,CX			;Save column
	SHR	AX,1			;Get column offset
	SHR	AX,1			; ..
	AND	AL,0FEH			; ..
	ADD	SI,AX			;Add column offset to address
	NOT	CL			;Get shift count
	AND	CL,7			; ..
	MOV	AX,[SI]			;Return the point
	ROR	AX,CL			; ..
	AND	AX,101H			; ..
	ROL	AH,1			; ..
	OR	AL,AH			; ..
	POP	DS			;Restore registers
	POP	SI			; ..
	POP	CX			; ..
Get640_4A:
	IRET

;
;Plot a point on 16 color graphics screen
;

Plot16:
	CMP	CX,319			;Validate X
	JA	Plot16B			; ..
	CMP	DX,199			;Validate Y
	JA	Plot16B			; ..
	PUSH	CX			;Save registers
	PUSH	SI			; ..
	MOV	SI,DX			;Get scan line address
	SHL	SI,1			; ..
	MOV	SI,CS:ScanLine[SI]	; ..
	OR	AL,AL			;See if pixel should be XOR'ed over
	JS	Xor16			; .. existing pixel
	AND	AL,15			;Mask off unwanted bits
	SHR	CX,1			;Get column offset
	JC	Plot16Odd		;Check for odd/even pixel

;Plot a pixel for an even address
	ADD	SI,CX			;Add column offset to address
	MOV	CL,4			;Move color to proper position
	SHL	AL,CL			; ..
	MOV	CX,DS			;Save DS
	MOV	DS,CS:[VideoSeg]	;Point DS at video buffer
	MOV	AH,[SI]			;Plot the point
	AND	AH,0FH			; ..
	OR	AH,AL			; ..
	MOV	[SI],AH			; ..
	JMP	Plot16A

;Plot a pixel for an odd address
Plot16Odd:
	ADD	SI,CX			;Add column offset to address
	MOV	CX,DS			;Save DS
	MOV	DS,CS:[VideoSeg]	;Point DS at video buffer
	MOV	AH,[SI]			;Plot the point
	AND	AH,0F0H			; ..
	OR	AH,AL			; ..
	MOV	[SI],AH			; ..
Plot16A:
	MOV	DS,CX			;Restore DS
	POP	SI			;Restore registers
	POP	CX			; ..
Plot16B:
	IRET				;Return from interrupt

;Xor a pixel onto the screen
Xor16:
	AND	AL,15			;Mask off unwanted bits
	SHR	CX,1			;Get column offset
	JC	Xor16Odd		;Check for odd/even pixel

;Xor a pixel for an even address
	ADD	SI,CX			;Add column offset to address
	MOV	CL,4			;Move color to proper position
	SHL	AL,CL			; ..
	MOV	CX,DS			;Save DS
	MOV	DS,CS:[VideoSeg]	;Point DS at video buffer
	XOR	[SI],AL			;XOR the pixel over existing pixel
	JMP	Plot16A

;Xor a pixel for an odd address
Xor16Odd:
	ADD	SI,CX			;Add column offset to address
	MOV	CX,DS			;Save DS
	MOV	DS,CS:[VideoSeg]	;Point DS at video buffer
	XOR	[SI],AL			;XOR the pixel over existing pixel
	JMP	Plot16A

;
;Return a point from 160x200x16 color graphics mode
;

Get16:
	CMP	CX,319			;Validate X
	JA	Get16B			; ..
	CMP	DX,199			;Validate Y
	JA	Get16B			; ..
	PUSH	CX			;Save registers
	PUSH	SI			; ..
	MOV	SI,DX			;Get scan line address
	SHL	SI,1			; ..
	MOV	SI,CS:ScanLine[SI]	; ..
	SHR	CX,1			;Get column offset
	JC	Get16Odd		;Check for odd/even pixel

;Get pixel for an even address
	ADD	SI,CX			;Add column offset to address
	MOV	CX,DS			;Save DS
	MOV	DS,CS:[VideoSeg]	;Point DS at video buffer
	MOV	AL,[SI]			;Get the pixel
	SHR	AL,1			; ..
	SHR	AL,1			; ..
	SHR	AL,1			; ..
	SHR	AL,1			; ..
	JMP	Get16A

;Get pixel for an odd address
Get16Odd:
	ADD	SI,CX			;Add column offset to address
	MOV	CX,DS			;Save DS
	MOV	DS,CS:[VideoSeg]	;Point DS at video buffer
	MOV	AL,[SI]			;Get the pixel
	AND	AL,0FH			; ..
Get16A:
	MOV	DS,CX			;Restore DS
	POP	SI			;Restore registers
	POP	CX			; ..
Get16B:
	IRET				;Return from interrupt

;
;Return residency status of driver or remove program from memory
;

Special:
	CMP	AX,0FF00H		;Return residency status?
	JNE	CheckRemove		; ..
	CMP	BL,1			;Validate it's a call to this program
	JE	GetStatus		; ..
SpecialExit:
	JMP	OldINT10H		;Execute normal video BIOS call

;Return residency status
GetStatus:
	MOV	AX,0DEADH		;Indicate this program is resident
	IRET				;Return from interrupt handler

;Remove program from memory
CheckRemove:
	CMP	AX,0FF01H		;See if program should be removed
	JNE	SpecialExit		; ..
	CMP	BL,1			;Validate it's a call to this program
	JNE	SpecialExit		; ..
	PUSH	DX			;Save registers
	PUSH	DS			; ..
	PUSH	ES			; ..
	MOV	AX,2510H		;Reset original video vector
	LDS	DX,OldINT10H		; ..
	INT	21H			; ..
	PUSH	CS			;Point ES at local data segment
	POP	ES			; ..
	MOV	AH,49H			;Free memory function
	INT	21H			; ..
	MOV	ES,CS:[2CH]		;Get environment segment
	MOV	AH,49H			;Free memory function
	INT	21H			; ..
	POP	ES			;Restore registers
	POP	DS			; ..
	POP	DX			; ..
	IRET				;Return from interrupt

Video		ENDP

;-------------------------------------------------------------------------------

Initialize	PROC	NEAR

	MOV	[Parameter],0		;Assume no argument on command line
	CLD				;Make sure string op's go forward
	MOV	SI,80H			;Check command line
	LODSB				; ..
	CBW				; ..
	OR	AX,AX			; ..
	JZ	Initialize1		; ..
	MOV	CX,AX			;Command line count in CX
	MOV	DI,81H			;Set command line starting address
	MOV	AL,'/'			;Search for a "/"
	REPNE	SCASB			; ..
	JNE	Initialize1		;Not there
	JCXZ	Initialize1		; ..
	DEC	DI			;It's there, now get character after
	MOV	AX,[DI]			; .. "/" and make sure it's upper case
	SUB	AH,32			; .. if it's a letter
	MOV	[Parameter],AX		; ..

;See if the program is already installed
Initialize1:
	MOV	AX,0FF00H		;Check if program is already installed
	MOV	BX,1			; ..
	INT	10H			; ..
	CMP	AX,0DEADH		; ..
	JNE	InitializeOK		; ..
	CMP	[Parameter],'R/'	;Check if program should be removed
	JE	Remove			; ..
	MOV	AH,9			;Program already installed
	MOV	DX,OFFSET ErrorMsg	; .. Print error message and exit
	INT	21H			; ..
	MOV	AX,4C00H		; ..
	INT	21H			; ..

;Remove program from memory
Remove:
	MOV	AX,0FF01H		;Request to remove program from memory
	MOV	BX,1			; ..
	INT	10H			; ..
	MOV	AH,9			;Everything is OK, print remove message
	MOV	DX,OFFSET RemoveMsg	; .. and exit
	INT	21H			; ..
	MOV	AX,4C00H		; ..
	INT	21H			; ..

;Save old video interrupt
InitializeOK:
	MOV	AH,35H			;Get interrupt vector
	MOV	AL,10H			; ..
	INT	21H			; ..
	MOV	[INT10H],BX		;Save the old video vector
	MOV	[INT10H+2],ES		; ..

;Install new interrupt
	MOV	[NewINT10H],OFFSET Video;Save new interrupt vector address
	MOV	[NewINT10H+2],CS	; ..
	MOV	AH,25H			;Set interrupt vector
	MOV	AL,10H			; ..
	MOV	DX,OFFSET Video		; ..
	INT	21H			; ..

;Terminate and stay resident
	MOV	AH,9			;Print installed message
	MOV	DX,OFFSET InstallMsg	; ..
	INT	21H			; ..
	MOV	ES,CS:[2CH]		;Get environment segment
	MOV	AH,49H			;Free memory function
	INT	21H			; ..
	MOV	AX,3100H		;Keep process function
	MOV	DX,OFFSET Initialize	;Point to last byte of TSR code
	MOV	CL,4			;Get # of paragraphs to keep
	SHR	DX,CL			; ..
	INC	DX			; ..
	INT	21H			; ..

Parameter	DW	?		;Command line parameter

InstallMsg	DB	13,10
		DB	'FASTGRAF 1.0  Copyright (C) 1990 by '
		DB	'Joseph A. Albrecht'
		DB	13,10
		DB	13,10
		DB	'Tandy 1000 BIOS graphics speedup routines now '
		DB	'installed.'
		DB	13,10
		DB	'$'

ErrorMsg	DB	7
		DB	13,10
		DB	'FASTGRAF is already installed!'
		DB	13,10
		DB	'$'

RemoveMsg	DB	13,10
		DB	'FASTGRAF now removed from memory'
		DB	13,10
		DB	'$'

Initialize	ENDP

;-------------------------------------------------------------------------------

Code		ENDS
;*******************************************************************************

		END	Begin
