/*
    Modstuf.h

    Header file for Modstuf.c.  This is the same stuff as in Modstuf.inc, 
    only this is the header file for C.
*/

#ifndef MODSTUF_H
#define MODSTUF_H

/*************************************************************************/
/*                                                                       */
/* Macros.                                                               */
/*                                                                       */
/*************************************************************************/

#define PARTMIXSIZE 13364     /* size of the partial-mix buffer in bytes */
#define MAXTICKS 48           /* maximum number of ticks per division */


/*************************************************************************/
/*                                                                       */
/* Types.                                                                */
/*                                                                       */
/*************************************************************************/

    /* Internal sample data structure. */
struct samprec {
    unsigned sampseg;       /* segment address of sample data */
    unsigned samplen;       /* length of sample in words */
    unsigned samplstart;    /* start of sample loop in words */
    unsigned sampllen;      /* length of sample loop in words */
    unsigned sampc4spd;     /* playback rate at C4 in Hertz */
    signed char sampvol;    /* default volume for the sample, byte 0-64 */
    char sampemsflag;       /* 1 if sample loaded in EMS */
    unsigned sampemshandle; /* EMS handle if loaded in EMS */
};

    /* Sample data structure in the mod file.  Note that word values here 
       will need to have the bytes swapped (they are big-endian). */
struct filsamrec {
    char filsamname[22];        /* name of sample */
    unsigned filsamlen;         /* length of sample in words */
    unsigned char filsamfine;   /* finetune of sample */
    unsigned char filsamvol;    /* volume of sample */
    unsigned filsamrstart;      /* sample repeat start (word offset) */
    unsigned filsamrlen;        /* sample repeat length in words */
};

    /* Channel data structure (76 bytes currently). */
struct chanrec {
        /* near pointer to sample structure for current sample */
    struct samprec near *chansampptr;
    signed char chanlastsamp;   /* last output sample on this channel, byte */
                                /*   -128 to 127                            */
    char chansampdone;          /* sample done flag, 1 if sample is not  */
                                /*   looped and has been played through; */
                                /*   channel may not be ramped down yet  */
    unsigned chansampfrac;      /* fractional part of current byte offset  */
                                /*   from the start of the current segment */
                                /*   in the sample buffer                  */
    unsigned chansampoffs;      /* integer part of current byte offset     */
                                /*   from the start of the current segment */
                                /*   in the sample buffer                  */
    unsigned chansampseg;       /* current segment in the sample buffer;   */
                                /*   equal to the segment address of the   */
                                /*   sample buffer, or 1000h more than the */
                                /*   sample segment                        */
    unsigned chanstepfrac;      /* fractional part of sample step in bytes */
    unsigned chanstepint;       /* integer part of sample step in bytes */
    unsigned chanpartoffs;      /* offset of the starting address in the  */
                                /*   partial-mix buffer for the channel;  */
                                /*   for channels on the left, this is 0, */
                                /*   for channels on the right, 2         */
    unsigned chanpartseg;       /* segment address of the partial-mix    */
                                /*   buffer; this is a copy of a global  */
                                /*   variable put here so we can use the */
                                /*   LES instruction                     */
    unsigned chanc4spd;         /* playback rate of sample on channel at */
                                /*   C4 in Hertz                         */
    unsigned chaneffperiod;     /* effective period for the channel */
        /* near pointer to effect tick procedure for the channel */
    void (near *chanefftickproc)( void );
        /* near pointer to effect end procedure for the channel */
    void (near *chaneffendproc)( void );
    unsigned chanastep0frac;    /* fractional part of arpeggio sample step */
                                /*   0 in bytes                            */
    unsigned chanastep0int;     /* integer part of arpeggio sample step 0 */
                                /*   in bytes                             */
    unsigned chanastep1frac;    /* fractional part of arpeggio sample step */
                                /*   1 in bytes                            */
    unsigned chanastep1int;     /* integer part of arpeggio sample step 1 */
                                /*   in bytes                             */
    unsigned chanastep2frac;    /* fractional part of arpeggio sample step */
                                /*   2 in bytes                            */
    unsigned chanastep2int;     /* integer part of arpeggio sample step 2 */
                                /*   in bytes                             */
    unsigned char chanarpcount; /* arpeggio counter, byte 0-2 */
    char changliss;             /* glissando flag, 1 if glissando slide */
                                /*   enabled                            */
    int chanslideincr;          /* signed slide increment (for period      */
                                /*   slide), -128 to 127, sign-extended to */
                                /*   16 bits                               */
    unsigned chanperiodgoal;    /* period goal for slide to note */
    unsigned near *chanvibwave; /* near pointer to vibrato waveform table */
    unsigned near *chantremwave; /* near pointer to tremolo waveform table */
    unsigned chanvibdepth;      /* vibrato depth, 1-15, extended to 16 bits */
    unsigned chantremdepth;     /* tremolo depth, 1-15, extended to 16 bits */
    unsigned chanvibincr;       /* vibrato increment, 1-15, extended to 16 */
                                /*   bits                                  */
    unsigned chantremincr;      /* tremolo increment, 1-15, extended to 16 */
                                /*   bits                                  */
    unsigned chanvibpos;        /* current position in vibrato table, 0-63, */
                                /*   extended to 16 bits                    */
    unsigned chantrempos;       /* current position in tremolo table, 0-63, */
                                /*   extended to 16 bits                    */
    char chanvibnoretrg;        /* vibrato retrigger flag, 1 if no retrigger */
    char chantremnoretrg;       /* tremolo retrigger flag, 1 if no retrigger */
    signed char chanmainvol;    /* main volume for the channel, byte 0-64 */
    signed char chaneffvol;     /* effective volume for the channel, byte */
                                /*   0-64                                 */
    signed char chanmixvol;     /* mixing volume for the channel, byte 0-64 */
    signed char chanvolincr;    /* signed volume increment (for volume     */
                                /*   slide), -15 to 15, sign-extended to 8 */
                                /*   bits
    unsigned char chanretrigspeed; /* retrigger speed, byte 1-15 */
    unsigned char chanretrigcount; /* retrigger count, byte 0-15 */
    unsigned char chancutcount; /* cut count, byte 0-15 */
    unsigned char chandelaycount; /* delay count, byte 0-15 */
    char chansamphalf;          /* current 64k half of sample, if in EMS */
    unsigned char chaninfobyte; /* infobyte for current effect (.s3m) */
    unsigned char chantremoroff; /* count where tremor turns channel off */
    unsigned char chantremorend; /* count where tremor turns channel on */
                                 /*   again                             */
    unsigned char chantremorcount; /* current tremor count */
    char pad;                   /* (pad to an even number of bytes) */
};

    /* Internal note data structure. */
struct noterec {
    unsigned char notesampnum;  /* sample number for note */
    signed char notevol;        /* volume for note (for .s3m) */
    unsigned noteperiod;        /* period for note (.s3m range) */
    unsigned char noteeffparm;  /* parameter for note effect */
    unsigned char noteeffnum;   /* major effect number for note */
};

    /* Note data structure in the mod file. */
struct filnotrec {
    unsigned filnotperiodhi:4;  /* high nibble of the period number */
    unsigned filnotsampnumhi:4; /* high nibble of the sample number */
    unsigned filnotperiodlo:8;  /* low byte of period number */
    unsigned filnoteffnum:4;    /* major effect number for note */
    unsigned filnotsampnumlo:4; /* low nibble of the sample number */
    unsigned filnoteffparm:8;   /* parameter for note effect */
};

    /* 2k buffer segment data structure.  This data is kept on each buffer 
       segment so that it can be displayed to the user when the segment is 
       played. */
struct bufsegrec {
    unsigned bufsegentry;       /* pattern table entry */
    unsigned bufsegpatnum;      /* pattern number */
    unsigned char bufsegrow;    /* row number in pattern */
    unsigned char bufsegbpm;    /* beats per minute */
    unsigned bufsegticksper;    /* ticks per division */
    signed char bufseggvol;     /* global volume */
    char pad;                   /* (pad to an even number of bytes) */
};


/*************************************************************************/
/*                                                                       */
/* Global variables.                                                     */
/*                                                                       */
/*************************************************************************/

extern unsigned c4spds[];            /* playback rates at C4 for finetunes */
extern struct samprec samplerecs[];  /* array of sample data structures */
extern unsigned ninstruments;        /* number of samples in the file */
extern struct chanrec channelrecs[]; /* array of channel data structures */
extern unsigned patterntable[];      /* pattern table */
extern unsigned pattablesize;        /* number of entries in the pattern */
                                     /*   table                          */
extern unsigned nfilepatterns;       /* number of patterns in the file */
extern unsigned patternsegs[];       /* table of segment addresses of */
                                     /*   pattern buffers             */
extern unsigned patbufsize;          /* size of a pattern buffer in */
                                     /*   paragraphs                */
extern char visiteds[];              /* table of visited flags for pattern */
                                     /*   table entries                    */
extern unsigned currentpat;          /* current entry in the pattern table */
extern unsigned nextpat;             /* next entry in the pattern table */
                                     /*   (entry to play at after this  */
                                     /*   division)                     */
extern unsigned songendjump;         /* song end jump position */
extern char loopdisable;             /* loop disable flag */
extern unsigned currentpatseg;       /* segment address of current pattern */
                                     /*   buffer                           */
extern unsigned partmixseg;          /* segment address of the partial-mix */
                                     /*   buffer                           */
extern unsigned inpartmix;           /* number of samples in the partial-mix */
                                     /*   buffer                             */
extern unsigned samplespertick;      /* number of output samples per tick */
extern unsigned char setspeedparm;   /* set speed parameter */
extern unsigned char beatspermin;    /* number of beats per minute */
extern unsigned char bpmdefl;        /* default for number of beats per */
                                     /*   minute                        */
extern unsigned ticksperrow;         /* number of ticks per division */
extern unsigned ticksdefl;           /* default for number of ticks per */
                                     /*   division                      */
extern unsigned ticksleft;           /* ticks remaining in this division, */
                                     /*   plus one                        */
extern unsigned char patdelayparm;   /* pattern delay parameter */
extern unsigned char currentrow;     /* current row in the pattern */
extern unsigned char nextrow;        /* next row in the pattern (row to play */
                                     /*   at after this division)            */
extern unsigned char patloopstart;   /* pattern loop start */
extern unsigned char patloopcount;   /* pattern loop count */
extern unsigned nchannels;           /* number of channels */
extern unsigned char bytesperrow;    /* bytes per row in the pattern table */
extern struct bufsegrec bufsegrecs[]; /* array of 2k buffer segment data */
                                      /* records                         */
extern signed char globalvol;         /* global volume, 0-64 */
extern signed char globalvoldefl;     /* default for global volume */
extern char savemem;                  /* "save memory" flag */
extern char optimize;                 /* "optimize loading" flag */


/*************************************************************************/
/*                                                                       */
/* Function prototypes.                                                  */
/*                                                                       */
/*************************************************************************/

    /* initialization routine for the player module */
extern int initmodstuf( void );
    /* routine to convert a byte to 2 hex digits */
extern void pascal byte2hex( char *retstr, unsigned char byteval );
    /* routine to convert sample number to ASCII */
extern void pascal sampstring( char *retstr, unsigned char sampnum );
    /* routine to convert effect and parameter to ASCII */
extern void pascal effstring( char *retstr, unsigned char effnum,
        unsigned char effparm );
    /* routine to convert period to ASCII note */
extern void pascal periodstring( char *retstr, unsigned period );
    /* routine to convert volume to ASCII */
extern void pascal volumestring( char *retstr, signed char vol );
    /* routine to convert note records to internal format */
extern void pascal fil2memnotes( struct noterec far *memnote,
        struct filnotrec *filnote, unsigned numnotes );
    /* routine to convert .s3m note to period */
extern unsigned pascal note2period( int note );
    /* routine to set the number of beats per minute */
extern void pascal setbeats( unsigned char bpm );
    /* routine to get 2k worth of samples */
extern int getsamples( unsigned segnum, int first, ... );
    /* routine to dump information about the music module */
extern int dumpmod( char *outpath, char **errmsg );
    /* routine to dump a sample to a file */
extern int dumpsample( unsigned sampnum, char *modname, char **errmsg );
    /* routine to unload the currently-loaded file */
extern void unloadfile( void );
    /* main file loader routine */
extern int loadfile( char *filename, char **errmsg );

#endif
