; TPLCMD.ASM
;
; This is a program to set or clear bits in the planar control register, 
; using device driver Tpldev.bin.  There are three ways to invoke this
; program:
;
;    TPLCMD
;    TPLCMD -f+s
;    TPLCMD w11101111b
;
; When invoked without options, the program simply displays the current
; contents of the register.  When invoked with any combination of the
; following options, Tplcmd sets or clears individual bits as follows:
;
;     +H or +h     Enable hard disk controller
;     -H or -h     Disable hard disk controller
;     +P or +p     Enable parallel port
;     -P or -p     Disable parallel port
;     +V or +v     Enable video controller
;     -V or -v     Disable video controller
;     +F or +f     Enable floppy controller
;     -F or -f     Disable floppy controller
;     +S or +s     Enable serial port
;     -S or -s     Disable serial port
;
; Finally, when invoked with a single string of the form
;
;     w [eight binary bits] b        (or)
;     W [eight binary bits] B
;
; this program sets all bits in the planar control register as specified.
;
		JMP	START

;*********************** DATA
;
; Device name and handle for TPLDEV device.
;
DEVICENAME	DB	"TPLANAR$",0
HANDLE		DW	0
;
; Pointers to the command tail in the PSP.
;
PCMDLEN		EQU	80h
CMDLEN		DW	0
CMDTAIL		EQU	81h
;
; String for bitwise modifications.
;
SETBITSTR	DB	'C'
SETBITNO	DB	'2'
SETBITVAL	DB	'1'
		DB	'Z'
;
; Flag, indicates whether a modification has been made.
;
WRITEDONE	DB	0
;
; String to set entire register, and character count so far.
;
SETREGSTR	DB	"W11111111B",0
;
; "String" to clear read pointer.
;
CLEARPTRSTR	DB	'X'
;
; Messages.
;
STARTMSG        DB      "Planar control register control for the "
		DB      "Tandy 1000 series -",0Dh,0Ah,"$"
NODRIVERMSG	DB	"TPLDEV.BIN not loaded, no change made.",0Dh,0Ah,"$"
WRITEERRMSG	DB	"Error writing to device TPLDEV.BIN.",0Dh,0Ah,"$"
SYNTAXMSG	DB	"Syntax:",0Dh,0Ah
		DB	"  TPLCMD (options)",0Dh,0Ah,0Dh,0Ah
		DB	"where (options) are:",0Dh,0Ah
		DB	"  -h or +h  Disable/enable hard drive controller"
		DB	0Dh,0Ah
		DB	"  -p or +p  Disable/enable parallel port",0Dh,0Ah
		DB	"  -v or +v  Disable/enable video controller",0Dh,0Ah
		DB	"  -f or +f  Disable/enable floppy controller",0Dh,0Ah
		DB	"  -s or +s  Disable/enable serial port",0Dh,0Ah,"$"
NEWVALMSG	DB	"11111111B.",0Dh,0Ah,"$"
READERRMSG	DB	"Error reading from device TPLDEV.BIN.",0Dh,0Ah,"$"
NOCHANGEMSG	DB	"No change made, register value is $"
CHANGEMSG	DB	"Register set to $"

;***************************** CODE
;
; Main program.  Display opening message.
;
START:		MOV     AH,9
		MOV     DX,OFFSET STARTMSG
		INT     21h
		;
		; Open Tpldev device read/write.
		;
		MOV	AX,3D02h
		MOV	DX,OFFSET DEVICENAME
		INT	21h
		JNC	>L00
		MOV     AH,9
		MOV     DX,OFFSET NODRIVERMSG
		INT     21h
		MOV	AX,4C02h	; return code 2 = driver not loaded
		INT	21h
L00:		MOV	HANDLE,AX
		;
		; Set the device to raw mode.
		;
		MOV	AX,4401h
		MOV	BX,HANDLE
		MOV	DX,0A0h
		INT	21h
		;
		; Convert the command tail to uppercase.
		;
		MOV	CL,[PCMDLEN]
		XOR	CH,CH
		MOV	CMDLEN,CX
		MOV	DI,CMDTAIL
		CLD
		OR	CX,CX
		JNZ	>L01
		JMP	NOCHANGE
L01:		MOV	AL,ES:[DI]
		CMP	AL,'a'
		JB	>L02
		CMP	AL,'z'
		JA	>L02
		SUB	AL,'a'-'A'
L02:		STOSB
		LOOP	L01
		;
		; Process command line - first check for WxxxxxxxxB.
		;
		MOV	CX,CMDLEN
		MOV	DI,CMDTAIL
		MOV	AL,'W'
		REPNE	SCASB
		JNE	PLUSMINUS
		MOV	SI,DI		; DS:SI -> first digit past "W"
		MOV	DI,OFFSET SETREGSTR
		STOSB			; save "W" in string
		MOV	CX,8
L03:		LODSB			; save 8 binary digits
		CMP	AL,'0'
		JAE	>L04
		JMP	BADSYNTAX
L04:		CMP	AL,'1'
		JBE	>L05
		JMP	BADSYNTAX
L05:		STOSB
		LOOP	L03
		LODSB
		CMP	AL,'B'		; don't need to store the "B", already
		JE	>L06		;   have it
		JMP	BADSYNTAX
L06:		MOV	AH,40h		; write string to device to set
		MOV	BX,HANDLE	;   register
		MOV	CX,10
		MOV	DX,OFFSET SETREGSTR
		INT	21h
		JC	WRITEFAIL
		CMP	AX,CX
		JNE	WRITEFAIL
		JMP	EXITSUCCESS
		;
		; Check for second format command line.
		;
PLUSMINUS:	MOV	CX,CMDLEN
		MOV	SI,CMDTAIL
L07:		CALL    FINDSWITCH
		CMP     AL,0Dh
		JE      >L08
		CALL    DOSWITCH
		CMP	AL,1
		JB	L07
		JA	WRITEFAIL
		JMP	BADSYNTAX
L08:		CMP	WRITEDONE,1
		JNE	NOCHANGE
		JMP	EXITSUCCESS
		;
		; Error writing to device.
		;
WRITEFAIL:	MOV	AH,9
		MOV	DX,OFFSET WRITEERRMSG
		INT	21h
		MOV	AX,4C03h	; return code 3 = write error
		INT	21h
		;
		; Incorrect command line syntax.
		;
BADSYNTAX:	MOV	AH,9
		MOV	DX,OFFSET SYNTAXMSG
		INT	21h
		MOV	AX,4C01h	; return code 1 = bad command line
		INT	21h
		;
		; Nothing changed (no switches on command line).
		;
NOCHANGE:	CALL	GETREGISTER
		JC	READFAIL
		MOV	AH,9
		MOV	DX,OFFSET NOCHANGEMSG
		INT	21h
		MOV	AH,9
		MOV	DX,OFFSET NEWVALMSG
		INT	21h
		MOV	AX,4C00h
		INT	21h
		;
		; Exit with success code.
		;
EXITSUCCESS:	CALL	GETREGISTER
		JC	READFAIL
		MOV	AH,9
		MOV	DX,OFFSET CHANGEMSG
		INT	21h
		MOV	AH,9
		MOV	DX,OFFSET NEWVALMSG
		INT	21h
		MOV	AX,4C00h	; return code 0 = success
		INT	21h
		;
		; Error reading from device.
		;
READFAIL:	MOV	AH,9
		MOV	DX,OFFSET READERRMSG
		INT	21h
		MOV	AX,4C04h
		INT	21h
;
; Routine to find the next switch on the command line.  Switches begin with
; "-" or "+".  On entry, DS:SI -> command line (or what's left of it), DF
; clear.  Returns:  AL = "+" or "-" (or 0Dh at end of line), DS:SI ->
; character following switch in AL.  Command line should end with CR or LF.
;
FINDSWITCH:     LODSB
		CMP     AL,'+'
		JE      >L0
		CMP     AL,'-'
		JE      >L0
		CMP     AL,0Dh
		JE      >L0
		CMP     AL,0Ah
		JNE     FINDSWITCH
		MOV     AL,0Dh
L0:             RET
;
; Process a command-line switch, for the case where this driver is already 
; installed.  AL = "+" or "-", DS:SI -> following character, DF clear.
; Returns AL = 0 if OK, 1 if bad syntax, 2 if write failed.  Destroys AH.
;
DOSWITCH:	PUSH    BX              ; save BX, CX, DX, DS
		PUSH	CX
		PUSH    DX
		PUSH    DS
		MOV     AH,AL           ; AH = "+" or "-"
		MOV     AL,[SI]         ; AL = character following "+" or "-"
		MOV     DL,'0'          ; char "H" => DL = '0'
		CMP     AL,'H'
		JE      >L0
		INC     DL              ; char "P" => DL = '1'
		CMP     AL,'P'
		JE      >L0
		INC     DL              ; char "V" => DL = '2'
		CMP     AL,'V'
		JE      >L0
		INC     DL              ; char "F" => DL = '3'
		CMP     AL,'F'
		JE      >L0
		INC     DL              ; char "S" => DL = '4'
		CMP     AL,'S'
		JNE     DOSWITCH_SYNTAX	; otherwise, invalid
L0:             MOV     AL,'0'          ; if "-", AL = "0"
		CMP     AH,'+'          ; if "+", AL = "1"
		JNE     >L1
		MOV     AL,'1'
L1:             MOV     AH,DL           ; AH = bit to change in ASCII
		MOV     DX,CS           ; AL = value in ASCII
		MOV     DS,DX           ; DS = ES = CS
		MOV     SETBITNO,AH	; set string for write request
		MOV     SETBITVAL,AL
L2:		MOV	AH,40h		; write string to device to set
		MOV	BX,HANDLE	;   register
		MOV	CX,4
		MOV	DX,OFFSET SETBITSTR
		INT	21h
		JC	DOSWITCH_WRITEFAIL
		CMP	CX,AX
		JNE	DOSWITCH_WRITEFAIL
		CMP     SETBITNO,'1'	; if parallel port, perform second
		JNE     >L3		;   call to set bit 7
		MOV     SETBITNO,'7'
		JMP     L2
L3:		XOR	AL,AL
		MOV	WRITEDONE,1
		JMP	DOSWITCH_DONE
DOSWITCH_SYNTAX:
		MOV	AL,1
		JMP	DOSWITCH_DONE
DOSWITCH_WRITEFAIL:
		MOV	AL,2
DOSWITCH_DONE:	POP     DS              ; restore DS, DX, CX, BX
		POP     DX
		POP	CX
		POP     BX
		RET
;
; Read back the current value of the register from the driver.  Returns
; CF set if error.
;
GETREGISTER:	PUSH	AX		; save AX, BX, CX, DX
		PUSH	BX
		PUSH	CX
		PUSH	DX
		MOV	AH,40h		; write string to device to clear
		MOV	BX,HANDLE	;   read count
		MOV	CX,1
		MOV	DX,OFFSET CLEARPTRSTR
		INT	21h
		JC	GETREGISTER_ERROR
		CMP	CX,AX
		JNE	GETREGISTER_ERROR
		MOV	AH,3Fh		; read string from device
		MOV	CX,9
		MOV	DX,OFFSET NEWVALMSG
		INT	21h
		JC	GETREGISTER_ERROR
		CMP	CX,AX
		JNE	GETREGISTER_ERROR
		CLC
		JMP	GETREGISTER_DONE
GETREGISTER_ERROR:
		STC
GETREGISTER_DONE:
		POP	DX		; restore DX, CX, BX, AX
		POP	CX
		POP	BX
		POP	AX
		RET
