; TPLDEV.ASM
;
; This is a device driver to add control for the planar control register 
; at I/O port 65h.  Bits of this register control hardware components of 
; the Tandy 1000-series as follows:
;
;    Bit         Description
;     0        1 = Enable hard disk controller
;     1        1 = Enable parallel port select
;     2        1 = Enable video controller
;     3        1 = Enable floppy controller
;     4        1 = Enable serial port select
;     5        (nothing)
;     6        (nothing)
;     7        1 = Enable parallel port output
;
; This register is present on the SL and later models, not including the
; RSX.  Command-line options for this driver are as follows:
;
;     +H or +h     Enable hard disk controller
;     -H or -h     Disable hard disk controller
;     +P or +p     Enable parallel port
;     -P or -p     Disable parallel port
;     +V or +v     Enable video controller
;     -V or -v     Disable video controller
;     +F or +f     Enable floppy controller
;     -F or -f     Disable floppy controller
;     +S or +s     Enable serial port
;     -S or -s     Disable serial port
;
; If there are slashes or other invalid characters on the command line, 
; they are ignored.  If conflicting options are specified, the last option 
; governs.  Options may be specified in any order and may or may not be 
; separated by whitespace, but "+" or "-" must not be separated from the 
; character identifying the device being enabled or disabled.
;
; This driver can appear more than once in CONFIG.SYS, but will only be
; loaded once.  Second and subsequent invocations process command-line
; options only.
		ORG 0

;********************** RESIDENT DATA
;
; Device header.
;  
		DD      -1              ; link to next driver in chain
DEVICEATTRIB    DW      8000h           ; device attribute
		;
		; Pointers to strategy and interrupt routines.
		;
		DW      OFFSET STRATEGY 
		DW      OFFSET INTERRUPT
		DB      "TPLANAR$"      ; device name
;
; Doubleword pointer to request header (stored by strategy routine, used by
; interrupt routine).
;
		EVEN
REQUESTPTR      LABEL   DWORD
REQUESTOFFS     DW      0
REQUESTSEG      DW      0
;
; Generic request structure, for INTERRUPT and other routines.
;
GENREQ          STRUC   [BX]
REQLEN          DB      ?
		DB      ?
COMMANDCODE     DB      ?
REQSTATUS       DW      ?
		ENDS
;
; Request structure for READ and WRITE routines.
;
READREQ         STRUC   [BX]
REQLEN          DB      ?
		DB      ?
COMMANDCODE     DB      ?
REQSTATUS       DW      ?
		DB      9 DUP (?)
DATAPTR         DD      ?
NUMBYTES        DW      ?
		ENDS
;
; Request structure for NONDEST routine.
;
NONDESTREQ      STRUC   [BX]
REQLEN          DB      ?
		DB      ?
COMMANDCODE     DB      ?
REQSTATUS       DW      ?
		DB      8 DUP (?)
NONDESTCHAR     DB      ?
		ENDS
;
; Jump table for INTERRUPT routine.
;
		EVEN
INTERJUMPS      EQU     $
		DW      OFFSET INIT             ; Init
		DW      OFFSET NULLFUNC         ; Media Check
		DW      OFFSET NULLFUNC         ; Build BPB
		DW      OFFSET UNSUPP           ; IOCTL Read
		DW      OFFSET READ             ; Read
		DW      OFFSET NONDEST          ; Nondestructive Read
		DW      OFFSET NULLFUNC         ; Input Status
		DW      OFFSET WRITE            ; Flush Input Buffers
		DW      OFFSET WRITE            ; Write
		DW      OFFSET WRITE            ; Write with Verify
		DW      OFFSET NULLFUNC         ; Output Status
		DW      OFFSET NULLFUNC         ; Flush Output Buffers
		DW      OFFSET UNSUPP           ; IOCTL Write
;
; Data:  pointer for Read function.  This pointer indexes the next byte 
; in the ASCIIBITS array to be returned by the Read function.
;
READCOUNT       DW      0
		;
		; Pointer for Write function.  If WRITESTAT = "W" below,
		; this pointer indexes the next byte in the ASCIIBITS 
		; array to be modified by the Write function, or 8 if all
		; bits have been written and we are awaiting "B".  If 
		; WRITESTAT = "C", then:
		;
		;       0       "C" entered, awaiting bit to change
		;       1       bit to change entered, awaiting value
		;       2       data ready, awaiting "Z"
		;
WRITECOUNT      DW      0
		;
		; Bit to be changed, when WRITESTAT = "C" (see Write
		; function.)
		;
CHANGEBIT       DW      0
		;
		; Current Write status.  "W" = writing all 8 bits; "C" =
		; changing single bit; "U" = undefined (not writing).
		;
WRITESTAT       DB      'U'
		;
		; ASCII version of the planar control register at 65h, saved
		; this way for I/O purposes.
		;
ASCIIBITS       EQU     $
HDBIT           DB      '1'     ; hard disk select enable
LPTSBIT         DB      '1'     ; parallel port select enable
VIDBIT          DB      '1'     ; video port select enable
FDBIT           DB      '1'     ; floppy disk port select enable
COMBIT          DB      '1'     ; serial port select enable
RES1BIT         DB      '1'     ; reserved
RES2BIT         DB      '1'     ; reserved
LPTOBIT         DB      '1'     ; parallel port output enable
		DB      'B'
		DB      1Ah     ; control-Z
MAXBYTES        EQU     $-ASCIIBITS
		;
		; Temporary copy of ASCIIBITS array above, for writes.
		;
TEMPBITS        EQU     $
THDBIT          DB      '1'     ; hard disk select enable
TLPTSBIT        DB      '1'     ; parallel port select enable
TVIDBIT         DB      '1'     ; video port select enable
TFDBIT          DB      '1'     ; floppy disk port select enable
TCOMBIT         DB      '1'     ; serial port select enable
TRES1BIT        DB      '1'     ; reserved
TRES2BIT        DB      '1'     ; reserved
TLPTOBIT        DB      '1'     ; parallel port output enable
		DB      'B'
		DB      1Ah     ; control-Z
		;
		; Previous Int 2Fh vector, for chaining.
		;
		EVEN
INT2FVEC        LABEL   DWORD
INT2FOFFS       DW      0
INT2FSEG        DW      0

;***************************** RESIDENT DEVICE DRIVER CODE
;
; Strategy routine:  stores address of request header.
;
STRATEGY:       MOV     CS:REQUESTOFFS,BX
		MOV     CS:REQUESTSEG,ES
		RETF    
;
; Interrupt routine:  processes request.
;
; Save registers and flags on stack.
;
INTERRUPT:      PUSHF
		PUSH    AX
		PUSH    BX
		PUSH    CX
		PUSH    DX
		PUSH    SI
		PUSH    DI
		PUSH    BP
		PUSH    DS
		PUSH    ES
		;
		; Get function code and check if valid.
		;
		LDS     BX,CS:REQUESTPTR
		MOV     REQSTATUS,0             ; success by default
		MOV     BL,COMMANDCODE
		CMP     BL,12
		JNA     >L0
		CALL    UNSUPP
		JMP     >L1
		;
		; Function code valid, call function.
		;
L0:             XOR     BH,BH
		SHL     BX,1
		CALL    CS:[BX+INTERJUMPS]
		;
		; Set done bit.
		;
L1:             LDS     BX,CS:REQUESTPTR
		OR      REQSTATUS,100h
		;
		; Pop registers and flags and return.
		;
		POP     ES
		POP     DS
		POP     BP
		POP     DI
		POP     SI
		POP     DX
		POP     CX
		POP     BX
		POP     AX
		POPF
		RETF    
;
; Null function, does nothing.
;
NULLFUNC:       RET
;
; Unsupported function, sets error.
;
UNSUPP:         LDS     BX,CS:REQUESTPTR
		MOV     REQSTATUS,8003h
		RET             
;
; Read function routine.  This routine will return a maximum of 10 bytes
; per call.  A call to the Write function (below) resets the read pointer; 
; the read pointer will also be reset after the 10th byte is read.  The 
; following data is returned by successive 1-byte calls:
;
;     call        data returned
;       1       bit 0 stored at port 65h as ASCII, i.e., "0" or "1"
;       2       bit 1 stored at port 65h as ASCII, i.e., "0" or "1"
;       3       bit 2 stored at port 65h as ASCII, i.e., "0" or "1"
;       4       bit 3 stored at port 65h as ASCII, i.e., "0" or "1"
;       5       bit 4 stored at port 65h as ASCII, i.e., "0" or "1"
;       6       bit 5 stored at port 65h as ASCII, i.e., "0" or "1"
;       7       bit 6 stored at port 65h as ASCII, i.e., "0" or "1"
;       8       bit 7 stored at port 65h as ASCII, i.e., "0" or "1"
;       9       letter "B"
;      10       control-Z (EOF char, ASCII code 1Ah)
;
; Note that this function does not wrap; i.e., the most that can be
; returned in a single call is 10 bytes.
;
READ:           LDS     BX,CS:REQUESTPTR        ; DS:BX -> request header
		MOV     CX,NUMBYTES             ; CX = bytes requested
		CMP     CX,MAXBYTES             ; can't get more than 10
		JBE     >L0
		MOV     CX,MAXBYTES
L0:             MOV     SI,CS:READCOUNT         ; get read pointer
		SUB     CX,SI                   ; reduce count by bytes read
		MOV     NUMBYTES,CX             ; return bytes read this time
		ADD     SI,ASCIIBITS            ; SI -> next byte to read
		LES     DI,DATAPTR              ; ES:DI -> caller's buffer
		MOV     AX,CS                   ; DS:SI -> data to read
		MOV     DS,AX
		OR      CX,CX                   ; if count = 0, nothing to do
		JZ      >L1
		CLD                             ; copy data to caller's buffer
		REP     MOVSB
L1:             SUB     SI,ASCIIBITS            ; recover read pointer
		CMP     SI,MAXBYTES             ; wrap pointer to 0 if needed
		JBE     >L2
		XOR     SI,SI
L2:             MOV     READCOUNT,SI            ; save read pointer
		MOV     WRITESTAT,'U'           ; read resets write status
		RET             
;
; Nondestructive read.  Returns next character to read, does not update
; pointers or change write status.  See above for data returned.
;
NONDEST:        LDS     BX,CS:REQUESTPTR        ; DS:BX -> request header
		MOV     SI,CS:READCOUNT         ; get next byte
		MOV     AL,CS:[SI+ASCIIBITS]
		MOV     NONDESTCHAR,AL          ; return it
		RET
;
; Flush input buffers, write, or write with verify.  Resets the read pointer.
; To update the planar control register, write the following sequence:
;
;     call        data written
;       1       letter "W"
;       2       bit 0 to be stored at port 65h as ASCII, i.e., "0" or "1"
;       3       bit 1 to be stored at port 65h as ASCII, i.e., "0" or "1"
;       4       bit 2 to be stored at port 65h as ASCII, i.e., "0" or "1"
;       5       bit 3 to be stored at port 65h as ASCII, i.e., "0" or "1"
;       6       bit 4 to be stored at port 65h as ASCII, i.e., "0" or "1"
;       7       bit 5 to be stored at port 65h as ASCII, i.e., "0" or "1"
;       8       bit 6 to be stored at port 65h as ASCII, i.e., "0" or "1"
;       9       bit 7 to be stored at port 65h as ASCII, i.e., "0" or "1"
;      10       letter "B"
;
; Alternately, to change one bit, write the following sequence:
;
;     call        data written
;       1       letter "C"
;       2       number of bit to be stored as ASCII, "0" to "7"
;       3       value of bit to be stored as ASCII, i.e., "0" or "1"
;       4       letter "Z"
;
; Any other value (or bytes written out of sequence) will simply reset 
; the read pointer.  Note that, unlike the Read function, any number of
; bytes can be processed in a single Write, since input is treated as a
; stream.
;
WRITE:          LDS     BX,CS:REQUESTPTR        ; DS:BX -> request header
		CMP     COMMANDCODE,7           ; Flush Input Buffers?
		JNE     >L0
		MOV     CS:WRITESTAT,'U'        ; if so, reset write status
		JMP     >L2
L0:             MOV     CX,NUMBYTES             ; CX = bytes to write
		LDS     SI,DATAPTR              ; DS:SI -> caller's data
		OR      CX,CX                   ; if count = 0, nothing to do
		JZ      >L2
		CLD
L1:             LODSB                           ; AL = byte to write
		CALL    WRITEBYTE               ; process it
		LOOP    L1                      ; (repeat until done)
L2:             MOV     CS:READCOUNT,0          ; reset read pointer
		RET
;
; Interrupt 2Fh handler, for installation check; also a "backdoor" to the
; driver from a subsequent invocation in CONFIG.SYS.  On entry:
;
;    AX = 0FDDBh
;    DX = 0BDDFh
;    ES:BX -> MS-DOS device header
;      or ES = 0 for installation check only
;
; Returns:
;
;    AX = 4321h
;
; See the MS-DOS Encyclopedia, Section II, Article 15 for device header
; format.  On return, the caller's device header is modified as if the
; call came from DOS (provided ES <> 0 on entry).
;
INT2FHDLR:      PUSHF                   ; save caller's flags
		CMP     AX,0FDDBh       ; magic number: AX=FDDBh, DX=BDDFh
		JNE     >L0
		CMP     DX,0BDDFh
		JE      >L1
L0:             POPF                    ; not our interrupt:  restore flags,
		JMP     DWORD PTR CS:INT2FVEC   ;   chain to previous handler
L1:             POPF                    ; it's ours, remove flags from stack
		MOV     AX,ES           ; if ES = 0, installation check only
		OR      AX,AX
		JZ      >L2             ; if ES <> 0, perform driver request
		MOV     CS:REQUESTSEG,AX ;  save request header address
		MOV     CS:REQUESTOFFS,BX
		PUSH    CS
		CALL    INTERRUPT
L2:             MOV     AX,4321h
		IRET

;********************* SUBROUTINES
;
; GENERAL NOTE:  Subroutines should make no assumptions about registers such
; as DS and BP.  They should not modify any word register not used to return
; values.  (They can modify flags, however.)
;
; Routine to process a byte written to the device.  See coding under Write
; function, above.  AL = byte to process, DF = clear.
;
WRITEBYTE:      PUSH    DX              ; save DX, DS
		PUSH    DS
		MOV     DX,CS           ; DS = CS
		MOV     DS,DX
		CMP     AL,'W'          ; if byte is "W" or "C" then
		JE      >L0
		CMP     AL,'C'
		JNE     >L1
L0:             CALL    INITWRITE       ; ... start a new write sequence
		JMP     >L3
L1:             CMP     WRITESTAT,'U'   ; otherwise, if not in a write
		JE      >L3             ;   sequence, just ignore the data
		CMP     WRITESTAT,'W'   ; call handler based on sequence
		JNE     >L2             ;   type, "W" or "C"
		CALL    WRITEBYTEW
		JMP     >L3
L2:             CALL    WRITEBYTEC
L3:             POP     DS              ; done - restore DS, DX
		POP     DX
		RET
;
; Routine to (re)initialize the TEMPBITS array when starting a new write
; sequence.  Also sets WRITECOUNT and WRITESTAT.  AL = "C" or "W", DS = CS,
; DF = clear.
;
INITWRITE:      PUSH    AX              ; save AX, CX, SI, DI, ES
		PUSH    CX
		PUSH    SI
		PUSH    DI
		PUSH    ES
		MOV     WRITECOUNT,0    ; WRITECOUNT = CHANGEBIT = 0
		MOV     CHANGEBIT,0
		MOV     WRITESTAT,AL    ; save new write status
		MOV     SI,ASCIIBITS    ; copy ASCIIBITS array to TEMPBITS
		MOV     AX,CS
		MOV     ES,AX
		MOV     DI,TEMPBITS
		MOV     CX,MAXBYTES
		REP     MOVSB
		POP     ES              ; restore ES, DI, SI, CX, AX
		POP     DI
		POP     SI
		POP     CX
		POP     AX
		RET
;
; Routine to process a byte written to the device, when WRITESTAT = "W".
; See coding under Write function, above.  AL = byte to process, DS = CS,
; DF = clear.
;
WRITEBYTEW:     PUSH    BX              ; save BX
		CMP     AL,'B'          ; if byte is "B"
		JNE     >L0
		CMP     WRITECOUNT,8    ;   invalid if count is not 8
		JNE     >L1
		CALL    UPDATEREG       ;   otherwise, sequence finished,
		JMP     >L1             ;     do the update
L0:             CMP     WRITECOUNT,7    ; if byte is not "B"
		JA      >L1             ;   invalid if count is 8
		CMP     AL,'0'          ;   invalid if byte is not "0" or "1"
		JB      >L1
		CMP     AL,'1'
		JA      >L1
		MOV     BX,WRITECOUNT   ;   save byte
		MOV     [BX+TEMPBITS],AL
		INC     WRITECOUNT      ;   increment count
		JMP     >L2
L1:             MOV     WRITESTAT,'U'   ; invalid or finished, reset status
L2:             POP     BX              ; restore BX
		RET
;
; Routine to process a byte written to the device, when WRITESTAT = "C".
; See coding under Write function, above.  AL = byte to process, DS = CS,
; DF = clear.
;
WRITEBYTEC:     PUSH    AX              ; save AX, BX
		PUSH    BX
		CMP     AL,'Z'          ; if byte is "Z"
		JNE     >L0
		CMP     WRITECOUNT,2    ;   invalid if count is not 2
		JNE     >L2
		CALL    UPDATEREG       ;   otherwise, sequence finished,
		JMP     >L2             ;     do the update
L0:             CMP     WRITECOUNT,0    ; if byte is not "Z"
		JNE     >L1             ;   if count is 0
		SUB     AL,'0'          ;     convert byte to binary word
		JB      >L2             ;       (invalid if not 0 to 7)
		SUB     AL,7
		JA      >L2
		NEG	AL
		CBW
		MOV     CHANGEBIT,AX    ;     save bit to be changed
		INC     WRITECOUNT      ;     increment count
		JMP     >L3
L1:             CMP     WRITECOUNT,1    ;   else if count is 1 (invalid if 2)
		JNE     >L2
		CMP     AL,'0'          ;     invalid if byte is not "0" or "1"
		JB      >L2
		CMP     AL,'1'
		JA      >L2
		MOV     BX,CHANGEBIT    ;     save value for changed bit
		MOV     [BX+TEMPBITS],AL
		INC     WRITECOUNT      ;     increment count
		JMP     >L3
L2:             MOV     WRITESTAT,'U'   ; invalid or finished, reset status
L3:             POP     BX              ; restore BX, AX
		POP     AX
		RET
;
; Routine to update the planar control register at the end of a valid
; write sequence.  DS = CS, DF = clear.
;
UPDATEREG:      PUSH    AX              ; save AX, CX, SI, DI, ES
		PUSH    CX
		PUSH    SI
		PUSH    DI
		PUSH    ES
		MOV     AX,DS           ; ES = DS = CS
		MOV     ES,AX
		MOV     CX,MAXBYTES     ; copy TEMPBITS to ASCIIBITS
		MOV     SI,TEMPBITS
		MOV     DI,ASCIIBITS
		REP     MOVSB
		MOV     CX,8            ; convert ASCIIBITS to binary byte
		MOV     SI,ASCIIBITS
		XOR     AH,AH
L0:		SHL	AH,1
		LODSB
		SUB     AL,'0'
		OR      AH,AL
		LOOP    L0
		MOV     AL,AH           ; set register
		OUT     65h,AL
		JMP	$+2
		POP     ES              ; restore ES, DI, SI, CX, AX
		POP     DI
		POP     SI
		POP     CX
		POP     AX
		RET

;********************** TRANSIENT INSTALLATION DATA
;
; End of resident code.
;
END_RESIDENT    EQU     $
		;
		; Message displayed at start up.
		;
STARTMSG        DB      "Planar control register control for the "
		DB      "Tandy 1000 series",0Dh,0Ah,"$"
NOTINSTMSG      DB      "Device driver installed, $"
INSTMSG         DB      "Driver already resident, $"
DATADISP        DB      "register set to "
DATASTR         DB      "00000000B"
		DB      0Dh,0Ah,0Dh,0Ah,"$"
;
; Request structure for INIT routine.
;
INITREQ         STRUC   [BX]
REQLEN          DB      ?
		DB      ?
COMMANDCODE     DB      ?
REQSTATUS       DW      ?
		DB      8 DUP (?)
NUMUNITS        DB      ?
FREEMEMOFFS     DW      ?
FREEMEMSEG      DW      ?
CONFIGPTR       DD      ?
		DB      5 DUP (?)
		ENDS
		;
		; Request headers, to call previous installation of the
		; device driver.
		;
WRITECMD        DB      TYPE READREQ DUP (?)
READCMD         DB      TYPE READREQ DUP (?)
		;
		; String for Write request to installed driver.
		;
WRITESTR        DB      'C'
WRITEBITNO      DB      '0'
WRITEBITVAL     DB      '1'
		DB      'Z'

;*********************** TRANSIENT INSTALLATION CODE            
;
; Init routine.
;
INIT:           MOV     AX,CS           ; DS = CS
		MOV     DS,AX
		MOV     AH,9            ; display driver message
		MOV     DX,OFFSET STARTMSG
		INT     21h
		XOR     AX,AX           ; check if driver already installed
		MOV     ES,AX
		MOV     AX,0FDDBh
		MOV     DX,0BDDFh
		INT     2Fh
		CMP     AX,4321h
		JNE     >L0
		MOV     AH,9            ; display message "already installed"
		MOV     DX,OFFSET INSTMSG
		INT     21h
		CALL    INITINSTALLED   ; if already installed, process command
		CALL    GETREGISTER     ;   line, then get resulting register
		JMP     >L1             ;   value
L0:             MOV     AH,9            ; display message "driver installed"
		MOV     DX,OFFSET NOTINSTMSG
		INT     21h
		CALL    INITNOTINSTALLED ; install if not already done
L1:             MOV     AX,CS           ; display register value set
		MOV     ES,AX
		MOV     SI,ASCIIBITS
		MOV     DI,OFFSET DATASTR
		MOV     CX,9
		CLD
		REP     MOVSB
		MOV     AH,9
		MOV     DX,OFFSET DATADISP
		INT     21h
		RET
;
; Init routine, for the case where the driver is not already installed.
; DS = CS on entry.
;
INITNOTINSTALLED:
		PUSH    AX              ; save AX, BX, CX, DX, SI, DI, DS, ES
		PUSH    BX
		PUSH    CX
		PUSH    DX
		PUSH    SI
		PUSH    DI
		PUSH    DS
		PUSH    ES
		LES     BX,REQUESTPTR   ; ES:BX -> request header
		LDS     SI,ES:CONFIGPTR ; DS:SI -> DEVICE= line in CONFIG.SYS
		CLD                     ; while not end of line:
L0:             CALL    FINDSWITCH      ;   find next switch
		CMP     AL,0Dh          ;   (AL = 0Dh at end of line)
		JE      >L1
		CALL    SWITCHNONINST   ;   process switch
		JMP     L0
L1:             MOV     AX,CS           ; DS = CS again
		MOV     DS,AX
		MOV     CX,8            ; convert ASCIIBITS to binary byte
		MOV     SI,ASCIIBITS
		XOR     AH,AH
L2:		SHL	AH,1
		LODSB
		SUB     AL,'0'
		OR      AH,AL
		LOOP    L2
		MOV     AL,AH           ; set register
		OUT     65h,AL
		JMP	$+2
		MOV     AX,352Fh        ; get and save Int 2Fh vector
		INT     21h
		MOV     INT2FSEG,ES
		MOV     INT2FOFFS,BX
		MOV     AX,252Fh        ; hook Int 2Fh
		MOV     DX,INT2FHDLR
		INT     21h
		LDS     BX,REQUESTPTR   ; set request header fields
		MOV     FREEMEMOFFS,END_RESIDENT
		MOV     FREEMEMSEG,CS
		POP     ES              ; restore ES, DS, DI, SI, DX, CX, 
		POP     DS              ;   BX, AX
		POP     DI
		POP     SI
		POP     DX
		POP     CX
		POP     BX
		POP     AX
		RET
;
; Process a command-line switch, for the case where this driver is not
; already installed.  AL = "+" or "-", DS:SI -> following character, DF
; clear.  According to the MS-DOS Encyclopedia, these characters are 
; converted to uppercase.
;
SWITCHNONINST:  PUSH    AX              ; save AX, DI
		PUSH    DI
		MOV     AH,AL           ; AH = "+" or "-"
		MOV     AL,[SI]         ; AL = character following "+" or "-"
		MOV	DI,7		; char "H" => DI = 7
		CMP     AL,'H'
		JE      >L0
		DEC     DI              ; char "P" => DI = 6
		CMP     AL,'P'
		JE      >L0
		DEC     DI              ; char "V" => DI = 5
		CMP     AL,'V'
		JE      >L0
		DEC     DI              ; char "F" => DI = 4
		CMP     AL,'F'
		JE      >L0
		DEC     DI              ; char "S" => DI = 3
		CMP     AL,'S'
		JNE     >L2             ; otherwise, invalid
L0:             MOV     AL,'0'          ; if "-", AL = "0"
		CMP     AH,'+'          ; if "+", AL = "1"
		JNE     >L1
		MOV     AL,'1'
L1:             MOV     CS:[DI+ASCIIBITS],AL  ; save option bit in ASCIIBITS
		CMP     DI,6           ; special case, parallel port involves
		JNE     >L2             ;   two bits
		XOR	DI,DI
		MOV     CS:[DI+ASCIIBITS],AL
L2:             POP     DI              ; restore DI, AX
		POP     AX
		RET
;
; Init routine, for the case where the driver is already installed.  DS = CS
; on entry.
;
INITINSTALLED:  PUSH    AX              ; save AX, BX, SI, DS, ES
		PUSH    BX
		PUSH    SI
		PUSH    DS
		PUSH    ES
		LES     BX,REQUESTPTR   ; ES:BX -> request header
		LDS     SI,ES:CONFIGPTR ; DS:SI -> DEVICE= line in CONFIG.SYS
		CLD                     ; while not end of line:
L0:             CALL    FINDSWITCH      ;   find next switch
		CMP     AL,0Dh          ;   (AL = 0Dh at end of line)
		JE      >L1
		CALL    SWITCHINSTALLED ;   process switch
		JMP     L0
L1:             LDS     BX,CS:REQUESTPTR ; set request header fields
		MOV     NUMUNITS,0
		MOV     FREEMEMOFFS,0   ; use device header address to
		MOV     FREEMEMSEG,CS   ;   bypass installation
		POP     ES              ; restore ES, DS, SI, BX, AX
		POP     DS
		POP     SI
		POP     BX
		POP     AX
		RET
;
; Process a command-line switch, for the case where this driver is already 
; installed.  AL = "+" or "-", DS:SI -> following character, DF clear.  
; According to the MS-DOS Encyclopedia, these characters are converted to 
; uppercase.  In this case, for each switch found, we pass a command to
; the previous driver rather than updating our own ASCIIBITS array.
;
SWITCHINSTALLED:
		PUSH    AX              ; save AX, BX, DX, DS, ES
		PUSH    BX
		PUSH    DX
		PUSH    DS
		PUSH    ES
		MOV     AH,AL           ; AH = "+" or "-"
		MOV     AL,[SI]         ; AL = character following "+" or "-"
		MOV     DL,'0'          ; char "H" => DL = '0'
		CMP     AL,'H'
		JE      >L0
		INC     DL              ; char "P" => DL = '1'
		CMP     AL,'P'
		JE      >L0
		INC     DL              ; char "V" => DL = '2'
		CMP     AL,'V'
		JE      >L0
		INC     DL              ; char "F" => DL = '3'
		CMP     AL,'F'
		JE      >L0
		INC     DL              ; char "S" => DL = '4'
		CMP     AL,'S'
		JNE     >L3             ; otherwise, invalid
L0:             MOV     AL,'0'          ; if "-", AL = "0"
		CMP     AH,'+'          ; if "+", AL = "1"
		JNE     >L1
		MOV     AL,'1'
L1:             MOV     AH,DL           ; AH = bit to change in ASCII
		MOV     DX,CS           ; AL = value in ASCII
		MOV     DS,DX           ; DS = ES = CS
		MOV     ES,DX
		MOV     WRITEBITNO,AH   ; set string for write request
		MOV     WRITEBITVAL,AL
		MOV     BX,OFFSET WRITECMD ; DS:BX -> request header
		MOV     REQLEN,TYPE READREQ ; fill in length of header
		MOV     COMMANDCODE,8   ; Write command
		;
		; Set pointer to output string.
		;
		MOV     WORD PTR DATAPTR,OFFSET WRITESTR
		MOV     WORD PTR DATAPTR+2,DS
		MOV     NUMBYTES,4      ; bytes to write = 4
L2:             MOV     AX,0FDDBh       ; AX,DX = magic number
		MOV     DX,0BDDFh       ; ES:BX -> request header (already)
		INT     2Fh             ; call previous driver thru backdoor
		CMP     WRITEBITNO,'1'  ; if parallel port, perform second
		JNE     >L3             ;   call to set bit 7
		MOV     WRITEBITNO,'7'
		JMP     L2
L3:             POP     ES              ; restore ES, DS, DX, BX, AX
		POP     DS
		POP     DX
		POP     BX
		POP     AX
		RET
;
; Routine to get the current value of the planar control register from the
; existing driver, if already installed.  DS = CS on entry.
;
GETREGISTER:    PUSH    AX              ; save AX, BX, DX, ES
		PUSH    BX
		PUSH    DX
		PUSH    ES
		;
		; Set pointer to request header.
		;
		MOV     AX,DS           ; ES:BX -> request header
		MOV     ES,AX
		MOV     BX,OFFSET READCMD
		;
		; Read buffer is ASCIIBITS array.
		;
		MOV     WORD PTR DATAPTR,ASCIIBITS
		MOV     WORD PTR DATAPTR+2,DS
		MOV     REQLEN,TYPE READREQ ; fill in length of header
		;
		; Perform a call to Flush Input Buffers to reset the read
		; pointer (in case there were no valid command line 
		; parameters to force a Write previously).
		;
		MOV     COMMANDCODE,7   ; Flush Input Buffers command
		MOV     AX,0FDDBh       ; AX,DX = magic number
		MOV     DX,0BDDFh       ; ES:BX -> request header (already)
		INT     2Fh             ; call previous driver thru backdoor
		;
		; Read from the existing device driver through the Int 2Fh
		; backdoor.
		;
		MOV     COMMANDCODE,4   ; Read command
		MOV     NUMBYTES,MAXBYTES ; get entire string
		MOV     AX,0FDDBh       ; AX,DX = magic number
		MOV     DX,0BDDFh       ; ES:BX -> request header (already)
		INT     2Fh             ; call previous driver thru backdoor
		POP     ES              ; restore ES, DX, BX, AX
		POP     DX
		POP     BX
		POP     AX
		RET
;
; Routine to find the next switch on the command line.  Switches begin with
; "-" or "+".  On entry, DS:SI -> command line (or what's left of it), DF
; clear.  Returns:  AL = "+" or "-" (or 0Dh at end of line), DS:SI ->
; character following switch in AL.  Command line should end with CR or LF.
;
FINDSWITCH:     LODSB
		CMP     AL,'+'
		JE      >L0
		CMP     AL,'-'
		JE      >L0
		CMP     AL,0Dh
		JE      >L0
		CMP     AL,0Ah
		JNE     FINDSWITCH
		MOV     AL,0Dh
L0:             RET
