;****************************************************************************
;*
;*  Copyright (c) 1991-93 Sierra Semiconductor Corp.
;*
;*  FILE:          aim.asm
;*
;*  FUNCTION:      _AriaInt
;*
;*  LANGUAGES:     Microsoft Macro Assembler 5.1
;*                 Borland Turbo Assembler 
;*
;*  DESCRIPTION:   The Aria Interrupt Manager (AIM) handles all interrupts
;*                 generated by the Aria hardware.  The Aria Data Port will
;*                 indicate which service routine is activated.
;*
;*                 The interrupt vector table (_ISRvector) must be updated
;*                 by RegisterISR() in the Aria C language API.
;*
;*                 For Microsoft Macro Assembler 5.1
;*                 =================================
;*                 To assemble:  masm -ML aim.asm,,;   (for small model)
;*
;*                 add:
;*
;*                   -DMEDIUMMDL  for medium model
;*                   -DCOMPACTMDL for compact model
;*                   -DLARGEMDL   for large model
;*
;*                 For Borland Turbo Assembler
;*                 ===========================
;*                 To assemble:  tasm -ml aim.asm    (for small model)
;*
;*                 add:
;*
;*                   -DMEDIUMMDL  for medium model
;*                   -DCOMPACTMDL for compact model
;*                   -DLARGEMDL   for large model
;*
;****************************************************************************
        TITLE  aim.asm

; $Header:   F:\projects\ariai\dos\archives\aim.asv   2.2   03 Sep 1993 10:10:46   golds  $
; $Log:   F:\projects\ariai\dos\archives\aim.asv  $
; 
;    Rev 2.2   03 Sep 1993 10:10:46   golds
; Minor changes to declaration of wave info structures
; 
;    Rev 2.0   24 Jun 1993 14:05:58   golds
; Initial revision.

IFDEF LARGEMDL
        .MODEL large
ELSEIFDEF COMPACTMDL
        .MODEL compact
ELSEIFDEF MEDIUMMDL
        .MODEL medium
ELSE
        .MODEL small
ENDIF
        .286

        INCLUDE aria.inc

        .DATA

        EXTRN   _dspbase     :WORD

        PUBLIC _ISRvector
_ISRvector     LABEL BYTE

        dd     0    ;DSP Application 0  ISR (Aria Synthesizer and PCM Audio)
        dd     0    ;DSP Application 1  ISR (Sound Blaster Emulation)
        dd     0    ;DSP Application 2  ISR (Aria PCM Audio)
        dd     0    ;DSP Application 3  ISR (Aria Synthesizer)
        dd     0    ;DSP Application 4  ISR (Telephone Interface)
        dd     0    ;DSP Application 5  ISR (Speech Recognition)
        dd     0    ;DSP Application 6  ISR (Undefined)
        dd     0    ;DSP Application 7  ISR (Reverb Effect Processor)
        dd     0    ;DSP Application 8  ISR (QSound(TM) Virtual Audio)
        dd     0    ;DSP Application 9  ISR (Undefined)
        dd     0    ;DSP Application 10 ISR (Undefined)
        dd     0    ;DSP Application 11 ISR (Undefined)
        dd     0    ;DSP Application 12 ISR (Undefined)
        dd     0    ;DSP Application 13 ISR (Undefined)
        dd     0    ;DSP Application 14 ISR (Undefined)
        dd     0    ;DSP Application 15 ISR (Undefined)

intFlag dw     0    ;Interrupt type flag
intMask dw     0    ;Interrupt identification mask
intCnt  dw     0    ;Interrupt cycle counter
AIMbusy db     0    ;Aria Interrupt Manager busy flag


        .CODE

        PUBLIC _AriaInt

_AriaInt       PROC FAR
        pusha                              ; push registers
        push   ds
        mov    ax, @data
        mov    ds, ax                      ; set up ds register
	ASSUME ds:@data

        mov    dx, _dspbase                ; determine interrupt type by
        in     ax, dx                      ;   reading DSP data port

        or     intFlag, ax                 ; store interrupt bit(s)

        cmp    AIMbusy, 0                  ; is an interrupt in progress?
        jne    exit2                       ; yes, exit
                                           ; no,
        mov    AIMbusy, 1                  ;   set busy flag
        mov    intCnt, 0                   ;   reset counter
        mov    intMask, 1                  ;   set mask to first bit

        sti                                ;   enable interrupts
cycle1:
        mov    ax, intMask                 ; for each bit starting with 0,
        test   intFlag, ax                 ;   is it set?
        jz     next2
                                           ;   yes,
        not    ax
        and    intFlag, ax                 ;     clear the bit flag

        mov    si, intCnt                  ;     get the address offset
        shl    si, 2
        cmp    WORD PTR _ISRvector[si], 0  ;  if vector is 0,
        jne    next1                       ;        we don't want to call it
        cmp    WORD PTR _ISRvector[si+2], 0
        je     next2
next1:
        cli                                ;     disable interrupts
        call   DWORD PTR _ISRvector[si]    ;     call it
        sti                                ;     enable interrupts
next2:
        cmp    intFlag, 0                  ;   are we done?
        je     exit                        ;   yes, exit AIM

        inc    intCnt                      ;   increment counter
        shl    intMask, 1                  ;   shift mask to next bit
        jnc    cycle1                      ;   not done, go back for more

        mov    intCnt, 0                   ;   reset counter
        mov    intMask, 1                  ;   reset mask to first bit
        jmp    short cycle1                ;   go back to rescan int flag

        ; End of Interrupt
exit:
        cli                                ; disable interrupts before EOI
        mov    AIMbusy, 0                  ; clear busy flag
exit2:
        mov    al, 20h                     ; send EOI to interrupt controllers
        out    INTCTRLR1-1, al             ;   slave controller
        out    INTCTRLR0-1, al             ;   primary controller

        pop    ds
        popa                               ; pop all registers
        iret                               ; return from interrupt
_AriaInt       ENDP

        END

