//***************************************************************************
//
// Copyright (c) 1991-93 Sierra Semiconductor Corp.
//
// FILE:    playwave.c
//
// LANGUAGE:
//          Microsoft C/C++ Version 7.0
//
// DESCRIPTION:
//
//          A stand alone utility that plays up to 4 Microsoft Wave (.WAV) 
//          files
//
//          Compile:  cl /AL /c /Zp playwave.c
//          Link:     link playwave,,,aria_l;
//
// Aria is a trademark of Sierra Semiconductor Corp.
//
//***************************************************************************

// $Header:   F:\projects\ariai\dos\archives\playwave.c_v   1.7   08 Dec 1993 13:59:26   golds  $
// $Log:   F:\projects\ariai\dos\archives\playwave.c_v  $
// 
//    Rev 1.7   08 Dec 1993 13:59:26   golds
// Recompiled with API libraries version 2.5 (Fixes stereo ADPCM problem in
// older ROMs - ver. 1.6).
// 
//    Rev 1.6   03 Sep 1993 10:21:24   golds
// Recompiled with API library version 2.2
// 
//    Rev 1.5   13 Aug 1993 09:15:30   golds
// Various optimizations, linked with Version 2.1 library
// 
//    Rev 1.1   13 Jul 1993 14:17:36   golds
// Added define for WAVE_FORMAT_SIERRA_ADPCM
// 
//    Rev 1.0   24 Jun 1993 12:51:10   golds
// Initial revision.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#ifdef TURBOC
#include <alloc.h>
#else
#include <malloc.h>
#endif
#include <dos.h>

#include "aria.h"

#define READBUFFERSIZE 63488L
#define HALFBUFFERSIZE ((DWORD)(READBUFFERSIZE>>1))
#define WAVE_FORMAT_PCM          0x0001
#define WAVE_FORMAT_ALAW         0x0006
#define WAVE_FORMAT_MULAW        0x0007
#define WAVE_FORMAT_SIERRA_ADPCM 0x0013

#define mmioFOURCC( ch0, ch1, ch2, ch3 )                                \
                ( (DWORD)(BYTE)(ch0) | ( (DWORD)(BYTE)(ch1) << 8 ) |    \
                ( (DWORD)(BYTE)(ch2) << 16 ) | ( (DWORD)(BYTE)(ch3) << 24 ) )

typedef DWORD FOURCC;      // A four character code
#define FOURCC_RIFF        mmioFOURCC('R', 'I', 'F', 'F')
#define FOURCC_WAVE        mmioFOURCC('W', 'A', 'V', 'E')
#define FOURCC_fmt         mmioFOURCC('f', 'm', 't', ' ')
#define FOURCC_data        mmioFOURCC('d', 'a', 't', 'a')

#define BREAKINT  0x1B     // Control break interrupt
#define CTRLCINT  0x23     // Control C interrupt

// global variables

struct headerstruct     // File header format
   {
   FOURCC   ckID1;
   DWORD    size1;
   FOURCC   ckID2;
   FOURCC   ckID3;
   DWORD    size3;
   WORD     formatTag;
   WORD     nChannels;
   DWORD    nSamplesPerSec;
   DWORD    nAvgBytesPerSec;
   WORD     nBlockAlign;
   WORD     nBitsPerSample;
   } header;

struct headerstruct2
   {
   WORD     cbExtraSize;
   WORD     wRevision;
   } header2;

struct headerstruct3
   {
   FOURCC   ckID4;
   DWORD    size4;
   // Data goes here
   } header3;

FILE   *samplefile[4];  // Sample file (.WAV)
HPBYTE buffer[4];       // Pointer to sample buffer
DWORD  bsize;           // Number of bytes read
BYTE   silence;         // Silence sample byte
DWORD  rate = 11025L;   // Sample rate
BOOL   compress=FALSE;  // Compressed data flag
WORD   formatTag;       // File format
WORD   formatRate;      // Rate to send to format command
WORD   formatType;      // Format type for Aria API
WORD   bitspersample;   // Bits per sample
WORD   channels;        // Number of channels
DWORD  pos;             // Offset counter
DWORD  size[4];         // Size of current buffer
DWORD  offset[4];       // Buffer pointer to half to fill
short  i, j;            // Loop control variables
short  maxch;           // Number of sample files to play
short  isplaying;       // Playing control flag
VOID (interrupt FAR *oldctrlchandler)();
VOID (interrupt FAR *oldbreakhandler)();

extern WORD wDSPpart;
extern WORD intr;

VOID errexit (short);
VOID interrupt FAR newctrlchandler (VOID);
VOID interrupt FAR newbreakhandler (VOID);


main (short argc, LPSTR argv[])
   {
   if (argc == 1)
      {
      printf ("\nUsage:  PLAYWAVE <sfile>\n\n");
      printf ("        sfile = sound file in Microsoft Wave format (.WAV)\n");
      exit (1);
      }
   printf ("\nPLAYWAVE  Version 1.7");
   printf ("\nCopyright (c) 1991-93 Sierra Semiconductor Corp.\n");

   // Look for Aria board

   if (i = SystemInit (ARIA_SYNTH))
      {
      printf ("\nERROR - Aria board not found (%d)\n", i);
      exit (1);
      }
   if ((i = GetInterrupt ()) < 0)
      {
      printf ("\nERROR - Aria board interrupt not found (%d)\n", i);
      exit (1);
      }

   maxch = argc - 1;
   if (maxch > 4)
      {
      printf ("\nERROR - Too many sound files, limit is 4\n");
      exit (1);
      }

   SetPlaybackMode (NOSYNTH);
   for (i = 0; i < maxch; ++i)
      {
      // Open sample file

      if ((samplefile[i] = fopen (argv[i+1], "rb")) == NULL)
         errexit (-1);

      // Read header

      fread (&header, 1, sizeof (struct headerstruct), samplefile[i]);
      if (header.ckID1 != FOURCC_RIFF ||
          header.ckID2 != FOURCC_WAVE ||
          header.ckID3 != FOURCC_fmt)
         errexit (-1);

      switch (header.formatTag)
         {
         case WAVE_FORMAT_PCM:
            break;

         case WAVE_FORMAT_ALAW:
         case WAVE_FORMAT_MULAW:
            if (wDSPpart < SC18026)
               errexit (-4);
            fread (&header2, 1, 2, samplefile[i]);
            compress = TRUE;
            break;

         case WAVE_FORMAT_SIERRA_ADPCM:
            fread (&header2, 1, sizeof (struct headerstruct2), samplefile[i]);
            if (header.nBitsPerSample != 4 || header2.cbExtraSize != 2 || 
                header2.wRevision != 0x0100)
               errexit (-1);
            compress = TRUE;
            break;

         default:
            errexit (-1);
         }

      while (TRUE)
         {
         if (fread (&bsize, 4, 1, samplefile[i]) != 1)
            errexit (-1);
         if (bsize == FOURCC_data)
            break;
         if (fread (&bsize, 4, 1, samplefile[i]) != 1)
            errexit (-1);
         if (bsize & 1)
            ++bsize;
         if (fseek (samplefile[i], bsize, SEEK_CUR) != 0)
            errexit (-1);
         }

      if (i && (rate  != (DWORD) header.nSamplesPerSec || 
                bitspersample != header.nBitsPerSample ||
                channels      != header.nChannels      ||
                formatTag     != header.formatTag))
         errexit (-3);

      rate = (DWORD) header.nSamplesPerSec;
      bitspersample = header.nBitsPerSample;
      channels      = header.nChannels;
      formatTag     = header.formatTag;

      // Get size of sample file

      fread (&size[i], 4, 1, samplefile[i]);
      if (size[i] % 1024L)
         size[i] += (1024L - (size[i] % 1024L));

      // Allocate memory for buffer

      if ((buffer[i] = malloc ((size_t) READBUFFERSIZE)) == NULL)
         errexit (-2);

      // Read data into first half of buffer

      bsize = fread (buffer[i], 1, (size_t) HALFBUFFERSIZE, samplefile[i]);

      // Silence any extra samples

      if (bitspersample > 8 || compress)
         silence = 0x00;
      else
         silence = 0x80;
      _fmemset (buffer[i] + bsize, silence, (size_t) (HALFBUFFERSIZE - bsize));

      if (i == 1 && channels == 2)
         {
         maxch = 2;
         break;
         }
      }

   // Set format

   printf ("\nSample rate     = %lu kHz", rate);
   switch (rate)
      {
      case 11025L:
         formatRate = SR11KHZ;
         break;
      case 22050L:
         formatRate = SR22KHZ;
         break;
      case 44100L:
         formatRate = SR44KHZ;
         break;
      case 32000L:
         formatRate = SR32KHZ;
         break;
      case 16000L:
         formatRate = SR16KHZ;
         break;
      case 8000L:
         formatRate = SR8KHZ;
         break;
      }

   printf ("\nSample format   = ");
   switch (formatTag)
      {
      case WAVE_FORMAT_SIERRA_ADPCM:
         printf ("Sierra ADPCM");
         formatType = 4;
         break;
      case WAVE_FORMAT_MULAW:
         printf ("CCITT Mu-Law Companded");
         formatType = 6;
         break;
      case WAVE_FORMAT_ALAW:
         printf ("CCITT A-Law Companded");
         formatType = 8;
         break;
      default:
         printf ("PCM");
         if (bitspersample == 8)
            formatType = 0;
         else
            formatType = 2;
         break;
      }
   if (channels == 2)
      ++formatType;

   SetAudioFormat ((UINT) (formatRate | formatType));

   // Print more statistics

   printf ("\nBits per sample = %d", bitspersample);

   if (channels == 1)
      printf ("\nMonophonic sample\n\n");
   else if (channels == 2)
      printf ("\nStereo sample\n\n");
   else
      printf ("\n%d channels defined in sample\n\n", channels);

   DISABLE
   oldctrlchandler = GETVECT (CTRLCINT);
   oldbreakhandler = GETVECT (BREAKINT);
   SETVECT (CTRLCINT, newctrlchandler);
   SETVECT (BREAKINT, newbreakhandler);
   ENABLE

   // Start sample(s)

   InstallAriaInt ();
   printf ("\rPlaying...\n");
   isplaying = 1;
   for (i = 0; i < maxch; ++i)
      {
      offset[i] = HALFBUFFERSIZE;
      StartPlayback ((UINT) i, (LPBYTE) buffer[i], READBUFFERSIZE, size[i]);
      }

   while (isplaying)
      {
      isplaying = 0;
      if (kbhit ())
         // Stop all samples

         for (i = 0; i < maxch; ++i)
            StopPlayback ((UINT) i);
      else
         {
         for (i = 0; i < maxch; ++i)
            {
            // Print out current offset from start of sample

            pos = GetAudioPosition ((UINT) i);
            if (!i)
               printf ("\rpos =");
            printf (" %7ld", size[i] - pos);
            if (pos != 0L)
               {
               isplaying = 1;

               // Check for buffer running out of data

               pos = GetBufferPosition ((UINT) i);
               if (pos > offset[i] && pos <= (offset[i] + HALFBUFFERSIZE))
                  {
                  // Load more data into other half of buffer

                  bsize = fread (buffer[i] + offset[i], 1,
                                 (size_t) HALFBUFFERSIZE, samplefile[i]);

                  // Silence fill if necessary

                  if (bsize > 0L)
                     _fmemset (buffer[i] + offset[i] + bsize, silence,
                               (size_t) (HALFBUFFERSIZE - bsize));

                  // Adjust buffer offset pointer

                  if (offset[i] > 0L)
                     offset[i] = 0L;
                  else
                     offset[i] = HALFBUFFERSIZE;
                  }
               }
            }
         }
      }
   
   for (i = 0; i < maxch; ++i)
      fclose (samplefile[i]);

   DISABLE
   SETVECT (CTRLCINT, oldctrlchandler);
   SETVECT (BREAKINT, oldbreakhandler);
   ENABLE

   RemoveAriaInt ();

   if (SystemInit (DEFAULT_SYNTH))
      printf ("\nERROR - Could not reset system to default mode\n");

   printf ("\nAll done\n");
   exit (0);
   }


VOID errexit (short err)
   {
   switch (err)
      {
      case -1:
         printf ("\nERROR - Invalid sound file specified\n");
         break;

      case -2:
         printf ("\nERROR - Not enough memory\n");
         break;

      case -3:
         printf ("\nERROR - Multiple files must be the same format\n");
         break;

      case -4:
         printf ("\nERROR - Cannot play specified data format\n");
         break;
      }
   SystemInit (DEFAULT_SYNTH);
   exit (1);
   }


VOID interrupt FAR newctrlchandler (VOID)
   {
   }


VOID interrupt FAR newbreakhandler (VOID)
   {
   }

