//***************************************************************************
//
// Copyright (c) 1993 Sierra Semiconductor Corp.
//
// FILE:    sbvol.c
//
// LANGUAGE:
//          Microsoft C Versions 5.0, 6.0, and 7.0
//
// DESCRIPTION:
//
//          COMMAND LINE VOLUME CHANGE for SOUND BLASTER and ADLIB
//             This program is a stand-alone DOS program to set the
//	            AdLib(TM) and SoundBlaster(TM) volumes by using an 
//             unused MIDI command
//
// AdLib is a trademark of AdLib, Inc.
// Aria is a trademark of Sierra Semiconductor Corp.
// Sound Blaster is a trademark of Creative Labs Inc.
//
//***************************************************************************

// $Header:   F:\projects\ariai\dos\archives\sbvol.c_v   1.3   07 Sep 1993 08:11:56   golds  $
// $Log:   F:\projects\ariai\dos\archives\sbvol.c_v  $
// 
//    Rev 1.3   07 Sep 1993 08:11:56   golds
// Changed name from SETVOL to SBVOL
// 
//    Rev 1.2   03 Sep 1993 10:22:14   golds
// Updated version number
// 
//    Rev 1.1   20 Apr 1993 09:20:12   golds
// Initial revision.
// Added environment variable detect and various other code cleanup prior 
// to release.

#include <stdio.h>
#include <stdlib.h>

// defines
#define VOLCMD    0x3A
#define STATPORT  0x0C
#define CMDPORT   0x0C

// function prototypes
short write_midi_data (short, char);
short GetSBEnv (unsigned *, unsigned *, unsigned *, unsigned *);

// main program
main (short argc, char *argv[])
   {
   unsigned short sb_vol;
   unsigned short adlib_vol;
   unsigned short port, irq, dma, ver;

   printf ("\nSOUND BLASTER(TM) VOLUME CONTROL for Aria-based Sound Boards (v1.3)");
   printf ("\nCopyright (c) 1993 Sierra Semiconductor Corp.");
   printf ("\nNOTE: This program may not function with certain ROM versions.\n");

   // Determine base port address -- first check environment

   if (GetSBEnv (&port, &irq, &dma, &ver) == -1)
      printf ("\nWARNING - Sound Blaster environment variable not set.\n");

   if (argc < 2)
      {
	   printf ("\nPlease Enter Digital Audio Volume (0 - 63): ");
	   scanf ("%d", &sb_vol);
      if (sb_vol > 63)
         sb_vol = 63;
      }
   else
      {
	   if ((sb_vol = atoi (argv[1])) > 63)
         sb_vol = 63;
	   printf ("\nSound Blaster digital audio volume = %d\n", sb_vol);
      }

   if (argc < 3)
      {
	   printf ("Please Enter Synthesizer Volume   (0 - 63): ");
	   scanf ("%d", &adlib_vol);
      if (adlib_vol > 63)
         adlib_vol = 63;
      }
   else
      {
	   if ((adlib_vol = atoi (argv[2])) > 63)
         adlib_vol = 63;
   	printf ("Sound Blaster synthesizer volume   = %d\n", adlib_vol);
      }

   // Write the command and volume levels

   if (write_midi_data (port, (char) VOLCMD) ||
       write_midi_data (port, (char) sb_vol) ||
       write_midi_data (port, (char) adlib_vol))
      {
	   printf ("\nERROR - SOUND BLASTER COMMAND FAILED\n");
      exit (1);
      }
   exit (0);
   }


short write_midi_data (short port, char data)
   {
   short i=0;

   while (inp (port+STATPORT) & 0x80)
      if (++i > 20000)
         return 1;

   outp (port+CMDPORT, data);
   return 0;
   }


short GetSBEnv (unsigned *port, unsigned *irq, unsigned *dma, unsigned *ver)
   {
   char *value;
   char buf[4];
   unsigned short temp;

   // Set parameters to defaults

   *port = 0x220;
   *irq  = 7;
   *dma  = 1;
   *ver  = 1;

   // Environment variable defined?

   if ((value = getenv ("BLASTER")) == NULL)
      return -1;

   // Parse the environment string

   while (*value != '\0')
      {
      // Skip blanks
      while (*value == ' ')
         ++value;

      switch (*value)
         {
         // Get base address port (hex string)
         case 'A':
         case 'a':
            value++;
            temp = (*value - '0') << 8;
            value++;
            temp += ((*value - '0') << 4);
            value++;
            temp += (*value - '0');
            value++;
            *port = temp;
            break;

         // Get IRQ number
         case 'I':
         case 'i':
            value++;
            temp = *value - '0';
            value++;
            if (*value != ' ' && *value != '\0')
               {
               temp *= 10;
               temp += (*value - '0');
               value++;
               }
            *irq = temp;
            break;

         // Get DMA channel
         case 'D':
         case 'd':
            value++;
            temp = *value - '0';
            value++;
            *dma = temp;
            break;

         // Get system version number
         case 'T':
         case 't':
            value++;
            temp = *value - '0';
            value++;
            if (*value != ' ' && *value != '\0')
               {
               temp *= 10;
               temp += (*value - '0');
               value++;
               }
            *ver = temp;
            break;

         default:
            while (*value != ' ' && *value != '\0')
               value++;
            break;
         }
      }
   return 0;
   }
