//***************************************************************************
//
// Copyright (c) 1993 Sierra Semiconductor Corp.
//
// FILE:    volume.c
//
// LANGUAGE:
//          Microsoft C Versions 5.0, 6.0, and 7.0
//
// DESCRIPTION:
//
//          COMMAND LINE VOLUME CHANGE for master volume
//
// Aria is a trademark of Sierra Semiconductor Corp.
//
//***************************************************************************

// $Header:   F:\projects\ariai\dos\archives\volume.c_v   1.0   03 Sep 1993 17:11:30   golds  $
// $Log:   F:\projects\ariai\dos\archives\volume.c_v  $
// 
//    Rev 1.0   03 Sep 1993 17:11:30   golds
// Initial revision.

#include <stdio.h>
#include <stdlib.h>
#include "aria.h"

main (short argc, char *argv[])
   {
   unsigned short master_vol;

   printf ("\nMASTER VOLUME CONTROL for Aria-based Sound Boards (v1.0)");
   printf ("\nCopyright (c) 1993 Sierra Semiconductor Corp.\n");

   if (argc < 2)
      {
      printf ("\nPlease Enter Master Output Volume (0 - 63): ");
	   scanf ("%d", &master_vol);
      if (master_vol > 63)
         master_vol = 63;
      }
   else
      {
	   if ((master_vol = atoi (argv[1])) > 63)
         master_vol = 63;
	   printf ("Master output volume = %d\n", master_vol);
      }

   // Change master volume
   if (SystemInit (ARIA_SYNTH) != 0)
      {
      printf ("\nERROR - COULD NOT ACCESS SOUND BOARD\n");
      exit (1);
      }
   master_vol <<= 9;
   SetMasterVolume (master_vol, master_vol);
   SystemInit (DEFAULT_SYNTH);

   exit (0);
   }

