'*===================================*
'*                                   *
'* Music Quest Programmer's ToolKit  *
'* Interpreted Trace                 *
'*                                   *
'*===================================*
'*                                   *
'* Copyright (c) 1988                *
'* Music Quest, Inc.                 *
'*                                   *
'*===================================*

DEFINT A-Z

' $include: 'mcc.cst'
' $include: 'mcc.inc'
DECLARE function midigetw% ()

'*===================================*
'*                                   *
'* Interpreted trace                 *
'*                                   *
'*===================================*
sub tkitrace
  cls
  print "Press any key to end trace"
  rc%=mcccommand(UART.MODE)             ' put MCC into pass-thru mode
  mccsetreceiveslih                     ' set up our slih

  channel%=0
  midic%=0
  sysexsw%=0
  rstatus%=1                            ' running status = note on
  do
    midic=mccget
    if sysexsw OR (midic >= 0) then
        sysexsw=0
        if midic AND &h80 then          ' new status?
          if (midic < &hF0) then        ' non-system message?
              channel=(midic AND &h0F)+1
              rstatus=(midic AND &h70) \ 16
              cmdx%=rstatus
              byte1%=midigetw
          else                          ' system message
            cmdx%=7
          end if
        else                            ' running status
            byte1=midic
            cmdx=rstatus
        end if

        select case cmdx%
            case 0
              byte2%=midigetw
              print "Note off            channel=";channel;" key=";byte1;" velocity=";byte2
            case 1
              byte2%=midigetw
              print "Note on             channel=";channel;" key=";byte1;" velocity=";byte2
            case 2
              byte2%=midigetw
              print "Key aftertouch      channel=";channel;" key="byte1;" pressure=";byte2
            case 3
              byte2=midigetw
              print "Control change      channel=";channel;" controller=";byte1;" value=";byte2
            case 4
              print "Program change      channel=";channel;" program=";byte1
            case 5
              print "Channel aftertouch  channel=";channel;" pressure=";byte1
            case 6
              byte2=midigetw
              print "Pitch bend          channel=";channel;" bend=";hex$((byte2%*128)+byte1%)
            case 7
              select case midic AND &h0F
                  case 0                ' sys ex
                    print "System exclusive    ";
                    k%=16
                    do
                        midic=midigetw
                        hx$=hex$(midic)
                        if len(hx$) = 1 then
                          hx$="0"+hx$
                        end if
                        print hx$;" ";
                        k=k-1
                        if k = 0 then
                            print chr$(10);"                    "
                            k%=16
                        end if
                    loop while (midic AND &h80) <> &h80
                    print
                    if midic <> &hF7 then       ' ended on new command, not eox
                      sysexsw=1
                    end if
                  case 1                ' midi time code
                    byte1=midigetw
                    print "MIDI time code      code=";byte1
                  case 2                ' song position
                    byte1=midigetw
                    byte2=midigetw
                    print "Song position       beats=";(byte2*128)+byte1
                  case 3                ' song select
                    byte1=midigetw
                    print "Song select         song=";byte1
                  case 6                ' tune request
                    print "Tune request"
                  case 8:               ' clock
                    print "Clock"
                  case 10               ' start
                    print "Start"
                  case 11               ' continue
                    print "Continue"
                  case 12               ' stop
                    print "Stop"
                  case 14               ' active sense
                  case 15
                    print "System reset"
                  case else
                    print "Undefined           status=";midic
              end select
        end select
    end if
  loop while inkey$=""

  mccsetnoslih                          ' default slih
  mccreset
end sub

'*===================================*
'*                                   *
'* Wait for the next MIDI data byte  *
'*                                   *
'*===================================*
function midigetw%
  t!=timer+2                            ' max wait of 2 sec
  do
    mbyte%=mccget                       ' try for a byte
  loop while (t! > timer) AND (mbyte% < 0) ' spin until data or time out
  midigetw=mbyte
end function
