{*===================================*}
{*                                   *}
{* Music Quest Programmer's ToolKit  *}
{*                                   *}
{*===================================*}
{*                                   *}
{* Definitions for MCC commands      *}
{*                                   *}
{*===================================*}
{*                                   *}
{* Copyright (c) 1988                *}
{* Music Quest, Inc.                 *}
{*                                   *}
{*===================================*}

const

   M_STOP                 = $01; {* Send MIDI stop to MIDI-out. *}
   M_START                = $02; {* Send MIDI start to MIDI-out. *}
   M_CONTINUE             = $03; {* Send MIDI continue to MIDI-out. *}
   STOP_PLAY              = $05; {* Stop play back and send MIDI stop. *}
   START_PLAY             = $0A; {* Start play back and send MIDI start. *}
   CONTINUE_PLAY          = $0B; {* Continue play back and send MIDI continue. *}
   STOP_REC               = $11; {* Stop recording and send MIDI stop. *}
   STOP_RECPLAY           = $15; {* Stop recording and play back, and MIDI stop. *}
   STOP_RECSMPTE          = $1C; {* Stop recording SMPTE tape sync data *}
   STOP_SMPTE_READ        = $1D; {* Stop reading SMPTE tape sync *}
   REC_STANDBY            = $20; {* Recording standby. *}
   START_REC              = $22; {* Start recording and send MIDI start. *}
   CONTINUE_REC           = $23; {* Continue recording and send MIDI continue. *}
   START_PLAY_RECSTDBY    = $28; {* Start play back and enter recording standby. *}
   START_PLAY_REC         = $2A; {* Start play back and recording, and send MIDI start. *}
   CONTINUE_PLAY_REC      = $2B; {* Continue play back and recording, and send MIDI continue. *}
   START_RECSMPTE         = $2C; {* Start recording SMPTE tape sync data *}
   START_SMPTE_READ       = $2D; {* Start reading SMPTE tape sync *}
   DISABLE_RT             = $32; {* Disable MIDI real time messages (clock, start, stop, continue). *}
   DISABLE_ALL_THRU       = $33; {* Disable MIDI thru. *}
   ENABLE_TB              = $34; {* Send data in stop state messages with timing byte. *}
   ENABLE_MODEMSG         = $35; {* Enable mode messages to PC. *}
   ENABLE_SYSEX_THRU      = $37; {* Enable system exclusive through messages. *}
   ENABLE_SYSCOM_PC       = $38; {* Enable system common messages to PC. *}
   ENABLE_RT_PC           = $39; {* Enable real time messages to PC. *}
   DISABLE_SMPTE_MSG      = $3A; {* Disable SMPTE frame messages to PC. *}
   ENABLE_SMPTE_MSG       = $3B; {* Enable SMPTE frame messages to PC. *}
   CLS_MODE               = $3C; {* Chase Lock Sync mode *}
   SMPTE_MODE             = $3D; {* SMPTE Sync mode *}
   UART_MODE              = $3F; {* Enter pass-thru or UART mode. *}
   INT_SYNCH              = $80; {* Use internal synchronization. *}
   MIDI_SYNCH             = $82; {* Use MIDI synchronization. *}
   METRO_ON               = $83; {* Metronome on, without accents. *}
   METRO_OFF              = $84; {* Metronome off. *}
   METRO_ACCENTS          = $85; {* Metronome on, with accents. *}
   DISABLE_BENDER_PC      = $86; {* Filter out bender/controller MIDI messages. *}
   ENABLE_BENDER_PC       = $87; {* Enable bender/controller MIDI messages to PC. *}
   DISABLE_THRU           = $88; {* Disables MIDI-thru for acceptable channel messages. *}
   ENABLE_THRU            = $89; {* Enables MIDI-thru for acceptable channel messages. *}
   DISABLE_STOP_MSGS      = $8A; {* Disable MIDI messages to PC when stopped. *}
   ENABLE_STOP_MSGS       = $8B; {* Enable MIDI messages to PC when stopped. *}
   DISABLE_MEASUREND      = $8C; {* Disable measure end messages to PC. *}
   ENABLE_MEASUREND       = $8D; {* Enable measure end messages to PC. *}
   DISABLE_CONDUCTOR      = $8E; {* Disable conductor track. *}
   ENABLE_CONDUCTOR       = $8F; {* Enable conductor track. *}
   DISABLE_MIDI_CTRL      = $90; {* Disable external MIDI control. *}
   ENABLE_MIDI_CTRL       = $91; {* Enable external MIDI control. *}
   DISABLE_CLOCK_PC       = $94; {* Disable clock-to-PC messages. *}
   ENABLE_CLOCK_PC        = $95; {* Enable clock-to-PC messages. *}
   DISABLE_SYSEX_PC       = $96; {* Disable system exclusive messages to PC. *}
   ENABLE_SYSEX_PC        = $97; {* Enable system exclusive messages to PC. *}
   REQ_PLAY_CNTR          = $A0; {* Request play counter for track 1. *}
                                     {* A1 - A7 for tracks 2 - 8 *}
   REQ_USERBITS           = $AA; {* Request SMPTE user bits *}
   REQ_REC_CNTR           = $AB; {* Read and clear record counter. *}
   REQ_VERSION            = $AC; {* Request MCC version number. *}
   REQ_REVISION           = $AD; {* Request MCC revision number. *}
   REQ_TEMPO              = $AF; {* Request current, active tempo. *}
   RESET_REL_TEMPO        = $B1; {* Reset relative tempo setting. *}
   CLEAR_PLAY_TRACKS      = $B8; {* Clear all play track counters. *}
   CLEAR_PLAY_MAP         = $B9; {* Clear play map. *}
   CLEAR_REC_CNTR         = $BA; {* Clear record counter. *}
   INT_CLOCK_48           = $C2; {* Set internal clock to 48 ticks/beat. *}
   INT_CLOCK_72           = $C3; {* Set internal clock to 72 ticks/beat. *}
   INT_CLOCK_96           = $C4; {* Set internal clock to 96 ticks/beat. *}
   INT_CLOCK_120          = $C5; {* Set internal clock to 120 ticks/beat. *}
   INT_CLOCK_144          = $C6; {* Set internal clock to 144 ticks/beat. *}
   INT_CLOCK_168          = $C7; {* Set internal clock to 168 ticks/beat. *}
   INT_CLOCK_192          = $C8; {* Set internal clock to 192 ticks/beat. *}
   REQ_SEND_PT            = $D0; {* Request to send message on play track 1. *}
                                     {* D1-D7 for tracks 2-8 *}
   REQ_SEND_SYS           = $DF; {* Request to send system message. *}
   SET_TEMPO              = $E0; {* Set tempo. *}
   SET_REL_TEMPO          = $E1; {* Set relative tempo. *}
   SET_GRADUATION         = $E2; {* Set relative tempo change graduation. *}
   SET_METRO              = $E4; {* Set number of MIDI clocks per metronome click. *}
   SET_BPM                = $E6; {* Set number of beats per measure, for the metronome. *}
   SET_CLOCK_PC           = $E7; {* Set clock-to-PC message rate, in terms of internal clock ticks. *}
   SET_CLS_DELAY          = $EA; {* Set CLS delay time (in seconds). *}
   SET_MIDI_PATH          = $EB; {* Set MIDI path for message group. *}
   ACTIVE_TRACKS          = $EC; {* Set active play back tracks. *}
   OVRERDUB_REC_CNTRS     = $ED; {* Select tracks whose play counters will be sent when recording starts. *}
   CHANNELS_1             = $EE; {* Select acceptable channels 1-8. *}
   CHANNELS_9             = $EF; {* Select acceptable channes 9-16. *}
   SMPTE_CONTROL          = $F4; {* SMPTE control data. *}
   SMPTE_ORIGIN           = $00; {* SMPTE control data, set origin subfunction *}
   SMPTE_USER             = $01; {* SMPTE control data, set user bits subfunction *}
   SMPTE_CUE_POINT        = $02; {* SMPTE control data, set cue point subfunction *}
   RESET_MCC              = $FF; {* MCC reset. *}

