{*===================================*}
{*                                   *}
{* Music Quest Programmer's ToolKit  *}
{*                                   *}
{* Tape sync features                *}
{*                                   *}
{* Copyright (c) 1988                *}
{* By Music Quest, Inc.              *}
{*                                   *}
{*===================================*}

unit mqxsync;                           {stand-alone unit}

interface

  uses Dos, Crt, mcc;

  procedure show_spp;
  procedure show_smpte;
  procedure cue_point;
  procedure write_smpte;

implementation

{$I mccconst.inc}

{*===================================*}
{*                                   *}
{* Chase Lock - SPP display          *}
{*                                   *}
{*===================================*}
procedure show_spp;

var
  rc:           integer;
  running:      integer;
  spp_val:      integer;
  spp_m:        integer;
  spp_b:        integer;
  rtcmd:        integer;
  kbc:          char;

begin
  ClrScr;
  GotoXY(12,1);
  write('MCC/MQX-32 Programmers ToolKit - Song Position Pointer');
  GotoXY(21,23);
  write('Please start the tape or ESC to return');

  running:=0;
  _mcc_set_coprocslih;
  _mcc_reset;                           {* return to coproc mode *}
  rc:=_mcc_command(DISABLE_ALL_THRU);   {* disable thru *}
  rc:=_mcc_command(DISABLE_THRU);
  rc:=_mcc_command(ENABLE_SYSCOM_PC);   {* enable SPP msgs *}
  rc:=_mcc_command(ENABLE_RT_PC);       {* enable real time msgs *}
  rc:=_mcc_command(ACTIVE_TRACKS);      {* no tracks active *}
  _mcc_put(0);
  rc:=_mcc_command(ENABLE_MIDI_CTRL);   {* enable external MIDI control *}
  rc:=_mcc_command(CLS_MODE);           {* enable CLS sync mode *}
  rc:=_mcc_command(MIDI_SYNCH);

  while not KeyPressed do               {* until escape *}
    begin
      _spp_efw(rc,spp_val);             {* get SPP status *}
      if rc <> 0 then                   {* if SPP received *}
        begin
          if running = 0 then           {* replace prompt *}
            begin
              GotoXY(1,23);
              ClrEol;
              GotoXY(30,23);
              write('Press ESC to return');
            end;
          running:=1;
          GotoXY(20,12);
          ClrEol;
          spp_m:=(spp_val div 16)+1;
          spp_b:=((spp_val mod 16) div 4)+1;
          write('SPP=',spp_val,' Measure(4/4)=',spp_m,' Beat(4/4)=',spp_b);
        end;
      rtcmd:=_realtime_efw;
      if rtcmd <> 0 then                {* display MIDI status *}
        begin
          GotoXY(33,14);                {* display MIDI status *}
          ClrEol;
          case rtcmd of
            $FA:                        {* start *}
              begin
                write('MIDI Start');
                GotoXY(20,12);
                ClrEol;
              end;
            $FB:                        {* continue *}
              begin
                write('MIDI Continue');
              end;
            $FC:                        {* stop *}
              begin
                write('MIDI Stop');
                GotoXY(20,12);
                ClrEol;
              end;
            else
              begin
              end
          end;
        end;
    end;

  ClrScr;
  _mcc_reset;                           {* return to coproc mode *}
  kbc:=ReadKey;                         {* clear exit key *}
end;

{*===================================*}
{*                                   *}
{* SMPTE frame trace                 *}
{*                                   *}
{*===================================*}
procedure show_smpte;

var
  rc:           integer;
  running:      integer;
  kbc:          char;
  smpte_addr:   smpte_fid;

begin
  ClrScr;
  GotoXY(15,1);
  write('MCC/MQX-32 Programmers ToolKit - SMPTE Frame Trace');
  GotoXY(21,24);
  write('Please start the tape or ESC to return');

  running:=0;
  _mcc_set_coprocslih;
  rc:=_mcc_command(ENABLE_SMPTE_MSG);
  rc:=_mcc_command(DISABLE_ALL_THRU);
  rc:=_mcc_command(DISABLE_THRU);

  rc:=_mcc_command(SMPTE_MODE);
  rc:=_mcc_command(START_SMPTE_READ);

  while not KeyPressed do               {* until escape *}
    begin
      _smpte_efw(rc,smpte_addr);        {* get frame address status *}
      if rc <> 0 then                   {* if a SMPTE frame address received *}
        begin
          if running = 0 then           {* replace prompt *}
            begin
              GotoXY(1,23);
              ClrEol;
              GotoXY(30,23);
              write('Press ESC to return');
            end;
          running:=1;
          GotoXY(36,12);                {* display frame address *}
          write((smpte_addr[0] and $1F):2,':',
                 smpte_addr[1]:2,':',
                 smpte_addr[2]:2,':',
                 smpte_addr[3]:2);
        end;
      if _strk_end_efw <> 0 then        {* check for end of track *}
        begin
          GotoXY(31,16);
          write('End of SMPTE Track');
        end;
    end;

  _mcc_reset;                           {* return to coproc mode *}
  kbc:=ReadKey;                         {* clear exit key *}
  ClrScr;
end;

{*===================================*}
{*                                   *}
{* SMPTE cue point                   *}
{*                                   *}
{*===================================*}
procedure cue_point;

var
  rc:           integer;
  running:      integer;
  kbc:          char;
  hh, mm, ss, fr: integer;
  smpte_addr:   smpte_fid;

begin
  ClrScr;
  GotoXY(11,1);
  write('MCC/MQX-32 Programmers ToolKit - SMPTE Cue Point Example');
  GotoXY(1,12);
  write('Enter cue point (hh mm ss fr): ');
  read(hh,mm,ss,fr);
  GotoXY(1,12);
  ClrEol;
  GotoXY(24,10);
  write('Cue point = ',hh:2,':',mm:2,':',ss:2,':',fr:2);

  hh:=hh or $60;

  _mcc_set_coprocslih;
  rc:=_mcc_command(DISABLE_ALL_THRU);
  rc:=_mcc_command(DISABLE_THRU);
  rc:=_mcc_command(ENABLE_SMPTE_MSG);   {* enable SMPTE frame messages *}
  rc:=_mcc_command(SMPTE_CONTROL);      {* set up the cue point *}
  _mcc_put(SMPTE_CUE_POINT);
  _mcc_put(hh);
  _mcc_put(mm);
  _mcc_put(ss);
  _mcc_put(fr);

  rc:=_mcc_command(SMPTE_MODE);
  rc:=_mcc_command(START_SMPTE_READ);

  GotoXY(21,24);
  write('Please start the tape or ESC to return');
  running:=0;

  while not KeyPressed do               {* until escape *}
    begin
      _smpte_efw(rc,smpte_addr);        {* get frame address status *}
      if rc <> 0 then                   {* if a SMPTE frame address received *}
        begin
          if running = 0 then           {* replace prompt *}
            begin
              GotoXY(1,23);
              ClrEol;
              GotoXY(30,23);
              write('Press ESC to return');
            end;
          running:=1;
          GotoXY(36,12);                {* display frame address *}
          write((smpte_addr[0] and $1F):2,':',
                 smpte_addr[1]:2,':',
                 smpte_addr[2]:2,':',
                 smpte_addr[3]:2);
        end;

      if _cuepoint_efw = 1 then
        begin
          GotoXY(32,14);                {* display frame address *}
          write('CUE POINT HIT!!');
        end;
      if _strk_end_efw <> 0 then        {* check for end of track *}
        begin
          GotoXY(31,16);
          write('End of SMPTE Track');
        end;
    end;

  _mcc_reset;                           {* return to coproc mode *}
  kbc:=ReadKey;                         {* clear exit key *}
  ClrScr;
end;

{*===================================*}
{*                                   *}
{* Write SMPTE track                 *}
{*                                   *}
{*===================================*}
procedure write_smpte;

var
  rc:           integer;
  kbc:          char;
  ohh, omm, oss, ofr: integer;
  dur:          integer;
  hh, mm:       integer;
  smpte_addr:   smpte_fid;

begin
  ClrScr;
  GotoXY(11,1);
  write('MCC/MQX-32 Programmers ToolKit - Write SMPTE Track');
  GotoXY(1,8);
  write('Enter SMPTE origin (hh mm ss fr): ');
  read(ohh,omm,oss,ofr);
  write('How many minutes of tape (1-60): ');
  read(dur);

  ohh:=ohh or $60;                      {* force 30 frame non-drop *}
  mm:=(omm+dur) mod 60;                 {* calc cue point for end *}
  hh:=ohh+((omm+dur) div 60);

  _mcc_reset;                           {* put MQX-32 into known state *}
  _mcc_set_coprocslih;

  rc:=_mcc_command(SMPTE_CONTROL);      {* set up the origin frame address *}
  _mcc_put(SMPTE_ORIGIN);
  _mcc_put(ohh);
  _mcc_put(omm);
  _mcc_put(oss);
  _mcc_put(ofr);
  rc:=_mcc_command(SMPTE_CONTROL);      {* set up the cue point *}
  _mcc_put(SMPTE_CUE_POINT);
  _mcc_put(hh);
  _mcc_put(mm);
  _mcc_put(oss);
  _mcc_put(ofr);

  writeln(#10#10'Start the tape in record mode');
  writeln('Press any key when tape is running');
  kbc:=ReadKey;

  rc:=_mcc_command(SMPTE_MODE);         {* put the MQX-32 into SMPTE mode *}
  rc:=_mcc_command(ENABLE_SMPTE_MSG);
  rc:=_mcc_command(START_RECSMPTE);     {* start writing *}

  writeln('Writing ',dur,' minutes of SMPTE track; press any key to stop');

  {* spin until end of time or asked to quit *}
  repeat
    begin
      _smpte_efw(rc,smpte_addr);        {* get frame address status *}
      if rc <> 0 then                   {* if a SMPTE frame address received *}
        begin
          GotoXY(1,18);                 {* display frame address *}
          write((smpte_addr[0] and $1F):2,':',
                 smpte_addr[1]:2,':',
                 smpte_addr[2]:2,':',
                 smpte_addr[3]:2);
        end;
    end;
  until (KeyPressed) or (_cuepoint_efw = 1);

  rc:=_mcc_command(STOP_RECSMPTE);      {* stop writing *}

  if KeyPressed then                    {* if terminated from kbd *}
    kbc:=ReadKey
  else
    begin
      writeln;
      writeln('Sync track written; press any key to continue');
      kbc:=ReadKey
    end;
  _mcc_reset;                           {* return to default mode *}
end;
end.
