	PAGE	90,132			;AN000
	TITLE	TREESYSM.SAL - INCLUDES THE COMMON SYSTEM MESSAGE HANDLER ;AN000;

;/*
; *                      Microsoft Confidential
; *                      Copyright (C) Microsoft Corporation 1991
; *                      All Rights Reserved.
; */

;****************** START OF SPECIFICATIONS *****************************
; MODULE NAME: TREESYSM.SAL

; DESCRIPTIVE NAME: Include the DOS system MESSAGE HANDLER in the SEGMENT
;		    configuration expected by the modules of TREE.

;FUNCTION: The common code of the DOS SYSTEM MESSAGE HANDLER is made a
;	   part of the TREE module by using INCLUDE to bring in the
;	   common portion, in SYSMSG.INC.  This included code contains
;	   the routines to initialize for message services, to find
;	   where a particular message is, and to display a message.

; ENTRY POINT: SYSDISPMSG:near
;	       SYSGETMSG:near
;	       SYSLOADMSG:near

; INPUT:
;    AX = MESSAGE NUMBER
;    BX = HANDLE TO DISPLAY TO (-1 means use DOS functions 1-12)
;    SI = OFFSET IN ES: OF SUBLIST, OR 0 IF NONE
;    CX = NUMBER OF %PARMS, 0 IF NONE
;    DX = CLASS IN HIGH BYTE, INPUT FUNCTION IN LOW
;   CALL SYSDISPMSG		;DISPLAY THE MESSAGE

;    If carry set, extended error already called:
;    AX = EXTENDED MESSAGE NUMBER
;    BH = ERROR CLASS
;    BL = SUGGESTED ACTION
;    CH = LOCUS
; _ _ _ _ _ _ _ _ _ _ _ _

;    AX = MESSAGE NUMBER
;    DH = MESSAGE CLASS (1=DOS EXTENDED ERROR, 2=PARSE ERROR, -1=UTILITY MSG)
;   CALL SYSGETMSG		 ;FIND WHERE A MSG IS

;    If carry set, error
;     CX = 0, MESSAGE NOT FOUND
;    If carry NOT set, ok, and resulting regs are:
;     CX = MESSAGE SIZE
;     DS:SI = MESSAGE TEXT
; _ _ _ _ _ _ _ _ _ _ _ _

;   CALL SYSLOADMSG		 ;SET ADDRESSABILITY TO MSGS, CHECK DOS VERSION
;    If carry not set:
;    CX = SIZE OF MSGS LOADED

;    If carry is set, regs preset up for SYSDISPMSG, as:
;    AX = ERROR CODE IF CARRY SET
;	  AX = 1, INCORRECT DOS VERSION
;	  DH =-1, (Utility msg)
;	OR,
;	  AX = 1, Error loading messages
;	  DH = 0, (Message manager error)
;    BX = STDERR
;    CX = NO_REPLACE
;    DL = NO_INPUT

; EXIT-NORMAL: CARRY is not set

; EXIT-ERROR:  CARRY is set
;	       Call Get Extended Error for reason code, for SYSDISPMSG and
;	       SYSGETMSG.

; INTERNAL REFERENCES:
;    ROUTINES: (Generated by the MSG_SERVICES macro)
;	SYSLOADMSG
;	SYSDISPMSG
;	SYSGETMSG

;    DATA AREAS:
;	INCLUDE TREEMS.INC ;message defining control blocks
;	INCLUDE SYSMSG.INC   ;Permit System Message handler definition
;	INCLUDE COPYRIGH.INC ;Standard copy right notice
;	INCLUDE MSGHAN.INC   ;Defines message control blocks STRUCs
;	INCLUDE VERSIONA.INC ;INCLUDEd by code generated by SYSMSG.INC
;	INCLUDE PATHMAC.INC - PATHGEN MACRO

; EXTERNAL REFERENCES:
;    ROUTINES: none

;    DATA AREAS: control blocks pointed to by input registers.

; NOTES:
;	 This module should be processed with the SALUT preprocessor
;	 with the re-alignment not requested, as:

;		SALUT TREESYSM,NUL

;	 To assemble these modules, the alphabetical or sequential
;	 ordering of segments may be used.

;	 For LINK instructions, refer to the PROLOG of the main module,
;	 TREE.SAL.

;
;
;****************** END OF SPECIFICATIONS *****************************
	IF1				;AN000;
            ;%out    COMPONENT=TREE, MODULE=TREESYSM.SAL... ;AN000;
	ENDIF				;AN000;
	INCLUDE PATHMAC.INC		;AN013;

;	INCLUDE SYSMSG.INC
.XLIST					;AN000;
	INCLUDE SYSMSG.INC		;AN000;PERMIT SYSTEM MESSAGE HANDLER DEFINITION
.LIST					;AN000;
	MSG_UTILNAME <TREE>		;AN000;IDENTIFY THE COMPONENT
; =  =	=  =  =  =  =  =  =  =	=  =

CSEG	SEGMENT PARA PUBLIC 'CODE'	;AN000;
	ASSUME	CS:CSEG 		;AN000;ESTABLISHED BY CALLER
	ASSUME	SS:CSEG 		;AN000;ESTABLISHED BY CALLER
	ASSUME	DS:CSEG 		;AN000;ESTABLISHED BY CALLER
	ASSUME	ES:CSEG 		;AN000;ESTABLISHED BY CALLER

	INCLUDE MSGHAN.INC		;AN000;DEFINE MESSAGE HANDLER CONTROL BLOCKS
	INCLUDE TREEMS.INC		;AN000;DEFINE THE MESSAGES, AND CONTROL BLOCKS
	MSG_SERVICES <TREE.CLA,TREE.CL1,TREE.CL2> ;AN000;MESSAGE TEXTS
	MSG_SERVICES <MSGDATA>		;AN000;SYS MSG HANDLER WORKAREAS
; =  =	=  =  =  =  =  =  =  =	=  =
	PUBLIC	SYSLOADMSG		;AN000;
	PUBLIC	SYSDISPMSG		;AN000;
	PUBLIC	SYSGETMSG		;AN002;
;	INCLUDE COPYRIGH.INC		;TO BE INCLUDED BY THE MSG_SERVICES	;AN011;
	PATHLABL TREESYSM		;AN013;
					;DEFAULT=CHECK DOS VERSION
					;DEFAULT=NEARmsg
					;DEFAULT=NO INPUTmsg
					;DEFAULT=NO TIMEmsg
					;DEFAULT=NO DATEmsg
;	MSG_SERVICES <LOADmsg,DISPLAYmsg,GETmsg,CHARmsg,NUMmsg> 		       ;AN027;
.xlist					;AN000;
.xcref					;AN000;
	MSG_SERVICES <LOADmsg,DISPLAYmsg,GETmsg,CHARmsg,NUMmsg> ;AN027; 		     ;AC002;
.cref					;AN000;
.list					;AN000;
; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
	PATHLABL TREESYSM		;AN013;
LAST_BYTE EQU	$			;AN000;START OF AREA AVAIL FOR STACK
	PUBLIC	LAST_BYTE		;AN000;

include msgdcl.inc

CSEG	ENDS				;AN000;
	END				;AN000;


