/*	new_mclk.cpp                    		v0.85		12/11/95
 *
 *	An attempt to make a better (C++) video card utility program!
 *
 *	1)	the chips.lib, which acts as an interface to the actual chip-
 *		registers...
 *
 *		The first call in the program is to _detect(), which returns a
 *		pointer to a structure called "vga" (which is actually "cirrus"
 *		or "s3", depending on what my _detect() routine finds.
 *
 *	2)	this program...which acts like a front-end (user-interface)
 *		so we've got a command-line interface, sorry it's still a bit
 *		rough around the edges
 *
 *	Notes... compiled with Turbo C++ 3 (DOS), LARGE memory model,
 *	...you must DISABLE <debug info in .OBJ>, if you recompile
 *		(it's under Options -> Compiler -> Advanced Code Generation
 *
 *	v0.82 - added multiple command parsing, a "/X" command denotes the
 *		function to activate, while the following non-slashed parameters
 *		(eg. MCLK /X y z) are passed on the selectd MCLK function.
 *
 *	v0.83 - added _info readout, so ::_info only returns information about
 *		installed RAM (EDO/burst/1-cycle), with S3-86x/96x/Trio chipsets
 *
 *	v0.85 - modified program-code to use C++ streams instead of <stdio.h>
 *		still have some more routines to clean-up.
 *		added '/F' option to (f)orce user (override auto-detection)
 *
 *	07/28 Removed some unused (sloppy) code
 *
 *	If used, "/F" must be the FIRST command-line parameter...
 */


#define DEBUG	0
#define PARAM_SIZE	30

#include "vga.h"
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>

extern int _argc;		//	Command-line parameters
extern char **_argv;


void
main( void )
{
	vga_info chipset;	//	Temp var for holding vga chipsetID
	detect *find_vga = new detect;	//	Finds vga-card
	message msg;		//	Another temp var for holding text messages
	int i, op, switches = 0;	//	Stratch integers
		//	"switches" = # of NON-parameter related arguments
	int n, copied, index;    //	temp Return variable for sscanf
	char *param[ PARAM_SIZE ];	//	Parameter table

	vga *hardware = NULL;


	// Following code checks for manual videochipset selection "/F" or "F"
	// MCLK /F or MCLK /f or MCLK F or MCLK f

//	cout << "argv[ 1 ]= " << _argv[ 1 ] << "_argc = " << _argc;

	if ( _argc > 1 && _argv[ 1 ] )	{
		if ( !strcmpi( _argv[ 1 ], "/F" ) || !strcmpi( _argv[ 1 ], "F" ) ){
			// override autodetection
			switch( _argc )	{
				case 2:	msg = find_vga->_help();
					cout << msg.text ;
				// Display help about manually selecting video chipset
					exit( EXIT_SUCCESS );
					break;
				case 3:	msg = find_vga->_help( atoi( _argv[ 2 ] ) );
					cout << msg.text ;
					exit( EXIT_SUCCESS );
					break;
				default:	hardware = find_vga->_find(
						atoi( _argv[ 3 ] ), atoi( _argv[ 2 ] ) );
					// _find( chipset, family );
					i = 4;	// Skip "/F %1 %2"
			}
		}
	}

	if ( hardware == NULL )	{
		hardware = find_vga->_find();
		i = 1;
	}
		//	Chipset specific object, all calls through here


	cout << "\nVideo card MCLK utility v0.90eta 07/28/96, chips_lib ";
	cout << hardware->version() << "\nFAMILY= ";

	chipset = hardware->get_info();
	cout << chipset.make << " ... CHIP= " << chipset.chipset;
	cout << " ... REVISION: " << chipset.revision << "\n";
	msg = hardware->_info();		// Get any specific chipset
	cout << msg.text << "\n\n";

	if ( strcmpi( chipset.make, "vga" ) == 0 )	{
		cerr << "\nError, could not detect() installed chipset.";
		cerr << "\n...try the '/F' command-line option";
		exit( EXIT_FAILURE );
	}

	//	The following few lines prepare a "parameter table", which is
	//	needed by my "vga" class.

/*	hardware->num_param = _argc - 2 - switches;	// Prepare parameter table
	if ( hardware->num_param < 0 )
		hardware->num_param = 0;
	hardware->param = param;
	paramcpy ( hardware->param, _argv + 2 + switches, 2 - switches );
		// Copy first set of useable parameters to hardware->v_argv */

	// i == first active command parameter
	// (i not necessarily ==0, eg. "/F" used)

	do	{	// Keep on scanning command-line parameters until none left

	n = 0;	// Reset n, just incase sscanf() never executed
//	cout << "_argv[" << i << "] = " << _argv[ i ] << '\n';
	if ( _argv[ i ] && _argv[ i ][ 0 ] == '/' )
		n = sscanf( _argv[ i ] + 1 , " %d", &op );
	else if ( _argv[ i ] && i == 1 )	// For 1st param only, no '/' needed
		n = sscanf( _argv[ i ], " %d", &op );

	if ( n==0 )	{  //  If user invoked MCLK with no parameters,
		// Then display menu of options for given video chipset
		msg = hardware->get_settings();	//	get video card settings
		cout << "Adjustable settings:\n" << msg.text ;	// display them
		msg = hardware->get_vgahelp();	//	get video help
		cout << "\n" << msg.text;	// Display general help information
		exit( EXIT_SUCCESS );
	}

	++i;

	copied = 0;
	while ( i < _argc && _argv[ i ] && _argv[ i ][ 0 ] != '/' )
		param[ copied++ ] = _argv[ i++ ];

	hardware->num_param = copied;	// # of parameters loaded into table
	hardware->param = param;	//	Set-up vga-table's pointer to param

	if ( op > _MAXOPTIONS )	{
		cerr << "\nInvalid FXN" << op << " choice.  ";
		cerr << "Valid choices are 0 through " << _MAXOPTIONS;
		exit( EXIT_FAILURE );
	}

	if ( hardware->num_param > 0 )
		hardware->go( op , _SET );	// >1 param(s), run _SET
	else
		hardware->go( op , _HELP );	// not enough params, run _HELP

	cout << hardware->msg.text << "\n";	// display return-message

	if ( hardware->status == EXIT_FAILURE )	{
		cout << "\nERROR, operation" << op << " failed!";
		exit( hardware->status );
	}

	}	while ( i < _argc );

}