Updated June 18, 1996
________________________________________________________________________

Models DFMS-S1x, S2x, S3x, S4x, & S5x                IBM Hard Disk Drive
________________________________________________________________________
http:\\www.storage.ibm.com\storage\techsup\hddtech\hddtech.htm



High capacity 3.5" SCSI  1.32-5.31 GB,  1993

The DFMS models offer exceptional performance and reliability
with capacities up to 5.3GB.  The drives spin at 5400rpm and,
with an industry leading areal density, 2.6GB of storage is packed
in a 1 inch high drive and 5.3GB in a 1.6 inch high drive.



APPLICATIONS
============
 - Technical/Commercial workstations
 - Network servers
 - Mass storage arrays
 - High end personal computers



FEATURES
--------

*  1.32/2.32/2.65/4.32/5.31GB formatted capacity (at 512 bytes/sector)
*  Industry standard interface
    - 50 pin ANSI SCSI-2
    - 68 pin ANSI SCSI-3
    - single ended or differential (50/68 pin)
    - single connector attachment (SCA 80 pin)
*  7.65/12.58 MB/s media data rate; 13 bands
*  Rotational speed 5400 rpm
*  Average read seek time 7.8ms (1.32/2.32/2.65GB) 8.4ms (4.32/5.31GB)
*  Latency 5.55 ms
*  Magneto resistive heads
*  PRML data channel (partial response maximum likelihood with digital
   filter)
*  Spindle synchronization
*  User configurable block sizes
*  512KB multi-segmented dual port data buffer
*  Drive supported SCSI bus terminator power
*  Industry standard mounting
*  Low command overhead
*  Read ahead caching
*  ECC on the fly
*  Write cache support
*  Predictive failure analysis
*  MTBF 1,000,000 hours



BENEFITS
--------

*  Popular capacity points
*  Range of SCSI interfaces to suit application.  High interface
   data rate
*  Exceptionally high data rate across entire disk surface
*  Fast access to data
*  Industry leading areal density 578MB/sq in
*  Robust data channel for improved data integrity
*  Data server applications
*  Compatible with many software systems
*  Fast data retrieval in multi-tasking environments
*  Easy integration across multiple platforms
*  Easy installation
*  Improved data throughput
*  Industry leading reliability



ELECTRICAL CONNECTOR LOCATIONS
------------------------------

The electrical connectors are located as shown.


Electrical Connectors (rear view) 80 Pin SCA models


            /                                               /
           /                     /  /                      /
          /                                               /
         /                     /  /                      /
        /                                               /
       /_________________    /  /   ___________________/
       |                /__________/|                  |
       |                |         | |                  |
       |                |   |  |  | |                  |
       |                |         | |                  |
       |                |   |  |  | |                  |
       |                |         | |                  |        /
       |                |   |  |  | |                  |       /
       |                |         | |                  |      /
       |________________|   |  |  | |__________________|     /
       |                |_________|/                   |    /
       |         __________________________            |   /
       |        /                          \           |  /
       |       /  ========================  \          | /
       |______/___|__________________________\_________|/
                  |
                  |
                Pin 1

  Note:  See Electrical Interface Specifications section for
         power pin assignments.





Electrical Connectors (rear view) 68 Pin models


            /                                               /
           /                     /  /                      /
          /                                               /
         /                     /  /                      /
        /                                               /
       /_________________    /  /   ___________________/
       |                /__________/|                  |
       |                |         | |                  |
       |                |   |  |  | |                  |
       |                |         | |                  |
       |                |   |  |  | |                  |
       |                |         | |                  |        /
       |         SCSI Pin 1 |  |  | |   Aux Pin 1      |       /
       |                | |       | |   |              |      /
       |________________| | |  |  | |___|______________|     /
       |                |_|_______|/    |              |    /
       | _________________|____  _______|_   ________  |   /
       | \  ...............   / | ....... | /        \ |  /
 SCSI-->  \ ...............  /  | ....... | | O O O O |<---- Power
       |___\______________|_/___|_______|_|_|_______|_||/
                          |             |           |
                          |             |           |
                 SCSI Pin 35       Aux Pin 2        Power Pin 1




Electrical Connectors (rear view) 50 Pin models


            /                                               /
           /                     /  /                      /
          /                                               /
         /                     /  /                      /
        /                                               /
       /_________________    /  /   ___________________/
       |                /__________/|                  |
       |                |         | |                  |
       |                |   |  |  | |                  |
       |                |         | |                  |
       |                |   |  |  | |                  |
       |                |         | |                  |        /
       |                |   |  |  | |   SCSI Pin 1     |       /
       |                |         | |   |              |      /
       |________________|   |  |  | |___|______________|     /
       |                |_________|/    |              |    /
       | _______________________________|_   ________  |   /
       || . . . . . . . . . . . . . . . . | /        \ |  /
 SCSI-->| . . . . . . . . . . . . . . . . | | O O O O |<---- Power
       ||_________________________________|_|_______|_||/
                                                    |
                                                    |
                                                    Power Pin 1





Jumper Pin Locations (front view)--all models


             /                                               /
            /                     /  /                      /
           /                            ___________________/
          /                     /  /   /|                 /
         /                            / |                /
        /                     /  /   /  |               /
       /____________________________/   |              /
       |                            |   |              |
       |                    |   |   |   |              |
       |                            |   |______________|
       |                    |   |   |  /_______________|
       |                            | |                |
       |                    |   |   | |                |        /
  Option Jumper Block               | |                |       /
          Pin 1             |   |   | |                |      /
       |  |                         | |________________|     /
       |__|_________________________|/_________________|    /
       | _|________________     __                     |   /
       || .... ........... |   |..|                    |  /
       || ................ |    --                     | /
       |__|_____________________|______________________|/
          |                     |
          |                     |
      Pin 2                    Termination Power Enable Pin 1





<:O! WARNING:  This disk drive can be damaged by Electro-Static
Discharge.  Please follow recommended ESD procedures before
unpacking or handling the drive.  Ask your IBM marketing
representative for details if you need assistance.



OPTION JUMPER BLOCKS
--------------------

DFMS models contain a jumper block that can be used to enable certain
features and select the SCSI ID of the drive.  This jumper block is
referred to as the 'Front' Option Jumper Block due to it's location
on the drive (opposite the SCSI connector).  This jumper block varies
in pin definition based on interface type (50, 68, Differential, SCA).

The Option Block connector (2 x 16) used on 50 pin models is an AMP
connector (PN 84156-4) having a pin spacing of 2mm.

The Option Block connector (2 x 16) used on the 68 and 80 pin models
is an AMP connector (PN 84156-5) having a pin spacing of 2mm.


50/68 Pin Models

                                 Pin
                            ______________
  Ground Pin   ------------ | o  2   1 o | -----  SCSI_ID 3 (MSB, 68-pin only)
  Ground Pin   ------------ | o  4   3 o | -----  SCSI_ID 2 (MSB, 50-pin)
  Ground Pin   ------------ | o  6   5 o | -----  SCSI_ID 1
  Ground Pin   ------------ | o  8   7 o | -----  SCSI_ID 0 (LSB)
  Unused       ------------ | o 10   9   | -----  Blank (Polarity)
  Ground Pin   ------------ | o 12  11 o | -----  Auto Start
**Enable Active Termination | o 14  13 o | ----- +5V **
  Slave Sync   ------------ | o 16  15 o | -----  Master Sync
 +5V           ------------ | o 18  17 o | -----  External Activity LED
  Ground Pin   ------------ | o 20  19 o | -----  Write Protect
  Ground Pin   ------------ | o 22  21 o | -----  Auto Start Delay
  Ground Pin   ------------ | o 24  23 o | -----  Option Block Mode
  Ground Pin   ------------ | o 26  25 o | -----  Disable T.I. Sync Negotiation
  Ground Pin   ------------ | o 28  27 o | -----  Disable SCSI Parity
  Ground Pin   ------------ | o 30  29 o | -----  Disable Unit Attention
  Ground Pin   ------------ | o 32  31 o | -----  Customizing
                            ______________

      NOTE 1: If the Auto Start Shunt is not on, the file starts by SCSI
              command only
      NOTE 2: Models with 50 pin SCSI connectors do not have Pins 1 & 2.
      NOTE 3: Pin 13 is Enable Narrow Mode on 80-pin SCA and 68-pin
               differential models.
      NOTE 4: Pin 14 is Ground on on 80-pin SCA and 68-pin differential
               models.

      Note:  Pins 2, 4, 6, 8, 12, 20, 22, 24, 26, 28, 30, and 32 are Ground.



SCSI ID (ADDRESS) PINS
----------------------

Note:  In the address determination tables "off" means jumper
is not in place and "on" means jumper is in place.

Address Determination--68 and 80 Pin Models


  Bit3    Bit2    Bit1    Bit0    Address
  off     off     off     off        0
  off     off     off     on         1
  off     off     on      off        2
  off     off     on      on         3
  off     on      off     off        4
  off     on      off     on         5
  off     on      on      off        6
  off     on      on      on         7
  on      off     off     off        8
  on      off     off     on         9
  on      off     on      off       10
  on      off     on      on        11
  on      on      off     off       12
  on      on      off     on        13
  on      on      on      off       14
  on      on      on      on        15


Address Determination of 50 Pin Models


  Bit2    Bit1    Bit0    Address
  off     off     off       0
  off     off     on        1
  off     on      off       2
  off     on      on        3
  on      off     off       4
  on      off     on        5
  on      on      off       6
  on      on      on        7



68 Pin Auxiliary Connector


The 68 pin models contain an "Auxiliary" connector that replicates
some of the functions contained in the Front Option Jumper Block.
The Auxiliary connector signal definition conforms to the SCSI
document SFF-8009 Rev 2 with the following exceptions:

1.  EXTERNAL FAULT (XTFALT-) is not supported on pin 2.
2.  AUTO SPIN START was chosen as the "vendor unique" signal
    assignment (on pin 4).  (This signal is an input to the
    drive.  The SCSI spec (SCSI SFF-8009) specifies this pin
    as an output.)  This signal should be useful for those
    applications that want to "auto-start" the drive based on
    location dependent SCSI ID.

    This pin should be handled in one of the following ways:

    a.  tied to ground (auto spin start enabled)
    b.  allowed to "float" (no connection)
    c.  driven with an open collector driver (> 1 mA sink
        capability)

    Refer to auxiliary connector diagram below.


68 Pin Auxiliary Connector Pin Assignments


                               Pin
                          ______________
  Unused       ---------- | o  2   1 o | ---------  SCSI ID 0 (LSB)
  Auto Spin Start ------- | o  4   3 o | ---------  SCSI ID 1
  Slave Sync   ---------- | o  6   5 o | ---------  SCSI ID 2
  External Activity LED - | o  8   7 o | ---------  SCSI ID 3 (MSB)
  Ground       ---------- | o 10   9   | ---------  Enable Active Termination
  Write Protect --------- | o 12  11 o | --------- +5V
                          ______________




Auto Start (& Delay) Pins


The Auto Start and Auto Start Delay pins control when and how the drive
can spin up and come ready.  When configured for Auto-Startup, the motor
spins up after power is applied without the need of a SCSI Start Unit
command.  For no Auto-Start, a SCSI Start Unit command is required to
make the drive spin and be ready for media access operations.  When in
Auto-Start mode, the drive will delay its start time by a period of
time multiplied by its own SCSI address.


Auto-Startup Modes selectable by Auto-Start/Delay Pin Combinations


       Pins (50 and 68
     interface pin models)           Drive Behavior


Auto Start     Auto Start     Auto Startup     Delay(sec)
  Delay                          Mode?         Multiplier
- - - - - -    - - - - - -    - - - - - - -    - - - - - -
   off           off              No              N/A
   off           on               Yes              0
   on            off              Yes             10
   on            on               Yes              4


       Pins
(80 interface pin models)            Drive Behavior
- - - - - - - - - - - - - -   - - - - - - - - - - - - - - -
Auto Start      Auto Start    Auto Startup     Delay(sec)
  Delay                          Mode?         Multiplier

   off           off              YES              0
   off            on               NO             N/A
    on           off              YES             10
    on            on               NO             N/A



External Activity (LED) Pins


The LED pins can be used to drive an external drive Light Emitting
Diode.  Please refer to the LED pin section of the DFMS Interface
Specification for a detailed functional description of this pin.

Up to 33 mA (plus or minus 5%) of TTL level LED drive capability
is provided.  Current limiting for the LED is provided on the
electronics card.  The LED Anode may be tied to the +5V source
provided on pin 18 of the Front Option Jumper Block, pin 11 of the
Auxiliary connector on the 68 pin Unitized connector or the 5V
power source on the 80 pin SCA model.  The LED Cathode is then
connected to the EXTERNAL ACTIVITY Pin to complete the circuit.
Note:  This set of pins can be used to drive an LED located
in a bezel connected to the front of the drive or to an external
LED in systems where the front of the drive cannot be easily seen.


Note:  68 pin and 80 pin SCA SCSI models have two sets of pins, a set
on the front and a set on the back, that are connected to the same LED
driver circuit.  The combined drive capability is stated above.


Write Protect Pins


If the Write Protect pin is jumpered to ground, the drive will
prohibit SCSI commands that alter the customer data area portion
of the media from being performed.  The state of this pin is monitored
on a per command basis.  See the DFMS interface specification for
functional details.


Option Block Mode Pin


The Option Block Mode pin is used to modify the function of the
Front Option Jumper Block.  When the Option Block Mode Pin is not
grounded the pin function of the Front Option Jumper Block will be as
defined by the upper portion of the referenced figures.  When the
Option Block Mode Pin is grounded the pins (25, 27, 29, 31) will be
redefined to control what is referred to as 'Alternate Mode."

"Alternate Mode" allows tailoring of SCSI options such as "boot up"
characteristics and other operational features on a per customer
basis.

Please contact your IBM Customer Representative for functional details
on the customization of function allowed by this mode.

The state of these pins immediately after power is applied to the drive
will determine their function.


Disable T.I. Sync. Negotiation Pin


If a Disable Target Initiated Synchronous Negotiation pin is grounded
then an Initiator is required to start a negotiation handshake if
Synchronous and/or 'Wide' (Double Byte) SCSI transfers are desired.
Please refer to the DFMS Interface Specification for more details on
this feature.


Disable SCSI Parity Pin


Grounding this pin will disable SCSI Parity checking


Disable Unit Attention Pin


Grounding this pin will disable the drive from building Unit
Attention Sense information for commands immediately following a
Power On Reset (POR) or SCSI Bus Reset.  Any pending Unit Attention
conditions will also be cleared at POR or SCSI Reset times.


Customizing Pin


The customizing pin is currently reserved for future use.


Enable Narrow Mode


Jumpering pin 14 to pin 13 will cause the 68 pin Differential or
the 80 pin SCA to operate in a Single Byte mode.  The drive will not
negotiate for 'Wide' (Double Byte) operation.  The drive will terminate
the unused upper byte and upper byte parity on the SCSI Bus


Enable Active Termination


Upon request, Single Ended 50 and 68 pin models are available with
on card SCSI bus Active terminators.  (Please contact your IBM
Customer Representative for the appropriate card PN.)

For those cards having the Active Termination feature, this function
can be enabled by installing a jumper between pins 13 and 14 of the
Front Option Jumper Block or connecting pins 9 and 11 of the
Auxiliary Connector on 68 SCSI pin models.



DATA ORGANIZATION
-----------------

Note:  The recording band located nearest the disk outer diameter (OD)
is referred to as 'Notch No 1'.  While the recording band located
nearest the inner diameter (ID) is called 'Notch No 13'.  'Average'
values are weighted with respect to the number of LBAs per notch
when the drive is formatted with 512 byte blocks.

Data Transfer Rates


  Notch                          No.1      No.13     Average
                                 - - -     - - -     - - - -
    Buffer to/from media         12.58      7.65      10.87
                                 MB/s (instantaneous)

  Host to/from buffer            up to 20.0 MB/s
                                 (synchronous)(sustained)
  Data buffer size (bytes)       512K
  Rotational speed (RPM)         5402.05
  Average latency (milliseconds) 5.55
  Track density (TPI)            4352

                                   Min         Max
                                   - - - -     - - - -
  Recording density (BPI)          115,289     132,817
  Areal density (Megabits/sq in)    501.8       578.1

  Model/Numbers                    S5x    S4x    S3x    S2x    S1x
                                   ---    ---    ---    ---    ---
  Disks                             8      7     4      4      2
  User data heads (trk/cyl)        16     13     8      7      4
  Seek times (in milliseconds)
     Single Cylinder (Read)        0.6    0.6   0.6    0.6    0.6
                     (Write)       2.5    2.5   2.5    2.5    2.5
     Average (weighted) (Read)     8.4    8.4   7.8    7.8    7.8
                        (Write)    9.9    9.9   9.3    9.3    9.3
     Full stroke     (Read)        16.5   16.5  16.5   16.5   16.5
                     (Write)       19.0   19.0  19.0   19.0   19.0

Notes:  Times are typical for a drive population under nominal voltages
and casting temperature 25 degrees Celsius.  Weighted seeks are seeks
to the cylinders of random logical block addresses (LBAs).


Total Cylinders (tcyl) and User Cylinders (ucyl)


           All models   S5x      S4x      S3x      S2x      S1x
           ----------   ----     ----     ----     ----     ----
               tcyl     ucyl     ucyl     ucyl     ucyl     ucyl

Notch No. 1    1183     1170     1169     1168     1167     1165
Notch No. 2     200      199      199      199      199      199
Notch No. 3     251      250      250      250      250      250
Notch No. 4     108      107      107      107      107      107
Notch No. 5     374      373      373      373      373      373
Notch No. 6     151      150      150      150      150      150
Notch No. 7     265      264      264      264      264      264
Notch No. 8     228      227      227      227      227      227
Notch No. 9     176      175      175      175      175      175
Notch No.10     246      245      245      245      245      245
Notch No.11      52       51       51       51       51       51
Notch No.12     929      928      928      928      928      928
Notch No.13     253      251      251      251      251      251

Sum of all
 Notches       4416     4390     4389     4388     4387     4385


Spare Sectors/cylinder (spr/cyl)


                S5x      S4x      S3x      S2x      S1x
                ---      ---      ---      ---      ---
Notch No. 1      53       43       27       23       13
Notch No. 2      51       41       25       22       13
Notch No. 3      50       40       25       22       12
Notch No. 4      49       40       24       21       12
Notch No. 5      47       38       24       21       12
Notch No. 6      46       37       23       20       11
Notch No. 7      44       36       22       19       11
Notch No. 8      43       35       21       19       11
Notch No. 9      41       34       21       18       10
Notch No.10      40       32       20       17       10
Notch No.11      39       32       20       17       10
Notch No.12      36       29       18       16        9
Notch No.13      31       25       16       14        8
Last cylinder
  extra spares   62       50       32       28       16


User bytes/sector


     256-744 (even number of bytes only)


Sectors/logical block


     1-8
     The lowest sectors/lba that satisfies the following rules is used:
     1.  Block Length is evenly divisible by a number 2-8.
     2.  Quotient of previous equation is evenly divisible by 2.
     3.  Quotient must be greater than or equal to 256 and less than
         or equal to 744.


User bytes/logical block


     256-5952


Gross sectors per track for several block lengths


                                Notch Number

User bytes/   1   2   3   4   5   6   7   8  9   10  11  12  13
logical
block
256          288 280 270 270 260 240 240 240 240 220 216 180 180
512          180 171 168 165 160 164 150 144 140 135 133 120 105
520          171 168 165 160 154 150 144 140 137 133 132 109 102
522          171 168 163 160 154 150 144 140 137 132 120 108 102
524          171 168 160 160 154 150 144 140 137 132 120 108 102
528          171 168 160 160 154 150 144 140 135 120 120 108 102
688          137 135 130 129 120 120 120 120 109 105 105  87  80
744          129 120 120 120 120 120 108 105 102  98  98  80  76


User capacity for several block lengths
---------------------------------------

        S5x Models
        - - - - - -
User bytes/   formatted capacity     logical blocks/
logical block     (bytes)                 drive
256            4,287,613,696            16,748,491
512            5,318,080,000            10,386,875
520            5,153,496,920             9,910,571
522            5,154,233,742             9,874,011
524            5,167,693,764             9,862,011
528            5,166,743,472             9,785,499
688            5,436,451,472             7,901,819
744            5,484,002,424             7,370,971

        S4x Models
        - - - - - -
User bytes/   formatted capacity     logical blocks/
logical block     (bytes)                 drives
256            3,484,894,336           13,605,056
512            4,320,075,264            8,437,647
520            4,186,398,840            8,050,767
522            4,186,994,364            8,021,062
524            4,197,927,488            8,011,312
528            4,197,149,088            7,949,146
688            4,416,339,424            6,419,098
744            4,454,988,672            5,987,888

        S3x Models
        - - - - - -
User bytes/   formatted capacity     logical blocks/
logical block     (bytes)                 drives
256            2,142,450,432           8,368,947
512            2,657,211,904           5,189,867
520            2,574,966,680           4,951,859
522            2,575,328,238           4,933,579
524            2,582,051,396           4,927,579
528            2,581,562,544           4,889,323
688            2,716,242,576           3,948,027
744            2,739,951,864           3,682,731

        S2x Models
        - - - - - -
User bytes    formatted capacity     logical blocks/
logical block     (bytes)                 drives
256            1,874,287,104           7,321,434
512            2,324,733,440           4,540,495
520            2,252,796,520           4,332,301
522            2,253,111,732           4,316,306
524            2,258,993,344           4,311,056
528            2,258,563,296           4,277,582
688            2,376,479,968           3,454,186
744            2,397,248,352           3,222,108

        S1x Models
        - - - - - -
User bytes    formatted capacity     logical blocks/
logical block     (bytes)                 drives
256            1,070,519,040           4,181,715
512            1,327,857,152           2,593,471
520            1,286,779,000           2,474,575
522            1,286,957,070           2,465,435
524            1,290,315,940           2,462,435
528            1,290,066,096           2,443,307
688            1,357,470,096           1,973,067
744            1,369,343,160           1,840,515



MODE SELECT OPTIONS
===================

Certain parameters are alterable using the SCSI 'Mode Select' command.
This allows certain drive characteristics to be modified to optimize
performance on a particular system.  Refer to the DFMS SCSI Functional
Specification for a detailed definition of Mode Select parameters.



DC POWER REQUIREMENTS LIMITS
============================

The following voltage specifications apply at the driver power connector.
There are no special power on/off sequencing requirements.
  +12 Volt Supply
      +/- 5.0%        (during run)
      +5.0% / -7.0%   (during spin-up)
  + 5 Volt Supply
      +/- 5.0%        (during run and spin-up)


  S1x, S2x, and S3x Power Supply Current +5VDC
  --------------------------------------------
                                 Population
                   Notes         Mean

  Idle average                   .690 Amps  (note 1)
  R/W average                    .98 Amps
  R/W pulse      Base-to-peak    .28 Amps


  S4x Power Supply Current +5VDC
  ------------------------------
                    Notes        Population
                                 Mean

  Idle average                   .720 Amps
  R/W average                    1.01 Amps
  R/W pulse     Base-to-peak     0.33 Amps


  S5x Power Supply Current +5VDC
  -------------------------------
  Idle average                   .740 Amps
  R/W average                    .961 Amps
  R/W pulse     Base-to-peak     .392 Amps


  S1x Power Supply Current +12VDC
  -------------------------------
  Idle average                   0.17 Amps
  Seek average  1 op/sec         .0027 Amps
  Seek peak                      1.2 Amps (note 2)
  Spin-up       1.5 sec max      1.3 Amps (note 3)


  S2x and S3x Power Supply Current +12VDC
  ---------------------------------------
  Idle average                   .256 Amps
  Seek average  1 op/sec         .003 Amps
  Seek peak                      1.2 Amps (note 2)
  Spin-up       1.5 sec max      1.3 Amps (note 3)


  S4x Power Supply Current +12VDC
  -------------------------------
  Idle average                   0.34 Amps
  Seek average  1 op/sec         0.004 Amps
  Seek peak                      1.2 Amps  (note 2)
  Spin-up       1.5 sec max      1.8 Amps  (note 3)


  S5x Power Supply Current +12VDC
  -------------------------------
  Idle average                   0.38 Amps
  Seek average  1 op/sec         0.051 Amps
  Seek peak                      1.58 Amps (note 2)
  Spin-up       1.5 sec max      1.8 Amps  (note 3)

  Notes:
  1.  5V current is given with termination power provided
      by the using system.
  2.  The idle average and seek peak should be added together to
      determine the total 12 volt peak current.
  3.  The current at start is the total 12 volt current required
      (ie, the motor start current, module current and voice coil
      retract current).



Externally generated ripple
===========================
 (as seen at drive power connector)

  Voltage         Maximum                Notes
  - - - - -       - - - - - - - - - -  - - - - -
  +5V DC          150mV peak-to-peak   0-20 MHz
  +12V DC         150mV peak-to-peak   0-20 MHz

During drive start up and seeking, 12 volt ripple is generated by
the drive (referred to as dynamic loading).  If several drives have
their power daisy-chained together then the power supply ripple plus
other drive's dynamic loading must remain within the regulation
tolerance widow of +/- 5%.  A common drive supply with separate
power leads to each drive is a more desirable method of power
distribution.



MODELS
======

The DFMS disk drive is available in the following capacities:
    DFMS-31080      1.0GB
    DFMS-32160      2.0GB
    DFMS-32600      2.6GB
    DFMS-342320     4.3GB
    DFMS-35250      5.0GB

The DFMS capacities vary as a function of model and user block size.
The emerging Industry Standard Capacity points are multiples of 1.08 GB
(ie 1.08/2.16/4.32) at a block size of 512 bytes.  This and future
products will plan to provide capacities that are consistent with
this standard.

Users who choose to make full use of the DFMS drive capacity above
the standard capacity may not find equivalent capacity breakpoints
in future products.

             Capacity GB    SCSI Pins/       SCSI Electrical
  Model No.  (at 512 Byte)  Connector Type   Signal Type
  ---------  -------------  --------------   ---------------
  S1F        1.32           50               SEF
  S1W        1.32           68               SEF/W
  S1E        1.32           68               DF/W
  S1S        1.32           80 SCA           SEF/W

  S2F        2.32           50               SEF
  S2W        2.32           68               SEF/W
  S2E        2.32           68               DF/W
  S2S        2.32           80 SCA           SEF/W

  S3F        2.65           50               SEF
  S3W        2.65           68               SEF/W
  S3E        2.65           68               DF/W
  S3S        2.65           80 SCA           SEF/W

  S4F        4.32           50               SEF
  S4W        4.32           68               SEF/W
  S4E        4.32           68               DF/W
  S4S        4.32           80 SCA           SEF/W

  S5F        5.31           50               SEF
  S5W        5.31           68               SEF/W
  S5E        5.31           68               DF/W
  S5S        5.31           80 SCA           SEF/W

  Note:
  "SEF" stands for Single Ended Fast
  "SEF/W" stands for Single Ended Fast/Wide
  "DF/W" stands for Differential Fast/Wide

  Notes:

  - 50 pin SCSI connector models offer an 8-bit SCSI bus using
     the SCSI 'A' connector.
  - 68 pin SCSI connector model offers an 8/16-bit SCSI bus using
     the SCSI 'P' connector which supports wide data transfers.
  - 80 pin SCSI connector models offer an 8/16-bit SCSI bus using
     the SCA   connector.
  - All models support Fast SCSI data transfers.



OPERATING ENVIRONMENT
=====================

The drive operates within its performance limits when the following
environment is maintained.  Product life calculations are based on the
nominal environment for a typical application.

  Humidity:
  ---------
  Operating              5% to 90% noncondensing
  Storage                5% to 95% noncondensing
  Shipping               5% to 100%
                         (applies at a packaged level)

  Wet Bulb Temperature:
  ---------------------
  Operating and Storage  80 degrees F (26.7 degrees C) maximum
  Shipping               85 degrees F (29.4 degrees C) maximum

  Elevation:
  ----------
  Operating              -1,000 to 10,000 feet
                         (-304 to 3,048 meters)
  Shipping/storage       -1,000 to 40,000 feet
                         (-304 to 12,192 meters)

  Temperature:
  ------------
  Operating ambient      41 to 131 degrees F (5 to 55 degrees C)
  Operating casting      41 to 158 degrees F (5 to 60 degrees C)
  temperature
  Shipping               -40 to 149 degrees F (-40 to 65 degrees C)
  Storage                34 to 149 degrees F (1.1 to 65 degrees C)

  Temperature Gradient
  --------------------
  Operating              36 degrees F (20 degrees C) per hour
  Shipping/Storage       Below condensation

These temperature limits are extremely important and must not be
exceeded at the worst case drive and system operating conditions
with the drive randomly seeking, reading, and writing.



HOT PLUG/UNPLUG SUPPORT
=======================

Power supply and SCSI bus hot plug and unplug is allowed.  There
is no special sequence required for connecting 5 volt, 12 volt,
or ground.  During a hot plug-in event the drive being plugged will
draw a large amount of current at the instant of plug-in.  This
current spike is due to charging the bypass capacitors on the drive.
This current pulse may cause the power supply to go out of regulation.
If this supply is shared by other drives then a low voltage a low voltage
power on reset may be initiated on those drives.  Therefore the
recommendation for hot plugging is to have one supply for each drive.
Never daisy chain the power leads if hot plugging is planned.  Hot
plugging should be minimized to prevent wear on the power connector.

Hot plugging the SCSI bus may cause glitches on the bus.  To minimize
the chance of glitching, it is recommended to plug in the SCSI bus
before the power is applied.

During hot plugging, the supplies must not go over the upper voltage
limit.  This means that proper ESD protection must be used during
the plugging event.



ELECTRICAL INTERFACE SPECIFICATIONS
===================================

Power Connector
---------------
The DC power connector used on all models (50, 68, and 80 pin SCA)
are an integral portion of the 50/68 pin SCSI 'Unitized' Connectors
or the 80 pin "Single Connector Attachment" (SCA) Connector.

 .....................................................................
             Power connector pin assignments
             - - - - - - - - - - - - - - - -


              Pin    4    3    2    1
                __________________________
                |  ____________________  |
                | /                    \ |
                | |  O    O    O    O  | |
                | |____________________| |
                |________________________|

                    +5V  GND  GND  +12V

 .....................................................................



SCSI Bus Connectors
-------------------
DFMS has different model types that support 50 or 68 pin SCSI
connectors in either single-ended or differential driver/receiver
configurations.  Also supported is the 80 pin SCA in a single-ended
driver/receiver configuration.

50 Pin Signal Connector
-----------------------
50 pin models use an AMP PN 84160-1 connector.  The connector is
compatible with the ANSI SCSI "A" connector specifications.  It is
limited to 8-bit data transfer only.

68 Pin Signal Connector
-----------------------
68 pin models use AMP connector (PN 786963-1) that is compatible
with the ANSI SCSI "P" connector specifications.  It can transfer
data in both 8-bit (narrow) and 16-bit (wide) modes.

Note:  that the "P" connector is not mechanically compatible
with the 50-pin "A" connector as defined in the ANSI SCS1-2
standard.  Therefore system cables used with 50 pin products cannot
be plugged directly into 68 pin models.  Despite the difference
in connector, the differential 68 pin models are electrically
compatible with differential 50 pin models and other 50 pin
differential SCSI products and therefore can coexist on the same
bus.  In order to do so, the differences in connector types would
need to be accounted for in the cable.  The same can be said for
connecting 68 and 50 pin single-ended models to the same bus.  But
differential and single-ended models do not work connected to the
same bus.

80 Pin (Single Connector Attachment) Connector
----------------------------------------------
80 pin SCA models use a Molex connector (PN 87091-0001) that is
compatible with the specification of:  'Single Connector Attachment
for Small SCSI Disk Drives'.  It can transfer data in both 8-bit
(Narrow) and 16-bit (wide) modes.

Note:  that the 'SCA' connector is not mechanically compatible with
the 50 pin 'A' connector or the 68 pin 'P' connector as defined
in the ANSI SCSI standard.  This connector is intended for direct
backplane attachment and is not intended to be cable attached
to the bus.

SCSI Bus Cable
--------------
Single-ended models permit cable lengths of up to 6 meters (19.68
feet).  It should be noted however that users who plan to use
"Fast" data transfers with single-ended models should follow all
of the ANSI SCSI guidelines for single-ended "Fast" operations.  This
may include a cable length of less than 6 meters.

SCA connector models are not designed for direct cable attachment
due to the combination of power and SCSI bus signals.  "Fast" data
transfers with SCA models should follow all of the ANSI SCSI
guidelines for single-ended "Fast" operations.

Differential models permit cable lengths of up to 25 meters (82.2
feet).  Cables must meet the requirements for differential cables
as set forth in the ANSI SCSI-2 standard under "Cable Requriements--
Differential Cable."

The ANSI SCSI standard states that any stub from main cable must
not exceed 0.1 meters for single-ended cables and 0.2 meters for
differential cables.  DFMS has a maximum internal stub length of
0.05 meters on all 'single-ended' SCSI signals, and 0.1 meters
on all 'differential' SCSI signals.  To remain compliant with the
standard, the SCSI bus cable must not add more than 0.05 meters
additional stub length to any of the single-ended SCSI signals or
0.1 meters to any differential SCSI signals.



SCSI BUS TERMINATORS (OPTIONAL)
===============================

For those cards having the Active Termination feature, this function
can be enabled by installing a jumper between pins 13 and 14 of the
Front Option Jumper Block or connecting pins 9 and 11 of the
Auxiliary Connector on 68 SCSI pin models.  The using system is
responsible for making sure that all required signals are terminated
at both ends of the cable.

80 pin SCA models do not have internal SCSI bus terminators.

Some external terminator possibilities for single-ended cabled
systems are listed below:

               Single-ended SCSI Terminators
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   50 Pin Model Terminators      68 Pin Model Terminators
   -  -  -  -  -  -  -  -  -     -  -  -  -  -  -  -  -  -
      DM550-06-0                     DM5000 68689
     DM1050-02-0                    DM2050-02-685


Differential models do not have internal SCSI bus terminators.  Some
terminator possibilities are shown below:

               Differential SCSI Terminators
  - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   50 Pin Model Terminators      68 Pin Model Terminators
   -  -  -  -  -  -  -  -  -     -  -  -  -  -  -  -  -  -
      Data Mate DM550-05-0        Data Mate DM2050-01-68D
     Data Mate DM1050-06-0             DM5000 686510


Note:  A Meritec model 940900-4 or a DataMate DM5000-5068-11 can be
used to connect the 68 pin connector on a SxW drive for use with
a 50 pin connector.  The drive will now perform 8 bit transfers.


SCSI Bus Termination Power
--------------------------
Termination power is optionally provided for systems that desire
to use it.  In order to use the termination power, the user needs
to install a jumper between pins 1 and 2 of the TermPower Block.
The jumper should only be installed on one device, which should be
the last device on the SCSI bus (ie, the drive that is physically
closest to a terminator).  68 pin models can source up to 2.0 Amps
of current at 5.0 Volts (+/- 5%) for termination power.
50 pin models can source up to 1.5 Amps to current at 5.0 Volts
(+/- 5%) for termination power.


SCSI Bus Termination Power Short Circuit Protection
---------------------------------------------------
The ANSI SCSI-2 specification recommends for devices that optionally
supply TERMPWR, to include current limited protection for accidental
short circuits.  It also recommends that the maximum current
available for TERMPWR should not exceed 5 Amps.  UL has a different
requirement that they call the 8 Amp rule.  This rule states that
when a power source leaves an enclosure (like SCSI TERMPWR in the
SCSI cable), it must trip 8 Amps of current within 1 minute.

The drive limits current to 5.0 amps through the use of a permanent
fuse mounted through the use of a permanent fuse mounted on the
electronics card.  Systems may also provide short circuit protection
for drive supplied TERMPWR by limiting the current of the 5V power
it supplies to the drive.



SCSI BUS NOISE REDUCTION RECOMMENDATIONS
========================================

The SCSI committee has spent a large amount of resource looking
into what needs to be done to assure SCSI devices will work as
specified in the SCSI-2 standard.  As a result of this, the committee
is recommending the following approach:

   -  Use regulated 110 ohm terminator
   -  Use AWG 28 polyolefin shielded cables
   -  Make sure data and parity are on the outer ring of
      the cable and the REQ and ACK are in the core of the
      cable.



START AND STOP TIMES
====================


Times     |           Nominal        |      Maximum
----------|--------------------------|-----------------------------
Models    | S1x  S2x  S3x  S4x  S5x  | S1x   S2x   S3x   S4x   S5x
          |                          |
PowerUp   | 1.5  1.5  1.5  1.5  1.5  | 2.0   2.0   2.0   2.0   2.0
Start-up  | 12.4 14.4 14.4 13.4 13.4 | 1 min 1 min 1 min 1 min 1 min
Spin-up   |  8.2 10.0 10.0  8.7  8.7 | 30.8  30.8  30.8  32.1  32.1
Stop Time |  4.5  9.0  9.0  6.5  6.5 | 12.0  12.0  12.0  12.0  12.0

Note:  Seconds unless stated.


Note:  BATS is the abbreviation for Basic Assurance Tests.  Start-up
sequence spins up the spindle motor, uploads code, performs BATS2
(verifies read/write hardware), resumes "Reassign in Progress"
operations, and more.  For more information on the start up sequence
refer to the DFMS interface specification.

 .....................................................................
                      Bring-up Sequence
                      -----------------

     Power-up                    Start-up Sequence
  |<---------->|<--------------------------------------------------->|
  | Reset, Init|   Spin-up      Upload     BATS2      Reassign, etc. |
  | and Test of|<----------->|<-------->|<-------->|<--------------->|
  | Controller |             |          |          |                 |
  |            |             |          |          |                 |
  |            | Motor Start |          | Testing  |                 |
  |  Enable    |             |          |    of    |                 |
  | SCSI Bus   | Init Servo  |          |Read/write|                 |
  |____________|_____________|__________|__________|_________________|
  |            |                                                     |
  |            |                                                     |
  Power-on     Auto Start function                File ready to accept
               enabled or Start Unit              Read and Write
               command issued at this             commands.
               time.


  Note:  If a RESET is issued before the drive comes ready the
  power on sequence will start again.  In all other cases when
  a RESET is issued the present state of the motor is not altered.
 .....................................................................



VIBRATION AND SHOCK
===================

Operating/Nonoperating Vibration
--------------------------------
Due to the complexity of this subject we recommend that users
contact the Distributor to discuss how to perform the required
measurements if they believe this to be an area which requires
evaluation.

Operating Shock
---------------
The drive will continue to operate, at the stated "Performance,"
when subjected to a 5 G half sine wave shock pulse of 11
milliseconds duration.


No permanent damage will occur to the drive when subjected to
a 10 G half sine wave shock pulse of 11 milliseconds duration.

The shock pulses are applied in either direction in each of
three mutually perpendicular axis, one axis at a time.

Nonoperating Shock
------------------
No damage will occur if the unpackaged drive is not subjected
to a square wave shock greater than a "faired" value of 35 Gs
applied to all three axis for a period of 20 milliseconds, one
direction at a time.

Additionally, no damage will occur if the unpackaged drive is
not subjected to an 11 millisecond half sine wave shock greater
than 60 Gs applied to all three axis, one direction at a time.



MECHANICAL SPECIFICATIONS
=========================

This section details the mechanical specifications of the IBM
OEM DFMS disk drive.  (All versions.)

Weight
------
  S1x, S2x, and S3x models
    Approximately 1.0 pounds (0.46 kilograms)

  S4x and S5x models
    Approximately 1.8 pounds (0.82 kilograms)


Dimensions
----------
            | U.S.                    | S.I. Metric
  ----------|-------------------------|--------------------
  Height    | 1.00 in (S4x 1.63 in)   | 25.4mm (S4x 41.3mm)
  Width     | 4.00 in                 | 101.6mm
  Depth     | 5.75 in                 | 146.0mm


Clearances
----------
A minimum of 2mm should be given to the bottom surface except
for a 10mm diameter area around the bottom mounting holes.  The
diagram shows the 2mm clearance requirements (see 1).  For
proper cooling it is suggested that a clearance of 6mm be provided
under the drive and on top of the file.

Note:  The top of the drive will not exceed the height dimension
by more than 2 millimetres during a nonoperating shock.


Mounting
--------
The drive can be mounted with any surface facing down.

The drive has both side and bottom mounting holes.  Refer to
the diagrams below for the location of these mounting holes
for each configuration.

The maximum allowable penetration of the mounting screws is 3.8mm.

The torque applied to the mounting screws must be 0.5 Newton
meters plus/minus 0.1 Newton meters.

 .......................................................................

               Location of Mounting Holes
               --------------------------

                                  SIDE VIEW
                                  =========
       REAR                                             Bezel
                                                          v
  SCSI               ---------------------------------------  - - - - - - -
  and               |                                   |   |            :
  Power             |         (6x)6-32 UNC-2B           |   |            :
  Connectors        |                                   |   |   G        F
   ----------->  ---|                                   |   |   :        :
          :     |   |   - O - - - - O - - - - - - O - - | - | - - -      :
         - - - -:---------:---------:-------------:---------: - - - - - - -
         - - - -:- - - - -:- - - - -:- - - - - - -:- - -:- -:   :
          :     :         :         :- - - A - - -:- B -:-C-:
          :     :         :- - - - - - - - D - - -:     :
          H     :- - - - - - - - - - - - - E - - - - - -:

        A =  60.00 +/- 0.2 mm   front mount hole to center mount hole
        B =  16.00 +/- 0.4 mm   DE front to front mount hole CL
        C =   4.83         mm   bezel thickness
        D = 101.60 +/- 0.2 mm   front mount hole to rear mount hole
        E = 146.00 +/- 0.5 mm   DE + connector length
        F =  25.20 +/- 0.5 mm   DE height (1" models)
             41.40 +/- 0.5 mm   DE height (1.6" models)
        G =   6.35 +/- 0.5 mm   mount hole CL above bottom DE surface
        H =   2.00         mm   minimum required clearance under DE

   . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .

                                BOTTOM VIEW
                                ===========             Bezel
                                                          v
                                                          ---  - - - - - -
            - - - ---------------------------------------|   |          :
   Power     :   |   |     - O - - - - O - - - - - - - - | - | - - - -  :
   Connector :   |   |                                   |   |      :   :
             :   |---|                                   |   |      :   :
 REAR        :   |   |                                   |   |      :   :
             A   |---|                                   |   |      F   :
             :   |   |        ---(4x)6-32 UNC-2B         |   |      :   D
   SCSI      :   |   |       |                           |   |  E   :   :
   Connector :   |   |       v                           |   |  :   :   :
             :   |   |     - O - - - - O - - - - - - - - | - | - - - -  :
            - - - -----------:---------:-----------------| - | - -      :
                             :         :                  ---  -:- - - - -
                             :- - B - -:- - - - C - - - -:   :
                                                         :   :
                                                        -:-G-:-

        A = 101.60 +/- 0.5 mm  DE width
        B =  44.45 +/- 0.2 mm  distance between mount hole CLs
        C =  60.33 +/- 0.4 mm  DE front to front mount hole CL
        D = 104.14 +/- 0.3 mm  bezel width
        E =   3.18 +/- 0.3 mm  DE side to mount hole CL
        F =  95.24 +/- 0.2 mm  distance between mount hole CLs
        G =   4.83         mm  bezel thickness

 .......................................................................




Grounding Requirements of the Disk Enclosure
--------------------------------------------
The disk enclosure is at Power Supply ground potential.  It is
allowable for the user mounting scheme to common the Disk
Enclosure to Frame Ground potential or leave it isolated from
Frame Ground.

The drive's mounting frame must be within plus/minus 150 millivolts
of the drive's power supply ground.  At no time should more than
35 milliamps of current (0 to 100MHz) be injected into the disk
enclosure.



TEMPERATURE MEASUREMENTS
========================

The following is a list of measurement points and their temperatures
(maximum and reliability).  Maximum temperatures must not be
exceeded at the worst case drive and system operating conditions
with the drive randomly seeking, reading, and writing.  Reliability
temperatures must not be exceeded at the nominal drive and system
operating conditions with the drive randomly seeking, reading, and
writing.

                        Maximum              Reliability
                        - - - - - -          - - - - - -
Disk Enclosure Top      158 F (70 C)         131 F (55 C)
Disk Enclosure Bottom   158 F (70 C)         131 F (55 C)
PRDF Module             203 F (95 C)         176 F (80 C)
WD COMBO Module         185 F (85 C)         167 F (75 C)
Microprocessor Module   194 F (90 C)         167 F (75 C)
VCM FET                 194 F (90 C)         167 F (75 C)
SMP FET                 194 F (90 C)         167 F (75 C)

 ...........................................................................


                Top view
                --------

                  ---------------------------------------
                 |                          |            |
                 |                          |            |
                 |                          \____________|
 REAR            |                                       |
 (SCSI/power)    |                  (DE Top) - - - - - - | - - - -
                 |                      :                |      :
                 |                      :                |    41.86 mm
                 |                      :                |      :
                 |                      :                |      :
                  ----------------------:----------------  - - - -
                                        :                :
                                        :                :
                                        :- - 58.53 mm - -:

    . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .


                  Bottom view
                  -----------

                               :- - - - 89.17 mm  - - - -:
                               :                         :
                  -------------:-------------------------  - - - -
                 |           O :FETS   O                 |      :
                 |             :                         |    38.5 mm
                 |             :                         |      :
 REAR            |         (DE Bottom) - - - - - - - - - | - - - -
 (SCSI/power)    |                                       |
                 |                                       |
                 |    WD      Micro                      |
                 |   Combo                      PRDF     |
                 |           O         O                 |
                  ---------------------------------------



  Note:  The diagrams above define where measurements should be
  made to determine the top casting temperature during drive
  operation and shows the location of the PRDF module.  The
  diagrams above define the modules that are located on the
  bottom side of the card and the measurement location on the
  bottom of the casting.

  There must be sufficient air flow through the drive so that the
  casting and module temperature limits defined above are not
  exceeded.

 ...........................................................................


Module Temperature Measurement Notes
------------------------------------
1.  Center on the top of the module.
2.  If copper tape is used to attach temperature sensors, it
    should be no larger than 6mm square.



SPINDLE SYNCHRONIZATION
=======================

Spindle Synchronization Overview
--------------------------------
There are four modes of spindle synchronization.  See below for
a list of how the -MASTER SYNC and -SLAVE SYNC pins on the Option
Jumper Block are used for the different modes.  The following
paragraphs give a short description of each spindle synchronization
mode:

-  The Slave drive (Slave Sync mode) receives the index from the
  Master drive on the -SLAVE SYNC line and synchronizes its INDEX
  (Slave index) to it.
-  Should the drive be the Master drive, (Master Sync mode), it
  outputs its INDEX on the -MASTER SYNC and the -SLAVE SYNC lines.
  The Master drive does not synchronize its Index to any other
  device.  It simply outputs its INDEX.
-  In the Master Sync Control mode, a drive will synchronize
  its spindle to the signal it receives on the -SLAVE SYNC input.
  It outputs to -MASTER SYNC a pulse that has the same period as the
  drive INDEX, but is not synchronized to the drive INDEX, but is
  not synchronized to the drive INDEX generated from the disk.
-  In the non-sync mode, the drive will receive the -SLAVE SYNC
  signal, but it is not used by the drive.



SPINDLE SYNCHRONIZATION CONTROL LINES
=====================================

           Spindle Synchronization Functional Modes
           ----------------------------------------

  --------------------------------------------------------------
  | -MASTER SYNC   |   -SLAVE SYNC    |    Functional Mode     |
  |----------------|------------------|------------------------|
  | released       |   receive        |    Slave sync          |
  | drive          |   drive          |    Master sync         |
  | drive          |   receive        |    Master sync control |
  | released       |   receive        |    non sync            |
  --------------------------------------------------------------



Drive Synchronization with Offset
---------------------------------
The drive electronics receives the Master Index and creates the
delayed Slave Index from the drive INDEX.  The delay is determined
by using the SCSI Mode Select command, Rigid Disk Drive Geometry
Parameters.  A rotational offset of 0/256 of a revolution up
to 255/256 of a revolution may be selected in increments 1/256 of
a revolution.  Reference the DFMS Interface Specification for
further information on the rotational offset of synchronized
spindles.

 ......................................................................


   -SLAVE SYNC
  _____     ________________________  ...  _____     _______________
       \___/                                    \___/
       :   :                                    :
    -->:   :<-- 2.0 usec, minimum               :
       :                                        :
       :<------- 8.333 msec --------  ... ----->:
       :
       :
    -->:     :<--  +/- 20.0 usec
             :___                                      ___
    _________/   \________________________  ...  _____/   \____________

   +SLAVE INDEX (internal signal)


 ......................................................................



Synchronized Time
-----------------
The SCSI Mode Select command is used to select the Spindle Sync
mode.  It could take up to 3.0 seconds (1.5 sec nominally) to
synchronize the Slave drive to the Master drive.  While the Slave
drive is synchronizing to the Master, it will not be able to
read and write data.  Once synchronized, the drive will maintain
plus/minus 20 usec synchronization tolerance.


Spindle Synchronization Bus
---------------------------
The spindle synchronization Bus consists of the two signal lines,
-MASTER SYNC and -SLAVE SYNC.  One potential configuration of this
bus for drives that are to be used in a synchronized mode is shown
in the following figure.  This example required the -SLAVE SYNC
lines to be daisy chained together.


 ......................................................................

  ----------              ---------- ----------       ----------
  | Master |              | Slave  | | Slave  |       | Slave  |
  |  Drive |              |  Drive | |  Drive |  ...  |  Drive |
  |        |              |        | |        |       |        |
  ----------              ---------- ----------       ----------
    |   | <-Option Block--> |   |      |   |            |   |
    -----                   -----      -----            -----
       o                       o          o                o
       |                       |          |                |
       |                       |          |                |
       |                       |          |                |
       ----------------------------------------- ... -------
          -SLAVE SYNC

 ......................................................................



Termination
-----------
Bus termination of the -MASTER SYNC and -SLAVE SYNC signals is
internal to the drive.  These two signals each have a 2000 ohm
pullup to the +5 volt supply.  A maximum of 16 drives can have
their -MASTER SYNC or -SLAVE SYNC lines daisy chained together.
Violating this could damage the Master drive line driver on
the -MASTER SYNC and/or -SLAVE SYNC line.

It is the using system's responsibility to provide the cable to
connect to the -SLAVE SYNC lines, and the -MASTER SYNC lines where
needed, of the synchronized drives.


Bus Characteristics
-------------------
-  maximum bus length = 6 meters
-  2 micro-second negative active pulse (when sourced to drive)
-  minimum of 1 micro-second negative active pulse when
    externally sourced
-  0.8 volts = valid low input
-  2.2 volts = valid high input
-  0.4 volts = low output
-  Vcc volts = high output
-  60 milli-amps = maximum output low level sink current

The drive used for these two signal lines is a tri-state buffer.


-SLAVE SYNC Input Timing Requirements
-------------------------------------
If the input to -SLAVE SYNC is supplied by an external source
other than a DFMS drive, the period of the input signal must be
11.11 msec with a tolerance of plus/minus .025%



PACKAGING:  The drive must be protected against Electro-Static
Discharge especially when being handled.  The safest way to
avoid damage is to put the drive in an anti-static bag before
ESD wrist straps etc are removed.

Drives should only be shipped in approved containers, severe
damage can be caused to the drive if the packaging does not
adequately protect against the shock levels induced when a box
is dropped.  Consult your IBM marketing representative if you
do not have an approved shipping container.
