@echo off
REM 
REM This Batchfile should be used on computers with too little memory for
REM model/render/model loop.
REM 

:ModelIt
REM Please enter the drive where you installed Moray on the next line.
c:

REM Please change the path to reflect where you installed Moray.
cd \moray

REM The next line is the actual call to Moray. The -B is essential.
MORAY.EXE -B 

REM Moray is done. Check whether a render was requested.
if errorlevel 17 goto POVRender
if errorlevel 16 goto PolyRender
if errorlevel 1 goto Err1

REM No Errorlevel, so leave the loop ...
goto Ende

REM A POV-Ray Render was requested ...
:POVRender
cd povscn
call go.bat
goto ModelIt

REM A Polyray Render was requested ...
:PolyRender
cd polyscn
call go.bat
goto ModelIt

:Err1
echo POV-Ray or Polyray returned an error. If it wasn't one, please check the
echo Manual for the IgnoreErrorLevel keyword.

:Ende

