;;;
;;;  Test ELFWIN functions
;;;

;;; MCI Command String Intrepreter

(xload"elf")

(defun C:MCI( / str done)
  (while (not done)
    (setq str (getstring "\nMCI String: " T))
    (if (> (strlen str) 0)
      (progn
        (princ "\nMCI returned: ")
        (princ (WinMCISendString str))
      )
    ;else
      (setq done T)
    )
  )
  (princ)
)

(defun MakeExt(path ext)
  (setq plst (splitpath path))
  (strcase(makepath (car plst) (cadr plst) (caddr plst) ext))
)

(defun MakeWav(path)
  (MakeExt path ".wav")
)

;;;*----- Async WAV Player

(defun C:PLAYWAV( / fn)
  (setq fn (getfiled "WAV filename" "" "WAV" 8))
  (if fn (WinPlaySound (MakeWav fn)))
  (princ)
)

;;;*----- MIDI Player

(defun PLAYMIDI(fn wait)
  (if(WinMCISendString (strcat "open sequencer!" fn " alias midi"))
    (progn
      (if wait
        (progn
          (princ "\nPress [F11] to stop MIDI player...")
          (WinMCISendString "break midi on 122") ; Syncronous player
          (WinMCISendString "play midi wait")    ; MIDI will play until F11 is hit
          (WinMCISendString "stop midi")
          (WinMCISendString "close midi")
        )
      ;else
        (WinMCISendString "play midi")    ; MIDI will play until stopped
      )
      T
    )
  ;else
    (progn
    (princ "\nError opening Midi Sequencer")
    nil
    )
  )
)

;;; Stop MIDI player

(defun C:STOPMIDI()
  (WinMCISendString "stop midi")
  (WinMCISendString "close midi")
  (princ)
)

;;; Play a MIDI file - system sounds can be played also (eg SystemExit)

(defun C:PLAYMIDI( / fn)
  (setq fn (getfiled "MID filename" "" "MID" 8))
  (if (eq fn 1)
    (setq fn (getstring "\nEnter MIDI filename: ")))
  (if fn (PlayMIDI (MakeExt fn ".mid") nil))
  (princ "Enter \"STOPMIDI\" to stop MIDI player")
  (princ)
)

;;;*----- WAV Sound Recorder

(defun RECORD(wavfile / rvalue)
  (if wavfile
    (if(not(WinMCISendString "open new type waveaudio alias sound"))
      (princ "\nError opening WaveAudio")
    ;else
    (progn
      (princ "Opened ")
      (princ(WinMCISendString "info sound input"))
      (princ "\nPress any key to begin recording...")
      (grread)
      (if(WinMCISendString "record sound")
        (progn
          (princ "\nRecording, press any key to stop...")
          (grread)
          (WinMCISendString "stop sound")
          (princ "\n")
          (princ (WinMCISendString "status sound length"))
          (princ " milliseconds recorded - playing...")
          (WinMCISendString "play sound from 1 wait")
          (setq wavfile (MakeWav wavfile))
          (if (WinMCISendString (strcat "save sound " wavfile))
            (progn
            (princ(strcat "\nfile " wavfile "saved"))
            (setq rvalue t)
            )
          ;else
            (princ(strcat "\nError saving file " wavfile))
          )
        )
      ;else
        (princ "\nError recording")
      )
      (if(WinMCISendString "close sound")
        (princ "\nWaveAudio Closed"))
    ))
  )
  rvalue
)

;;; Sound Recorder Command

(defun C:RECORDWAV()
  (record(getstring "WAV filename: "))
  (princ)
)

;;; Execute a (void) function in a DLL
;;; Warning this will cause a GPE if the function has parameters

(defun C:DLLBEEP()
  (Setq hInst (WinLoadLibrary "DLL.DLL"))
  (If (< hInst 32) (exit))
  (WinExecLibProc hInst "Beep")	;;; Execute Beep() in DLL.DLL
  (WinFreeLibrary hInst)
  (princ)
)

;;; Extract a field from a list

(Defun DXF (elist code)
  (Cdr (Assoc code elist))
)

;;; Retrieve the first 1000 group string in regapp

(defun EEDGET(en regapp / ed)
  (setq ed (entget en (list regapp)))
  (dxf(dxf(dxf ed -3) regapp) 1000)
)

;;; Record an AudioNote

(defun C:ADDNOTE()
  (princ "Select an entity to attach a Audio Note")
  (setq en (car(entsel)))
  (if(not en) (exit))
  (setq fn (getfiled "Select WAV file or Select Type to Record" "" "WAV" 8))
  (if (not fn) (exit))
  (if (eq fn 1)
    (progn
    (setq fn (getstring "WAV filename to record: "))
    (if (not fn) (exit))
    (princ "\nPress any key to begin recording...")
    (grread)
    (if (not(record fn)) (exit))
    )
  )
  (EEDdel en "ANOTE")
  (EEDadd en "ANOTE" fn)
)

;;; Play an Audio Note

(defun C:PLAYNOTE( / fn)
  (princ "Select an entity to play an Audio Note")
  (if(setq en (car(entsel)))
    (if (setq fn (findfile(MakeWav (eedget en "ANOTE"))))
      (WinPlaySound fn)
    ;else
      ("\nEntity does not have an audio note attached")
    )
  )
)

;;; Test Function to test EED functions

(defun C:XDADD()
  (setq en(car (entsel)))
  (eeddel en "ANAME")
  (eedadd en "ANAME" "STRINGDATA")
  (eedadd en "ANAME" 1)
  (eedadd en "ANAME" 2.222)
  (princ)
)

;;; Edit a file with Notepad

(defun C:NOTEPAD( / file)
  (setq file (getstring "File to edit: "))
  (WinExec "NOTEPAD" file)
  (princ)
)

(defun C:NP() (C:NOTEPAD))

;;; Print Hello World to AutoCAD text screen client area
;;; Note this will steal the DC handle from AutoCAD which can not
;;; be restored except by reloading ACAD. In real life you should
;;; only do this to your own window

(defun C:PRINT()
  (setq hwnd (WinFindWindow "AutoCAD.text")
	hdc  (WinGetDC hwnd))
  (WinMoveTo hDC 0 0)
  (WinTextOut hDC "Hello World" 50 50)
  (WinReleaseDC hWnd hDC)
)

;;; Set Focus to an existing window, You could also start the app
;;; with WinExec if it is not running (eg FindWindow fails)
;;; <HWND> (WinFindWindow <str> class <str> title)
;;; a nil class or title means use wildcard
;;; (WinSetFocus hWnd) will pop the window to the top and set keyboard focus
;;; (WinGetFocus) will return focus to AutoCAD

(defun C:ACTIVATE()
  (setq class (getstring "\nWindow Class:")
				hwnd (WinFindWindow class))
  (if (eq hWnd 0)
    (princ "\nCan't Find Window")
  ;else
    (if(not(WinSetFocus hwnd))
      (princ "\nError Setting Focus"))
  )
  (princ)
)

;;; Send a command to AutoCAD using WN_ACAD message

(defun C:SENDACAD()
  (WinSendACAD (strcat (getstring "\3\3\3" "\nCommand> ") "\n"))
)

;;; Send keys to a window using WM_CHAR message
;;; Note: Many apps (including Notepad) will ignore external WM_CHAR messages

(defun C:SENDKEYS()
  (setq class (getstring "\nWindow Class Name: ")
        hWnd (WinFindWindow class))
  (if (eq hWnd 0)
    (princ "\nCan't Find Window")
  ;else
    (progn
      (setq str (getstring "\nCommand String: "))
      (WinSetFocus hWnd)
      (WinSendKeys hWnd str)
      (WinGetFocus)
    )
  )
)


(textscr)
(WinPlaySound "elfdemo.wav" t)
(princ "\nThe following commands are available:")
(princ "\n\nPLAYMIDI\nSTOPMIDI\nPLAYWAV\nRECORDWAV\nADDNOTE\nPLAYNOTE")
(princ "\nMCI\nDLLBEEP\nNOTEPAD\nACTIVATE\nSENDKEYS\nSENDACAD")
(WinPlaySound "tada.wav")
(princ)

