/*----------------------------------------
   PATHDIR.C -- Paths and Directions
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <string.h>

char szClass [] = "PathDir" ;
char szTitle [] = "PathDir: Paths and Directions" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static char * szLabel [] = { "CW", "CCW" } ;
     char          szBuffer [16] ;
     int           iDir1, iDir2, iDir3 ;

               // Set up an anisotropic display area

     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx (hdc, 100, 100, NULL) ;
     SetViewportExtEx (hdc, cxArea / 4, cyArea / 2, NULL) ;

               // Set some display attributes

     SelectObject (hdc, GetStockObject (GRAY_BRUSH)) ;

     SetPolyFillMode (hdc, WINDING) ;

               // Cycle through the combinations

     for (iDir1 = 0 ; iDir1 < 2 ; iDir1++)
     for (iDir2 = 0 ; iDir2 < 2 ; iDir2++)
     for (iDir3 = 0 ; iDir3 < 2 ; iDir3++)
          {
          SetViewportOrgEx (hdc, (2 * iDir3 + iDir2) * cxArea / 4,
                                              iDir1  * cyArea / 2, NULL) ;

                    // Display the labels

          wsprintf (szBuffer, "%s-%s-%s",
                    szLabel [iDir1], szLabel [iDir2], szLabel [iDir3]) ;

          TextOut (hdc, 0, 0, szBuffer, strlen (szBuffer)) ;

                    // Create a path with three rectangles

          BeginPath (hdc) ;

          SetArcDirection (hdc, iDir1 ? AD_COUNTERCLOCKWISE : AD_CLOCKWISE) ;
          Rectangle (hdc, 15, 15, 60, 60) ;

          SetArcDirection (hdc, iDir2 ? AD_COUNTERCLOCKWISE : AD_CLOCKWISE) ;
          Rectangle (hdc, 30, 30, 75, 75) ;

          SetArcDirection (hdc, iDir3 ? AD_COUNTERCLOCKWISE : AD_CLOCKWISE) ;
          Rectangle (hdc, 45, 45, 90, 90) ;

          EndPath (hdc) ;

          StrokeAndFillPath (hdc) ;
          }
     }
