;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; Example Demo                                                             ;
;                                                                          ;
; A very small demo-like program to show you how to use the "funklite.asm" ;
;  attachment.                                                             ;
;                                                                          ;
; The organisation of your application programs in relation to the playback;
; code is as follows:                                                      ;
;                                                                          ;
;   Ŀ                                                ;
;    Your Program:                                                       ;
;                                                                        ;
;   include "funklite.asm                                                ;
;                                                   ;
;                  Ŀ       playback code                   ;
;                 +---------------------------------+               ;
;ĿĿ          | Ŀ               |               ;
;                        |                               |               ;
;                        |  FUNKLITE.ASM                 |               ;
;                        |                               |               ;
;                        |                |               ;
;                        +---------------------------------+               ;
;                                                                          ;
;  To compile this program, you need the following essential files:       ;
;                                                                          ;
;  EXAMPLE.ASM                                                             ;
;  FUNKLITE.ASM                                                            ;
;  DOS32.EXE      \                                                        ;
;  DOS32.INC       - from DOS32                                            ;
;  DOS32.OBJ      /                                                        ;
;  DEBUG.OBJ (if applicatable)  -\ from DOS32                              ;
;  V24.OBJ                      -/                                         ;
;                                                                          ;
;  TASM.EXE or TASMX.EXE                      (put these in your path)     ;
;  adams DLINK.EXE              -> from DOS32                              ;
;                                                                          ;
; (please note that i have setup Adam Seychells routines to work with my   ;
; TASM IDEAL mode references. If you are a MASM freak, then you had better ;
; refer to Adam's actual documentation of DOS32)                           ;
;                                                                          ;
;  To compile in DEBUG mode, type in:                                     ;
;                                                                          ;
;  tasmx example >e.pas                                                    ;
;  dlink debug v24 example, example                                        ;
;                                                                          ;
; (NB/ You must include the line "call debug" at the very start of the     ;
; program).                                                                ;
;                                                                          ;
;  To compile in RELEASEABLE mode, type in:                               ;
;                                                                          ;
;  tasmx example >e.pas                                                    ;
;  dlink -Sdos32 v24 example, example                                      ;
;                                                                          ;
; (NB/ don't forget to remove the "call debug" at the very start of the    ;
; program).                                                                ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model small

segment code32 public 'code' use32
assume cs:code32,ds:code32,fs:code32,gs:code32,ss:code32
include "dos32.inc"

include "funklite.asm"     ;<<<<---- here we must include the "attachment" thingy

our_songname          db "songs\disco70.fnk",0   ;<<- DON'T FORGET TO CHANGE THE BLOODY PATH
                                                 ;    WHEN YOU COMPILE IT IN YOUR OWN DIRECTORY

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;@STDIO MACRO: Modified By Adam Seychell 14/03/94 in V1.02
macro @stdio string
local @@tttext, @@skip
  jmp    @@skip
  ifb    <string>
@@tttext:
  db     "$"
  else
@@tttext:
  db     string, "$"
  endif
@@skip:
  push   eax edx
  lea    edx,[@@tttext]
  mov    ah,9
  int    21h
  pop    edx eax
endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; read the "funk.cfg" to determine settings.                              ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc read_cfg
  mov    eax,3d00h                                      ;open file
  lea    edx,[@@config_file]
  int    21h
  jnc    @@file_opened
  stc
  ret
@@file_opened:
  mov    ebx,eax
  mov    ah,3fh                                 ;read config
@@do_stuff:
  lea    edx,[init_settings]
  mov    ecx,size init_settings
  int    21h
  mov    ah,3eh                                 ;close file
  int    21h
  clc
  ret
@@config_file:
  db     "funk~.cfg",0
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
start32:
  call   debug
  cld

  call   read_cfg                                       ;read the "funk.cfg" config 
  jc     @@no_cfg                                       ;if there sin't one, then
                                                        ;abend

  call   scard_detect                                   ;with the config
  jc     @@card_not_found                               ;setting, we see
                                                        ;if the given card
                                                        ;is there. If not
                                                        ;then we abend..

  call   scard_init                                     ;once done, we
                                                        ;then fireup the
                                                        ;backround tracker
                                                        ;routines for the
                                                        ;given card. this
                                                        ;runs continuously
                                                        ;and responds to
                                                        ;flags set by the
                                                        ;foreground program.

  @stdio "loading fucking song...."

  lea    edx,[our_songname]                             ;we load song here
  call   load_funk_module
  or     al,al
  jnz    @@error_loadingfile

  call   init_for_play                                  ;just reset all the
                                                        ;tracker variables etc

  mov    [byte funk_info.trek_status],PLAY              ;we use this flag
                                                        ;to communicate with
                                                        ;the tracker code. at
                                                        ;this stage, the tracker
                                                        ;code will start to playback
                                                        ;the music.


  mov    eax,10h
  int    16h                                            ;run demo

  mov    [byte funk_info.trek_status],STOP              ;tell the tracker to
                                                        ;stop playing back the music

  call   stop_all_voices                                ;silence the channels

@@error_loadingfile:
  call   scard_deinit                                   ;blow the tracker
                                                        ;out of the water

  mov    eax,03h                                        ;usual winddown shit..
  int    10h                                            ;

  @stdio "An Example for how to use the 'Funklite.asm' attachment."
  mov    eax,4c00h
  int    21h
@@no_cfg:
  mov    eax,3h
  int    10h
  @stdio "Can't find 'funk.cfg'. Please create one...",13,10
  mov    eax,4c00h
  int    21h
@@card_not_found:
  mov    eax,3h
  int    10h
  @stdio "Soundcard not Detected.",13,10
  mov    eax,4c00h
  int    21h
ends

end
