#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <mem.h>

#include "mtypes.h"
#include "mems.h"

UBYTE ems_version;
UWORD ems_frameseg;
int   ems_active=0;


/******************************

	EMS core functions:

*******************************/



int EMS_Detect(void)
{
	void far *handler;
	void far *t;

	handler=getvect(0x67);
	t=MK_FP(FP_SEG(handler),10);

	return(memcmp(t,"EMMXXXX0",8)==0);
}



UBYTE EMS_Version(void)
{
	_AX=0x4600;
	geninterrupt(0x67);
	return(_AL);
}

int EMS_FreePages(void)
{
	_AX=0x4200;
	geninterrupt(0x67);
	return(_BX);
}


int EMS_TotalPages(void)
{
	_AX=0x4200;
	geninterrupt(0x67);
	return(_DX);
}


int EMS_FrameSeg(void)
{
	_AX=0x4100;
	geninterrupt(0x67);
	if(!_AH) return(_BX);
	else return -1;
}


int EMS_Alloc(int frames)
{
	_AX=0x4300;
	_BX=frames;
	geninterrupt(0x67);
	if(!_AH) return(_DX);
	else return -1;
}


void EMS_Free(int handle)
{
	int t;

	_AX=0x4500;
	_DX=handle;
	geninterrupt(0x67);
}



void EMS_Map(int handle,int logp,UBYTE physp)
{
	_AH=0x44;
	_AL=physp;
	_BX=logp;
	_DX=handle;
	geninterrupt(0x67);
}


char EMS_Save_Map(int handle)
{
	_AH=0x47;
	_DX=handle;
	geninterrupt(0x67);
	return(_AH);
}


char EMS_Restore_Map(int handle)
{
	_AH=0x48;
	_DX=handle;
	geninterrupt(0x67);
	return(_AH);
}


/******************************

	Higher level functions:

******************************/


int EMS_Init(void)
{
	if(ems_active) return 1;

	if(EMS_Detect()){
		ems_version=EMS_Version();

		printf( "EMS version %d.%d detected. Total %d pages, free %d pages. (fseg %X)\n",
				ems_version>>4,
				ems_version&0xf,
				EMS_TotalPages(),
				EMS_FreePages(),
				ems_frameseg=EMS_FrameSeg()
		);

		ems_active=1;
		return 1;
	}
	else{
		puts("No EMS detected.");
		ems_active=0;
		return 0;
	}
}


int EMS_AllocMem(long size)
{
	return EMS_Alloc((size+16383)>>14);
}


/*
void EMS_CopyToEMS(char far *src,long size,int handle,long offset)
{
	long todo;
	char far *dst;

	while(size>0){

		EMS_Map(handle,offset>>14,0);

		todo=16384-(offset&0x3fff);

		todo=(todo>size) ? size:todo;

		dst=MK_FP(ems_frameseg,offset&0x3fff);

		memcpy(dst,src,todo);

		size-=todo;
		offset+=todo;
		src+=todo;
	}
}
*/