#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>

#include "mtypes.h"
#include "wildfile.h"

#include "mloader.h"
#include "mdriver.h"
#include "mplayer.h"

#include "mems.h"


char helptext[]=

"Available switches (CaSe SeNsItIvE!):\n"
"\n"
"  /d x    use device-driver #x for output (0 is autodetect). Default=0\n"
"  /ld     List all available device-drivers\n"
"  /ll     List all available loaders\n"
"  /x      disables protracker extended speed\n"
"  /p      disables panning effects (9fingers.mod)\n"
"  /v xx   Sets volume from 0 (silence) to 100. Default=100\n"
"  /f xxxx Sets mixing frequency. Default=44100\n"
"  /m      Force mono output (so sb-pro can mix at 44100)\n"
"  /8      Force 8 bit output\n"
"  /r      Restart a module when it's done playing";


/*
	Declare external loaders:
*/
extern LOADER mtmload,s3mload,ultload,modload,dsmload,medload,
			  farload,s69load,xmload,stmload,m15load,uniload;


/*
	Declare external drivers:
*/
extern DRIVER gusdriver,sbdriver,nosnddriver;



/*
	declarations for boring old sys-v style getopt *yawn*:
*/
int     getopt(int argc, char *argv[], char *optionS);
extern char *optarg;
extern int optind;
extern int opterr;



int breakhandler(void)
{
	return 1;
}


void tickhandler(void)
{
	MP_HandleTick();    // play 1 tick of the module
	md_bpm=mp_bpm;          // and update the device bpm rate
}

void HandleTimer1(void);

int main(int argc,char *argv[])
{
	UNIMOD *mf;
	int cmderr=0;                   // error in commandline flag
	int morehelp=0;                 // set if user wants more help
	int quit;
	int t;

	puts(mikbanner);

	//      Expand wildcards on commandline (only neccesary for MSDOS):

	MyGlob(&argc,&argv,0);

	/*
		Initialize soundcard parameters.. you _have_ to do this
		before calling MD_Init(), and it's illegal to change them
		after you've called MD_Init()
	*/

	md_mixfreq      =44100;                     // standard mixing freq
	md_dmabufsize   =10000;                     // standard dma buf size
	md_mode         =DMODE_16BITS|DMODE_STEREO; // standard mixing mode
	md_device       =0;                                                     // standard device: autodetect

	/*
		Register the loaders we want to use..
	*/

	ML_RegisterLoader(&m15load);    // if you use m15load, register it as first!
	ML_RegisterLoader(&modload);
	ML_RegisterLoader(&mtmload);
	ML_RegisterLoader(&farload);
	ML_RegisterLoader(&s69load);
	ML_RegisterLoader(&s3mload);
	ML_RegisterLoader(&stmload);
	ML_RegisterLoader(&dsmload);
	ML_RegisterLoader(&medload);
	ML_RegisterLoader(&ultload);
	ML_RegisterLoader(&uniload);
	ML_RegisterLoader(&xmload);

	/*
		Register the drivers we want to use:
	*/

	MD_RegisterDriver(&nosnddriver);
	MD_RegisterDriver(&sbdriver);
	MD_RegisterDriver(&gusdriver);

	// Parse option switches using standard getopt function:

	opterr=0;

	while( !cmderr &&
		  (t=getopt(argc,argv,"ohxpm8rv:f:l:d:")) != EOF ){

		switch(t){

			case 'd':
				md_device=atoi(optarg);
				break;

			case 'l':
				if(optarg[0]=='d') MD_InfoDriver();
				else if(optarg[0]=='l') ML_InfoLoader();
				else{
					cmderr=1;
					break;
				}
				exit(0);

			case 'r':
				mp_loop=1;
				break;

			case 'm':
				md_mode&=~DMODE_STEREO;
				break;

			case '8':
				md_mode&=~DMODE_16BITS;
				break;

			case 'x':
				mp_extspd=0;
				break;

			case 'p':
				mp_panning=0;
				break;

			case 'v':
				if((mp_volume=atoi(optarg))>100) mp_volume=100;
				break;

			case 'f':
				md_mixfreq=atol(optarg);
				break;

			case 'h':
				morehelp=1;
				cmderr=1;
				break;

			case '?':
				puts("\07Invalid switch or option needs an argument\n");
				cmderr=1;
				break;
		}
	}

	if(cmderr || optind>=argc){

		/*
			there was an error in the commandline, or there were no true
			arguments, so display a usage message
		*/

		puts("Usage: MIKMOD [switches] <fletch.mod> ... \n");

		if(morehelp)
			puts(helptext);
		else
			puts("Type MIKMOD /h for more help.");

		exit(-1);
	}

	/*
		disable control-break by
		installing a custom handler, only for borland
	*/

#ifndef __WATCOMC__
	ctrlbrk(breakhandler);
	EMS_Init();
#endif

	//      initialize soundcard

	if(!MD_Init()){
		printf("Driver error: %s.\n",myerr);
		return 0;
	}

	printf("Using %s for %d bit %s sound at %u Hz\n\n",
			md_driver->Name,
			(md_mode&DMODE_16BITS) ? 16:8,
			(md_mode&DMODE_STEREO) ? "stereo":"mono",
			md_mixfreq);



	for(quit=0; !quit && optind<argc; optind++){

		printf("File    : %s\n",argv[optind]);

		//      load the module

		mf=ML_LoadFN(argv[optind]);

		//      didn't work -> exit with errormsg.

		if(mf==NULL){
			printf("MikMod Error: %s\n",myerr);
			break;
		}

		//      initialize modplayer to play this module

		MP_Init(mf);

		/* tell the device-driver to call our tickhandler every 'bpm' tick */

		MD_RegisterTickHandler(tickhandler);

		printf( "Songname: %s\n"
				"Modtype : %s\n"
				"Periods : %s,%s\n",
				mf->songname,
				mf->modtype,
				(mf->flags&UF_XMPERIODS) ? "XM type" : "mod type",
				(mf->flags&UF_LINEAR) ? "Linear" : "Log");

		/*
			set the number of voices to use.. you
			could add extra channels here (e.g. MD_Voices(mf->numchn+4) )
			to use for your own soundeffects:
		*/

		md_numchn=mf->numchn;

		//      start playing the module:

		MD_PlayStart();

		while(!MP_Ready()){

			char c;

			c=kbhit() ? getch() : 0;

			if(c=='+')
				MP_NextPosition();
			else if(c=='-')
				MP_PrevPosition();
			else if(c==0x1b){
				quit=1;
				break;
			}
			else if(c==' ') break;

			// wait a bit

			delay(20);
			printf("\rsngpos:%d patpos:%d sngspd %d bpm %d   ",mp_sngpos,mp_patpos,mp_sngspd,mp_bpm);
		}

		MD_PlayStop();          // stop playing
		ML_Free(mf);            // and free the module

		puts("\n");
	}

	MD_Exit();

	return 0;
}
