;-----------------------------------
; (c) Copyright 1991 Ralf Brown  All Rights Reserved
;
;  SPAWNVO
;	Overlaying spawnv()
;
;  File: SPAWNO.INC
;-----------------------------------

;-----------------------------------------------------------
; describe a dummy structure to hold all the swap device-specific
; routines

_spawn_funcs struc
 ?sf_init	dw ?	; called to determine whether to swap to a given device
 ?sf_write	dw ?	; called to write out memory
 ?sf_swapdone	dw ?	; called when all memory written out
 ?sf_swapin	dw ?	; called when ready to read back memory
 ?sf_read	dw ?	; called to read back a section of memory
 ?sf_finish	dw ?	; called to clean up at very end of swap
 ?sf_codeaddr	dw ?	; address of code to append to resident stub
 ?sf_codesize	dw ?	; total size of code to be appended
 ?sf_resident	dw ?	; number of bytes which must stay resident
_spawn_funcs ends

;-----------------------------------------------------------
; define manifest constants

StackSize equ 160h			; 352 bytes
StackSizePara equ (StackSize+15)/16
DefStackPara equ 4			; default stack size (in para)
MinStackPara equ 2			; absolute minimum stack while spawned

ENOENT equ 2				; file not found
ENOPATH equ 3				; path not found
EMFILE equ 4				; too many open files
EACCESS equ 5				; access denied
EBADF equ 6				; invalid file handle
ECONTR equ 7				; memory control blocks destroyed
ENOMEM equ 8				; out of memory
EINVDAT equ 13				; invalid data
ENODEV equ 15				; invalid drive / device
EINVAL equ 19				; invalid argument
E2BIG equ 20				; environment too big
EWRITEFAULT equ 29			; write error

;-----------------------------------------------------------
; define constants needed by swapin code which can't be made
; into ABS externals
;
abort_offset equ 26
overlay_size equ 3Eh
finish_overlay_size equ 5
resident_addr equ 70h

;-----------------------------------------------------------
; define useful macros

ifdef __TINY__
    MOV_ES_PSP macro
	    push    cs
	    pop	    es
	endm
else
    MOV_ES_PSP macro
	     mov    es,_psp@
	 endm
endif ;__TINY__

COALESCE_MEMORY macro
	mov	ah,48h
	mov	bx,0FFFFh		; force DOS to coalesce free blocks
	int	21h			; by attempting to allocate 1MB-16
	endm

;-----------------------------------------------------------


;*************
;*END OF FILE*
;*************
