;             Change.asm
; A find and replace utility for text files - see PCMagazine 
; Modified Apr 88 by Mike Bate & Gary Meeker 
;   Added format_msg, too_big, no_match, is_changed error msgs, 
;   buffer size reduced to 10K, test for buffer overflow.
; Modified Jan 18,90 by Gary Meeker
;   Added wildcard character (?) matching on findstring (not allowed to match
;   a Carriage Return or Line Feed to prevent nasty changes)
;   Usage: CHANGE "Match This ???" "Match This NOW"
; Modified Jan 11,92 by Gary Meeker
;   Added a /Q option for no message output (QUIET Mode)
;
CR             EQU  13
LF             EQU  10
BELL           EQU  7

CODE SEGMENT                           ;*************************
ASSUME CS:CODE,DS:CODE                 ;*                       *
ORG 100H                               ;*  REMEMBER TO EXE2BIN  *
                                       ;*                       *
START:         JMP    BEGINNING        ;*************************


;              DATA AREA
;              ---------
FILE_START     DW  ?
FIND_CNT       DW  0
REPLACE_CNT    DW  0
CHANGE_FLAG    DW  0
DIFF_CNT       DW  0
SIZE_CHNG      DW  10000
QUIET          DB  0            ; Non-Quiet mode

FORMAT_MSG     DB  BELL,CR,LF
               DB  'Format:  CHANGE filespec "findstring" "replacestring"',CR,LF
               DB  '  Strings must be in quotes or decimal ASCII - '
               DB  'Multiple codes in a string',CR,LF
               DB  '  are separated by commas.   '
               DB  'e.g. CHANGE MYFILE 27,"-1" "+5"',CR,LF,'$'
NOT_FOUND$     DB  BELL,CR,LF,'File not found.',CR,LF,'$'
TOO_BIG$       DB  BELL,CR,LF,'File too big - 50K is max size.',CR,LF,'$'
NO_MATCH$      DB  CR,LF,'No Match Found.',CR,LF,'$'
OVERFLO_MSG$   DB  BELL,CR,LF
               DB  'Filesize increase too large - CHANGE not accomplished.'
               DB  CR,LF,'$'
IS_CHANGED$    DB  CR,LF,'Changed.',CR,LF,'$'
               DB  "Copyright 1986 Ziff-Davis Publishing Co."
               DB  "Programmed by Michael J. Mefford"
               DB  "Version 3.10 - Changes by Mike Bate & Gary Meeker",1Ah

;              CODE AREA
;              ---------

;-------------------------------------------------------;
; First we will parse the filename and the two strings. ;
;-------------------------------------------------------;

BEGINNING:     MOV    SI,80H                 ;Point to parameters.
               MOV    DX,OFFSET FORMAT_MSG   ;Point to syntax message.
               CLD                           ;Move in forward direction.
               CALL   SPACE                  ;Parse leading spaces.
               MOV    FILE_START,SI          ;We now point to filename.

FILE_BYTE:     CMP    BYTE PTR [SI],CR       ;Is it a carriage return?
               JZ     EXIT                   ;If yes, exit with syntax error.
               CMP    BYTE PTR [SI],' '      ;Is it a space?
               JZ     ASCIIZ                 ;If yes, end of filename
               INC    SI                     ; else, point to next byte
               JMP    SHORT FILE_BYTE        ; and check it.
ASCIIZ:        MOV    BYTE PTR [SI],0        ;Make filename into ASCIIZ.

               CALL   SPACE                  ;Parse the spaces.
               XOR    CX,CX                  ;Set string counter to zero.
               MOV    DI,OFFSET FIND$        ;Point to find string storage.
FIND_BYTE:     CALL   STRING                 ;Get string.
               CMP    BYTE PTR [SI],' '      ;Are we now pointing to space?
               JZ     REPLACE                ;If yes, done here.
               CMP    BYTE PTR [SI],CR       ;Is it a carriage return?
               JZ     EXIT                   ;If yes, it's a syntax error
               INC    SI                     ; else point to next byte
               JMP    SHORT FIND_BYTE        ; and get rest of string.

REPLACE:       CALL   SPACE                  ;Parse spaces.
               MOV    FIND_CNT,CX            ;Save count of find string bytes.
               XOR    CX,CX                  ;Reset counter to zero.
               MOV    DI,OFFSET REPLACE$     ;Point to replace string storage.
REPLACE_BYTE:  CALL   STRING                 ;Get string.
               CMP    BYTE PTR [SI],' '      ;Are we now pointing to space?
               JZ     OPEN_FILE              ;If yes, we are done here.
               CMP    BYTE PTR [SI],CR       ;Are we now pointing to CR?
               JZ     OPEN_FILE              ;If yes, we are done here
               INC    SI                     ; else, point to next byte
               JMP    SHORT REPLACE_BYTE     ; and get rest of string.

;------------------------------------------;
; The exit is placed in the middle of code ;
; so it can be reached by short jumps.     ;
;------------------------------------------;

EXIT:          CMP    QUIET, 1               ;Quiet Mode
               JE     EXIT_QUIET             ;Yes
               MOV    AH,9                   ;No, Display message
               INT    21H                    ;
EXIT_QUIET:    INT    20H                    ; and terminate.

;-----------------------------------------------------------;
; We are ready to open the file and read it into the buffer ;
; offset 10,000 bytes from the start. We will then move the ;
; bytes to the start of buffer, trading any match of find   ;
; string with replacement string.                           ;
;-----------------------------------------------------------;

OPEN_FILE:     MOV    REPLACE_CNT,CX         ;Save count of replace bytes.
               SUB    CX,FIND_CNT            ;Test filesize increase
               MOV    DIFF_CNT,CX            ; time replacement is made
               MOV    DX,FILE_START          ;Point to ASCIIZ filename
               MOV    AX,3D00H               ; and open file for reading.
               INT    21H
               MOV    DX,OFFSET NOT_FOUND$   ;If not found
               JC     EXIT                   ; display message and exit.

READ_FILE:     MOV    BX,AX                    ;File handle into BX
               MOV    DX,OFFSET BUFFER+10000   ;Point buffer
               MOV    CX,50000                 ;Attempt to read 50,000 bytes.
               MOV    AH,3FH
               INT    21H
               MOV    DX,OFFSET TOO_BIG$     ;Point to error message.
               CMP    AX,49999               ;Did we read 50,000 bytes?
               JA     EXIT                   ;If yes, file too big; exit
               PUSH   AX                     ; else, save count of bytes
               MOV    AH,3EH                 ; and close the file.
               INT    21H

COMPARE:       POP    DX                     ;Retrieve byte count.
               MOV    AX,FIND_CNT            ;Retrieve find string length.
               CMP    DX,AX                  ;Is find string bigger than file?
               JGE    OK                     ;If no, it's OK
               MOV    DX,OFFSET NO_MATCH$    ; else exit with no change.
               JMP    SHORT EXIT

OK:            MOV    BX,OFFSET BUFFER+10000 ;Point to start of file
               MOV    AX,OFFSET BUFFER       ; and start of storage.
NEXT_COMP:     MOV    SI,OFFSET FIND$        ; point to find string
               MOV    DI,BX                  ; point to match attempt
               MOV    CX,FIND_CNT            ; get find string length
;              REP    CMPSB                  ; and compare.
Compare_Loop:  CMP    BYTE PTR [SI],"?"
               JNE    Normal_comp
               CMP    BYTE PTR [DI],CR       ;We won't match a carriage return
               JE     Normal_comp
               CMP    BYTE PTR [DI],LF       ;We won't match a line feed either
               JE     Normal_comp
               CMPSB                         ;do the compare
               CMP    AL,AL                  ;but force a match
               JMP    SHORT Wild_Comp
Normal_Comp:   CMPSB
Wild_Comp:     LOOPE  Compare_Loop
               MOV    DI,AX                  ;Point storage area.
               JZ     MATCH                  ;If match, store replace string
               MOV    SI,BX                  ; else store
               MOVSB                         ; old byte
               INC    AX                     ; point to next storage spot
               INC    BX                     ; start of next byte to compare
               DEC    DX                     ; decrement file byte count
               JMP    SHORT LOOP1            ; and check if end of file.

OVERFLO:       MOV    DX,OFFSET OVERFLO_MSG$
               JMP    EXIT

MATCH:         OR     CHANGE_FLAG,1          ;Indicate that we found a match.
               MOV    CX,SIZE_CHNG
               ADD    CX,DIFF_CNT            ;increment size_chng
               MOV    SIZE_CHNG,CX
               CMP    SIZE_CHNG,20000        ;Filesize increase over 10K?
                                             ;(size_chng starts at 10K)
               JAE    OVERFLO                ;Yes - would be too big - Abort
               MOV    SI,OFFSET REPLACE$     ;Point to replacement string.
               MOV    CX,REPLACE_CNT         ;Get length.
               ADD    AX,CX                  ; point to next storage spot
               ADD    BX,FIND_CNT            ; start of next byte to compare
               SUB    DX,FIND_CNT            ; subtract from file byte count
               REP    MOVSB                  ; and store the string.

LOOP1:         CMP    FIND_CNT,DX            ;Is find string bigger than
               JB     NEXT_COMP              ; balance of file? If no, next
               MOV    CX,DX                  ; compare else, transfer the
               ADD    AX,CX                  ; balance of file to write
               MOV    SI,BX                  ; storage area.
               REP    MOVSB

;-----------------------------------------;
; We are ready to write the file to disk. ;
;-----------------------------------------;

WRITE:         PUSH   AX                     ;Save length of new file.
               MOV    DX,FILE_START          ; point to ASCIIZ filename.
               XOR    CX,CX                  ; normal attribute
               MOV    AH,3CH                 ; and create new file.
               INT    21H
               POP    CX                     ;Retrieve file length
               SUB    CX,OFFSET BUFFER       ;It's in offset form; correct it.
               MOV    BX,AX                  ;File handle into BX
               MOV    DX,OFFSET BUFFER       ; point to storage buffer
               MOV    AH,40H                 ; and write the file.
               INT    21H
               MOV    AH,3EH                 ;Close file.
               INT    21H
               MOV    DX,OFFSET NO_MATCH$    ;Point to "No Match Found" msg
               CMP    CHANGE_FLAG,0          ;Did we find a match?
               JZ     NOT_CHANGED            ;If no, display string as is
               MOV    DX,OFFSET IS_CHANGED$  ;or point to "Changed" msg
NOT_CHANGED:   JMP    EXIT                   ; and we are done.

;---------------------------------------------;
; This subroutine will get the quoted string  ;
; or convert the decimal ASCII to hexadecimal ;
; and store in the appropriate storage area.  ;
;---------------------------------------------;

STRING:        MOV    AH,[SI]                ;Get a character
               CMP    AH,'"'                 ;Is it double quotes?
               JZ     Got_Quote              ;Yes -
               CMP    AH,"'"                 ;No  - Is it single quotes?
               JNZ    NUMBER                 ;If no, must be number
Got_Quote:     INC    SI                     ; else, point to first string
NEXT_STRING:   LODSB                         ; byte and retrieve.
               CMP    AL,CR                  ;Is it carriage return?
               JZ     ERROR                  ;If yes, syntax error; exit.
               CMP    AL,AH                  ;Is it a matching quotes?
               JNZ    STORE                  ;If no, store the byte
               CALL   DELIMITER              ; else, see if delimiter
               JNC    STORE                  ; and store the quote if part
               RET                           ; of string else, we are done.

STORE:         STOSB                         ;Store the byte
               INC    CX                     ; increment byte count
               JMP    SHORT NEXT_STRING      ; and get next string byte

NUMBER:        XOR    BL,BL                  ;Zero into hex counter.
GET_NUMBER:    CALL   DELIMITER              ;Is it a delimiter?
               JNC    LOAD_NUMBER            ;If no, get next decimal number
               MOV    AL,BL                  ; get hex byte
               STOSB                         ; and store
               INC    CX                     ; increment byte count
               RET                           ; and we are done

LOAD_NUMBER:   LODSB                         ;Get the decimal number
               CMP    AL,'0'                 ;Is it between 0 and 9?
               JB     ERROR                  ;If no, syntax error
               CMP    AL,'9'
               JA     ERROR
               SUB    AL,30H                 ; else, convert to hex
               MOV    BH,AL                  ; and save
               MOV    AL,10                  ; multiply by ten
               MUL    BL                     ; to shift place left
               MOV    BL,AL
               ADD    BL,BH                  ; add new number
               JMP    SHORT GET_NUMBER       ; and get next decimal number.
ERROR:         JMP    EXIT                   ;In lieu of range of short jump.

;--------------------------------;
; This subroutine will parse     ;
; leading and delimiting spaces. ;
;--------------------------------;

SPACE:         INC    SI                     ;Point to next byte
               CMP    BYTE PTR [SI],' '      ;Is it space?
               JZ     SPACE                  ;If yes, get next byte
               CMP    BYTE PTR [SI],'/'      ;No,Are we now pointing to Switch?
               JNZ    SPACE_EXIT             ;   If no, we are done here
               INC    SI                     ;   Yes, skip over it
               CMP    BYTE PTR [SI],'Q'      ;        Is it Quiet
               JZ     SP_QUIET               ;        Yes
               CMP    BYTE PTR [SI],'q'      ;        Is it quiet
               JNZ    SPACE                  ;        No
SP_QUIET:      MOV    QUIET, 1               ;        Yes, set flag
               JMP    SPACE                  ; next byte
SPACE_EXIT:    RET                           ; else, return.

;----------------------------;
; This subroutine will check ;
; for delimiter characters.  ;
;----------------------------;

DELIMITER:     CLC                           ;Assume not delimiter.
               CMP    BYTE PTR [SI],' '      ;Is it space
               JZ     SET_CARRY
               CMP    BYTE PTR [SI],CR       ; or carriage return
               JZ     SET_CARRY
               CMP    BYTE PTR [SI],','      ; or comma?
               JNZ    RETURN                 ;If no, return else, indicate
SET_CARRY:     STC                           ; by setting carry flag
RETURN:        RET                           ; and return.

;-------------------------------------------------------------;
; Storage buffers for findstring, replacestring and file at   ;
; end of code to make basic data listing appreciably shorter. ;
;-------------------------------------------------------------;

FIND$:
ORG  OFFSET FIND$+128
REPLACE$:
ORG  OFFSET REPLACE$+128
BUFFER:

CODE ENDS
END  START

