/*
 * Decompiled with CFR 0.152.
 */
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.Textarea;
import java.awt.Component;
import java.io.File;
import processing.core.PApplet;
import sojamo.drop.DropEvent;
import sojamo.drop.SDrop;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LSDJ_Wav_Editor_2
extends PApplet {
    float fLastTime;
    int g_iDataPerByte;
    int g_iWavStart;
    int g_iMaxNumInstruments;
    int g_iFrameLength;
    int g_iNumFrames;
    int g_iInstrumentByteLength;
    int g_iFrameByteLength;
    int g_iMainDrawX;
    int g_iMainDrawY;
    int g_iMainDrawPixelSize;
    Point2D g_MainFrameDrawSize;
    SDrop g_Dropper;
    ControlP5 g_ControlP5;
    SelectionInfo g_SelectionInfo;
    DataManager g_DataManager;
    WavEditor g_WavEditor;
    Frame g_FrameClipboard;
    Frame g_SawFrame;
    Frame g_SquareFrame;
    Textarea g_InstrumentLabel;
    boolean g_bMouseDown;

    public void setup() {
        this.size(600, 320);
        this.smooth();
        this.g_Dropper = new SDrop((Component)((Object)this));
        this.g_ControlP5 = new ControlP5((PApplet)this);
        this.initialiseGUI();
        this.fLastTime = this.millis();
        this.g_SelectionInfo = new SelectionInfo();
        this.g_DataManager = new DataManager();
        this.g_WavEditor = new WavEditor();
        this.generateFrames();
    }

    public void draw() {
        this.background(200);
        this.g_WavEditor.processMainFrame(this.g_SelectionInfo);
        this.processFrameSelection();
        this.displayClipboard();
        if ((float)this.millis() > this.fLastTime + 33.0f) {
            this.fLastTime = this.millis();
        }
    }

    public void mousePressed() {
        this.g_bMouseDown = true;
    }

    public void mouseReleased() {
        this.g_bMouseDown = false;
    }

    public boolean mouseDown() {
        return this.g_bMouseDown;
    }

    public void dropEvent(DropEvent dropEvent) {
        if (dropEvent.isFile()) {
            File file = dropEvent.file();
            LSDJ_Wav_Editor_2.println((String)("\nisDirectory ? " + file.isDirectory() + "  /  isFile ? " + file.isFile()));
            LSDJ_Wav_Editor_2.println((String)file.toString());
            this.g_SelectionInfo.setInstrument(0);
            this.g_SelectionInfo.setFrame(0);
            this.g_DataManager.loadData(file.toString());
        }
    }

    public void keyPressed() {
        int n = this.g_SelectionInfo.getFrame();
        if (this.key == (char)-1) {
            if (this.keyCode == 39) {
                ++n;
            } else if (this.keyCode == 37) {
                --n;
            }
        }
        if (n < 0) {
            n = this.g_iNumFrames - 1;
        }
        if (n > this.g_iNumFrames - 1) {
            n = 0;
        }
        this.g_SelectionInfo.setFrame(n);
    }

    public boolean pointInBox(int n, int n2, int n3, int n4, int n5, int n6) {
        return n > n3 && n < n3 + n5 && n2 > n4 && n2 < n4 + n6;
    }

    public void processFrameSelection() {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < this.g_iNumFrames / 2) {
            n2 = 2;
            n = 20 + n3 * (n2 * (this.g_iFrameLength + n2));
            int n4 = n3;
            Point2D point2D = this.g_WavEditor.drawFrame(n4, n, 200, n2);
            if (n4 == this.g_SelectionInfo.getFrame()) {
                this.noFill();
                this.stroke(53.0f, 53.0f, 243.0f);
                this.rect(n - 1, 199.0f, point2D.x + 2, point2D.y + 2);
            }
            n4 = n3 + this.g_iNumFrames / 2;
            point2D = this.g_WavEditor.drawFrame(n4, n, 240, n2);
            if (n4 == this.g_SelectionInfo.getFrame()) {
                this.noFill();
                this.stroke(53.0f, 53.0f, 243.0f);
                this.rect(n - 1, 239.0f, point2D.x + 2, point2D.y + 2);
            }
            ++n3;
        }
        if (this.mouseDown()) {
            n3 = 0;
            while (n3 < this.g_iNumFrames / 2) {
                n2 = 2;
                n = 20 + n3 * (n2 * (this.g_iFrameLength + n2));
                Point2D point2D = this.g_WavEditor.getFrameSize(n2);
                if (this.pointInBox(this.mouseX, this.mouseY, n, 200, point2D.x, point2D.y)) {
                    this.g_SelectionInfo.setFrame(n3);
                }
                if (this.pointInBox(this.mouseX, this.mouseY, n, 240, point2D.x, point2D.y)) {
                    this.g_SelectionInfo.setFrame(n3 + this.g_iNumFrames / 2);
                }
                ++n3;
            }
        }
    }

    public void displayClipboard() {
        this.g_WavEditor.drawFrame(this.g_FrameClipboard, 430, 20, 4);
    }

    public void initialiseGUI() {
        this.g_ControlP5.addButton("Save", 1.0f, 20, 290, 50, 20).setId(0);
        this.g_ControlP5.addButton("Copy Frame", 1.0f, 80, 290, 80, 20).setId(1);
        this.g_ControlP5.addButton("Paste Frame", 1.0f, 170, 290, 80, 20).setId(2);
        this.g_ControlP5.addTextarea("clipboardlabel", "Frame Clipboard:", 350, 20, 200, 60);
        this.g_ControlP5.addButton("Copy Square", 1.0f, 350, 100, 80, 20).setId(3);
        this.g_ControlP5.addButton("Copy Saw", 1.0f, 440, 100, 80, 20).setId(4);
        this.g_ControlP5.addSlider("Pulse Width", 0.0f, 100.0f, 50.0f, 350, 130, 100, 10);
        this.g_ControlP5.addButton("Generate Pulse", 1.0f, 350, 150, 80, 20).setId(5);
        this.g_InstrumentLabel = this.g_ControlP5.addTextarea("instrumentlabel", "Current Instrument: 0", 260, 293, 200, 60);
        this.g_ControlP5.addButton(" <", 1.0f, 530, 290, 20, 20).setId(6);
        this.g_ControlP5.addButton(" >", 1.0f, 555, 290, 20, 20).setId(7);
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (!this.g_DataManager.loadedData()) {
            return;
        }
        switch (controlEvent.controller().id()) {
            case 0: {
                this.g_DataManager.saveData("save.sav");
                break;
            }
            case 1: {
                this.g_FrameClipboard = this.g_DataManager.getFrame(this.g_SelectionInfo).getCopy();
                break;
            }
            case 2: {
                this.g_DataManager.setFrame(this.g_SelectionInfo, this.g_FrameClipboard);
                break;
            }
            case 3: {
                this.g_FrameClipboard = this.g_SquareFrame.getCopy();
                break;
            }
            case 4: {
                this.g_FrameClipboard = this.g_SawFrame.getCopy();
                break;
            }
            case 5: {
                this.g_DataManager.setFrame(this.g_SelectionInfo, this.generatePulseWidth(LSDJ_Wav_Editor_2.floor((float)this.g_ControlP5.controller("Pulse Width").value())));
                break;
            }
            case 6: {
                this.g_DataManager.previousInstrument();
                this.g_InstrumentLabel.setText("Current Instrument: " + this.g_SelectionInfo.getInstrument());
                break;
            }
            case 7: {
                this.g_DataManager.nextInstrument();
                this.g_InstrumentLabel.setText("Current Instrument: " + this.g_SelectionInfo.getInstrument());
                break;
            }
        }
    }

    public void generateFrames() {
        this.g_SawFrame = this.generateSawFrame();
        this.g_SquareFrame = this.generateSquareFrame();
    }

    public Frame generateSawFrame() {
        Frame frame = new Frame();
        int n = 0;
        while (n < this.g_iFrameLength) {
            int n2;
            frame.iData[n] = n2 = 15 - LSDJ_Wav_Editor_2.floor((float)(n / 2));
            ++n;
        }
        return frame;
    }

    public Frame generateSquareFrame() {
        return this.generatePulseWidth(50);
    }

    public Frame generatePulseWidth(int n) {
        Frame frame = new Frame();
        int n2 = 0;
        while (n2 < this.g_iFrameLength) {
            float f = (float)n / 100.0f;
            int n3 = LSDJ_Wav_Editor_2.floor((float)((float)this.g_iFrameLength * f));
            LSDJ_Wav_Editor_2.println((int)n3);
            frame.iData[n2] = n2 < n3 ? 15 : 0;
            ++n2;
        }
        return frame;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"LSDJ_Wav_Editor_2"});
    }

    private final /* synthetic */ void this() {
        this.g_iDataPerByte = 2;
        this.g_iWavStart = LSDJ_Wav_Editor_2.unhex((String)"6000");
        this.g_iMaxNumInstruments = 8;
        this.g_iFrameLength = 32;
        this.g_iNumFrames = 16;
        this.g_iInstrumentByteLength = 256;
        this.g_iFrameByteLength = 16;
        this.g_iMainDrawX = 20;
        this.g_iMainDrawY = 20;
        this.g_iMainDrawPixelSize = 10;
        this.g_FrameClipboard = new Frame();
        this.g_SawFrame = new Frame();
        this.g_SquareFrame = new Frame();
        this.g_bMouseDown = false;
    }

    public LSDJ_Wav_Editor_2() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SelectionInfo {
        int m_iSelectedFrame;
        int m_iSelectedInstrument;

        public void setFrame(int n) {
            this.m_iSelectedFrame = n;
        }

        public void setInstrument(int n) {
            this.m_iSelectedInstrument = n;
        }

        public int getFrame() {
            return this.m_iSelectedFrame;
        }

        public int getInstrument() {
            return this.m_iSelectedInstrument;
        }

        private final /* synthetic */ void this() {
            this.m_iSelectedFrame = 0;
            this.m_iSelectedInstrument = 0;
        }

        SelectionInfo() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DataManager {
        Instrument[] m_Instruments;
        byte[] m_LoadedBytes;
        boolean m_bLoadedData;

        public void loadData(String string) {
            this.m_LoadedBytes = LSDJ_Wav_Editor_2.this.loadBytes(string);
            this.m_bLoadedData = true;
            this.fillFrames();
        }

        public void debugCheck() {
            this.fillBytesFromFrames();
            this.fillFrames();
        }

        public void fillFrames() {
            int n = 0;
            int n2 = 0;
            while (n2 < LSDJ_Wav_Editor_2.this.g_iMaxNumInstruments) {
                int n3 = LSDJ_Wav_Editor_2.this.g_iWavStart + n2 * LSDJ_Wav_Editor_2.this.g_iInstrumentByteLength;
                int n4 = 0;
                while (n4 < LSDJ_Wav_Editor_2.this.g_iNumFrames) {
                    int n5 = n3 + n4 * LSDJ_Wav_Editor_2.this.g_iFrameByteLength;
                    int n6 = 0;
                    while (n6 < LSDJ_Wav_Editor_2.this.g_iFrameLength) {
                        n = n5 + LSDJ_Wav_Editor_2.floor((float)(n6 / 2));
                        byte by = this.m_LoadedBytes[n];
                        String string = LSDJ_Wav_Editor_2.binary((int)by, (int)8);
                        String string2 = n6 % 2 == 0 ? string.substring(0, 4) : string.substring(4);
                        this.m_Instruments[n2].frames[n4].iData[n6] = LSDJ_Wav_Editor_2.unbinary((String)string2);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public void fillBytesFromFrames() {
            int n = 0;
            while (n < LSDJ_Wav_Editor_2.this.g_iMaxNumInstruments) {
                int n2 = LSDJ_Wav_Editor_2.this.g_iWavStart + n * LSDJ_Wav_Editor_2.this.g_iInstrumentByteLength;
                int n3 = 0;
                while (n3 < LSDJ_Wav_Editor_2.this.g_iNumFrames) {
                    int n4 = n2 + n3 * LSDJ_Wav_Editor_2.this.g_iFrameByteLength;
                    int n5 = 0;
                    while (n5 < LSDJ_Wav_Editor_2.this.g_iFrameLength / 2) {
                        int n6 = n4 + LSDJ_Wav_Editor_2.this.g_iInstrumentByteLength * n + n5;
                        String string = LSDJ_Wav_Editor_2.binary((int)this.m_Instruments[n].frames[n3].iData[2 * n5], (int)4);
                        String string2 = LSDJ_Wav_Editor_2.binary((int)this.m_Instruments[n].frames[n3].iData[2 * n5 + 1], (int)4);
                        LSDJ_Wav_Editor_2.print((String)(string + ' ' + string2));
                        LSDJ_Wav_Editor_2.println();
                        String string3 = string + string2;
                        int n7 = LSDJ_Wav_Editor_2.unbinary((String)string3);
                        this.m_LoadedBytes[n6] = PApplet.parseByte((int)n7);
                        ++n5;
                    }
                    ++n3;
                }
                ++n;
            }
        }

        public void saveData(String string) {
            this.fillBytesFromFrames();
            LSDJ_Wav_Editor_2.this.saveBytes(string, this.m_LoadedBytes);
        }

        public int getData(SelectionInfo selectionInfo, int n) {
            return this.getData(selectionInfo.getInstrument(), selectionInfo.getFrame(), n);
        }

        public int getData(int n, int n2, int n3) {
            return this.m_Instruments[n].frames[n2].iData[n3];
        }

        public Frame getFrame(int n, int n2) {
            return this.m_Instruments[n].frames[n2];
        }

        public Frame getFrame(SelectionInfo selectionInfo) {
            return this.m_Instruments[selectionInfo.getInstrument()].frames[selectionInfo.getFrame()];
        }

        public void setFrame(SelectionInfo selectionInfo, Frame frame) {
            this.m_Instruments[selectionInfo.getInstrument()].frames[selectionInfo.getFrame()] = frame;
        }

        public void setData(SelectionInfo selectionInfo, int n, int n2) {
            this.m_Instruments[selectionInfo.getInstrument()].frames[selectionInfo.getFrame()].iData[n] = n2;
        }

        public boolean loadedData() {
            return this.m_bLoadedData;
        }

        public void nextInstrument() {
            int n = LSDJ_Wav_Editor_2.this.g_SelectionInfo.getInstrument();
            if (++n > LSDJ_Wav_Editor_2.this.g_iMaxNumInstruments - 1) {
                n = 0;
            }
            LSDJ_Wav_Editor_2.this.g_SelectionInfo.setInstrument(n);
        }

        public void previousInstrument() {
            int n = LSDJ_Wav_Editor_2.this.g_SelectionInfo.getInstrument();
            if (--n < 0) {
                n = LSDJ_Wav_Editor_2.this.g_iMaxNumInstruments - 1;
            }
            LSDJ_Wav_Editor_2.this.g_SelectionInfo.setInstrument(n);
        }

        private final /* synthetic */ void this() {
            this.m_Instruments = new Instrument[LSDJ_Wav_Editor_2.this.g_iMaxNumInstruments];
            this.m_bLoadedData = false;
        }

        DataManager() {
            this.this();
            int n = 0;
            while (n < LSDJ_Wav_Editor_2.this.g_iMaxNumInstruments) {
                this.m_Instruments[n] = new Instrument();
                int n2 = 0;
                while (n2 < LSDJ_Wav_Editor_2.this.g_iNumFrames) {
                    this.m_Instruments[n].frames[n2] = new Frame();
                    ++n2;
                }
                ++n;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WavEditor {
        Point2D m_MainDrawPos;
        int m_iMainPixelSize;
        Point2D m_MainFrameDrawSize;

        public void processMainFrame(SelectionInfo selectionInfo) {
            if (LSDJ_Wav_Editor_2.this.g_DataManager.loadedData()) {
                this.m_MainFrameDrawSize = this.drawFrame(selectionInfo.getFrame(), this.m_MainDrawPos.x, this.m_MainDrawPos.y, this.m_iMainPixelSize);
                this.modifyMainFrame();
            } else {
                Point2D point2D = this.getFrameSize(this.m_iMainPixelSize);
                LSDJ_Wav_Editor_2.this.fill(53);
                LSDJ_Wav_Editor_2.this.stroke(153);
                LSDJ_Wav_Editor_2.this.rect(this.m_MainDrawPos.x, this.m_MainDrawPos.y, point2D.x, point2D.y);
            }
        }

        public void modifyMainFrame() {
            if (!LSDJ_Wav_Editor_2.this.mouseDown()) {
                return;
            }
            boolean bl = false;
            int n = LSDJ_Wav_Editor_2.this.mouseX - this.m_MainDrawPos.x;
            int n2 = LSDJ_Wav_Editor_2.this.mouseY - this.m_MainDrawPos.y;
            if (n > 0 && n < this.m_MainFrameDrawSize.x && n2 > 0 && n2 < this.m_MainFrameDrawSize.y) {
                bl = true;
            }
            if (bl) {
                Point2D point2D = this.getPointInGrid(n, n2, 10);
                LSDJ_Wav_Editor_2.this.g_DataManager.setData(LSDJ_Wav_Editor_2.this.g_SelectionInfo, point2D.x, 16 - point2D.y);
            }
        }

        public Point2D getFrameSize(int n) {
            Point2D point2D = new Point2D();
            point2D.x = LSDJ_Wav_Editor_2.this.g_iFrameLength * n;
            point2D.y = 16 * n;
            return point2D;
        }

        public Point2D drawFrame(int n, int n2, int n3, int n4) {
            return this.drawFrame(LSDJ_Wav_Editor_2.this.g_DataManager.getFrame(LSDJ_Wav_Editor_2.this.g_SelectionInfo.getInstrument(), n), n2, n3, n4);
        }

        public Point2D drawFrame(Frame frame, int n, int n2, int n3) {
            Point2D point2D = this.getFrameSize(n3);
            LSDJ_Wav_Editor_2.this.fill(53);
            LSDJ_Wav_Editor_2.this.stroke(153);
            LSDJ_Wav_Editor_2.this.rect(n, n2, point2D.x, point2D.y);
            LSDJ_Wav_Editor_2.this.noStroke();
            int n4 = 0;
            while (n4 < LSDJ_Wav_Editor_2.this.g_iFrameLength) {
                int n5 = frame.getData(n4) + 1;
                int n6 = n + n4 * n3;
                int n7 = n2 + 16 * n3 - n5 * n3;
                LSDJ_Wav_Editor_2.this.fill(143);
                LSDJ_Wav_Editor_2.this.rect(n6, n7, n3, n5 * n3);
                LSDJ_Wav_Editor_2.this.fill(243);
                LSDJ_Wav_Editor_2.this.rect(n6, n7, n3, n3);
                ++n4;
            }
            return point2D;
        }

        public Point2D getPointInGrid(int n, int n2, int n3) {
            Point2D point2D = new Point2D();
            point2D.x = n;
            point2D.y = n2;
            return this.getPointInGrid(point2D, n3);
        }

        public Point2D getPointInGrid(Point2D point2D, int n) {
            Point2D point2D2 = new Point2D();
            point2D2.x = LSDJ_Wav_Editor_2.floor((float)(point2D.x / n));
            point2D2.y = LSDJ_Wav_Editor_2.floor((float)(point2D.y / n)) + 1;
            return point2D2;
        }

        WavEditor() {
            this.m_MainDrawPos = new Point2D(20, 20);
            this.m_iMainPixelSize = 10;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Point2D {
        int x;
        int y;

        Point2D() {
            this.x = 0;
            this.y = 0;
        }

        Point2D(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Frame {
        int[] iData;

        public Frame getCopy() {
            Frame frame = new Frame();
            int n = 0;
            while (n < LSDJ_Wav_Editor_2.this.g_iFrameLength) {
                frame.iData[n] = this.iData[n];
                ++n;
            }
            return frame;
        }

        public int getData(int n) {
            return this.iData[n];
        }

        Frame() {
            this.iData = new int[LSDJ_Wav_Editor_2.this.g_iFrameLength];
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Instrument {
        Frame[] frames;

        Instrument() {
            this.frames = new Frame[LSDJ_Wav_Editor_2.this.g_iNumFrames];
        }
    }
}

