/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5IOHandler;
import java.awt.Component;
import processing.core.PImage;

public class BitFontRenderer {
    static int numFonts = 3;
    int[] characters = new int[numFonts];
    int[][] charWidth = new int[numFonts][255];
    int[] charHeight = new int[numFonts];
    int[][][] chars = new int[numFonts][][];
    int[] lineHeight = new int[numFonts];
    int[] wh = new int[numFonts];
    protected static PImage[] font = new PImage[numFonts];
    private int _myCurrentFont = 0;
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    protected float height;
    protected int _mySpacing = 1;

    protected BitFontRenderer(Component component) {
        BitFontRenderer.font[0] = new PImage(ControlP5IOHandler.loadImage(component, this.getClass().getResource("standard58.gif")));
        BitFontRenderer.font[1] = new PImage(ControlP5IOHandler.loadImage(component, this.getClass().getResource("standard56.gif")));
        BitFontRenderer.font[2] = new PImage(ControlP5IOHandler.loadImage(component, this.getClass().getResource("synt24.gif")));
        this._myCurrentFont = 0;
        this.init();
    }

    public BitFontRenderer() {
        BitFontRenderer.font[0] = new PImage(ControlP5IOHandler.loadImage(this.getClass().getResource("standard58.gif")));
        BitFontRenderer.font[1] = new PImage(ControlP5IOHandler.loadImage(this.getClass().getResource("standard56.gif")));
        BitFontRenderer.font[2] = new PImage(ControlP5IOHandler.loadImage(this.getClass().getResource("synt24.gif")));
        this._myCurrentFont = 0;
        this.init();
    }

    private void init() {
        for (int i = 0; i < numFonts; ++i) {
            int n;
            this.charHeight[i] = BitFontRenderer.font[i].height;
            this.lineHeight[i] = this.charHeight[i];
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < BitFontRenderer.font[i].width; ++n) {
                ++n2;
                if (BitFontRenderer.font[i].pixels[n] != -65536) continue;
                this.charWidth[i][this.characters[i]] = n2;
                int n4 = i;
                this.characters[n4] = this.characters[n4] + 1;
                if (n2 > n3) {
                    n3 = n2;
                }
                n2 = 0;
            }
            this.chars[i] = new int[this.characters[i]][n3 * this.charHeight[i]];
            n = 0;
            for (int j = 0; j < this.characters[i]; ++j) {
                for (int k = 0; k < this.charWidth[i][j] * this.charHeight[i]; ++k) {
                    this.chars[i][j][k] = BitFontRenderer.font[i].pixels[n + k / this.charWidth[i][j] * BitFontRenderer.font[i].width + k % this.charWidth[i][j]];
                }
                n += this.charWidth[i][j];
            }
        }
    }

    public void setFont(int n) {
        this._myCurrentFont = n;
    }

    public int getWidth(String string, int n) {
        int n2 = 0;
        if (string == null) {
            string = " ";
        }
        for (int i = 0; i < string.length(); ++i) {
            int n3 = string.charAt(i) - 32;
            if (n3 < 0) continue;
            n2 += this.charWidth[n][n3] + this._mySpacing;
        }
        return n2 + 10;
    }

    public void setLineHeight(int n) {
        this.lineHeight[this._myCurrentFont] = n;
    }

    private void putchar(int n, int n2, int n3, int n4, boolean bl, PImage pImage, PImage pImage2, int n5) {
        try {
            int n6 = pImage.width * pImage.height;
            int n7 = this.charWidth[this._myCurrentFont][n] * this.charHeight[this._myCurrentFont];
            int n8 = n3 * pImage.width;
            for (int i = 0; i < n7; ++i) {
                int n9 = n2 + i % this.charWidth[this._myCurrentFont][n];
                int n10 = n9 + n8 + i / this.charWidth[this._myCurrentFont][n] * pImage.width;
                if (this.chars[this._myCurrentFont][n][i] != -16777216 || n9 >= pImage.width || n10 < 0 || n10 >= n6) continue;
                pImage.pixels[n10] = !bl ? n4 : -6710887;
                pImage2.pixels[n10] = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int write(PImage pImage, PImage pImage2, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = 0;
        int n10 = n2;
        Letter[] letterArray = new Letter[string.length()];
        int n11 = 0;
        for (n8 = 0; n8 < string.length(); ++n8) {
            char c = string.charAt(n8);
            if (c != '\n') {
                if (n5 > 0 && n9 > n5) {
                    n9 = 0;
                    n2 += n6;
                    int n12 = n8;
                    ++n11;
                    while (n8 > 0 && n11 < string.length()) {
                        if (--n8 == 1) {
                            n8 = n12;
                            break;
                        }
                        if (string.charAt(n8) != ' ' && string.charAt(n8) != '-') continue;
                        c = string.charAt(++n8);
                        break;
                    }
                }
                letterArray[n8] = new Letter(n9, c - 32, n2, n8 == n4);
                n9 += this.charWidth[this._myCurrentFont][c - 32] + n7;
                continue;
            }
            n2 += n6;
            n9 = 0;
            letterArray[n8] = new Letter(0, -1, 0, false);
        }
        for (n8 = 0; n8 < letterArray.length; ++n8) {
            if (letterArray[n8].letter == -1) continue;
            this.putchar(letterArray[n8].letter, n + letterArray[n8].indent, letterArray[n8].lineheight, n3, letterArray[n8].isHighlight, pImage, pImage2, n6);
        }
        return n2 - n10;
    }

    public int write(PImage pImage, String string, int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        int n7;
        int n8 = pImage.width * pImage.height;
        PImage pImage2 = new PImage(pImage.width, pImage.height);
        for (n7 = 0; n7 < n8; ++n7) {
            pImage.pixels[n7] = 0xFFFFFF;
            pImage2.pixels[n7] = -16777216;
        }
        n7 = this.write(pImage, pImage2, string, n, n2, n3, n4 - 1, bl ? pImage.width : -1, n5, n6);
        pImage.mask(pImage2);
        return n7;
    }

    private class Letter {
        int indent;
        int letter;
        boolean isHighlight;
        int lineheight;

        Letter(int n, int n2, int n3, boolean bl) {
            this.indent = n;
            this.letter = n2;
            this.isHighlight = bl;
            this.lineheight = n3;
        }
    }
}

