/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFontRenderer;
import controlP5.CDrawable;
import controlP5.CVector3f;
import java.awt.Component;
import processing.core.PApplet;
import processing.core.PImage;

public class Label
implements CDrawable {
    private PImage _myImage;
    private String _myText;
    private int _myWidth;
    private int _myHeight;
    private int _myColor;
    public static boolean isToUpperCase = true;
    private boolean isFixedSize = false;
    public static BitFontRenderer bitFontRenderer;
    private int _myFontIndex = 0;
    private int _myCursorPosition = -1;
    private boolean isMultiline = false;
    private int _myLineHeight = 10;
    private int _myOffsetY = 0;
    private int _myTextHeight;
    private boolean isVisible = true;
    public CVector3f position = new CVector3f();
    private int _myLetterSpacing = 0;

    protected Label(String string) {
        this(string, 0, 10, -1);
    }

    protected Label(String string, int n) {
        this(string, 0, 10, n);
    }

    protected Label(String string, int n, int n2) {
        this(string, n, n2, -1);
    }

    protected Label(String string, int n, int n2, int n3) {
        bitFontRenderer = new BitFontRenderer();
        this.init(string, n != 0 ? n : bitFontRenderer.getWidth(string.toUpperCase(), 0), n2, n3);
    }

    public Label(PApplet pApplet, String string, int n, int n2, int n3) {
        bitFontRenderer = new BitFontRenderer((Component)pApplet);
        this.init(string, n, n2, n3);
    }

    private void init(String string, int n, int n2, int n3) {
        if (string == null) {
            string = "";
        }
        this._myText = string;
        this._myWidth = n;
        this._myHeight = n2;
        this._myColor = n3;
        this._myImage = new PImage(this._myWidth, this._myHeight);
        this.fixedSize(true);
        this.set(this._myText);
    }

    public void toUpperCase(boolean bl) {
        isToUpperCase = bl;
        this.update();
    }

    public void draw(PApplet pApplet, int n, int n2) {
        if (this.isVisible && this._myImage.width > 0 && this._myImage.height > 0) {
            pApplet.image(this._myImage, (float)n, (float)n2);
        }
    }

    public void draw(PApplet pApplet) {
        if (this.isVisible) {
            pApplet.image(this._myImage, this.position.x, this.position.y);
        }
    }

    protected void draw(PApplet pApplet, int n, int n2, int n3) {
        if (this._myImage.width > 0 && this._myImage.height > 0) {
            this._myColor = n3;
            pApplet.image(this._myImage, (float)n, (float)n2);
        }
    }

    public void set(String string) {
        this.set(string, this._myColor, this._myCursorPosition);
    }

    public void set(String string, int n) {
        this._myColor = n;
        this.set(string, this._myColor, this._myCursorPosition);
    }

    public void setWithCursorPosition(String string, int n) {
        this.set(string, this._myColor, n);
    }

    public void setFont(int n) {
        this._myFontIndex = n;
        this.update();
    }

    protected void setLineHeight(int n) {
        this._myLineHeight = n;
    }

    protected void setLetterSpacing(int n) {
        this._myLetterSpacing = n;
        this.update();
    }

    public int lineHeight() {
        return this._myLineHeight;
    }

    public void multiline(boolean bl) {
        this.isMultiline = bl;
    }

    protected void update() {
        if (!this.isFixedSize) {
            this._myHeight = BitFontRenderer.font[this._myFontIndex].height;
            this._myWidth = bitFontRenderer.getWidth(this._myText, this._myFontIndex);
            this._myWidth += this._myText.length() * this._myLetterSpacing;
        }
        this._myImage = new PImage(this._myWidth, this._myHeight);
        this.set(this._myText, this._myColor, this._myCursorPosition);
    }

    public void setOffset(float f) {
        this._myOffsetY = (int)f;
    }

    public int offset() {
        return this._myOffsetY;
    }

    protected void set(String string, int n, int n2) {
        int n3;
        this._myCursorPosition = n2;
        bitFontRenderer.setFont(this._myFontIndex);
        if (string == null) {
            string = "";
        }
        if (!this.isFixedSize && (n3 = bitFontRenderer.getWidth(string, this._myFontIndex)) > this._myWidth) {
            this._myWidth = n3;
            this._myImage = new PImage(n3, this._myHeight);
        }
        this._myText = string;
        this._myColor = n;
        this._myTextHeight = bitFontRenderer.write(this._myImage, isToUpperCase ? this._myText.toUpperCase() : this._myText, 0, this._myOffsetY, this._myColor, n2, this.isMultiline, this._myLineHeight, this._myLetterSpacing);
        this._myImage.updatePixels();
    }

    public int textHeight() {
        return this._myTextHeight;
    }

    public void fixedSize(boolean bl) {
        this.isFixedSize = bl;
    }

    public int color() {
        return this._myColor;
    }

    public void setColor(int n) {
        this._myColor = n;
        this.set(this._myText, n);
    }

    public int width() {
        return this._myWidth;
    }

    public int height() {
        return this._myHeight;
    }

    public void setWidth(int n) {
        this._myWidth = n;
    }

    public void setHeight(int n) {
        this._myHeight = n;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public String toString() {
        return this._myText;
    }
}

