/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CRect;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.MultiListButton;
import controlP5.MultiListInterface;
import controlP5.Tab;
import java.util.Vector;
import processing.core.PApplet;

public class MultiList
extends Controller
implements MultiListInterface {
    protected Tab _myTab;
    protected boolean isVisible = true;
    private int cnt;
    protected boolean isOccupied;
    protected boolean isUpdateLocation = false;
    protected MultiListInterface mostRecent;
    protected CRect _myRect;
    public int closeDelay = 30;

    public MultiList(ControlP5 controlP5, Tab tab, String string, int n, int n2, int n3, int n4) {
        super(controlP5, tab, string, n, n2, n3, n4);
        this.setup();
    }

    public void setup() {
        this.mostRecent = this;
        this.isVisible = true;
        this.updateRect(this.position().x, this.position().y, this.width, this.height);
    }

    public void remove() {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.controlP5 != null) {
            this.controlP5.remove(this);
        }
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((MultiListButton)this.subelements.get(i)).remove();
        }
    }

    public Vector subelements() {
        return this.subelements;
    }

    protected void updateRect(float f, float f2, float f3, float f4) {
        this._myRect = new CRect(f, f2, f3, f4);
    }

    public void updateLocation(float f, float f2) {
        this.position().x += f;
        this.position().y += f2;
        this.updateRect(this.position().x, this.position().y, this.width, this.height);
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((MultiListInterface)this.subelements.get(i)).updateLocation(f, f2);
        }
    }

    public MultiListButton add(String string, int n) {
        MultiListButton multiListButton = new MultiListButton(this.controlP5, string, n, (int)this.position().x, (int)this.position().y + (this.height + 1) * this.subelements.size(), this.width, this.height, this, this);
        multiListButton.isMoveable = false;
        this.controlP5.register(multiListButton);
        this.subelements.add(multiListButton);
        multiListButton.show();
        this.updateRect(this.position().x, this.position().y, this.width, (this.height + 1) * this.subelements.size());
        return multiListButton;
    }

    public void draw(PApplet pApplet) {
        this.update(pApplet);
    }

    public boolean update(PApplet pApplet) {
        if (!this.isOccupied) {
            ++this.cnt;
            if (this.cnt == this.closeDelay) {
                this.close();
            }
        }
        if (this.isUpdateLocation) {
            this.updateLocation(this._myControlWindow.mouseX - this._myControlWindow.pmouseX, this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
            this.isUpdateLocation = pApplet.mousePressed;
        }
        if (this.isOccupied && pApplet.keyPressed && pApplet.mousePressed) {
            if (pApplet.keyCode == 18) {
                this.isUpdateLocation = true;
                return true;
            }
        }
        return false;
    }

    public void occupied(boolean bl) {
        this.isOccupied = bl;
        this.cnt = 0;
    }

    public boolean observe() {
        return CRect.inside(this._myRect, this._myControlWindow.mouseX, this._myControlWindow.mouseY);
    }

    public void close(MultiListInterface multiListInterface) {
        for (int i = 0; i < this.subelements.size(); ++i) {
            if (multiListInterface == (MultiListInterface)this.subelements.get(i)) continue;
            ((MultiListInterface)this.subelements.get(i)).close();
        }
    }

    public void close() {
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((MultiListInterface)this.subelements.get(i)).close();
        }
    }

    public void open() {
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((MultiListInterface)this.subelements.get(i)).open();
        }
    }

    public void setValue(float f) {
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "multilist");
        for (int i = 0; i < this.subelements.size(); ++i) {
            ((MultiListInterface)this.subelements.get(i)).addToXMLElement(controlP5XMLElement);
        }
    }
}

