/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.Slider;
import java.util.Hashtable;

public class ScrollList
extends ControlGroup
implements ControlListener {
    int _myListHeight;
    int _mySpacing = 13;
    int myCurrentHeight = 0;
    Slider _myScrollbar;
    String _myName;

    protected ScrollList(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, 9);
        this._myWidth = n3;
        this._myListHeight = n4 / this._mySpacing * this._mySpacing + 1 - 2;
        this._myScrollbar = new Slider(this.controlP5, this._myParent, string + "Scroller", 0.0f, this._myListHeight, 0.0f, this._myWidth + 1, 0, 10, this._myListHeight);
        this._myName = string;
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.setMoveable(false);
        this._myScrollbar.setLabelVisible(false);
        this._myScrollbar.setParent(this);
        this.add(this._myScrollbar);
        this._myScrollbar.addListener(this);
        this._myScrollbar.setVisible(false);
        this._myScrollbar.hide();
    }

    public Button addItem(String string, int n) {
        int n2 = this.controllers.size() - 1;
        this.myCurrentHeight += this._mySpacing;
        Button button = new Button(this.controlP5, this, string, n, 0, n2 * this._mySpacing, this._myWidth, this._mySpacing - 1);
        button.setMoveable(false);
        this.add(button);
        this.controlP5.register(button);
        this._myScrollbar.setMax(this.myCurrentHeight - this._myListHeight - 1);
        this._myScrollbar.setValue(this._myScrollbar.value() + (float)this._mySpacing);
        if (this.myCurrentHeight > this._myListHeight) {
            this._myScrollbar.show();
        }
        return button;
    }

    public void removeItem(String string) {
        for (int i = this.controllers.size() - 1; i >= 0; --i) {
            if (!this.controllers.get(i).name().equals(string)) continue;
            this.controllers.remove(this.controllers.get(i));
            this.controllers.get(i).remove();
            this.myCurrentHeight -= this._mySpacing * 2;
            this._myScrollbar.setMax(this.myCurrentHeight - this._myListHeight);
            this._myScrollbar.setValue(this._myScrollbar.value() + (float)this._mySpacing);
            if (this.myCurrentHeight > this._myListHeight) {
                this._myScrollbar.show();
                continue;
            }
            this._myScrollbar.hide();
        }
    }

    public void controlEvent(ControlEvent controlEvent) {
        float f = this.myCurrentHeight - this._myListHeight + this._mySpacing;
        int n = (int)((controlEvent.value() - f) / (float)this._mySpacing) * this._mySpacing;
        for (int i = 1; i < this.controllers.size(); ++i) {
            this.controllers.get((int)i).position().y = n + i * this._mySpacing;
            if (this.controllers.get(i).position().y() < 0.0f || this.controllers.get(i).position().y() > (float)this._myListHeight) {
                this.controllers.get(i).hide();
                continue;
            }
            this.controllers.get(i).show();
        }
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "scrolllist");
        controlP5XMLElement.setAttribute("width", new Integer(this._myWidth));
        controlP5XMLElement.setAttribute("height", new Integer(this._myListHeight + 1));
        for (int i = 1; i < this.controllers.size(); ++i) {
            ControlP5XMLElement controlP5XMLElement2 = new ControlP5XMLElement(new Hashtable(), true, false);
            controlP5XMLElement2.setName("item");
            controlP5XMLElement2.setAttribute("name", ((Controller)this.controllers.get(i)).name());
            controlP5XMLElement2.setAttribute("id", new Integer(((Controller)this.controllers.get(i)).id()));
            controlP5XMLElement2.setAttribute("value", new Float(((Controller)this.controllers.get(i)).value()));
            controlP5XMLElement.addChild(controlP5XMLElement2);
        }
    }
}

