/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.ControllerGroup;
import controlP5.Label;
import controlP5.Slider;
import processing.core.PApplet;

public class Textarea
extends ControllerGroup
implements ControlListener {
    String _myText;
    Slider _myScrollbar;
    int _myWidth = 200;
    int _myHeight = 20;

    public Textarea(ControlP5 controlP5, ControllerGroup controllerGroup, String string, String string2, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2);
        this._myWidth = n3;
        this._myHeight = n4;
        this._myText = string2;
        this.setup();
    }

    public Textarea(String string, int n, int n2) {
        super(n, n2);
        this._myText = string;
        this.setup();
    }

    private void setup() {
        this._myValueLabel = new Label(this._myText, this._myWidth - 4, this._myHeight - 4);
        this._myValueLabel.setFont(1);
        this._myValueLabel.multiline(true);
        this._myValueLabel.toUpperCase(false);
        this._myValueLabel.update();
        this._myValueLabel.position.set(2.0f, 2.0f);
        this.addDrawable(this._myValueLabel);
        this._myScrollbar = new Slider(this.controlP5, this._myParent, this.name() + "Scroller", -this._myValueLabel.textHeight() + this._myHeight - this._myValueLabel.lineHeight(), 0.0f, 0.0f, this._myWidth, 0, 10, this._myHeight);
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.isMoveable = false;
        this._myScrollbar.isLabelVisible = false;
        this._myScrollbar.setParent(this);
        this._myScrollbar.addListener(this);
        this.add(this._myScrollbar);
        this.setWidth(this._myWidth);
        this.setHeight(this._myHeight);
        this._myScrollbar.color.set(this.color);
    }

    public void setWidth(int n) {
        this._myWidth = n = n < 3 ? 3 : n;
        this._myValueLabel.setWidth(this._myWidth - 2);
        this._myValueLabel.update();
        this._myScrollbar.setValue(this._myValueLabel.offset());
        this._myScrollbar.position().x = this._myWidth;
        this._myScrollbar.setMin(-this._myValueLabel.textHeight() + this._myHeight - this._myValueLabel.lineHeight());
        this._myScrollbar.setVisible(this._myHeight < this._myValueLabel.lineHeight() + this._myValueLabel.textHeight());
    }

    public void setHeight(int n) {
        this._myHeight = n = n < 4 ? 4 : n;
        this._myValueLabel.setHeight(this._myHeight - 3);
        this._myValueLabel.update();
        this._myScrollbar.setHeight(this._myHeight);
        this._myScrollbar.setValue(this._myValueLabel.offset());
        this._myScrollbar.setMin(-this._myValueLabel.textHeight() + this._myHeight - this._myValueLabel.lineHeight());
        this._myScrollbar.setVisible(this._myHeight < this._myValueLabel.lineHeight() + this._myValueLabel.textHeight());
    }

    public void setLineHeight(int n) {
        this._myValueLabel.setLineHeight(n);
    }

    public void setColor(int n) {
        this._myValueLabel.setColor(n);
    }

    public void setText(String string) {
        this._myValueLabel.set(string);
    }

    public void setPosition(float f, float f2) {
        this.position.x = f;
        this.position.y = f2;
    }

    protected void preDraw(PApplet pApplet) {
        if (this._myScrollbar.isVisible()) {
            pApplet.stroke(this.color.colorBackground);
            pApplet.noFill();
            pApplet.rect(0.0f, 0.0f, (float)(this._myWidth + 1), (float)(this._myHeight - 1));
            pApplet.noStroke();
        }
    }

    public void controlEvent(ControlEvent controlEvent) {
        this._myValueLabel.setOffset(controlEvent.value());
        this._myValueLabel.update();
    }

    protected boolean inside() {
        return (float)this._myControlWindow.mouseX > this.position.x() + this._myParent.absolutePosition().x() && (float)this._myControlWindow.mouseX < this.position.x() + this._myParent.absolutePosition().x() + (float)this._myWidth && (float)this._myControlWindow.mouseY > this.position.y() + this._myParent.absolutePosition().y() && (float)this._myControlWindow.mouseY < this.position.y() + this._myParent.absolutePosition().y() + (float)this._myHeight;
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "textarea");
        controlP5XMLElement.setAttribute("width", new Integer(this._myWidth));
        controlP5XMLElement.setAttribute("height", new Integer(this._myHeight));
        controlP5XMLElement.setContent(this._myValueLabel.toString());
    }

    public String stringValue() {
        return "";
    }

    public float value() {
        return 0.0f;
    }
}

