/*
 * Decompiled with CFR 0.152.
 */
package oscP5;

import java.util.Vector;
import netP5.Logger;
import netP5.NetAddress;
import oscP5.OscEventListener;

public class OscProperties {
    public static final boolean ON = true;
    public static final boolean OFF = false;
    public static final int UDP = 0;
    public static final int MULTICAST = 1;
    public static final int TCP = 2;
    protected static final String[] _myProtocols = new String[]{"udp", "tcp", "multicast"};
    protected boolean isLocked = false;
    protected final Vector listeners;
    private NetAddress _myRemoteAddress = new NetAddress("", 0);
    private int _myListeningPort = 0;
    private int _myDatagramSize = 1536;
    protected String _myDefaultEventMethodName = "oscEvent";
    private int _myNetworkProtocol = 0;
    private boolean _mySendStatus = false;
    private boolean _mySRSP = false;

    public OscProperties(OscEventListener oscEventListener) {
        this();
        this.listeners.add(oscEventListener);
    }

    public OscProperties() {
        this.listeners = new Vector();
    }

    public Vector listeners() {
        return this.listeners;
    }

    public boolean sendStatus() {
        return this._mySendStatus;
    }

    public void setRemoteAddress(String string, int n) {
        this._myRemoteAddress = new NetAddress(string, n);
        this._mySendStatus = this._myRemoteAddress.isvalid();
    }

    public void setRemoteAddress(NetAddress netAddress) {
        this._myRemoteAddress = netAddress;
        this._mySendStatus = this._myRemoteAddress.isvalid();
    }

    public void setListeningPort(int n) {
        this._myListeningPort = n;
    }

    public void setDatagramSize(int n) {
        if (!this.isLocked) {
            this._myDatagramSize = n;
        } else {
            Logger.printWarning("OscProperties.setDatagramSize", "datagram size can only be set before initializing oscP5\ncurrent datagram size is " + this._myDatagramSize);
        }
    }

    public void setEventMethod(String string) {
        this._myDefaultEventMethodName = string;
    }

    public void setNetworkProtocol(int n) {
        if (!this.isLocked) {
            if (n > 2) {
                Logger.printWarning("OscProperties.setNetworkProtocol", "not in the range of supported Network protocols. the network protocol defaults to UDP");
            } else {
                this._myNetworkProtocol = n;
            }
        } else {
            Logger.printWarning("OscProperties.setNetworkProtocol", "network protocol can only be set before initializing oscP5.");
        }
    }

    public void setSRSP(boolean bl) {
        this._mySRSP = bl;
    }

    public boolean srsp() {
        return this._mySRSP;
    }

    public int listeningPort() {
        return this._myListeningPort;
    }

    public NetAddress remoteAddress() {
        return this._myRemoteAddress;
    }

    public int datagramSize() {
        return this._myDatagramSize;
    }

    public String eventMethod() {
        return this._myDefaultEventMethodName;
    }

    public int networkProtocol() {
        return this._myNetworkProtocol;
    }

    public String toString() {
        String string = "\nnetwork protocol: " + _myProtocols[this._myNetworkProtocol] + "\n";
        string = string + "host: " + (this._myRemoteAddress.address() != null ? this._myRemoteAddress.address() : "host address not set.") + "\n";
        string = string + "sendToPort: " + this._myRemoteAddress.port() + "\n";
        string = string + "receiveAtPort: " + this.listeningPort() + "\n";
        string = string + "datagramSize: " + this._myDatagramSize + "\n";
        string = string + "event Method: " + this._myDefaultEventMethodName + "\n";
        string = string + "(S)end(R)eceive(S)ame(P)ort: " + this._mySRSP + "\n\n";
        return string;
    }
}

