/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class ShitPatcher {
    byte[] baseLSDjROM = new byte[0x100000];
    byte[] baseLFMROM = new byte[32768];
    ROMStringValidator val_LSDJ = new ROMStringValidator(new byte[]{76, 83, 68}, 308, "Error: ROM header name doesn't say LSDJ.", "(OK)   ROM header name says LSDJ.");
    ROMStringValidator val_JP150 = new ROMStringValidator(new byte[]{0, -61, 80, 1}, 256, "Error: Invalid jump opcodes in header. Should be NOP; JP $150; (Is ROM already patched, or something other than LSDj?)", "(OK)   Entry jump in header is OK.");
    byte[] buttonRoutineSearch = new byte[]{-16, 0, 47, -26, 15, -80, -53, 55, 71, 62};
    byte[] theStrapon = new byte[]{-11, 62, 0, -32, 0, -59, -63, -59, -63, -16, 0, 47, -26, 15, 24, 2, -15, -55, 62, -45, -22, 0, 32, -32, -64, -32, -63, -61, 0, 64, 32, 64, -11, -26, 15, 32, 4, 49, -2, -1, -57, -15, -55};
    int freeBank;
    boolean validLSDj = false;
    boolean validLFM = false;

    ShitPatcher() {
    }

    boolean loadBaseLSDjROM(String string) throws IOException {
        int n = this.doload(this.baseLSDjROM, string);
        if (n != 0x100000) {
            ShitLogger.log("Error! Size of base ROM image must be 1048576 bytes (1 MiByte.) This file should be an unpatched LSDj ROM. (kits are ok if one slot is left empty for LittleFM)", true);
            return false;
        }
        ShitLogger.log("(OK)   ROM size OK!");
        if (this.checkValidLSDj()) {
            return true;
        }
        ShitLogger.log("Error! ROM does not appear to be an LSDj ROM! (Or, it has already been patched. Gimme a clean ROM, please!)", true);
        return false;
    }

    boolean patchLFM(String string, boolean bl) throws IOException {
        int n = this.doload(this.baseLFMROM, string);
        if (n != 32768) {
            ShitLogger.log("Error! Size of LittleFM patch image must be 32 kB!", true);
            return false;
        }
        ShitLogger.log("(OK)   ROM size OK!");
        if (!this.checkLFMCompatibility()) {
            return false;
        }
        this.doPatchLFM(bl);
        return true;
    }

    void doPatchLFM(boolean bl) {
        ShitUtil.patchWildcard(this.baseLSDjROM, 0, this.theStrapon, (byte)-45, (byte)this.freeBank);
        this.baseLSDjROM[256] = -57;
        ShitUtil.patchOffset(this.baseLSDjROM, this.freeBank * 16384, this.baseLFMROM, 16384);
        if (bl) {
            int n = ShitUtil.arraySearch(this.baseLSDjROM, 0, 16384, this.buttonRoutineSearch);
            if (n != -1) {
                ShitLogger.log("(OK)   Found joypad routine at " + n + ". Patching reset routine.");
                this.baseLSDjROM[n] = -25;
            } else {
                ShitLogger.log("Error! Could not find joypad routine. Reset routine not patched! Is ROM already patched?");
            }
            ShitLogger.log("(Info) Patched ROM image in memory with LittleFM and entry bootstrap!");
        }
    }

    boolean checkValidLSDj() {
        boolean bl = this.val_LSDJ.isValid(this.baseLSDjROM);
        boolean bl2 = this.val_JP150.isValid(this.baseLSDjROM);
        return bl && bl2;
    }

    boolean checkLFMCompatibility() {
        int n = ShitAnal.searchBankForLFM(this.baseLSDjROM);
        if (n > 0) {
            ShitLogger.log("(OK)   Found free ROM bank for LittleFM ($" + Integer.toHexString(n & 0xFF) + ")");
        } else {
            ShitLogger.log("Error! Could not find a free ROM bank to place LittleFM in! Try removing one kit!", true);
        }
        this.freeBank = n;
        return n > 0;
    }

    private int doload(byte[] byArray, String string) throws IOException {
        int n = 0;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        n = dataInputStream.read(byArray);
        ShitLogger.log("(Info) " + string + ": " + n + " bytes read");
        return n;
    }

    public void dumpROM(String string) throws IOException {
        this.fixCheckSum();
        this.dosave(this.baseLSDjROM, string);
    }

    public void fixCheckSum() {
        int n;
        this.baseLSDjROM[328] = 6;
        int n2 = 0;
        for (n = 308; n < 333; ++n) {
            n2 += 0xFF ^ this.baseLSDjROM[n];
            n2 &= 0xFF;
        }
        this.baseLSDjROM[333] = (byte)n2;
        n2 = 0;
        this.baseLSDjROM[334] = 0;
        this.baseLSDjROM[335] = 0;
        for (n = 0; n < this.baseLSDjROM.length; ++n) {
            n2 += 0xFF & this.baseLSDjROM[n];
            n2 &= 0xFFFF;
        }
        this.baseLSDjROM[334] = (byte)(n2 >> 8 & 0xFF);
        this.baseLSDjROM[335] = (byte)(n2 & 0xFF);
    }

    private void dosave(byte[] byArray, String string) throws IOException {
        boolean bl = false;
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
        dataOutputStream.write(byArray);
        dataOutputStream.close();
        ShitLogger.log("(Info) Patched ROM written to " + string);
    }
}

