/*NAME	LNCSMPL
  TITLE	Sample Launcher Aware Program

Copyright (C) 1993 WordPerfect Corp., All Rights Reserved
------------------------------------------------------------*/

#include	<conio.h>
#include	<stdio.h>
#include	<dos.h>
#include	<string.h>
#include	<graph.h>
#include	"lcdef.h"			//Required header file

/***************************************************************************
 * Program to demonstrate some of the basic functions of Launcher program. *
 * The Launcher program must be renamed to have the same name as this      *
 * program and end with the ".COM" extention.                              *
 ***************************************************************************/

/*****************************
 *        Prototypes         *
 *****************************/
void	LC_ReChk(void);				//2nd check if Launcher loaded
void	DisplayMenu(void);
void	GetList(void);				//Get list of currently active pgms
char	GetResponse(void);			//Get user input from menu

/****************************
 *     Global Variables     *
 *--------------------------*
 * Variables for 2nd        *
 * program to be swapped to *
 ****************************/
unsigned int Pgm2Umid=0x21;		//Unique menu ID for Program 2
char Pgm2[81];					//Combined path/filename of Pgm2
char Pgm2Name[13];				//File name of Pgm 2 for display
char far *Pgm2Ptr;				//Far pointer to "Pgm2" variable

char PocName[13]="LNCSMPL.EXE";	//Name of this program (Program of Choice)
int NOERROR=0;					//Number mening no errors

int NetNum, far *NetNumPtr;		//buffer to hold the Network type number
char NetInit[6],far *NetInitPtr,NetId[33],far *NetIdPtr; //buffers to hold user initals and ID

/***************************
 *      Start of Code      *
 ***************************/
void	main(void)
{
	char Item;			//Menu Choice from user
	int	er;				//Error code Variable
	unsigned int LnchrFlags, far *LnchrFlagsPtr; //LNC_REG Flags
	char env[3]="WP",far *envPtr;

	Pgm2Ptr=Pgm2;		//Initalize all far pointers to their variables
	NetInitPtr=NetInit;
	NetIdPtr=NetId;
    NetNumPtr=&NetNum;
    LnchrFlagsPtr=&LnchrFlags;
    envPtr=env;
    
	//Request the path and File name of 2nd program to swap to
	printf ("Enter in the path (not name) to the program to be swapped to:\n");
	scanf ("%s",&Pgm2);
	if (Pgm2[strlen(Pgm2)-1]!='\\') strcat(Pgm2,"\\");
	printf ("Enter the file name of program to swap to (include extention):\n");
	scanf ("%s",&Pgm2Name);
	strcat (Pgm2,Pgm2Name);
	_clearscreen(_GCLEARSCREEN);		//MicroSoft C++ Clear Screen
	//clrscr();				//Borland Clear Screen
	printf ("Reloaded, repeat following path & name:\n%s\n",Pgm2);

	if (LNC_CHK(NetNumPtr,NetInitPtr,NetIdPtr))				//Is Launcher already loaded?
	{
		printf("\nLoading Launcher\n");
		LNC_EXC(envPtr);			//Load this pgm under Launcher
		printf("\nLauncher was not loaded\n");
	}
	LC_ReChk();				//Check to see if Launcher really did get loaded
	er=LNC_REG (LnchrFlagsPtr,NULL);		//Register with Launcher
	if (er==NOERROR)
	{
		_clearscreen(_GCLEARSCREEN);	//MicroSoft Clear Screen
		//clrscr();			//Borland Clear Screen
		DisplayMenu();
		Item=GetResponse();
		while (Item !='5')
		{
			switch (Item)
			{
				case ('1'):	//Load/Swap in program 2
					printf ("* Please Wait *\n");
					LNC_SLD(Pgm2Ptr,NULL,NULL,Pgm2Umid,S_W,DISABLE);
					  //Swap to Program 2, if not loaded  load/swap to pgm2
					break;
				case ('2'):	//Get current active Programs
					_clearscreen(_GCLEARSCREEN); //MicroSoft Clear Screen
					//clrscr();		     //Borland Clear Screen
					GetList();
					break;
				case ('3'):
					LNC_HKS (DISABLE); //Disable CTRL+ALT+key swapping
					break;
				case ('4'):
					LNC_HKS (ENABLE); //Enable CTRL+ALT+key swapping
					break;
			}
			_clearscreen(_GCLEARSCREEN); //MicroSoft Clear Screen
			//clrscr();		     //Borland Clear Screen
			DisplayMenu();
			Item=GetResponse();
		}
		LNC_XALL (XA_SAVE);	//Exit all programs, if open work, reqest save
	}
	else
	{
		printf ("ERR -- Could not register with Launcher\n");
	}
}

void far LNCLEAN(void)			//Required function for clean up
{
}

int far FNDLNC(char far *lncpath)	//Required function to find Lancher
{
	char DefaultPath [12]="lncsmpl.com";
	char LocalLncPath [81];
	int i;

	//Get info from far ptr & put in near ptr for use by "str" funcs
	i=0;
	while (lncpath[i])
	{
		LocalLncPath [i]=lncpath[i];
		i++;
	}
	if (strcmp (LocalLncPath,DefaultPath)!=0)
	{
		//Copy default Launcher name to far pointer
		for (i=0;i<12;i++) lncpath[i]=DefaultPath[i];
	}
	return LNCFOUND;
}

void	LC_ReChk(void)
{
	if (LNC_CHK(NetNumPtr,NetInitPtr,NetIdPtr))		//Is launcher loaded?
		printf("\nNot Loaded\n");
	else
		printf("\nLauncher is loaded\n");
}

void	DisplayMenu (void)
{
	printf ("Launcher Sample Main Menu\n\n");
	printf ("1.  Load/Swap %s\n",Pgm2Name);
	printf ("2.  Show Resident Program list\n");
	printf ("3.  Turn off Hot Key support\n");
	printf ("4.  Turn on Hot Key support\n");
	printf ("5.  Exit Launcher Sample program\n\n");
	printf ("Selection: ");
	return;
}

char	GetResponse (void)
{
	char Character;

	//Get user's menu selection
	while (kbhit()==0);
	Character=getch();
	printf ("%c\n",Character);
	return Character;
}

void	GetList (void)
{
	int i;					//index variable for loops
	int ListBuff[15];		//Buffer to hold program list
	int ListCount;			//Holds number of entries in ListBuff
	int far *ListBuffPtr;	//Used to convert ListBuff to far ptr
	int far *ListCountPtr;	//Used to convert ListCount to far ptr

	//Initialize buffer and count pointers
	ListBuffPtr=ListBuff;
	ListCountPtr=&ListCount;

	//Get current active programs list
	if (LNC_CAP (ListBuffPtr,ListCountPtr))
	{
		printf ("ERR -- Problem trying to get program list\n");
	}
	else
	{
		//Evaluate Currently Active Program List
		printf ("Resident Program List\n\n");
		printf ("Currently resident programs are:\n");
		for (i=0;i<ListCount;i++)
		{
			switch (ListBuff[i*3]) //Just look at umid part of each entry
			{
				case (1):	//This program's umid
					printf ("%s\n",PocName);
					break;
				case (33):	//Decimal of 0x21 umid
					printf ("%s\n",Pgm2Name);
					break;
			}
		}
	}
	printf("\nPress any key to continue...\n");
	while ( kbhit()==0 );
	getch();
	return;
}
