;  File EXAMPLE.C
;  Title Example of a DOAPI Program that uses the WP 6.x DOAPI Library
;
;       Copyright (C) 1996, Corel Inc., All Rights Reserved 
;-----------------------------------------------------------

;***************************************************************************
;* Program: WordPerfect 6.0 Level DOAPI
;*
;* Purpose:
;* This program is designed to act as a "Library" to do the necessary
;* translations between the original WP6.x DOAPI and its pass-data-by-register
;* protocol to the pass-data-by-stack protocol used by the C programming
;* language.
;*
;* Functions visible to C:
;*                 _OpenInterface (Sets up translation layer between WP and C)
;*                     REQUIRED FUNCTION
;*                     In: Product code used to ID the WP Corp product calling
;*                         Far Pointer to C Key Handler Function
;*                         Far Pointer to C Token Handler Function
;*                         Far Pointer to C Record Handler Function
;*                     Out: None
;*                     Supporting local Subfunctions:
;*                              INT1AH
;*                 _CloseInterface (Clears translation layer between WP and C)
;*                     REQUIRED FUNCTION
;*                     In: None
;*                     Out: None
;*                 _SystemVariable (Gets various status info from WP)
;*                    OPTIONAL FUNCTION
;*                    In: unsigned int (System data requested)
;*                        Far Pointer (8 byte buffer to put data in)
;*                    Out: int (Declared type of data in buffer)
;*                    Supporting local Subfunctions:
;*                             POINTERCORRECT
;*                 _GetMergeVariable (Get the value of global merge/macro var)
;*                    OPTIONAL FUNCTION
;*                    In: Far Pointer (Name of variable)
;*                        Far Pointer (8 byte buffer to put data in)
;*                    Out: int (Declared type of data in buffer)
;*                    Supporting local Subfunctions:
;*                             POINTERCORRECT
;*                 _SetMergeVariable (Put a value into global variable)
;*                    OPTIONAL FUNCTION
;*                    In: Far Pointer (Name of variable)
;*                        Far Pointer (8 byte buffer containing var's data)
;*                        int (Declared type of data in buffer)
;*                    Out: None
;*                 _WPPurgeCache
;*                    OPTIONAL FUNCTION
;*                    In: None
;*                    Out: None
;*
;*                    Supporting local Subfunctions:
;*                             POINTERCORRECT
;* Internal Supporting functions not visible to C:
;*                 INT1AH (used to tell WP there's a DOAPI program for it)
;*                    Installed into 1Ah interrupt by _OpenInterface
;*                    Called by: WordPerfect 6.0 level product
;*                    In: Matching product code in AX
;*                    Out: None
;*                 KEYBAS (translation layer between WP and C's key functions)
;*                    Address passed to WordPerfect 6.0 level product by
;*                          INT1AH
;*                    Called by: WordPerfect 6.0 level product
;*                    In: WP key code in AX
;*                    Out: WP key code in AX
;*                    Supporting routines:
;*                           Key Handler (C function)
;*                           SWAP
;*                 TOKBAS (translation layer between WP and C's Token Funcs)
;*                    Address passed to WordPerfect 6.0 level product by
;*                          INT1AH
;*                    Called by WordPerfect 6.0 level product
;*                    In: Token Value in AX
;*                        Token Parameter(s) (if any) in ES:BX
;*                    Out: Token Value in AX
;*                         Token Parameter(s) (if any) in ES:BX
;*                         Size of parameter data area (in bytes) in CX
;*                    Supporting routines:
;*                         Token Handler (C function)
;*                         SWAP
;*                 RECBAS (translation layer between WP and C's Record Func)
;*                    Address passed to WordPerfect 6.0 level product by
;*                          INT1AH
;*                    Called by WordPerfect 6.0 level product
;*                    In: Token Value in AX
;*                        Token Parameter(s) (if any) in ES:BX
;*                    Out: None
;*                    Supporting routines:
;*                         Record Handler (C function)
;*                         SWAP
;*                 SWAP (swaps to C stack from WP stack and back again)
;*                    Called by: KEYBAS, TOKBAS, and RECBAS
;*                    In: None
;*                    Out: None
;*                 POINTERCORRECT (Converts 8 byte buffer pointer order of
;*                                 Segment/Offset to the correct order of
;*                                 Offset/Segment and [in SetMergeVariable]
;*                                 back again)
;*                    Called by: SystemVariable, GetMergeVariable, and
;*                               SetMergeVariable
;*                    In: None
;*                    Out: None
;****************************************************************************
DOSSEG
.MODEL small
.CODE
PUBLIC _OpenInterface,_CloseInterface,_SystemVariable,_GetMergeVariable
PUBLIC _SetMergeVariable,_WPPurgeCache
;ASM library for WP6.0 DOAPI

;**************************** global routine variables
css	dw	?			;C stack segment
csp	dw	?			;C stack pointer
old1ah	dd	?			;address to original 1Ah interupt
keyH	dd	?			;address of C key handler routine
tokenH	dd	?			;address of C token handler routine
recrd	dd	?			;address of C record handler routine
wpstr	db	"WPCORP",0		;string to confirm WP calling
wpss	dw	?			;WP stack segment
wpsp	dw	?			;WP stack pointer
pram1	dw	?			;Parameter 1 off current stack
stkflg	db	0			;indicator for direction of stk swap
prodct	dw	?			;Product Code of calling WP Product
CData	dw	?			;To pass on C DS reg. for Small mem C
wpreq	dd	?			;address of universal WP request func.
parm	dd	?			;address of token parameter data area
tokhld	dw	?			;variable to hold token value

_OpenInterface	proc	far		;setup C-WP Interface
;************************* Get far pointer to C key handler func. off stack

	mov	cs:css,ss		;save C stack...
	mov	cs:csp,sp		;...for stack swaps
	sub	cs:csp,500		;move csp for later spawn
	mov	cs:CData,DS		;Save DS for small model C programs
	push	bp			;save BP register for later
	mov	bp,sp			;put SP value into BP
	mov	ax,[bp+6]		;get product code off of stack
	mov	prodct,ax		;save it for later use
	mov	ax,[bp+8]		;get C's key handler offset off stack
	mov	word ptr cs:keyH,ax	;save it for later use
	mov	ax,[bp+10]		;get C's key handler segment off stack
	mov	word ptr cs:keyH+2,ax	;save it for later use
	mov	ax,[bp+12]		;get C's token handler offset
	mov	word ptr cs:tokenH,ax	;save it for later use
	mov	ax,[bp+14]		;get C's token handler segment
	mov	word ptr cs:tokenH+2,ax	;save it for later use
	mov	ax,[bp+16]		;get C's record handler offset
	mov	word ptr cs:recrd,ax	;save it for later use
	mov	ax,[bp+18]		;get C's record handler segment
	mov	word ptr cs:recrd+2,ax	;save it for later use
	pop	bp			;restore BP register to normal

;*********************** save old 1Ah interupt address
	push	bx			;save BX
	push	dx
	push	ds
	mov	ax,351ah		;call for 1Ah interupt address
	int	21h			;execute call
	mov	word ptr cs:old1ah,bx	;save segment...
	mov	word ptr cs:old1ah+2,es	;...and offset of old 1Ah interupt

;*********************** grab 1Ah interupt
	mov	ax,cs			;make DS register...
	mov	ds,ax			;...equal CS register
	mov	dx,offset cs:int1ah	;point DX reg. to INIT1AH routine
	mov	ax,251ah		;req routine replace old 1Ah interupt
	int	21h			;execute request

;******************** return to C
	pop	ds			;restore DS register
	pop	dx
	pop	bx			;restore BX
	xor	ax,ax			;return value
	ret				;return to C
_OpenInterface	endp

;WP DOAPI Detection Interupt handler (inserted into 1Ah) to let WP know we here
int1ah	proc	far
	cmp	ax,cs:prodct		;Did expected product call interupt?
	 jne	chain			;no, goto chain

;******** it may be WP calling so save pointer to WP request routine
	push	ax			;save AX and BX registers
	push	bx
	mov	word ptr cs:wpreq+2,es	;get the WP Request routine from...
	mov	word ptr cs:wpreq,di	;...ES:DI

;******** Now that its saved, do the double checks to confirm WP is calling
	push	es			;put CS value into ES
	push	cs
	pop	es
	push	si			;save SI, DI, and CX registers...
	push	di
	push	cx
	pushf				;...and the flags
	mov	di,offset cs:wpstr	;point ES:DI to "WPCORP" string
	mov	cx,7			;CX=length of "WPCORP" string
wpcmp:	mov	ax,ds:[si]		;compare values at DS:SI...
	cmp	ax,es:[di]		;...with the values at ES:DI
	 jne	chain2			;if they don't match goto CHAIN2

	inc	si			;Increment SI and DI for next...
	inc	di			;...character check
	dec	cx			;decrement length counter
	 jnz	wpcmp			;if more characters to check go WPCMP

	cmp	bh,6h			;is this 6.x calling?
	 jne	chain2			;if no, goto CHAIN2

;********* its wp calling for sure, register key handler routine base with WP
	cmp	word ptr cs:keyH+2,0	;see if there is no key handler routine
	 je	tkchk			;if there isn't, go to TKCHK

	mov	di,offset keybas	;if there is, set tranlation base
	mov	ah,0ffh			;req. to register KEYBAS addr.
	call	cs:wpreq		;make request to WP

;********* register Token handler routine base with WP
tkchk:	cmp	word ptr cs:tokenH+2,0	;isn't there a token handler?
	 je	recchk			;if there isn't, goto RECCHK

	mov	di,offset tokbas	;if there is, set translation base
	mov	ah,0feh			;req. to register TOKBAS address
	call	cs:wpreq		;make request to WP

;********* register Record handler routine base with WP
recchk:	cmp	word ptr cs:recrd+2,0	;isn't there a record handler?
	 je	notng			;if there isn't, goto NOTNG

	mov	di,offset recbas	;if there is, set translation base
	mov	ah,0fdh			;req. to register RECBAS address
	call	cs:wpreq		;make request to WP

notng:	popf				;restore all saved registers...
	pop	cx			;...and flags
	pop	di
	pop	si
	pop	es
	pop	bx
	pop	ax
	 jmp	short chain		;goto CHAIN

;pass info to original 1Ah routine
chain2:	popf				;restore all registers and flags
	pop	cx
	pop	di
	pop	es
	pop	bx
	pop	ax
chain:	 jmp	cs:old1ah		;go to original 1Ah routine
int1ah	endp

;WP DOAPI WP-C (& C-WP) interface, pass key to C, & new key to WP
keybas	proc	far
	push	dx			;save all registers except AX
	push	es
	push	ds
	push	si
	push	cx
	push	di
	push	bx
	pushf
	mov	cs:wpss,ss		;save stack for...
	mov	cs:wpsp,sp		;...C-WP or WP-C stack swap
	call	short Swap		;swap to the C stack
	mov	ds,cs:CData		;Give small mem C's there data back
	push	ax			;push key on stack
	call	cs:keyH			;call C Key Handler Routine
	pop	cx			;restore stack
	call	short Swap		;Swap back to WP's stack
	popf				;restore all registers except AX
	pop	bx
	pop	di
	pop	cx
	pop	si
	pop	ds
	pop	es
	pop	dx
	ret				;return back to WP
keybas	endp

;WP DOAPI WP-C (& C-WP) interface, pass Token to C, & back to WP
tokbas	proc	far
	push	dx			;save all registers except AX & BX,...
	push	ds			;...CX, and ES
	push	si
	push	di
	pushf
	mov	cs:wpss,ss		;save stack for...
	mov	cs:wpsp,sp		;...C-WP or WP-C stack swap
	call	short Swap		;swap to the C stack
	mov	ds,cs:CData		;set DS back to C's data segment

;******* save values from WP for passing to C
	push	es			;save ES and BX incase their values...
	push	bx			;...need to be passed on unchanged
	mov	word ptr cs:parm+2,0	;set PARM to zero incase there is...
	mov	word ptr cs:parm,0	;...no parameter data for the token
	cmp	bx,0ffffh		;is there no parameter data?
	 je	itnull			;if there isn't, goto ITNULL

	mov	word ptr cs:parm+2,es	;if there is, put its address in PARM
	mov	word ptr cs:parm,bx
itnull:	mov	cs:tokhld,ax		;save the token value into TOKHLD


;******* push parameter address on stack
	push	cs			;push segment on stack
	mov	ax,offset cs:parm	;push PARM offset onto stack.  PARM...
	push	ax			;...is a pointer to the parameter addr.

;******* push token address on stack
	push	cs			;push segment on stack
	mov	ax,offset cs:tokhld	;push TOKHLD offset...
	push	ax			;...on stack

	call	cs:tokenH		;call C token handler function
	pop	cx			;clear stack
	pop	cx
	pop	cx
	pop	cx

;******* get C values and addresses & send them back to WP
	mov	cx,ax			;put parameter size in CX
	mov	ax,cs:tokhld		;get current token value into AX
	pop	bx			;restore BX and ES
	pop	es
	cmp	word ptr cs:parm+2,0	;is there no parameters w/cur. tok.?
	 je	nochng			;if yes, goto NOCHNG

	mov	es,word ptr cs:parm+2	;if no, get current parameter addr...
	mov	bx,word ptr cs:parm	;...and put it into ES:BX

;******* return to WP
nochng:	call	short Swap		;Swap back to WP's stack
	popf				;restore all registers except...
	pop	di			;AX, BX, CX, and ES
	pop	si
	pop	ds
	pop	dx
	ret				;return back to WP
tokbas	endp

;WP DOAPI WP-C (& C-WP) interface, pass Token to C
recbas	proc	far
	push	dx			;save all registers
	push	bx
	push	es
	push	ds
	push	si
	push	di
	push	ax
	push	cx
	pushf
	mov	cs:wpss,ss		;save stack for...
	mov	cs:wpsp,sp		;...C-WP or WP-C stack swap
	call	short Swap		;swap to the C stack
	mov	ds,cs:CData		;restore C's data segment into DS

;******* push parameter address on stack
	cmp	bx,0ffffh		;does this token not have parameters?
	 jne	nonull			;if does have parameters, goto NONULL

	mov	cx,0			;if it doesn't, set PARM pointer to 0
	push	cx			;push zero pointer onto stack
	push	cx
	 jmp	short fin1		;goto FIN1

nonull:	push	es			;if parameters exist, push their...
	push	bx			;address on stack

;******* push token address on stack
fin1:	push	ax			;push token on stack

	call	cs:recrd		;call C record handler function
	pop	cx			;clear stack
	pop	cx
	pop	cx

;******* return to WP
	call	short Swap		;Swap back to WP's stack
	popf				;restore all registers
	pop	cx
	pop	ax
	pop	di
	pop	si
	pop	ds
	pop	es
	pop	bx
	pop	dx
	ret				;return back to WP
recbas	endp

_SystemVariable	proc	far
;************** get requested system variables off stack
	push	bp			;save base pointer
	mov	bp,sp			;move base pointer to stack pointer
	mov	ax,[bp+6]		;get SysVar request information off...
	mov	bx,ax			;...stack and put into BX
	mov	ax,[bp+8]		;get buffer offset off stack and...
	mov	di,ax			;...put it into DI
	mov	ax,[bp+10]		;get buffer segment off stack and...
	mov	es,ax			;...put it into ES
	pop	bp			;restore base pointer

;************** pass request and data buffer address to WP
	mov	ah,0			;command to get requested sysvar data
	call	cs:wpreq		;send command to WP's request function
	cmp	al,5			;is returned data pointer to WP str?
	 jne	onward			;if no, goto onward

	call	short PointerCorrect	;if yes, call POINTERCORRECT
onward:	and	ax,00ffh		;clear AH
	ret				;return to calling C program
_SystemVariable	endp

PointerCorrect	proc	near
;pointer comes in as segment/offset.  Convert to offset/segment
	push	ax			;save AX
	push	word ptr es:[di]	;save pointer segment from ES:DI
	mov	ax,word ptr es:[di+2]	;move pointer offset into AX
	mov	word ptr es:[di],ax	;move offset to former seg's place
	pop	word ptr es:[di+2]	;move segment to former off's place
	pop	ax			;restore AX
	ret				;return to calling assembly function
PointerCorrect	endp

_GetMergeVariable	proc	far
;********** get variable name word string, & buffer addresses off stack
	push	bp			;save base pointer
	mov	bp,sp			;move base pointer to stack pointer
	mov	ax,[bp+6]		;get offset of variable name off...
	mov	bx,ax			;...stack and into BX
	mov	ax,[bp+8]		;get segment of variable name off...
	mov	es,ax			;...stack and into ES
	mov	ax,[bp+10]		;get offset of buffer off stack...
	mov	di,ax			;...and into DI
	pop	bp			;restore base pointer

;*********** send request to WP
	mov	ah,1			;cmd to req. data from given var name
	call	cs:wpreq		;call WP to get data
	xor	ah,ah			;zero out AH
	cmp	al,5			;is the returned data a ptr to WP str?
	 jne	gobak			;if no, goto GOBAK

	call	short PointerCorrect	;if yes, call POINTERCORRECT
gobak:	ret				;return to calling C program
_GetMergeVariable	endp

_SetMergeVariable	proc	far
;********** get variable name word string, buffer addresses, & Type off stack
	push	bp			;save base pointer
	mov	bp,sp			;move base pointer to stack pointer
	mov	ax,[bp+6]		;get offset of variable name off...
	mov	bx,ax			;...stack and into BX
	mov	ax,[bp+8]		;get segment of variable name off...
	mov	es,ax			;...stack and into ES
	mov	ax,[bp+10]		;get offset of buffer off stack and...
	mov	di,ax			;...into DI
	mov	ax,[bp+14]		;get data type off stack & into AX
	pop	bp			;restore base pointer

;*********** send request to WP
	mov	ah,2			;command to set variable
	cmp	al,5			;is data type a pointer to WP string?
	 jne	conot			;if no, goto CONOT

	call	short PointerCorrect	;if yes, call POINTERCORRECT
conot:	call	cs:wpreq		;call WP's request function to set var
	xor	ax,ax			;zero AX
	ret				;return to calling C program
_SetMergeVariable	endp

_WPPurgeCache	proc	far
;********** Used to purge the Cache for Macro files
	mov	ax,300h			;command to purge cache
	call	cs:wpreq		;call WP's request function to do cmd
	xor	ax,ax			;zero AX
	ret				;return to calling C program
_WPPurgeCache	endp
	
_CloseInterface	proc	far		;Do all DOAPI clean up for C exit
;******************** Restore Int 1Ah to the way you originally found it
	push	ds			;save all used registers
	push	dx
	mov	ds,word ptr cs:old1ah+2	;get original 1Ah address
	mov	dx,word ptr cs:old1ah
	mov	ax,251ah		;call to restore interupt
	int	21h			;execute call

;******************** Return to c
	pop	dx			;restore used registers
	pop	ds
	xor	ax,ax			;return 0 value to C
	ret				;return back to C
_CloseInterface	endp

Swap	proc	near
;******************** toggle between C and WP stacks each time its called
	pop	cs:pram1		;save return address
	cmp	cs:stkflg,0		;is swap direction from WP 2 C
	 jne	C2WP			;if no, goto C2WP

;********* swap WP stack to C stack
WP2C:	inc	cs:stkflg		;set STKFLG to 1 for later toggles
	cli				;clear interupts for stack swap
	mov	ss,cs:css		;swap in C stack segment
	mov	sp,cs:csp		;swap in C stack pointer
	sti				;restore interupts
	 jmp	resto			;goto RESTO

;********* swap C stack to WP stack
C2WP:	mov	cs:stkflg,0		;set STKFLG to zero for later toggles
	cli				;clear interupts for stack swap
	mov	ss,cs:wpss		;swap in WP stack segment
	mov	sp,cs:wpsp		;swap in WP stack pointer
	sti				;restore interupts

;*************** restore stack data and return to calling program
resto:	push	cs:pram1		;put return address back on stack
	ret				;return back to calling program
Swap	endp
	END
