;name	VGA.ASM
;title	Display driver for Standard VGA Mode 12h
;
;  Copyright (C) 1991,1993 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;
;-----	includes
include	wpgidc.inc

;-----  macros
wo	equ	word ptr
by	equ	byte ptr
ofs	equ	offset

;********************
;  EQUATES
;	equates for resolution, colors, etc.
;********************

;Setup mode dependent equates
;These are equates are based on a mode value.
;mode 12H
M12_MODE	equ	12h		;video mode
M12_MAX_Y	equ	479		;max nuber in y
M12_DPI_Y	equ	77		;dots per inch y
M12_COL		equ	16		;# colors
M12_COLWP	equ	16		;# colors to report to WP
M12_FADE	equ	64		;bit res per gun
M12_BBP		equ	4		;perin bits per pixel
M12_PGS		equ	1		; number of video pages supported

;mode independent equates
;These are equates that stay the same independent of the mode value.
BIG_Y		equ	M12_MAX_Y	;should be largest of max_y
MAX_X		equ	639		;nax number in x
DPI_X		equ	77		;dots per inch x
BYTROW		equ	80		;number of bytes in a row
VIDEO_ADDR 	equ	0a000h		;frame buffer address
MEM_MODEL	equ	3		;memory model 4-plane planar

;drawing mode equates
XOR_MODE	equ	6		; d = s xor d

;DCC equates.  Documented p. 486 of Video Systems.
;Display combination code valid for MCGA and VGA only.
DCC_NOR		equ	0ffh		;Video system not recognized
DCC_NO		equ	0		;No display
DCC_MDA		equ	1		;MDA w/ mono display
DCC_CGA		equ	2		;CGA w/ color display
DCC_EGAC	equ	4		;EGA w/ color display
DCC_EGAM	equ	5		;EGA w/ mono display
DCC_PGC		equ	6		;Professional Graphics Controller
DCC_VGAM	equ	7		;VGA w/ analog mono display
DCC_VGAC	equ	8		;VGA w/ analog color display
DCC_MCDC	equ	0ah		;MCGA w/ digital color display
DCC_MCAM	equ	0bh		;MCGA w/ analog mono display
DCC_MCAC	equ	0ch		;MCGA w/ analog color display


CSEG2	SEGMENT PARA PUBLIC 'CODE'
ASSUME	cs:cseg2,ds:psseg,es:nothing
ORG	0
	jmp	start		;MUST be first thing in segment!

ORG	4
	jmp	start2

;--- table of routines to place in PS segment jump table

jtab2	DW	cdriv		; Close graphics display driver
	DW	ddot		; Draw a dot
	DW	drect_f		; Draw a rectangle
	DW	horln		; Draw a horizontal line
	DW	verln		; Draw a vertical line
	DW	colorm		; Set color map
	DW	svert		; Scroll vertically
	DW	shor		; Scroll horizontally
	DW	cpix_blt	; pixel blitter
	DW	gcur_size	; graphics curosr size
	DW	gcur_init	; graphics cursor init
	DW	gcur_erase	; graphics cursor erase
	DW	gcur_write	; graphics cursor write
	DW	size_bitblk	; bitmap size
	DW	save_bitblk	; bitmap save
	DW	restore_bitblk	; bitmap restore
	DW	BuildPat	; build a pattern
	DW	GetBitmap	; get a bitmap in standard format
	DW	PutBitmap	; put a bitmap in standard format
jtab2sz	equ	($-jtab2)/2

;----- 	User defined vars
;	Variables necessary for the driver can be defined here.

GetPS		dd 0	;address of GetPS_f (passed to init)
assoc		db 0	;count of presentation spaces associated with this
			;device context
gray		db 0	;gray mode flag
wpparm		db 0	;Wordperfect saved parameter wp{wp}.set
max_y		dw 0	;variable for max y
max_col		db 0	;max # colors diplayable
saved_state	db 0	;save display mode prior to entering graphics mode
saved_page  	db 0	;save display page prior to entering graphcis mode
saved_equi	db 0	; equiment regsiter in BIOS

latable	dw BIG_Y+1   dup(?)	;table of raster addresses for fast display

ltable	db	080h,040h,020h,010h,008h,004h,002h,001h
			;mask table for plotting pixels

mtable	DB	0ffh,07fh,03fh,01fh,00fh,007h,003h,001h
			;mask table for horizontal fill on the right side

mtable1	DB	080h,0c0h,0e0h,0f0h,0f8h,0fch,0feh,0ffh
			;mask table for horizontal fill on the left side

Plane3		db	80+2 dup (?)	;raster buffer for plane 3
Plane2		db	80+2 dup (?)	;raster buffer for plane 2
Plane1		db	80+2 dup (?)	;raster buffer for plane 1
Plane0		db	80+2 dup (?)	;raster buffer for plane 0

;idriv
;desc:	Initialize Graphic's Display Driver
;in:	ds = presentation space segment
;	bx = presentation space handle
;	dx:cx	- address of GetPS_f
;	al = video mode
;out:	
;ret:	jc = error, cannot initialize graphics mode
;notes:	
;	This routine will be called first for each presentation space.
;
;	All things necessary to put the display device in graphic mode should
;	be done at this time. If any text modes need to be detected and
;	saved this needs to be done now and restored at close driver time.
;
;	Any variables that are used throughout the driver should have been
;	defined in the code segment and should now be initialized.  A presence
;	test should also be conducted at this point to see if the display
;	mode (or device) requested is present.  A carry should be returned
;	if not.
;
;	All registers may be changed except DS.

start2	label	near
	push	bp
	mov	bp,sp
	sub	sp,2
	push	ax
	mov	al,1
	jmp	short in_00

start	label	near
idriv	PROC	FAR
	push	bp
	mov	bp,sp
	sub	sp,2
	push	ax
	xor	al,al
in_00:	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
iflag	equ by [bp-2]
.ax	equ wo [bp-4]
.ds	equ wo [bp-16]
	mov	iflag,al
	mov	ax,.ax			;restore passed ax
	push	cs			;set up ds to point at internal vars
	pop	ds
assume	ds:cseg2	
	mov	gray,0			;not gray mode
	test	ah,01h			;is this a gray mode?
	 jz	in_02			;  no
	mov	gray,80h		;set to gray mode
in_02:	inc	assoc			;increment count of presentation spaces
	cmp	assoc,1			;is this the first one?
	 jne	in_05			; no
	mov	wpparm,al		; save wordperfect parameter
	mov	wo GetPS,cx		;save address of GetPS routine
	mov	wo GetPS+2,dx

;----- See if passes DCC test and if valid color or analog monochrome display.
	mov	ax,1a00h			; go get the display combination code
	int	10h
	cmp	al,1ah				; see if we got DCC
	 jne	int01
	cmp	bl,DCC_VGAC			;is active display vga color
	 je	int02				; yes so jmp
	cmp	bh,DCC_VGAC			;is inactive display vga color
	 je	int02				; yes so jmp
	cmp	bl,DCC_VGAM			;is active display vga mono
	 je	int02				; yes so jmp
	cmp	bh,DCC_VGAM			;is inactive display vga mono
	 je	int02				; yes so jmp

int01:	mov	.ax,GIERRNODEVICE		;return error message number
	stc					; set carry
	jmp	in_99

int02:	mov	ah,0fh			; get device current state
	int	10h

	mov	saved_state,al		; save current state of screen
	mov	saved_page,bh		; save current page number

;---- VGA as 2nd display.
;It was discovered that the following code is necessary to allow 
;the use of a vga display as a secondary graphical display in a two 
;display setup.  This was tested in a setup where the primary display was
;a ttl mono driven by a hercules card.
	cmp	al,7			; see if mode 7
	 jne	in_05

	push	es
	push	si
	xor	ax,ax			; get zero
	mov	es,ax			; give to es
	mov	si,410h			; get equipment register offset
	mov	al,es:[si]		; get lower half
	mov	saved_equi,al		; save it for later
	and	al,0efh			; mask off a bit
	mov	es:[si],al		; write it for color
	pop	si
	pop	es
;End VGA as 2nd display code.

in_05:	mov	ds,.ds
assume	ds:psseg

	mov	ps.ColorModel,CMOD_INDEXED	;we are an indexed device
	mov	ps.NumClr,M12_COLWP		;with this many colors
	mov	ps.ColorEnhance,CENH_DITHER	;and we support this color
						;enhancement model
	mov	ps.DpiX,DPI_X		;save DPI in X
	mov	ps.DpiY,M12_DPI_Y	;save DPI in Y
	mov	ps.MaxX,MAX_X		;save maximum X coordinate
	mov	ps.MaxY,M12_MAX_Y	;save maximum Y coordinate
	mov	ps.DevBnds.BRLeft,0	;save coordinate of left edge
	mov	ps.DevBnds.BRBottom,M12_MAX_Y+1	;save coordinate of bottom edge
	mov	ps.DevBnds.BRRight,MAX_X+1 ;save coordinate of right edge
	mov	ps.DevBnds.BRTop,0	;save coordinate of top edge
	mov	ps.ClrRes,M12_FADE	;bit res per gun
;perin	mov	ps.BitPrPx,M12_BBP	;return bits per pixel
	mov	bl,M12_PGS		;set up numpgs return
	or	bl,gray			;add the gray scale info
	mov	ps.NumPgs,bl		; set number of pages
	mov	ps.MemModel,MEM_MODEL	;set memory model

	mov	cs:max_y,M12_MAX_Y	;load as variable will be used later
	mov	cs:max_col,M12_COL	;save max colors in variable

	push	cs
	pop	bx			;bx = segment of our routines
	mov	di,ps.DcJmpTblp		;address in ps to fill
	mov	si,ofs jtab2		;si->our jump table
	mov	cx,jtab2sz		;cx:=number of entries in table
in_20:	mov	ax,cs:[si]		;get offset of routine
	mov	[di],ax			;store in ps
	mov	[di+2],bx		;store segment of routine in ps
	add	di,4			;bump ps table pointer
	inc	si
	inc	si			;bump our table pointer
	loop	in_20			;do all of our supported routines

	cmp	cs:gray,0		;in gray mode?
	 je	in_30			;  no
	mov	ps.ColorModel,CMOD_MONO
	mov	ps.ColorEnhance,CENH_GRAYSHADES

in_30:	push	cs
	pop	ds
assume	ds:cseg2

	cmp	assoc,1			;is this first associate?
	 jne	in_99			; no
	cmp	iflag,0			;want to init mode?
	 je	in_32			; yes
	inc	assoc			; no, set so close driver doesn't reset mode
	jmp	short in_35

in_32:	mov	al,wpparm		;low byte holds mode
	mov	ah,0			;function - set mode
	int	10h			;set the mode
	mov	ah,5			;set active display page = 0
	mov	al,0
	int	10h

in_35:	lea	si,latable		;CS:SI -> line address table
	mov	ax,M12_MAX_Y*BYTROW	;set up AX
	mov	cx,M12_MAX_Y+1		;set to number of rasters

in_40:	mov	cs:[si],ax		;store the address
	add	si,2			;increment table pointer
	sub	ax,BYTROW		;decrement address value
	loop	in_40			;do the next entry

	cmp	gray,0			;in gray mode?
	 je	in_98			;  no
	push	ax
	mov	ax,0			;start with register 0

in_60:	mov	al,ah			;get index
	push	ax
	shl	al,1			;adjust to gray VGA color
	shl	al,1
	mov	bl,ah
	xor	bh,bh
	mov	ch,al
	mov	cl,al
	mov	dh,al
	mov	ax,1010h
	int	10h
	pop	ax
	push	ax
	mov	bh,al
	mov	bl,al
	mov	ax,1000h
	int	10h
	pop	ax
	inc	ah			;next shade
	cmp	ah,10h			;check for 16
	 jl	in_60			;loop 'till wrap around
	pop	ax
	
in_98:	clc
in_99:	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
idriv	ENDP
assume	ds:psseg
;cdriv
;desc:	Close Graphic's Display Driver
;in:	ds = presentation space segment
;	bx = presentation space handle
;out:	cl = number of ps spaces still associated
;ret:	none
;notes:	
;	This routine will be called last.
;
;	The state of the display device should at this point be restored
;	to the state that it was in previous to the initialize driver routine.
;	Any clean up that needs to be done before leaving graphics and
;	returning to text mode also needs to be done.
;
;	All registers may be changed.

cdriv	PROC	FAR
	push	ax
	push	si
	push	ds
	push	es
	push	cs
	pop	ds
assume 	ds:cseg2
	dec	assoc			;dec count of presentation spaces
	 jnz	cld99			; if not last, don't reset
	mov	al,saved_state
	cmp	al,7			; see if it was herc mono
	 jne	cld01

	xor	ax,ax			; get zero
	mov	es,ax			; give to es
	mov	si,410h			; get equipment register offset
	mov	al,saved_equi		; save it for later
	mov	es:[si],al		; write it for color

cld01:	xor	ah,ah			; restore screen state
	mov	al,saved_state
	int	10h

	mov	ah,5			; restore active page
	mov	al,saved_page
	int	10h

cld99:	mov	cl,cs:assoc		;return number of ps spaces still associated
	clc

	pop	es
	pop	ds
	pop	si
	pop	ax
	ret
assume	ds:psseg
cdriv	ENDP
;ddot
;desc:	Draw a pixel in the frame buffer
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx	= x coordinate
;	dx	= y coordinate
;	ps.CurForeClr,ps.CurBackClr = color,pattern to use
;out:	none
;ret:	jc = error
;notes:	This routine should turn 1 pixel on.
;	It supports DITHERED and SOLID colors, and supports a solid or
;	non-solid fill pattern
ddot	PROC	FAR
	push	bp
	mov	bp,sp
	push	ax	
	push	bx
	push	cx
.cx equ wo [bp-6]
	push	dx
.dx equ wo [bp-8]
	push	si
	push	di
	push	es

	mov	si,ps.CurForeClrp
	mov	ax,VIDEO_ADDR
	mov	es,ax			;es:=VGA frame buffer segment address
	mov	di,dx			;calculate address of start of row
	shl	di,1
	mov	di,cs:latable[di]	;di->start of row address
	mov	ax,cx			;calculate byte in row we are on
	shr	ax,1			;x/8
	shr	ax,1			;
	shr	ax,1			;
	add	di,ax			;di:=address of byte we are interested in
	mov	bx,cx			;calc x mod 8
	and	bx,7
	mov	dh,cs:ltable[bx]	;get bit mask for this bit in byte
	mov	bl,0ffh			;assume solid fill
	cmp	[si].ColorFPp,0		;do we have a pattern?
	 je	dd_20			;  no, so solid
	mov	si,[si].ColorFPp	;  yes, point at pattern def
	mov	ax,cx			;ax:=x coordinate
	shr	ax,1			;divide by 8 to compute byte in raster
	shr	ax,1
	shr	ax,1
	xor	ah,ah
	mov	bl,[si].FPWidthB	;get width in bytes
	cmp	bl,1			;if 1 skip divide
	 jne	dd_5
	xor	ah,ah
	jmp	short dd_10

dd_5:	div	bl			;compute byte in pattern raster (ah)
dd_10:	mov	bl,ah			;bl :=byte in pattern row
	xor	bh,bh
	mov	ax,.dx			;ax:=raster #
	mov	dl,[si].FPHeight	;get height of pattern
	div	dl			;ah := fill pattern row number
	sub	ah,[si].FPHeight	;flip, since pattern orientation is
	inc	ah			;upside down relative to normal
	neg	ah			;orientation
	mov	al,ah
	xor	ah,ah
	mov	cl,[si].FPWidthB	;get width in bytes
	cmp	cl,1			;if 1, skip multiply
	 je	dd_15
	mul	cl			;compute offset of pattern row
dd_15:	add	bx,ax			;bx:=address of byte from pattern we want
	add	bx,si			;offset into pattern
	add	bx,FPData
	mov	bl,[bx]			;get pattern byte
	mov	bh,dh			;save a copy of bit in byte mask
	mov	si,ps.CurForeClrp	;assume foreground color
	and	dh,bl			;combine bit masks
	 jnz	dd_20			; ok
	not	bl			;foreground doesn't show,
	and	bh,bl			;make background mask
	mov	dh,bh
	mov	si,ps.CurBackClrp	;point at current background color

;--- we now have mask setup for this particular bit
;--- find color
dd_20:	cmp	[si].ColorMM,MM_TRNSPRNT;is this color transparent?
	 je	dd_99			; yes, finished

dd_25:	push	dx			;save bit mask in dh
	cmp	[si].ColorFlag,CLR_DITHER; is the color dithered?
	 je	dd_30			; yes
	mov	bx,[si].ColorMP		; no, get mapped index
	mov	bh,by [bx].MIdx		;
	jmp	short dd_35		;and continue

dd_30:	mov	dx,.dx			;restore y coordinate
	and	dx,7			;y mod 8
	shl	dx,1			;* 8 for start of row
	shl	dx,1
	shl	dx,1
	mov	bx,.cx			;get x coord
	and	bx,7			;x mod 8
	add	bx,dx			;bx:=offset into dither pattern
	add	bx,[si].ColorMP
	mov	bh,[bx].DitherM		;bh:=color to use for this dot
dd_35:	mov	dx,03CEh		;Graphics Controller port address
	mov	ax,0205h		;select write mode 2
	out	dx,ax
	mov	ax,0003h		;assume overpaint mode
	cmp	[si].ColorMM,MM_XOR	;XOR mix mode?
	 jne	dd_40			; no
	mov	ah,18h			; yes
dd_40:	out	dx,ax			;set register 3 function
	pop	ax			;recover bit mask in ah
	mov	al,8			;select mask register
	out	dx,ax			;ah has mask, remember?
	mov	al,es:[di]		;latch the existing data
	mov	es:[di],bh		;write new data
	mov	ax,0ff08h		;reset bit mask
	out	dx,ax
	mov	ax,0005h		;reset read/write mode
	out	dx,ax			;	\
dd_99:	clc
	pop	es
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	bp
	ret
ddot	ENDP
;drect
;desc:	Draw a rectangle
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx,dx = x1,y1 (bottom left corner of rectangle)
;	ax,si = x2,y2 (top right corner of rectangle)
;	Ps.CurForeClrp
;	Ps.CurBackClrp
;out:	none
;ret:	jc = error
;notes:	
drect_f	proc	far
	call	drect
	ret
drect_f	endp

drect	PROC	near
	push	bp
	mov	bp,sp
	sub	sp,10
r_remx 		equ wo [bp-2]
r_remx1		equ wo [bp-4]
r_byte_x1	equ by [bp-6]
r_byte_x	equ by [bp-5]
r_DY		equ wo [bp-8]
r_DX		equ by [bp-10]
	push	ax			;bp-12
.ax equ wo [bp-12]
	push	bx			;bp-14
.bx equ wo [bp-14]
	push	cx			;bp-16
.cx equ wo [bp-16]
	push	dx			;bp-18
.dx equ wo [bp-18]
	push	si			;bp-20
	push	di			;bp-22
	push	es			;bp-24
r_x	equ	<.cx>
r_y	equ	<.dx>
r_x1	equ	<.ax>

	sub	si,dx			;change y1 to delta y
	inc	si
	mov	r_DY,si
	and	cx,7			;x mod 8
	mov	r_remx,cx		;save in r_remx
	mov	cl,3			;setup shift count
	mov	ax,r_x			; get x coordinate
	shr	ax,cl			; x/8
	mov	r_byte_x,al		; save in r_byte_x
	mov	ax,r_x1			;get x1 back
	shr	ax,cl			; x1/8
	mov	r_byte_x1,al		; save in r_byte_x1
	sub	al,r_byte_x		;compute delta x in bytes
	inc	al
	mov	r_DX,al
	mov	ax,r_x1			;get x1
	and	ax,7			;x1 mod 8
	mov	r_remx1,ax		;save 
	mov	ax,VIDEO_ADDR		; get video buffer address
	mov	es,ax			;setup es->frame buffer address
	mov	si,ps.CurForeClrp	;point at foreground first

;--- top of loop for doing foreground/background fills
;--- first pass does foreground, second pass does background

dr_00:	cmp	[si].ColorMM,MM_TRNSPRNT;is mix mode transparent for this color?
	 jne	dr_001			;  no
	jmp	dr_60			;  yes, don't bother with it
dr_001:	mov	dx,03CEh		;point at register select register
	cmp	[si].ColorFlag,CLR_DITHER;is color dithered?
	 je	dr_02			; yes

;--- setup mode registers for write mode 2, allowing use to write
;--- all four planes at once, given a single index

	mov	ax,0205h		;setup for solid color fill
	out	dx,ax			;select write mode 2
	mov	ax,0003h		;assume overpaint mode
	cmp	[si].ColorMM,MM_XOR	;XOR mix mode?
	 jne	dr_01			; no
	mov	ah,18h			; yes, select XOR mode
dr_01:	out	dx,ax			;set register 3 function
	mov	dx,03c4h		;dx-> sequencer I/O port
	mov	ax,0f02h		; default Map Mask value
	out	dx,ax			;
	jmp	short dr_05			

;--- setup write mode 0 w/set-reset disabled, so we can write 1 plane at
;--- a time, to do a dithered color

dr_02:	mov	ax,0005			;write mode 0 into mode select
	out	dx,ax			;
	mov	ax,0003h		;assume overpaint mode
	cmp	[si].ColorMM,MM_XOR	;XOR mix mode?
	 jne	dr_03			; no
	mov	ah,18h			; yes, select XOR mode
dr_03:	out	dx,ax			;
	mov	ax,0001h		;disable set/reset mode
	out	dx,ax			;
dr_05:	mov	bl,r_byte_x		;bl:=starting byte number on row
	mov	dx,r_y			;dx:=starting y
	mov	ax,r_DY			;ax:=delta y
	mov	cl,r_DX			;cl:=delta x in bytes
	mov	di,r_remx		;get non-byte aligned count
	cmp	bl,r_byte_x1		;see if starting byte same as ending byte number
	 je	dr_50			;if same then block is <= 1 byte wide
	or	di,di			;see if remx is zero
	 jz	dr_10			;yes jump
	mov	bh,cs:mtable[di]	;bh:=bit mask for non-byte aligned
	mov	di,ofs mblock_fill_d	;assume non-dithered color
	cmp	[si].ColorFlag,CLR_DITHER;is this color dithered?
      	 jne	dr_08			; no
	mov	di,ofs mblck_fill_d	; yes
dr_08:	call	di			;draw left sliver (non-byte aligned)
	inc	bl			;bump starting byte number
	dec	cl			;dec delta x
dr_10:	mov	di,r_remx1		;get right non-byte aligned part
	cmp	di,7			;see if right non-byte aligned part is 7
	 je	dr_30			;jump if yes
	push	bx			;save starting byte number
	mov	bl,r_byte_x1		;get starting byte number for right sliver
	mov	bh,cs:mtable1[di]	;bh:=bit mask for non-byte aligned
	mov	di,ofs mblock_fill_d	;assume non-dithered color
	cmp	[si].ColorFlag,CLR_DITHER;is this color dithered?
      	 jne	dr_20			; no
	mov	di,ofs mblck_fill_d	; yes
dr_20:	call	di			;draw last third
	pop	bx			;recover starting byte number
	dec	cl			;dec delta x
dr_30:	or	cl,cl			;see if any more to do
	 jz	dr_60			; no, check next color
	mov	di,ofs block_fill_d	;assume non-dithered color
	cmp	[si].ColorFlag,CLR_DITHER;is this color dithered?
      	 jne	dr_40			; no
	mov	di,ofs blck_fill_d	; yes
dr_40:	call	di			; draw middle third
	jmp	short dr_60		; done so jump

;--- this handles a block which is within a single byte
dr_50:	mov	bh,cs:mtable[di]	;get mask for left side
	mov	di,r_remx1		;get remainder for left side
	and	bh,cs:mtable1[di]	;finish making mask
	mov	di,ofs mblock_fill_d	;assume non-dithered color
	cmp	[si].ColorFlag,CLR_DITHER;is this color dithered?
      	 jne	dr_55			; no
	mov	di,ofs mblck_fill_d	; yes
dr_55:	call	di			;draw last third
dr_60:	cmp	si,ps.CurForeClrp	;were we doing foreground color?
	 jne	dr_90			; no, we are done
	cmp	[si].ColorFPp,0		;yes, was foreground solid?
	 je	dr_90			; yes, we are done
	mov	si,ps.CurBackClrp	;point at background color and go again
	jmp	dr_00
 
dr_90:	cmp	[si].ColorFlag,CLR_DITHER;was last color we did dithered?
	 jne	dr_98			; no
	mov	dx,03c4h		; yes, reset sequencer mask to all planes
	mov	ax,0f02h		; default Map Mask value
	out	dx,ax			;
dr_98:	mov	dx,03ceh		;reset read/write mode
	mov	ax,0005h		;	\
	out	dx,ax			;	\
	clc
	pop	es
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
drect	ENDP
;mblock_fill_d
;desc:	fill a rectangle with uneven byte boundaries
;in:	ds = psseg
;	bh = bit mask for sliver
;	bl = starting byte # of raster
;	dx = starting y raster #
;	ax = # of rasters (delta y)
;	cl = # of bytes (not used in this routine)
;	si->color to use
;	es = frame buffer segment
;out:	byte written to frame buffer
;ret:	none
;notes:	This does NON-DITHERED colors
public	mblock_fill_d
mblock_fill_d	PROC	NEAR
	push	bp
	mov	bp,sp
	sub	sp,6
ycnt	equ wo [bp-2]
ivflg	equ by [bp-4]
ptwidth	equ wo [bp-6]
	push	ax
	push	bx
.bh	equ by [bp-9]
.bl	equ by [bp-10]
	push	cx
.cx	equ wo [bp-12]
	push	dx
.dx	equ wo [bp-14]
	push	si
.si	equ wo [bp-16]
	push	di

	mov	ycnt,ax			;save loop count
	mov	di,dx			;get starting raster #
	shl	di,1			;make into word offset
	mov	di,cs:latable[di]	;di:=start of row
	xor	bh,bh
	add	di,bx			;di:=address of byte to write

;select the bit mask register
	mov	dx,3ceh			; graphics controller port address
	mov	al,8			;
	out	dx,al			; select register 8
	inc	dx			;bump to address for writing mask
	mov	si,ps.CurForeClrp	;see about pattern
	cmp	[si].ColorFPp,0		;do we have a pattern?
	 jne	mbl_05			; yes
	mov	al,0ffh			; no, setup for solid fill
	and	al,.bh			;setup mask for bits to set
	out	dx,al
	mov	cx,ycnt		 	;get number of rasters
	mov	si,.si			;point at passed color
	mov	si,[si].ColorMP		;point at mapped index
	mov	al,by [si].MIdx		;get mapped color index
mbl_02:	mov	ah,es:[di]		;latch existing data
	mov	es:[di],al		;set color
	sub	di,BYTROW		;bump address by a raster
	loop	mbl_02
	jmp	mbl_99

mbl_05:	mov	ivflg,0			;init
	cmp	si,.si			;are we doing background color?
	 je	mbl_06			; no, foreground
	mov	ivflg,1			; yes, set flag to invert pattern
mbl_06:	mov	si,[si].ColorFPp	;point si at fill pattern def
	mov	bl,[si].FPWidthB	;get pattern width in bytes
	xor	bh,bh
	mov	ptwidth,bx		;save
	mov	al,.bl			;get starting byte number in raster
	xor	ah,ah
	cmp	bl,1			;if 1, skip divide
	 je	mbl_07
	div	bl			;otherwise, compute offset into pattern row
mbl_07:	mov	bl,ah			;bx:=offset into pattern row
	xor	bh,bh
	mov	cl,[si].FPHeight	;get pattern height
	mov	ax,.dx			;get raster number
	div	cl			;compute pattern row #
	sub	ah,[si].FPHeight	;flip raster number since patterns
	inc	ah			;are basically upside down related
	neg	ah			;to normal orientation
	mov	al,ah
	mov	ch,al			;ch:=starting pattern raster number
	xor	ah,ah
	mov	cl,[si].FPWidthB	;get pattern width in bytes
	cmp	cl,1 			;if 1, skip multiply
	 je	mbl_08
	mul	cl			;else, compute offset of start of row
mbl_08:	add	ax,si			;ax->start of current pattern raster
	add	ax,FPData
	mov	si,.si			;si->passed color
	mov	si,[si].ColorMP		;
	mov	cl,by [si].MIdx		;cl:=mapped color index
	mov	si,ax			;si->start of current pattern raster
mbl_10:	mov	al,[si+bx]		;get bit pattern 
    	test	ivflg,1			;need to invert pattern?
	 jz	mbl_15			; no
	not	al			; yes
mbl_15:	and	al,.bh			;mask bits we don't want to set
	out	dx,al			;setup bit mask register
	mov	al,es:[di]		;latch current data
	mov	es:[di],cl		;set new data
	sub	di,BYTROW		;bump byte position byte a raster
	sub	si,ptwidth		;bump pattern pointer a raster
	dec	ch			;bump pattern raster number
	 jge	mbl_40			; ok
	mov	si,ps.CurForeClrp	;point at color def w/pattern
	mov	si,[si].ColorFPp	;point at pattern def
	mov	ch,[si].FPWidthB	;get width of pattern in bytes
	mov	al,[si].FPHeight	;get height of pattern in bits (rows)
	dec	al
	xor	ah,ah
	cmp	ch,1			;if 1, skip multiply
	 je	mbl_20
	mul	ch
mbl_20:	add	ax,si
	add	ax,FPData
	mov	ch,[si].FPHeight
	dec	ch			;ch is new current pattern raster
	mov	si,ax			;si->new starting pattern raster
mbl_40:	dec	ycnt			;decrement loop count
	 jnz	mbl_10			; loop back
mbl_99:	mov	dx,3ceh			;reset bit mask
	mov	ax,0ff08h		;	\
	out	dx,ax			;	\
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
mblock_fill_d	ENDP
;block_fill_d
;desc:	fill a rectangle with even byte boundaries
;in:	ds = psseg
;	bl = starting byte # of raster
;	dx = starting y raster #
;	ax = # of rasters (delta y)
;	cl = # of bytes (delta x in bytes)
;	si->color to use
;	es = frame buffer segment
;out:	bytes written to frame buffer
;ret:	none
;notes:	This does NON-DITHERED colors
public	block_fill_d
block_fill_d	PROC	NEAR
	push	bp
	mov	bp,sp
	sub	sp,10
ycnt	equ wo [bp-2]
ptwidth	equ wo [bp-4]
ptheight equ wo [bp-6]
ivflg	equ by [bp-8]
lcnt	equ by [bp-10]
lcntr	equ by [bp-9]
	push	ax
	push	bx
.bl	equ by [bp-14]
	push	cx
.cl	equ by [bp-16]
	push	dx
	push	si
.si	equ wo [bp-20]
	push	di
	mov	ycnt,ax			;save loop count
	mov	di,dx			;get starting raster
	shl	di,1			;make into word offset
	mov	di,cs:latable[di]	;di:=start of row
	xor	bh,bh
	add	di,bx			;di->starting byte on raster


	mov	si,ps.CurForeClrp
	cmp	[si].ColorFPp,0		;do we have a pattern?
	 jne	blf07			; yes
	mov	dx,3ceh			; no, do a quick solid fill
	mov	ax,0ff08h
	out	dx,ax			;setup mask register for solid
	mov	si,.si
	mov	dl,[si].ColorMM		;get mix mode for compare in loop
	mov	si,[si].ColorMP
	mov	al,by [si].MIdx		;get color index to use
	xor	ch,ch
blf02:	push	di			;save starting byte address
	mov	cl,.cl			;get width of block in bytes
	cmp	dl,MM_OVERPAINT		;are we doing just a replace?
	 je	blf05			; yes, do it as fast as possible
blf03:	mov	ah,es:[di]		; no, latch current data
	stosb				;store new data
	loop	blf03
	jmp	short blf06

blf05:	rep	stosb			;write the bytes
blf06:	pop	di			;recover starting byte address
	sub	di,BYTROW		;bump by a raster
	dec	ycnt			
	 jnz	blf02
	jmp	blf99

blf07:	mov	ivflg,0			;assume don't need to invert pattern
	cmp	si,.si			;are we doing foreground?
	 je	blf08			; yes
	mov	ivflg,1			; no, must invert pattern
blf08:	mov	si,[si].ColorFPp	;si->pattern def
	mov	al,cl			;al:= width of block in bytes
	xor	ah,ah
	mov	cl,[si].FPWidthB	;get width of pattern in bytes
	cmp	cl,1			;if pattern width 1, skip divide
	 je	blf09
	div	cl			;divide block width in bytes by pattern width in bytes
blf09:	mov	lcntr,ah		;save remainder
	mov	lcnt,al			;save full loop count
	xor	ch,ch
	mov	ptwidth,cx		;save pattern width in bytes
	mov	al,.bl			;get starting byte number
	xor	ah,ah
	cmp	cl,1			;if pattern width 1, skip divide
	 je	blf09a
	div	cl
blf09a:	mov	bl,ah			
	xor	bh,bh			;bx:=starting offset into pattern raster
	mov	cl,[si].FPHeight	;get height of pattern
	xor	ch,ch
	mov	ptheight,cx		;save
	mov	ax,dx			;ax:=starting raster #
	div	cl
	mov	cl,ah			;cx:=starting pattern raster number
	xor	ch,ch
	sub	cx,ptheight		;flip, since patterns are basically
	inc	cx			;upside down relative to standard
	neg	cx			;orientation

	mov	dx,3ceh			;graphics controller port address
	mov	al,8			;
	out	dx,al			;select register 8 (bit mask register)
	inc	dx			;

;--- main output loop
;--- in: ax = starting raster #
;---     bx = byte offset into pattern raster
;---	 cx = starting raster # in pattern
;---	 dx = address of port to write for setting bit mask register
;---     di = address of starting byte on raster

blf10:	push	bx
	push	cx
	push	di
	mov	si,.si			;get pointer to passed color
	mov	si,[si].ColorMP
	mov	ch,by [si].MIdx		;get mapped color index
	mov	si,ps.CurForeClrp	;point at foreground color (has pattern)
	mov	si,[si].ColorFPp	;si->pattern def
	mov	al,cl			;get pattern raster number
	xor	ah,ah
	mov	cl,[si].FPWidthB	;get width of pattern in bytes
	cmp	cl,1			;if width 1, skip multiply
	 je	blf30
	mul	cl
blf30:	add	ax,si
	add	ax,FPData		;ax:=address of fill pattern data
	mov	si,ax			;si->starting of current fill pattern raster
	mov	ah,ch			;get mapped color index
	mov	cl,lcnt			;get full loop count
	or	cl,cl			;any to do?
	 jz	blf60			; no
	mov	cx,ptwidth		; yes, get width of pattern in bytes
blf50:	push	di			;save starting byte number
	push	cx			;save outer loop count
	mov	al,[si+bx]		;get bit mask from pattern
	test	ivflg,1			;need to invert?
	 jz	blf54			; no
	not	al			; yes
blf54:	out	dx,al			;set bit mask register
	mov	cl,lcnt			;get count
blf55:	mov	al,es:[di]		;latch current data
	mov	es:[di],ah		;put new data out
	add	di,ptwidth		;bump to next byte
	loop	blf55			;go do next byte
	inc	bx			;bump index into pattern
	cmp	bx,ptwidth		;need to wrap around?
	 jb	blf56			; no
	xor	bx,bx			; yes
blf56:	pop	cx			;recover outer loop count
	loop	blf57
	inc	sp			;clean di value from stack
	inc	sp
	sub	di,ptwidth		;adjust di to point after stuff we wrote
	inc	di
	jmp	short blf60		;and do any remainder we need to

blf57:	pop	di			;recover starting byte
	inc	di			;bump
	jmp	short blf50		;and continue loop

;--- bx points at current byte in pattern
;--- es:di points at current byte to set
blf60:	mov	cl,lcntr		;get loop count remainder
	xor	ch,ch
	 jcxz	blf80			; no remainder to do
blf62:	mov	al,[si+bx]		;get bit mask from pattern
	test	ivflg,1			;need to invert?
	 jz	blf64			; no
	not	al			; yes
blf64:	out	dx,al			;set it
	mov	al,es:[di]		;latch current data
	mov	es:[di],ah		;put new data out
	inc	di
	inc	bx			;bump offset into pattern
	cmp	bx,ptwidth		;need to wrap around?
	 jb	blf66			; no
	xor	bx,bx			; yes
blf66:	loop	blf62

blf80:	pop	di
	pop	cx
	pop	bx
	sub	di,BYTROW		;add number of bytes in a raster
	dec	cx			;bump pattern raster number
	 jge	blf85			; ok
	mov	cx,ptheight		; loop around
	dec	cx
blf85:	dec	ycnt			;dec loop count
	 jz	blf99
	jmp	blf10
blf99:	mov	dx,3ceh			;reset bit mask
	mov	ax,0ff08h		;	\
	out	dx,ax			;	\
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
block_fill_d	ENDP
;mblck_fill_d
;desc:	fill a rectangle with uneven byte boundaries
;in:	ds = psseg
;	bh = bit mask for sliver
;	bl = starting byte # of raster
;	dx = starting y raster #
;	ax = # of rasters (delta y)
;	cl = # of bytes (not used in this routine)
;	si->color to use
;	es = frame buffer segment
;out:	byte written to frame buffer
;ret:	none
;notes:	this does DITHERED colors
public	mblck_fill_d
mblck_fill_d	PROC	NEAR
	push	bp
	mov	bp,sp
	sub	sp,8
Plane4c	equ by [bp-1]
Plane3c	equ by [bp-2]
Plane2c	equ by [bp-3]
Plane1c equ by [bp-4]
ycnt	equ wo [bp-6]
ptheight equ by [bp-7]
ivflg	equ by [bp-8]
	push	ax
	push	bx
.bl	equ by [bp-12]
.bh	equ by [bp-11]
	push	cx
	push	dx
.dx	equ wo [bp-16]
	push	si
.si	equ wo [bp-18]
	push	di

	mov	ycnt,ax			;save number of rasters to do
	mov	di,dx			;get starting raster #
	shl	di,1			;make into word offset
	mov	di,cs:latable[di]	;di:=start of row
	xor	bh,bh
	add	di,bx			;di:=address of starting byte

	mov	si,ps.CurForeClrp	;point at color def w/pattern
	cmp	[si].ColorFPp,0		;do we have a pattern?
	 jne	mblk05			; yes
	mov	si,.si			; no, point at passed color

;--- solid fill code
;---
	mov	dx,3ceh			; no, setup for solid fill
	mov	al,8
	mov	ah,.bh
	out	dx,ax
	mov	si,[si].ColorMP
	mov	cx,ycnt			;get number of rasters to do
	mov	dx,03c4h		;DX:=Sequencer I/O port address
	mov	al,2			; select map mask register
	out	dx,al
	inc	dx			;point dx at map mask reg
	mov	ax,.dx			;get starting y raster
mblk01:	push	ax			;save current y coordinate
	mov	bx,ax			;get current y coordinate
	and	bx,7			;mod 8
	add	bx,si			;bx->dither pattern raster to use
	mov	al,8			;start by enabling plane 1
	mov	cx,4			;do four planes
mblk02:	out	dx,al			;enable plane
	mov	ah,es:[di]		;latch existing video data
	mov	ah,[bx]			;get current plane data
	mov	es:[di],ah
	add	bx,8			;bump to next plane data
	shr	al,1			;get mask for next plane
	loop	mblk02			;do rest of planes
	pop	ax
	sub	di,BYTROW		;bump address by a raster
	inc	ax			; (not dec) y goes up from bot
	dec	ycnt
	 jnz	mblk01
	jmp	mblk99

;--- end solid fill code
;---

mblk05:	mov	ivflg,0			;assume foreground color
	cmp	si,.si			;is it?
	 je	mblk06			; yes
	mov	ivflg,1			; no
mblk06:	mov	si,[si].ColorFPp	;si->pattern def
	mov	al,.bl			;get byte number
	xor	ah,ah
	mov	bl,[si].FPWidthB	;get pattern width in bytes
	cmp	bl,1			;skip divide if by 1
       	 je	mblk07
	div	bl			;else compute starting byte in pat row
mblk07:	mov	bl,ah			
	xor	bh,bh			;bx:=offset into pattern raster
	mov	cl,[si].FPHeight	;get pattern height
	mov	ptheight,cl		;save
	mov	ax,.dx			;ax:=starting raster
	div	cl			;compute starting pattern row
	sub	ah,ptheight		;flip orientation since patterns are
	inc	ah			;upside down relative to standard 
	neg	ah			;orientation
	mov	ch,ah			;ch:=starting pattern raster number
	mov	ax,.dx			;get starting y
mblk10:	push	ax			;starting x byte, delta y
	push	bx
	push	cx
;--- create the four bit plane bytes for this raster
	mov	si,.si			;get pointer to color def to use
	and	ax,7			;y mod 8
	add	ax,[si].ColorMP		;point at dither pattern
	mov	si,ax
	mov	al,[si]			;get plane 1 bits
	mov	Plane1c,al		;save 
	mov	al,[si+8]		;get plane 2 bits
	mov	Plane2c,al		;save
	mov	al,[si+16]		;get plane 3 bits
	mov	Plane3c,al		;save
	mov	al,[si+24]		;get plane 4 bits
	mov	Plane4c,al		;save

;--- create the pattern mask for this raster

	mov	si,ps.CurForeClrp	;point at foreground color (since it has pattern)
	mov	si,[si].ColorFPp	;si->fill pattern def
	mov	al,ch			;get current pattern raster #
	xor	ah,ah
	mov	cl,[si].FPWidthB	;get byte width of pattern
	cmp	cl,1			;if 1, skip multiply
	 je	mblk12
	mul	cl
mblk12:	add	ax,si			;ax:=start of current pattern raster
	add	ax,FPData
	mov	si,ax			;si:=same
	mov	ah,[si+bx]		;get bit mask from pattern
	test	ivflg,1			;need to invert pattern?
	 jz	mblk15			; no
	not	ah			; yes
mblk15:	and	ah,.bh			;adjust for sliver we are doing
	mov	dx,3ceh			; graphics controller port address
	mov	al,8			;select bit mask register
	out	dx,ax			;select register 8, write mask
	mov	dx,03c4h		;DX:=Sequencer I/O port address
	mov	al,2			; select map mask register
	out	dx,al
	inc	dx			;point dx at map mask reg
	mov	bx,0408h		;write 4 planes (bh), starting with plane 1 (bl)
	lea	si,Plane1c		;point at plane 1 color bits
mblk30:	mov	al,bl			;enable plane
	out	dx,al
	mov	al,es:[di]		;latch plane data
	mov	al,ss:[si]		;get color bits for plane
	mov	es:[di],al		;write plane
	inc	si			;bump pointer to plane data
	shr	bl,1			;enable next plane
	dec	bh			;do all four
	 jnz	mblk30
mblk60:	pop	cx			;restore current raster number
	pop	bx
	pop	ax
	sub	di,BYTROW		;add number of bytes in a raster
	inc	ax			;bump y coordinate
	dec	ch			;bump current pattern raster
	 jge	mblk65			;need to wrap?
	mov	ch,ptheight		; yes
  	dec	ch			;
mblk65:	dec	ycnt			;decrement count of rasters to do
	 jz	mblk99
	jmp	mblk10
mblk99:	mov	dx,3ceh			;reset bit mask
	mov	ax,0ff08h		;	\
	out	dx,ax			;	\
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
mblck_fill_d	ENDP
;blck_fill_d
;desc:	fill a rectangle with even byte boundaries
;in:	ds = psseg
;	bl = starting byte # of raster
;	dx = starting y raster #
;	ax = # of rasters (delta y)
;	cl = # of bytes (delta x in bytes)
;	si->color to use
;	es = frame buffer segment
;out:	bytes written to frame buffer
;ret:	none
;notes:	This does DITHERED colors
public	blck_fill_d
blck_fill_d	PROC	NEAR
	push	bp
	mov	bp,sp
	sub	sp,16

Plane4c	equ by [bp-1]
Plane3c	equ by [bp-2]
Plane2c	equ by [bp-3]
Plane1c	equ by [bp-4]
CurFBp	equ wo [bp-6]
ycnt	equ wo [bp-8]
ivflg	equ by [bp-10]
mmode	equ by [bp-9]
lcntr	equ by [bp-12]
lcnt	equ by [bp-11]
ptheight equ wo [bp-14]
ptwidth	equ wo [bp-16]

	push	ax
	push	bx
.bl	equ by [bp-20]
	push	cx
.cl	equ by [bp-22]
	push	dx
.dx	equ wo [bp-24]
	push	si
.si	equ wo [bp-26]
	push	di

	mov	ycnt,ax			;save number of rasters to do
	mov	di,dx			;get starting raster #
	shl	di,1			;make into word offset
	mov	di,cs:latable[di]	;di:=start of row
	xor	bh,bh
	add	di,bx			;di:=address of starting byte
	mov	si,ps.CurForeClrp	;point at color def w/pattern
	cmp	[si].ColorFPp,0		;do we have a pattern?
	 jne	blk10			; yes

;--- solid fill code
;---
	mov	dx,3ceh			; no, setup for solid fill
	mov	ax,0ff08h
	out	dx,ax
	mov	si,.si			;si->passed color def
	mov	al,[si].ColorMM		;get mix mode value
	mov	mmode,al		;save mix mode value
	mov	si,[si].ColorMP
	mov	cx,ycnt			;get number of rasters to do
	mov	dx,03c4h		;DX:=Sequencer I/O port address
	mov	al,2			; select map mask register
	out	dx,al
	inc	dx			;point dx at map mask reg
	mov	ax,.dx			;get starting y raster
blk01:	push	ax			;save current y coordinate
	mov	bx,ax			;get current y coordinate
	and	bx,7			;mod 8
	add	bx,si			;bx->dither pattern raster to use
	mov	ah,8			;start by enabling plane 1
	mov	cx,4			;do four planes
blk05:	push	cx			;save number of planes left, starting address
	push	di
	mov	al,ah			;
	out	dx,al			;enable plane
	mov	al,[bx]			;get current plane data
	mov	cl,.cl			;get number of bytes
	xor	ch,ch
	cmp	mmode,MM_OVERPAINT	;are we doing just a solid replace?
	 je	blk07			; yes, do it as fast as possible
blk06:	mov	al,es:[di]		;no, latch current data
	mov	al,[bx]			;get new data
	stosb				;store new data
	loop	blk06
	jmp	short blk08

blk07:	rep	stosb
blk08:	add	bx,8			;bump to next plane data
	shr	ah,1			;get mask for next plane
	pop	di			;recover number of planes
	pop	cx
	loop	blk05			;do rest of planes
	pop	ax
	sub	di,BYTROW		;bump address by a raster
	inc	ax			; (not dec) y goes up from bot
	dec	ycnt
	 jnz	blk01
	jmp	blk99

;--- end solid fill code
;---

blk10:	mov	ivflg,0			;assume doing foreground
	cmp	si,.si			;are we?
	 je	blk11			; yes
	mov	ivflg,1			; no
blk11:	mov	si,[si].ColorFPp	;si->fill pattern def
	mov	al,cl			;al:= width of block in bytes
	xor	ah,ah
	mov	cl,[si].FPWidthB	;get fill pattern byte width
	cmp	cl,1			;if 1, skip divide
	 je	blk12
	div	cl			;else compute number of times pattern repeats
blk12:	mov	lcntr,ah		;save remainder
	mov	lcnt,al			;save full loop count
	xor	ch,ch
	mov	ptwidth,cx		;save pattern with in convenient place
	mov	al,.bl			;get starting byte number
	xor	ah,ah			;do mod byte pattern width
	cmp	cl,1			;if width 1, skip divide
	 je	blk13
	div	cl
blk13:	mov	bl,ah
	xor	bh,bh			;bx:=starting offset into pattern row
	mov	cl,[si].FPHeight	;get height of pattern
	xor	ch,ch
	mov	ptheight,cx		;save in convenient place
	mov	ax,dx			;get starting raster #
	div	cl			;raster # mod pattern height
	mov	cl,ah
	sub	cl,[si].FPHeight	;flip orientation since patterns are
	inc	cl			;upside down relative to standard
	neg	cl			;orientation
	xor	ch,ch
	mov	ax,dx			;get starting y
blk19:	push	ax			;save y value, offset into pat raster, current pattern raster
	push	bx
	push	cx
	mov	CurFBp,di		;save current frame buffer pointer

;--- create the four bit plane bytes for this raster

	mov	si,.si			;get pointer to color def to use
	mov	di,ax			;get current y coordinate
	and	di,7			;mod 8
	add	di,[si].ColorMP		;point at dither pattern
	mov	al,[di]			;get plane 1 bits
	mov	Plane1c,al		;save 
	mov	al,[di+8]		;get plane 2 bits
	mov	Plane2c,al		;save
	mov	al,[di+16]		;get plane 3 bits
	mov	Plane3c,al		;save
	mov	al,[di+24]		;get plane 4 bits
	mov	Plane4c,al		;save

;--- setup pointer to start of current pattern raster

	mov	si,ps.CurForeClrp	;point at color def with pattern
	mov	si,[si].ColorFPp	;si->pattern def
	mov	al,cl			;get current raster number
	xor	ah,ah
	mov	cl,[si].FPWidthB	;get pattern byte width
	cmp	cl,1			;if 1, skip multiply
      	 je	blk25
	mul	cl
blk25:	add	ax,si			;create pointer into pattern
	add	ax,FPData
	mov	si,ax			;si->start of current pattern raster
	
	mov	di,CurFBp		;di->starting byte on raster
	mov	cl,lcnt			;get full loop count
	or	cl,cl			;any to do?
	 jz	blk60			; no
	mov	cx,ptwidth		; yes, get width of pattern in bytes
blk30:	push	bx			;loop count, pointers
	push	cx
	push	si
	push	di
	mov	ah,[si+bx]		;get bit mask from pattern
	test	ivflg,1			;need to invert?
	 jz	blk31			; no
	not	ah			; yes
blk31:	mov	dx,3ceh			;set bit mask register
	mov	al,8
	out	dx,ax
	mov	dx,03c4h		;DX:=Sequencer I/O port address
	mov	al,2			;select map mask register
	out	dx,al
	inc	dx			;point dx at map mask reg
	mov	bx,0408h		;write 4 planes (bh), starting with plane 1 (bl)
	lea	si,Plane1c		;point at plane 1 color bits
	xor	ch,ch			;clear top of cx for loop count
blk35:	push	di			;save starting byte address
	mov	al,bl			;enable plane
	out	dx,al
	mov	cl,lcnt			;get count to write
	mov	al,ss:[si]		;get color bits for plane
blk40:	mov	ah,es:[di]		;latch plane data
	mov	es:[di],al		;write new data
	add	di,ptwidth		;bump pointer
	loop	blk40			;
	pop	di			;recover starting byte address
	inc	si			;bump pointer to plane data
	shr	bl,1			;enable next plane
	dec	bh			;do all four
	 jnz	blk35
	pop	di			;recover loop count, pointers
	pop	si
	pop	cx
	pop	bx
	inc	di			;
	inc	bx			;bump index into pattern
	cmp	bx,ptwidth		;need to wrap around?
	 jb	blk45			; no
	xor	bx,bx			; yes
blk45:	loop	blk30
	mov	di,ps.CurForeClrp
	mov	di,[di].ColorFPp	;di->fill pattern def
	mov	al,lcnt
	xor	ah,ah
	mov	cl,[di].FPWidthB	;get byte width
	cmp	cl,1			;if 1, skip multiply
      	 je	blk50
	mul	cl
blk50:	add	ax,CurFBp		;compute address of next byte to write
	mov	di,ax

;--- es:di->byte to write
;--- bx->current byte in pattern raster
;--- si->start of current pattern raster

blk60:	mov	cl,lcntr		;get loop count remainder
	xor	ch,ch
	 jcxz	blk80			;jump if none to do
blk61:	push	bx			;save loop count
	push	cx
	push	si
	mov	ah,[si+bx]		;get bit mask from pattern
	test	ivflg,1			;need to invert?
	 jz	blk62			; no
	not	ah			; yes
blk62:	mov	dx,3ceh			;setup bit mask register
	mov	al,8
	out	dx,ax
	mov	dx,03c4h		;DX:=Sequencer I/O port address
	mov	al,2			;select map mask register
	out	dx,al
	inc	dx			;point dx at map mask reg
	mov	bx,0408h		;write 4 planes (bh), starting with plane 1 (bl)
	lea	si,Plane1c		;point at plane 1 color bits
blk65:	mov	al,bl			;enable plane
	out	dx,al
	mov	al,ss:[si]		;get color bits for plane
	mov	ah,es:[di]		;latch plane data
	mov	es:[di],al		;write new data
	inc	si			;bump pointer to plane data
	shr	bl,1			;enable next plane
	dec	bh			;do all four
	 jnz	blk65
	inc	di			;point at next byte to do
	pop	si
	pop	cx
	pop	bx
	inc	bx	  		;bump pointer to current pattern byte
	cmp	bx,ptwidth		;need to wrap around?
	 jb	blk66			; no
	xor	bx,bx			; yes
blk66:	loop	blk61			;
blk80:	mov	di,CurFBp		;restore frame buffer pointer
	pop	cx			;restore loop parms
	pop	bx
	pop	ax
	sub	di,BYTROW		;add number of bytes in a raster
	inc	ax			;bump y coordinate
	dec	cx			;bump current pattern raster number
 	 jge	blk85			; ok
	mov	cx,ptheight		;need to wrap around
	dec	cx
blk85:	dec	ycnt			;decrement count of rasters to do
	 jz	blk99
	jmp	blk19
blk99:	mov	dx,3ceh			;reset bit mask
	mov	ax,0ff08h		;	\
	out	dx,ax			;	\
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
blck_fill_d	ENDP
;horln
;desc:	Draw a horizontal line
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx x coordinate, left
;	dx y coordinate
;	ax x coordinate, right
;	ps.LnClr = color
;out:	none
;ret:	jc  = error
;notes:	
;	This routine should draw a line from x (CX) to x1 (AX) along the
;	y (DX) raster with color in BL.
;
;	All registers may be changed.
;

horln	PROC	FAR
	push	ax
	push	cx
	push	dx
	push	si
	mov	si,dx			;setup for drect
	cmp	cx,ax			;make sure x < x1
	 jbe	hl2			; ok
	xchg	cx,ax
hl2:	call	drect
	pop	si
	pop	dx
	pop	cx
	pop	ax
	ret
horln	ENDP
;verln
;desc:	Draw a vertical line
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx = x coordinate
;	dx = y coordinate, bottom
;	ax = y1 coordinate, top
;	Ps.LnClr = color
;out:	none
;ret:	jc = error
;notes:	
;	This routine should draw a line from y (DX) to y1 (AX) along the
;	x (CX) column with ps.LnClr color
;
;	All registers may be changed.

verln	PROC	FAR
	push	ax
	push	cx
	push	dx
	push	si
	mov	si,ax			;setup for drect
	mov	ax,cx
	cmp	dx,si			;make sure y < y1
	 jbe	vl2
	xchg	dx,si
vl2:	call	drect
	pop	si
	pop	dx
	pop	cx
	pop	ax
	ret
verln	ENDP
;colorm
;desc:	Set Color Map
;in:	ds = presentation space segment
;	bx = presentation space handle
;	dx = number of first entry to change (0 origin)
;	cx = number of entries to change
;	es:si --> dd = pointer to:
;			db	red (0-255)
;		  	db	green
;		  	db	blue
;			   ...
;			db	red (0-255)
;		  	db	green
;		  	db	blue
;out:	none
;ret:	jc = error
;notes:	
;	BX will contain the first color register number.  CX will contain
;	the number of color registers to change starting at BX.  DS:SI
;	will point to a list of RGB entries CX*3 bytes long.
;
;	The RGB values will be a number from 0-255, 0 meaning no color,
;	255 meaning full color.
;
;	All registers may be changed.
;
; **** equates for RGB offsets ****
cm_red		equ	0			; red color calue
cm_green	equ	1			; green color value
cm_blue		equ	2			; blue color value

coltbl	db	0, 1h, 8h, 9h		; color translation table

colorm	PROC	FAR
	cmp	cs:gray,0		;is this gray scale?
	 je	cm00			;  no
	clc
	ret

cm00:	push	bp
	mov	bp,sp
	push	ax
	push	bx
	push	cx
.cx	equ wo [bp-6]
	push	dx
.dx	equ wo [bp-8]
	push	si
.si	equ wo [bp-10]
	push	es
.es	equ wo [bp-12]

	mov	ax,1009h
	push	cs
	pop	es
	mov	dx,ofs Plane3		; point to temporary buffer
	int	10h			; get list of color indexes

	mov	es,.es
	mov	si,.si
	les	si,es:[si]		;load pointer to RGB entries
	mov	bx,.dx			;bx := first entry to change
	xor	bh,bh			;zero high byte
	mov	dx,.cx

cm10:	cmp	bl,max_col		; check for # of colors
	 jae	cm90
	push	dx
	mov	dh,es:[si+cm_red]	; get red
	shr	dh,1
	shr	dh,1
	mov	ch,es:[si+cm_green]	; get  green
	shr	ch,1
	shr	ch,1
	mov	cl,es:[si+cm_blue]	; get blue
	shr	cl,1
	shr	cl,1

	mov	al,plane3[bx]		; get DAC to write
	mov	ah,dh			; ah = red value
	mov	dx,3c8h			; dx = DAC LUT index port
	out	dx,al			; select color register
	jmp	$+2			; 1 word no op
	inc	dx			; dx = DAC LUT output port
	mov	al,ah			; write red value
	out	dx,al			;  /
	jmp	$+2			; 1 word no op
	mov	al,ch			; write green value
	out	dx,al			;  /
	jmp	$+2			; 1 word no op
	mov	al,cl			; write blue value
	out	dx,al			;  /

	pop	dx
	inc	bx			; bump color number
	add	si,3			; bump pointer
	dec	dl
	 jnz	cm10

cm90:	clc				; clear carry flag
	pop	es
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
colorm	ENDP
;svert
;desc:	Scroll a portion of the display screen up or down
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx,dx - lower left corner of rectangle to scroll
;	ax,si - upper left corner of rectangle to scroll
;	di - delta (signed amount to scroll rectangle, + = up, - = down)
;out:	none
;ret:	jc = error
;notes:	
;	This routine should scroll the information on the display in the the
;	box described by x,y (lower left) and x1,y1 (upper right) up or down
;	by the amount in delta. Delta is a signed number, positive meaning
;	scroll up, negitive meaning scroll down.
;

svert	PROC	FAR
	push	bp
	mov	bp,sp
	sub	sp,16
s_p1	equ wo [bp-2]		; point 1 source
s_p2	equ wo [bp-4]		; point 2 destination
s_inc	equ wo [bp-6]		; increment value
s_remx	equ by [bp-8]		; remainder of x
s_byte_x1 equ by [bp-7]	 	; byte number for x1
s_byte_x equ by [bp-10]		; byte number for x
s_mask	equ by [bp-9]		; mask value
s_bytes	equ by [bp-12]		; number of bytes
s_y1	equ wo [bp-14]		;delta y
s_delta	equ wo [bp-16]		;scroll delta

	push	ax
.ax	equ wo [bp-18]
	push	bx
	push	cx
.cx	equ wo [bp-22]
	push	dx
.dx	equ wo [bp-24]
	push	si
	push	di

s_x		equ	<.cx>		; x coordinate
s_y		equ	<.dx>		; y coordinate
s_x1		equ	<.ax>		; x1 coordinate

	sub	si,dx			;compute delta y
	inc	si
	mov	s_y1,si

	or	di,di			; see if up or down
	 jl	sv_01			; jmp if negitive
	mov	ax,dx			; get y
	add	ax,si
	dec	ax
	mov	s_p2,ax			; set point 2
	sub	ax,di			; get point 1
	mov	s_p1,ax			; set point 1
	mov	WO s_inc,-1		; setup increment value
	jmp	short sv_02		; all done

sv_01:	neg	di			; make positive
	mov	ax,dx			; get point 1
	mov	s_p2,ax			; set point 2
	add	ax,di			; setup point 1
	mov	s_p1,ax			; set point 1
	mov	WO s_inc,1		; set increment value

sv_02:	mov	s_delta,di		; save abs (delta)

	mov	bx,s_x			; get x coordinate
	and	bx,7			; x mod 8
	mov	s_remx,bl		; save in remx

	mov	ax,s_x1			; get x1 coordinate
	shr	ax,1			; x1/8
	shr	ax,1			;
	shr	ax,1			;
	mov	s_byte_x1,al		; save in byte_x1

	mov	ax,s_x			; get x coordinate
	shr	ax,1			; x/8
	shr	ax,1			;
	shr	ax,1			;
	mov	s_byte_x,al		; save in byte_x

	cmp	al,s_byte_x1		; compare byte_x ans byte_x1
	 je	sv_40			; if equal then jump
	
	or	bl,bl			; see if remx is zero
	 jz	sv_10			; yes jump
	mov	al,cs:mtable[bx]	; get mask
	mov	s_mask,al		; save it
	mov	cl,s_byte_x		; get byte_x
	call	mblock_scroll_d		; go draw first third
	mov	al,s_byte_x		; get byte_x
	inc	ax			; bump by one
	mov	s_byte_x,al		; save
sv_10:	mov	bx,s_x1			; get x1 coordinate
	and	bx,7			; x1 mod 8
	mov	s_remx,bl		; save in remx
	cmp	bl,7			; see if 7
	 je	sv_30			; jump if yes
	mov	al,cs:mtable1[bx]	; get mask
	mov	s_mask,al		; save it
	mov	cl,s_byte_x1		; get byte_x1
	call	mblock_scroll_d		; draw last third
	mov	al,s_byte_x1		; get byte x1
	dec	al			; less 1
	mov	s_byte_x1,al		; save it
sv_30:	mov	al,s_byte_x		; get byte_x
	mov	ah,s_byte_x1		; get byte_x1
	sub	ah,al			; get x1-x
	inc	ah
	mov	s_bytes,ah		; save in bytes
	 jle	sv_90			; jump if bytes is <= 0
	mov	cl,s_byte_x		; get byte_x
	call	block_scroll_d		; draw middle third
	jmp	short sv_90		; done so jump

sv_40:	mov	al,cs:mtable[bx]	; get mask
	mov	s_mask,al		; save
	mov	bx,s_x1			; get x1 coordinate
	and	bx,7			; x1 mod 8
	mov	s_remx,bl		; save in remx
	mov	al,cs:mtable1[bx]	; get mask
	and	s_mask,al		; and mask1
	mov	cl,s_byte_x		; get byte_x
	call	mblock_scroll_d		; go draw the whole thing

sv_90:	clc
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
svert	ENDP
;mblock_scroll_d
;desc:	scroll a block with uneven byte boundaries
;in:
;s_delta	equ	es:[si]		; scroll delta
;s_x		equ	es:[si+2]	; x coordinate
;s_y		equ	es:[si+4]	; y coordinate
;s_x1		equ	es:[si+6]	; x1 coordinate
;s_y1		equ	es:[si+8]	; y1 coordinate

;s_p1		equ	[bp+2]		; point 1 source
;s_p2		equ	[bp+4]		; point 2 destination
;s_inc		equ	[bp+6]		; increment value
;s_remx		equ	[bp+8]		; remainder of x
;s_byte_x1	equ	[bp+9]		; byte number for x1
;s_byte_x	equ	[bp+10]		; byte number for x
;s_mask		equ	[bp+11]		; mask value
;s_bytes	equ	[bp+12]		; number of bytes

mblock_scroll_d	PROC	NEAR
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di

	mov	bx,s_p2
	push	bx
	push	ds
	xor	ch,ch			; fix for x_byte

	mov	bx,s_p1			; get p1 coordinate

;--- Set the write mode
	mov	dx,3ceh			; Graphics Controller port address
	mov	ax,0005h		; read mode 0 write mode 0
	out	dx,ax			; Select Mode register (5)
	mov	ax,0003h		;assume overpaint mode
	out	dx,ax
	mov	ax,0001h		;disable set/reset mode
	out	dx,ax			;

;--- Set the Bit mask register

	mov	al,8			; mask index
	mov	ah,s_mask		; set mask
	out	dx,ax			; select register 8

	mov	dx,VIDEO_ADDR		; get VGA buffer address
	mov	ds,dx			; point to correct address

	mov	dx,3c4h			; seqencer I/O address
	mov	al,02			; index of plane map
	out	dx,al			; set index to plane map

	mov	dx,3ceh			; graphics controller address
	mov	al,04			; read map index
	out	dx,al			; set index to read map select

	mov	ax,s_y1			; get delta y
	sub	ax,s_delta		; fix it up

mbs_1:	push	ax			; save delta y
	push	bx			; save y
	push	si

	shl	bx,1			; setup source
	mov	ax,latable[bx]		; get frame buffer address
	add	ax,cx			; got it in SI

	mov	bx,s_p2			; setup destination
	shl	bx,1			; x2
	mov	di,latable[bx]		; get frame buffer address
	add	di,cx			; got it in DI
	mov	si,ax

	mov	ax,803h			; cycle thru all planes

mbs_5:	push	ax			; save rd/wr planes
	mov	dx,3c5h			; load sequencer data address
	xchg	ah,al
	out	dx,al			; set plane to write to
	xchg	ah,al

	mov	dx,3cfh			; graphics controller data
	out	dx,al			; set plane to read
	
	mov	ah,[si]			; get source
	mov	al,[di]			; latch destination
	mov	[di],ah			; write destination
	pop	ax
	dec	al			; next read plane
	shr	ah,1			; next write plane
	 jnz	mbs_5

	pop	si
	pop	bx

	mov	ax,s_inc		; bump pointer 2
	add	s_p2,ax

	pop	ax

	add	bx,s_inc		; bump pointer 1
	dec	ax
	 jnz	mbs_1			; loop around

	mov	dx,3c5h			; load controller register
	mov	al,0fh			; enable all planes
	out	dx,al

	mov	dx,3cfh			; load sequencer register
	mov	al,0			; reset read plane
	out	dx,al
	mov	al,0ffh			; reset bit mask
	out	dx,al

	pop	ds
	pop	bx
	mov	s_p2,bx
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
mblock_scroll_d	ENDP
;block_scroll_d
;desc:	scroll a block with even byte boundaries
;in:
;s_delta		equ	es:[si]		; scroll delta
;s_x		equ	es:[si+2]	; x coordinate
;s_y		equ	es:[si+4]	; y coordinate
;s_x1		equ	es:[si+6]	; x1 coordinate
;s_y1		equ	es:[si+8]	; y1 coordinate

;s_p1		equ	[bp+2]		; point 1 source
;s_p2		equ	[bp+4]		; point 2 destination
;s_inc		equ	[bp+6]		; increment value
;s_remx		equ	[bp+8]		; remainder of x
;s_byte_x1	equ	[bp+9]		; byte number for x1
;s_byte_x	equ	[bp+10]		; byte number for x
;s_mask		equ	[bp+11]		; mask value
;s_bytes	equ	[bp+12]		; number of bytes

block_scroll_d	PROC	NEAR
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di

	mov	dx,3ceh			; Graphics Controller port address
	mov	ax,0105h		; read mode 1 write mode 0
	out	dx,ax			; Select Mode register (5)

	xor	ch,ch			; fix for x_byte
	mov	bx,s_p1			; get p1 coordinate

	; Set the Bit mask register
	mov	dx,3ceh			; graphics controller port address
	mov	ax,0ff08h		;
	out	dx,ax			; select register 8

	mov	dx,VIDEO_ADDR		; get vga buffer address

	mov	ax,s_y1			; get delta y
	sub	ax,s_delta		; fix it up

bs_1:	push	ax			; save delta y
	push	bx			; save y
	push	si

	shl	bx,1			; setup source
	mov	ax,cs:latable[bx]	; get frame buffer address
	add	ax,cx			; got it in SI (eventually)

	mov	bx,s_p2			; setup destination
	shl	bx,1			; x2
	mov	di,cs:latable[bx]	; get frame buffer address
	add	di,cx			; got it in DI
	
	mov	bh,s_bytes		; get inner loop count
	mov	si,ax			; get pointer from ax
	mov	ah,bh			; ah = inner loop count

	push	ds
	mov	ds,dx			; point to correct address

bs_2:	mov	al,[si]
	mov	al,0ffh
	mov	[di],al

	inc	di			; bump frame buffer pointers
	inc	si
	dec	ah
	 jnz	bs_2			; inner loop

	pop	ds
	pop	si
	pop	bx

	mov	ax,s_inc		; bump pointer 2
	add	s_p2,ax

	pop	ax

	add	bx,s_inc		; bump pointer 1
	dec	ax
	 jnz	bs_1			; outer loop
	mov	dx,03ceh		;reset read/write mode
	mov	ax,0005h		;	\
	out	dx,ax			;	\
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
block_scroll_d	ENDP

;shor
;desc:	Scroll a portion of the display screen horizontally
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx,dx - lower left corner of rectangle to scroll
;	ax,si - upper left corner of rectangle to scroll
;	di - delta (signed amount to scroll rectangle, + = right, - = left)
;out:	none
;ret:	jc = error
;notes:	
;	This routine should scroll the infromation on the display in the the
;	box described by x,y (lower left) and x1,y1 (upper right) right or left
;	by the amount in delta. Delta is a signed number, positive meaning
;	scroll right, negitive meaning scroll left.
;
;
; **** temporary variables on stack ****
shor	PROC	FAR
	push	bp
	mov	bp,sp
	sub	sp,26
	push	si
h_delta	equ wo [bp-2]		; scroll delta
h_x	equ wo [bp-4]		; x coordinate
h_y	equ wo [bp-6]		; y coordinate
h_x1	equ wo [bp-8]		; x1 coordinate
h_y1	equ wo [bp-10]		; y1 coordinate
h_sp_b	equ wo [bp-12]		; pointer to source byte
h_dp_b	equ wo [bp-14]		; pointer to destination byte
d_x	equ wo [bp-16]		; destination pixel
h_srem	equ by [bp-18]		; source remainder of x
h_drem	equ by [bp-17]		; destination remainder of x
h_rot	equ by [bp-20]		; rotation value
h_mask	equ by [bp-19]		; mask value
h_bytes	equ by [bp-22]		; number of bytes
h_mask1	equ by [bp-21]		; temp mask
h_read_plane equ by [bp-24]	; read plane number
h_write_plane equ by [bp-23]	; write plane number
h_byte	equ by [bp-26]		; byte read

	mov	h_delta,di		; save delta
	mov	h_x,cx			; save x
	mov	h_y,dx			; save y
	mov	h_x1,ax			; save x1
	sub	si,dx			;compute delta y
	inc	si
	mov	h_y1,si			;save it

	or	di,di			; see if - delta
	 jl	shr_01			; jmp if neg
	call	scroll_right_d		; positive so scroll right
	jmp	short shr_99		; done

shr_01:	neg	h_delta			; make positive
	call	scroll_left_d		; scroll left
shr_99:	clc
	pop	si
	mov	sp,bp
	pop	bp
	ret
shor	ENDP
;scroll_left_d
;desc:	scroll the window left
;in:	see shor above
;out:	none
;ret:	none
;notes:
;
scroll_left_d proc near
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	es
	call	scroll_setup_d		; go setup device for a scroll
	mov	ax,h_x			; get x coordinate
	mov	d_x,ax			; save ax
	add	ax,h_delta		; add delta
	mov	h_x,ax			; save it

	mov	ax,h_x			; get x coordinate
	shr	ax,1
	shr	ax,1
	shr	ax,1
	mov	h_sp_b,ax		; save h_x/8

	mov	ax,d_x			; get x coordinate
	shr	ax,1
	shr	ax,1
	shr	ax,1
	mov	h_dp_b,ax		; save d_x/8

	mov	ax,h_x			; get x coordinate
	and	ax,7			; get mod 8
	mov	h_srem,al		; save it

	mov	ax,d_x			; get x coordinate
	and	ax,7			; get mod 8
	mov	h_drem,al		; save it

	mov	al,h_srem		; get source rem
	sub	al,h_drem		; sub destination rem
	mov	h_rot,al		; save it in rot

	xor	bh,bh
	mov	bl,h_drem		; get drem
	mov	al,cs:mtable[bx]	; get mask
	mov	h_mask,al		; save it

	mov	dx,VIDEO_ADDR		; get vga buffer address
	mov	es,dx

	mov	ax,h_x1			; get	x1
	shr	ax,1
	shr	ax,1
	shr	ax,1
	sub	ax,h_sp_b		; subtract destination byte
	mov	bx,h_x1			; get x1
	mov	h_bytes,al		; save it

	mov	cx,h_y1			; get y delta
scl_10:	push	cx			; save for later

	xor	al,al			; get read plane number
	mov	h_read_plane,al		; save it

	inc	al			; get write plane number
	mov	h_write_plane,al	; save it

scl_20:	mov	dx,3ceh			; Select Graphics Controller
	mov	al,4
	mov	ah,h_read_plane
	out	dx,ax

	mov	dx,3c4h			; Sequencer/Map Mode port address
	mov	al,2
	mov	ah,h_write_plane
	out	dx,ax

	mov	bx,h_y			; get y coordinate
	shl	bx,1
	mov	si,cs:latable[bx]	; get address
	mov	di,si
	add	si,h_sp_b		; setup source
	add	di,h_dp_b		; setup destination

	mov	al,es:[si]		; get first byte
	mov	h_byte,al		; save for later
	inc	si			; bump pointer

	mov	bl,h_bytes

	mov	cl,h_rot		; get rot
	or	cl,cl
	 jl	scl_50			; jump if negitive

	or	bl,bl			; see if all in one byte
	 jz	scl_40			; jmp if all in one byte

	mov	dh,h_byte
	mov	dl,es:[si]		; get next byte
	mov	h_byte,dl		; save for later

	shl	dx,cl			; shift left
	mov	al,h_mask		; get mask
	and	dh,al			; mask unwanted
	xor	al,0ffh			; invert mask
	mov	ah,es:[di]		; get destination byte
	and	ah,al			; mask unwanted
	or	ah,dh			; combine
	mov	es:[di],ah		; save


	mov	al,0ffh		; get mask
	mov	h_mask1,al	; set it for later

scl_30:	inc	si			; bump pointers
	inc	di

	dec	bl			;
	 jz	scl_40			; jump if zero

	mov	dh,h_byte		; get byte
	mov	dl,es:[si]		; get next byte
	mov	h_byte,dl		; save for later

	shl	dx,cl			; shift it
	mov	es:[di],dh		; save it

	jmp	scl_30

scl_40:	mov	bx,h_x1			; get x1 coordinate
	sub	bx,h_delta		; sub h_delta
	and	bx,7			; get mod 8

	mov	al,cs:mtable1[bx]	; get mask
	and	h_mask1,al		; get old mask

	mov	dh,h_byte		; get new byte
	mov	dl,es:[si]		; get next byte
	mov	h_byte,dl		; save for later

	shl	dx,cl			; shift

	and	dh,al			; mask off unwanted
	xor	al,0ffh			; invert mask
	mov	ah,es:[di]		; get destination byte
	and	ah,al			; mask off unwanted
	or	ah,dh			; combine
	mov	es:[di],ah		; write it

	jmp	short scl_80		; all done

scl_50:	neg	cl			; make positive
	inc	bl			; bump
	dec	si			; decrement h_bp_b
	mov	dh,h_byte		; get first byte
	mov	dl,es:[si]		; get second byte
	mov	h_byte,dl		; save for later
	shr	dx,cl			; shift it
	mov	al,h_mask		; get mask
	and	dl,al			; mask unwanted
	xor	al,0ffh			; invert mask
	mov	ah,es:[di]		; get destination byte
	and	ah,al			; mask unwanted
	or	ah,dl			; combine
	mov	es:[di],ah		; write it

	mov	al,0ffh			; get new mask
	mov	h_mask1,al		; save for later

scl_60:	inc	si			; bump h_sp_b
	inc	di			; bump h_dp_b

	dec	bl			; decrement
	 jz	scl_70			; jump if done

	mov	dh,h_byte		; get new byte
	mov	dl,es:[si]		; get next byte
	mov	h_byte,dl		; save for later

	shr	dx,cl			; shift
	mov	es:[di],dl		; write it
	jmp	scl_60			; loop

scl_70:	mov	bx,h_x1			; get x1 coordinate
	sub	bx,h_delta		; sub delta x
	and	bx,7			; get mod 8
	mov	al,cs:mtable1[bx]	; get new mask
	and	h_mask1,al

	mov	dh,h_byte		; get new byte
	mov	dl,es:[si]		; get next byte
	mov	h_byte,dl		; save for later

	shr	dx,cl			; shift
	and	dl,al			; mask off unwanted
	xor	al,0ffh			; invert mask
	mov	ah,es:[di]		; get destination byte
	and	ah,al			; mask off unwanted
	or	ah,dl			; combine
	mov	es:[di],ah		; write it

scl_80:	shl	h_write_plane,1		; go to new write plane

	inc	h_read_plane		; go to new read plane
	mov	al,h_read_plane		; get read plane
	cmp	al,4
	 je	scl_85
	jmp	scl_20

scl_85:	mov	ax,h_y			; get y
	inc	ax			; bump by one
	mov	h_y,ax

	pop	cx
	loop	scl_90		; loop

; Restore default VGA graphics sequencer

	mov	dx,03C4h
	mov	ax,0F02h		; again select
	out	dx,ax			; Sequence/Map Mask register 2
	pop	es
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

scl_90:	jmp	scl_10

scroll_left_d endp
;scroll_right_d
;desc:	scroll the window right
;in:	see shor above
;out:	none
;ret:	none
;notes:
;
scroll_right_d proc near
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	es
	call	scroll_setup_d
	mov	ax,h_x1			; get x coordinate
	mov	d_x,ax			; save ax
	sub	ax,h_delta		; add delta

	push	ax

	shr	ax,1
	shr	ax,1
	shr	ax,1
	mov	h_sp_b,ax		; save h_x/8

	mov	ax,d_x			; get x coordinate
	shr	ax,1
	shr	ax,1
	shr	ax,1
	mov	h_dp_b,ax		; save d_x/8

	pop	ax
	and	ax,7			; get mod 8
	mov	h_srem,al		; save it

	mov	ax,d_x			; get x coordinate
	and	ax,7			; get mod 8
	mov	h_drem,al		; save it

	mov	al,h_drem		; get source rem
	sub	al,h_srem		; sub destination rem
	mov	h_rot,al		; save it in rot

	xor	bh,bh
	mov	bl,h_drem		; get drem
	mov	al,cs:mtable1[bx]	; get mask
	mov	h_mask,al		; save it

	mov	dx,VIDEO_ADDR	; get herc buffer address
	mov	es,dx

	mov	ax,h_x			; get	x
	shr	ax,1
	shr	ax,1
	shr	ax,1
	mov	bx,h_sp_b		; subtract destination byte
	sub	bx,ax

scr_10:	mov	h_bytes,bl		; save it
	mov	cx,h_y1			; get y delta
scr_15:	push	cx			; save for later

	xor	al,al			; get read plane number
	mov	h_read_plane,al		; save it

	inc	al			; get write plane number
	mov	h_write_plane,al	; save it

scr_20:	mov	dx,3ceh			; Select Graphics Controller
	mov	al,4
	mov	ah,h_read_plane
	out	dx,ax

	mov	dx,3c4h			; Sequencer/Map Mode port address
	mov	al,2
	mov	ah,h_write_plane
	out	dx,ax

	mov	bx,h_y			; get y coordinate
	shl	bx,1
	mov	si,cs:latable[bx]	; get address
	mov	di,si
	add	si,h_sp_b		; setup source
	add	di,h_dp_b		; setup destination

	mov	al,es:[si]		; get first byte
	mov	h_byte,al		; save for later
	dec	si

	mov	bl,h_bytes

	mov	cl,h_rot		; get rot
	or	cl,cl
	 jl	scr_60			; jump if negitive

	mov	dh,es:[si]		; get first byte
	mov	dl,h_byte		; get next byte
	mov	h_byte,dh		; save for later

	shr	dx,cl			; shift left
	mov	al,h_mask		; get mask
	mov	h_mask1,al		; save for later
	and	dl,al			; mask off unwanted
	xor	al,0ffh			; invert mask
	mov	ah,es:[di]		; get destination byte
	and	ah,al			; mask off unwanted
	or	ah,dl			; combine
	mov	es:[di],ah		; save

	mov	al,0ffh			; setup new mask
	mov	h_mask1,al

scr_30:	dec	si			; bump pointers
	dec	di
	dec	bl			;
	 jz	scr_40			; jump if zero
	 jns	scr_32
	jmp	scr_80
scr_32:	mov	dh,es:[si]		; get byte
	mov	dl,h_byte		; get next byte
	mov	h_byte,dh		; save for later
	shr	dx,cl			; shift it
	mov	es:[di],dl		; save it
	jmp	scr_30

scr_40:	mov	bx,h_x			; get x coordinate
	and	bx,7			; get mod 8
	mov	al,cs:mtable[bx]	; get mask
	and	h_mask1,al

	mov	dh,es:[si]		; get byte
	mov	dl,h_byte		; get next byte
	mov	h_byte,dh		; save for later
	shr	dx,cl			; shift it
	and	dl,al			; mask off unwanted
	xor	al,0ffh			; invert mask
	mov	ah,es:[di]		; get destination
	and	ah,al			; mask off unwanted
	or	ah,dl			; combine
	mov	es:[di],ah		; write it
scr_50:	jmp	short scr_80		; all done

scr_60:	neg	cl			; make positive
	inc	si			; decrement h_bp_b
	mov	dh,es:[si]		; get first byte
	mov	dl,h_byte		; get second byte
	mov	h_byte,dh		; save for later
	shl	dx,cl			; shift it
	mov	al,h_mask		; get mask
	mov	h_mask1,al		; save for later
	and	dh,al			; mask unwanted
	xor	al,0ffh			; invert mask
	mov	ah,es:[di]		; get destination byte
	and	ah,al			; mask unwanted
	or	ah,dh			; combine
	mov	es:[di],ah		; write it
	mov	al,0ffh
	mov	h_mask1,al
scr_65:	dec	si			; bump h_sp_b
	dec	di			; bump h_dp_b
	dec	bl			; decrement
	 jz	scr_70			; jump if done
	 js	scr_80			;already zero
	mov	dh,es:[si]		; get new byte
	mov	dl,h_byte		; get next byte
	mov	h_byte,dh		; save for later
	shl	dx,cl			; shift
	mov	es:[di],dh		; write it
	jmp	scr_65			; loop

scr_70:	mov	bx,h_x1			; get x1 coordinate
	add	bx,h_delta
	and	bx,7			; get mod 8
	mov	al,cs:mtable[bx]	; get new mask
	and	h_mask1,al

	mov	dh,es:[si]		; get new byte
	mov	dl,h_byte		; get next byte
	mov	h_byte,dh		; save for later
	shl	dx,cl			; shift
	and	dh,al			; mask off unwanted
	xor	al,0ffh			; invert mask
	mov	ah,es:[di]		; get destination byte
	and	ah,al			; mask off unwanted
	or	ah,dh			; combine
	mov	es:[di],ah		; write it

scr_80:	shl	h_write_plane,1		; go to new write plane

	inc	h_read_plane		; go to new read plane
	mov	al,h_read_plane		; get read plane
	cmp	al,4
	 je	scr_85
	jmp	scr_20

scr_85:	mov	ax,h_y			; get y
	inc	ax			; bump by one
	mov	h_y,ax

	pop	cx
	loop	scr_90		; loop

; Restore default EGA graphics status
	mov	dx,03C4h
	mov	ax,0F02h		; again select
	out	dx,ax		; Sequence/Map Mask register 2
	pop	es
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

scr_90:	jmp	scr_15

scroll_right_d endp
;scroll_setup_d
;desc:	set graphics controller registers prior to scrolling
;in:	none
;out:	none
;ret:	none
;notes:	
;
scroll_setup_d	PROC	NEAR
	push	ax
	push	dx
; Set Bit Mask register

	mov	dx,3ceh			; graphics Controller port address
	mov	ax,0ff08h
	out	dx,ax			; select regester 8
	mov	ax,0005h
	out	dx,ax			; Select Mode register (5)
	mov	ax,0003h		; select overpaint mode
	out	dx,ax
	pop	dx
	pop	ax
	ret
scroll_setup_d	ENDP
;cpix_blt
;desc:	Routine to move data from system memory to frame buffer
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx,dx = lower left corner
;	ax,si = upper right corner
;	es:di->	dd pointer -> bitmap data
;	ps.CurForeClrp->foreground color
;out:	none
;ret:	
;type:	
;notes:
cpix_blt	proc	FAR
;--- Allocate temporary variables on stack
	push	bp
	mov	bp,sp
	sub	sp,32
nextrow_offset equ wo [bp-2]
total_reads equ by [bp-3] 	; only allows bitmaps to be 2048 wide
ivflg	equ by [bp-4]		; invert pattern flag
line_count equ wo [bp-6]	
pbase	equ wo [bp-8]		; pattern offset
dbase	equ wo [bp-10]		; dither offset
drow	equ wo [bp-12]		; dither row
pht	equ by [bp-13]		; pattern height
pwd	equ by [bp-14]		; pattern width
pwdb	equ by [bp-15]		; pattern width in bytes
pcol	equ wo [bp-18]		; pattern column
bpcol	equ wo [bp-20]		; beginning pattern column
bprow	equ wo [bp-22]		; beginning pattern row
vseg	equ wo [bp-24]		; video segment
lines	equ wo [bp-26]		; lines to do
p4	equ by [bp-27]		; plane 1 dither component
p3	equ by [bp-28]		; plane 2 dither component
p2	equ by [bp-29]		; plane 3 dither component
p1	equ by [bp-30]		; plane 4 dither component
prowmax	equ wo [bp-32]		; max pattern row offset

	push	ax
	push	bx
	push	cx
.cx	equ wo [bp-38]
	push	dx
	push	di
.di	equ wo [bp-42]
	push	si
.si	equ wo [bp-44]
	push	ds
	push	es
.es	equ wo [bp-48]
	
	sub	si,dx			;compute delta y
	inc	si
	mov	line_count,si

;--- Set up count for number of bytes to move per row
	sub	ax,cx			;compute delta x in ax
	inc	ax
	add	ax,7			; round
	mov	cl,3			;setup for divide by 8
	shr	ax,cl
	mov	total_reads,al		; store away number of bytes/raster

;--- Calculate amount to add to di to increment to next row
	mov	nextrow_offset,BYTROW
	sub	nextrow_offset,ax	; offset to next row

;--- Calculate byte address (seg & offset) into video buffer
	mov	di,.si			;di->top raster #
	shl	di,1			; table index in words
	mov	di,cs:latable[di]	; offset of raster of first row
	mov	ax,.cx			; get x 
	shr	ax,cl			; divide by 8 to get bytes
	add	di,ax			; add offset to di

;--- calculate amount to shift data to align with frame buffer bytes
	mov	ax,.cx			;get x
	and	ax,7			;x mod 8
	mov	cl,8
	sub	cl,al			;cl = shift count to align bitmap

;--- setup color to write with
	mov	si,ps.CurForeClrp	;get pointer to current foreground color
	cmp	[si].ColorFPp,0		;check if we have a pattern
	 je	cpx_01			; no, continue
	call	cpixpatfill		;call pixel pattern blitter
	jmp	short cpx_90

cpx_01:	cmp	[si].ColorMM,MM_TRNSPRNT;is color transparent
	 je	cpx_90			; yes, finished
	cmp	[si].ColorFlag,CLR_DITHER;check if we have a dither
	 jne	cpx_02			; no, continue with normal cpix
	call	cpixditfill		;call pixel dither blitter
	jmp	short cpx_90

cpx_02:	mov	bh,[si].ColorMM		;save color map mode
	mov	si,[si].ColorMP		;do normal cpix_blt
	mov	ch,by [si].MIdx		;get mapped color

;--- Set up Graphics Controller registers
	mov	dx,3ceh			; graphics controller port address
	mov	ax,0a05h		; AL = Mode register number
					; AX = Write Mode 2 (bits 0-1)
					;      Read Mode 1 (bit 4)
	out	dx,ax
	mov	ax,0007			; AH = Color Don't Care bits
					; AL = Color Don't Care register #
	out	dx,ax
	mov	ax,0003h		;assume overpaint mode
	cmp	bh,MM_XOR		;check if xor mode
	 jne	cpx_09			; no continue
	mov	ah,18h			;set xor mode
cpx_09:	out	dx,ax

;--- Point to video buffer and bitmap
	mov	ds,.es
assume	ds:nothing
	mov	si,.di
	lds	si,[si]			;ds:si->bitmap data
	mov	ax,VIDEO_ADDR
	mov	es,ax			; es:di = EGA/VGA buffer segment address

;--- Main bit moving loops
	cld				; increment forward through bit map
cpx_10:	xor	ax,ax			; clear masks for start of run
	xor	bx,bx
	mov	bl,total_reads
cpx_20:	lodsb				; al = pattern for next byte of pixels
	shl	ax,cl			; align pattern in ah with video byte
	or	ah,bh			; add shifted and leftover bits
	mov	bh,al			; store leftover bits
	 jz	cpx_30			; if byte is 0's then skip writing
	mov	al,8
	out	dx,ax			; update Bit Mask register
	and	es:[di],ch		; write foreground pixels to video buf
	xor	ax,ax			; clear out last byte written
cpx_30:	inc	di			; increment buffer pointer
	dec	bl			; decrement byte counter
	 jz	cpx_40			; jump out if finished with row
	jmp	cpx_20			; do next byte

cpx_40:	mov	ah,bh			; put leftovers (if any) in ax
	or	ah,ah			; check to see if any bits to write
	 jz	cpx_50
	mov	al,8
	out	dx,ax			; write mask register
	and	es:[di],ch		; write leftover bits
cpx_50:	dec	line_count		; decrement line counter
	 jz	cpx_90			; jump out if done
	add	di,nextrow_offset	; inc to next line in video buffer
	jmp	cpx_10

;--- Restore Graphics Controller defaults
cpx_90:	mov	dx,3ceh			; graphics controller I/O port
	mov	ax,0f07h		; default Color Don't Care
	out	dx,ax
	mov	ax,0ff08h		;reset bit mask
	out	dx,ax
	mov	ax,0005h		;reset read/write mode
	out	dx,ax			;	\
cpx_99:	pop	es
	pop	ds
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
cpix_blt endp
;cpixpatfill
;desc:	Routine to do char blitting with patterns.
;in:	cl - shift count to align bitmap.
;	si - ps.CurForeClrp
;	di - points to char location in video buffer
;out:
;ret:	
;notes:	This routine will also handle dithered patterns.
;
;	**** This routine uses stack variables from cpix_blt ****
;	**** DON'T change bp ****

cpixpatfill	proc	near
assume	ds:psseg
	mov	bx,[si].ColorFPp	;point at fill pattern
	lea	ax,[bx].FPData		;get offset of pattern data
	mov	pbase,ax		;save offset of pattern data

	mov	dh,[bx].FPWidth		;get pattern width
	mov	pwd,dh			;save pattern width
	mov	ax,.cx			;get x position of char
	div	dh			;divide by pattern width
	shr	ah,1			;div ah by 8
	shr	ah,1
	shr	ah,1
	mov	al,ah			;change ah to word
	xor	ah,ah
	mov	bpcol,ax		;save beginning pattern column

	mov	dh,[bx].FPHeight	;get pattern height
	mov	pht,dh			;save pattern height
	mov	ax,.si			;get y position
	div	dh			;divide by height
	sub	ah,dh			;flip since pattern upside down
	inc	ah
	neg	ah
	mov	al,ah			;mov row to al
	mov	dh,[bx].FPWidthB	;get patterh width in bytes
	mov	pwdb,dh			;save pattern width in bytes
	mul	dh			;multiply by pattern width in bytes
	mov	bprow,ax		;save beginning pattern row offset

	mov	al,pht			;get pattern height
	mul	dh			;multiply by pattern width
	mov	prowmax,ax		;save pattern row offset max

	mov	ax,VIDEO_ADDR
	mov	vseg,ax			;save video segment

	mov	ivflg,0			;start with foreground

cpf_05:	push	ds			;preserve ds:si
	push	si
	push	di
	mov	ax,line_count		;get lines to do for this pass
	mov	lines,ax

	mov	dx,3ceh			;load dx with graphics contoroller

	cmp	[si].ColorMM,MM_TRNSPRNT;is this color transparent?
	 jne	cpf_06			; no, draw this color
	jmp	cpf_90			; yes, next color

cpf_06:	cmp	[si].ColorFlag,CLR_DITHER; is this color dithered?
	 jne	cpf_07			; no, draw solid color
	jmp	cpf_50			; yes, draw dithered color

cpf_07:	mov	bh,[si].ColorMM		;save color map mode
	mov	si,[si].ColorMP		;get color map pointer
	mov	ch,BY [si].MIdx		;get mapped index
	 
;--- Set up Graphics Controller registers
	mov	ax,0a05h		; AL = Mode register number
					; AX = Write Mode 2 (bits 0-1)
					;      Read Mode 1 (bit 4)
	out	dx,ax
	mov	ax,0007			; AH = Color Don't Care bits
					; AL = Color Don't Care register #
	out	dx,ax
	mov	ax,0003h		;assume overpaint mode
	cmp	bh,MM_XOR		;check if xor mode
	 jne	cpf_10			; no continue
	mov	ah,18h			;set xor mode
cpf_10:	out	dx,ax
	
;--- Point to video buffer and bitmap
	mov	ds,.es
assume	ds:nothing
	mov	si,.di
	lds	si,[si]			;ds:si->bitmap data

	mov	ax,bprow		;get beginning pattern row

cpf_20:	push	ax			;preserve pattern row
	mov	bx,ax			;get offset into pattern
	mov	ax,bpcol		;get beginning pattern column
	mov	pcol,ax			;save pattern column
	add	bx,ax			;get byte offset into pattern
	add	bx,pbase		;add offset of pattern base

;--- Main bit moving loops
	cld				; increment forward through bit map
	xor	ax,ax			; clear masks for start of run
	xor	dx,dx
	mov	dl,total_reads
cpf_30:	lodsb				; al = pattern for next byte of pixels
	shl	ax,cl			; align pattern in ah with video byte
	or	ah,dh			; add shifted and leftover bits
	mov	dh,al			; store leftover bits
	 jz	cpf_35			; if byte is 0's then skip writing
	mov	es,.ds		      	; get segment of psseg
	mov	al,es:[bx]		; get pattern byte
	cmp	ivflg,0			; check if doing background
	 je	cpf_31			; no, skip invert
	not	al			; yes, invert pattern
cpf_31:	and	ah,al			; and in pattern
	 jz	cpf_35			; skip if zero
	mov	al,8
	push	dx			; save dx
	mov	dx,3ceh			; load graphics controller
	out	dx,ax			; update Bit Mask register
	mov	es,vseg			; get video segment
	and	es:[di],ch		; write foreground pixels to video buf
					; 'and' loads latches and writes data
	pop	dx			; restore dx
cpf_35:	inc	pcol			; incerment pattern column
	inc	bx			; increment pattern pointer
	mov	ax,pcol			; get pattern column
	cmp	al,pwdb			; wrap pattern?
	 jl	cpf_36			; no, skip
	xor	ax,ax			; start at first column
	mov	pcol,ax
	sub	bl,pwdb			; wrap pattern pointer
	sbb	bh,0			; sub 1 from bh if carry
cpf_36:	inc	di			; increment buffer pointer
	xor	ax,ax			; clear out last byte written
	dec	dl			; decrement byte counter
	 jz	cpf_40			; jump out if finished with row
	jmp	cpf_30			; do next byte

cpf_40:	mov	ah,dh			; put leftovers (if any) in ax
	or	ah,ah			; check to see if any bits to write
	 jz	cpf_45
	mov	es,.ds		      	; get psseg
	mov	al,es:[bx]		; get pattern byte
	cmp	ivflg,0			; doing background?
	 je	cpf_41			; no, skip invert
	not	al			; yes, invert pattern
cpf_41:	and	ah,al			; and pattern byte with char
	mov	al,8
	push	dx			; save dx
	mov	dx,3ceh			; load graphics controller
	out	dx,ax			; write mask register
	mov	es,vseg			; get video segment
	and	es:[di],ch		; write leftover bits
	pop	dx			; restore dx
cpf_45:	pop	ax			; restore pattern row
	dec	lines			; decrement line counter
	 jz	cpf_49			; jump out if done
	add	di,nextrow_offset	; inc to next line in video buffer
	add	al,pwdb			; decrement row offset
	adc	ah,0
	cmp	ax,prowmax		; check against max pattern offset
	 jl	cpf_47			; check if wrapping pattern row
	sub	ax,prowmax		; start at beginning
cpf_47:	jmp	cpf_20

cpf_49:	jmp	cpf_90

cpf_50:	mov	ax,.si			;get beginning row
	and	ax,07			;get beginning dither row
	xor	ax,07			;flip dither
	mov	drow,ax			;save dither row offset

	mov	bx,[si].ColorMp		;get color map pointer
	mov	dbase,bx		;save dither base

	mov	ax,0005			;write mode 0 into mode select
	out	dx,ax			;
	mov	ax,0003h		;assume overpaint mode
	cmp	[si].ColorMM,MM_XOR	;XOR mix mode?
	 jne	cpf_55			; no
	mov	ah,18h			; yes, select XOR mode
cpf_55:	out	dx,ax			;
	mov	ax,0001h		;disable set/reset mode
	out	dx,ax			;

;--- Point to video buffer and bitmap
	mov	ds,.es
assume	ds:nothing
	mov	si,.di
	lds	si,[si]			;ds:si->bitmap data

	mov	ax,bprow		;get beginning pattern row

cpf_60:	push	ax			;preserve pattern row
	mov	bx,dbase		;get dither base
	add	bx,drow			;get offset of dither row

	mov	es,.ds			;get psseg
	mov	dl,es:[bx]		;get plane data of dither
	mov	p1,dl			;save plane data for this raster
	mov	dl,es:[bx+8]
	mov	p2,dl
	mov	dl,es:[bx+16]
	mov	p3,dl
	mov	dl,es:[bx+24]
	mov	p4,dl

	mov	bx,ax			;get pattern row
	mov	ax,bpcol		;get beginning pattern column
	mov	pcol,ax			;save pattern column
	add	bx,ax			;add to pattern row offset
	add	bx,pbase		;add to pattern base

;--- main routine
	cld				; increment forward through bit map
	xor	ax,ax			; clear masks for start of run
	xor	dx,dx
	mov	dl,total_reads
cpf_65:	lodsb				; al = pattern for next byte of pixels
	shl	ax,cl			; align pattern in ah with video byte
	or	ah,dh			; add shifted and leftover bits
	mov	dh,al			; store leftover bits
	 jz	cpf_70			; if byte is 0's then skip writing
	mov	es,.ds		      	; get segment of psseg
	mov	al,es:[bx]		; get pattern byte
	cmp	ivflg,0			; check if doing background
	 je	cpf_67			; no, skip invert
	not	al			; yes, invert pattern
cpf_67:	and	ah,al			; and in pattern
	 jz	cpf_70			; skip if zero

	mov	al,8
	push	dx			; save dx
	mov	dx,3ceh			; load graphics controller
	out	dx,ax			; update Bit Mask register

	mov	dx,3c4h			; load sequencer register
	mov	al,02			; plane mask index
	out	dx,al			; set index to plane mask
	mov	al,8			; start with plane 1
	inc	dx			; data regiseter
	mov	es,vseg			; get video segment

	mov	ah,es:[di]		; latch data
	push	si			; preserve char pointer
	lea	si,p1			; get offset of p1

cpf_69:	out	dx,al			; set plane to write
	mov	ah,ss:[si]		; get plane dither data
	mov	es:[di],ah		; write foreground pixels to video buf
	inc	si			; next plane dither
	shr	al,1			; next plane
	 jnz	cpf_69			; loop till all planes written

	pop	si			; restore char pointer
	pop	dx			; restore dx 
cpf_70:	inc	pcol			; incerment pattern column
	inc	bx			; increment pattern pointer
	mov	ax,pcol			; get pattern column
	cmp	al,pwdb			; wrap pattern?
	 jl	cpf_75			; no, skip
	xor	ax,ax			; start at first column
	mov	pcol,ax
	sub	bl,pwdb			; wrap pattern pointer
	sbb	bh,0			; sub 1 from bh if carry
cpf_75:	inc	di			; increment buffer pointer
	xor	ax,ax			; clear out last byte written
	dec	dl			; decrement byte counter
	 jz	cpf_80			; jump out if finished with row
	jmp	cpf_65			; do next byte

cpf_80:	mov	ah,dh			; put leftovers (if any) in ax
	or	ah,ah			; check to see if any bits to write
	 jz	cpf_85
	mov	es,.ds		      	; get psseg
	mov	al,es:[bx]		; get pattern byte
	cmp	ivflg,0			; doing background?
	 je	cpf_81			; no, skip invert
	not	al			; yes, invert pattern
cpf_81:	and	ah,al			; and pattern byte with char

	mov	al,8
	push	dx			; save dx
	mov	dx,3ceh			; load graphics controller
	out	dx,ax			; write mask register

	mov	dx,3c4h			; load sequencer register
	mov	al,02			; plane mask index
	out	dx,al			; set index to plane mask
	mov	al,8			; start with plane 1
	inc	dx			; point at data register

	mov	es,vseg			; get video segment

	mov	ah,es:[di]		; latch data
	push	si			; preserve char pointer
	lea	si,p1			; get offset of p1

cpf_83:	out	dx,al			; set plane to write
	mov	ah,ss:[si]		; get plane dither data
	mov	es:[di],ah		; write foreground pixels to video buf
	inc	si			; next plane dither
	shr	al,1			; next plane
	 jnz	cpf_83			; loop till all planes written

	pop	si			; restore char pointer
	pop	dx			; restore dx
cpf_85:	pop	ax			; restore pattern row
	dec	lines			; decrement line counter
	 jz	cpf_90			; jump out if done
	inc	drow			; increment dither row
	and	drow,7			; clip drow
	add	di,nextrow_offset	; inc to next line in video buffer
	add	al,pwdb			; decrement row offset
	adc	ah,0
	cmp	ax,prowmax		; check against max row offset
	 jl	cpf_87			; check if wrapping pattern row
	xor	ax,ax			; start at beginning
cpf_87:	jmp	cpf_60

cpf_90:	pop	di			;restore ds(psseg):si
	pop	si
	pop	ds
assume	ds:psseg
	cmp	si,ps.CurForeClrp	;are we doing foreground color?
	 jne	cpf_99			; no, finished
	mov	si,ps.CurBackClrp	;point at background color
	inc	ivflg			;set invert flag
	jmp	cpf_05			;do again

;--- Restore Graphics Controller defaults
cpf_99:	mov	dx,03c4h		; reset sequencer mask to all planes
	mov	ax,0f02h		; default Map Mask value
	out	dx,ax			;
	mov	dx,3ceh			; graphics controller
	mov	ax,0f07h		; default Color Don't Care
	out	dx,ax
	mov	ax,0ff08h		;reset bit mask
	out	dx,ax
	mov	ax,0005h		;reset read/write mode
	out	dx,ax			;	\
	ret
cpixpatfill	endp
;cpixditfill
;desc:	Routine to do char blitting with dithered foreground.
;in:	cl - shift count to align bitmap.
;	si - ps.CurForeClrp
;	di - points to char location in video buffer
;out:
;ret:	
;notes:
;
;	**** This routine uses stack variables from cpix_blt ****
;	**** DON'T change bp

cpixditfill	proc	near
assume	ds:psseg
	mov	bx,[si].ColorMp		;get color map pointer
	mov	dbase,bx		;save dither base

	mov	dx,3ceh			;load dx with graphics contoroller
	mov	ax,0005			;write mode 0 into mode select
	out	dx,ax			;
	mov	ax,0003h		;assume overpaint mode
	cmp	[si].ColorMM,MM_XOR	;XOR mix mode?
	 jne	cdf_05			; no
	mov	ah,18h			; yes, select XOR mode
cdf_05:	out	dx,ax			;
	mov	ax,0001h		;disable set/reset mode
	out	dx,ax			;

;--- Point to video buffer and bitmap
	mov	ds,.es
assume	ds:nothing
	mov	si,.di
	lds	si,[si]			;ds:si->bitmap data

	mov	ax,VIDEO_ADDR
	mov	vseg,ax			;save video segment

	mov	ax,.si			;get y
	and	ax,7			;get drow
	xor	ax,07			;flip dither

cdf_10:	push	ax			;save dither row
	mov	bx,dbase		;get dither base
	add	bx,ax			;get offset of dither row

	mov	es,.ds			;point at psseg
	mov	dl,es:[bx]		;get plane data of dither
	mov	p1,dl			;save plane data for this raster
	mov	dl,es:[bx+8]
	mov	p2,dl
	mov	dl,es:[bx+16]
	mov	p3,dl
	mov	dl,es:[bx+24]
	mov	p4,dl

;--- main routine
	mov	es,vseg			; point at video memory
	cld				; increment forward through bit map
	xor	ax,ax			; clear masks for start of run
	xor	dx,dx
	mov	dl,total_reads
cdf_15:	lodsb				; al = pattern for next byte of pixels
	shl	ax,cl			; align pattern in ah with video byte
	or	ah,dh			; add shifted and leftover bits
	mov	dh,al			; store leftover bits
	 jz	cdf_25			; if byte is 0's then skip writing

	mov	al,8
	push	dx			; save dx
	mov	dx,3ceh			; load graphics controller
	out	dx,ax			; update Bit Mask register

	mov	dx,3c4h			; load sequencer register
	mov	al,02			; plane mask index
	out	dx,al			; set index to plane mask
	mov	al,8			; start with plane 1
	inc	dx			; data regiseter

	mov	ah,es:[di]		; latch data
	push	si			; preserve char pointer
	lea	si,p1			; get offset of p1

cdf_20:	out	dx,al			; set plane to write
	mov	ah,ss:[si]		; get plane dither data
	mov	es:[di],ah		; write foreground pixels to video buf
	inc	si			; next plane dither
	shr	al,1			; next plane
	 jnz	cdf_20			; loop till all planes written

	pop	si			; restore char pointer
	pop	dx			; restore dx 
cdf_25:	inc	di			; increment buffer pointer
	xor	ax,ax			; clear out last byte written
	dec	dl			; decrement byte counter
	 jz	cdf_30			; jump out if finished with row
	jmp	cdf_15			; do next byte

cdf_30:	mov	ah,dh			; put leftovers (if any) in ax
	or	ah,ah			; check to see if any bits to write
	 jz	cdf_40

	mov	al,8
	push	dx			; save dx
	mov	dx,3ceh			; load graphics controller
	out	dx,ax			; write mask register

	mov	dx,3c4h			; load sequencer register
	mov	al,02			; plane mask index
	out	dx,al			; set index to plane mask
	mov	al,8			; start with plane 1
	inc	dx			; point at data register

	mov	ah,es:[di]		; latch data
	push	si			; preserve char pointer
	lea	si,p1			; get offset of p1

cdf_35:	out	dx,al			; set plane to write
	mov	ah,ss:[si]		; get plane dither data
	mov	es:[di],ah		; write foreground pixels to video buf
	inc	si			; next plane dither
	shr	al,1			; next plane
	 jnz	cdf_35			; loop till all planes written

	pop	si			; restore char pointer
	pop	dx			; restore dx
cdf_40:	pop	ax			; restore dither row
	dec	line_count		; decrement line counter
	 jz	cdf_90			; jump out if done
	inc	ax			; increment dither row
	and	ax,7			; clip drow
	add	di,nextrow_offset	; inc to next line in video buffer
	jmp	cdf_10

cdf_90:	mov	dx,03c4h		; reset sequencer mask to all planes
	mov	ax,0f02h		; default Map Mask value
	out	dx,ax			;
	mov	dx,3ceh			; graphics controller
	mov	ax,0f07h		; default Color Don't Care
	out	dx,ax
	mov	ax,0ff08h		;reset bit mask
	out	dx,ax
	ret
cpixditfill	endp
assume	ds:psseg
;gcur_size
;desc:	Routine to return the amount of memory needed to save a graphics cursor.
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx = cursor width
;	dx = cursor height
;out:	cx = number of bytes needed for cursor definition
;	dx = number of bytes needed for cursor save area
;ret:	
;notes:	This routine has been updated to allow for cursors of any width and
;	any height.  It assumes that any cursor which has a width that is not
;	evenly divisable by eight will have its bitmap data padded with zeros
;	on the right side to always use an even number of bytes per raster.

gcur_size PROC FAR
	push	ax
	push	bx
	mov	ax,cx			;get cursor width
	add	ax,7			;round up if necessary
	mov	cl,3
	shr	ax,cl			;AX = width / 8
	inc	ax			;account for possible extra byte
	mul	dx			;multiply by cursor height
	mov	dx,ax			;save size of one plane of one cursor
	shl	ax,1			;allow for mask and data
	shl	ax,cl			;AX = bytes needed for 8 cursors
	shl	dx,1			;multiply by four planes of data
	shl	dx,1
	mov	cx,ax
	clc				;clear carry flag
	pop	bx
	pop	ax
	ret				;return far
gcur_size ENDP
;gcur_init
;desc:	Routine to build a graphics cursor in memory.
;in:	ds = presentation space segment
;	bx = presentation space handle
;	es:si->dd->	dw	width
;			dw	height
;			dw	delta x for hotspot
;			dw	delta y for hotspot
;			db(dup?)	cursor mask
;			db(dup?)	cursor data
;	dx:cx->dd->	memory in which to build graphics cursor
;out:
;ret:	
;notes:	This routine has been updated to allow for cursors of any width and
;	any height.  It assumes that any cursor which has a width that is not
;	evenly divisable by eight will have its bitmap data padded with zeros
;	on the right side to always use an even number of bytes per raster.

gcur_init PROC FAR
	push	bp
	mov	bp,sp
	sub	sp,4
BitmapWidth equ wo [bp-2]
BitmapHeight equ wo [bp-4]

	push	ax
	push	cx
	push	dx
	push	si
	push	di
	push	ds
	
	mov	di,cx
	mov	ds,dx
	lds	di,[di]			;ds:di->memory in which to build cursor
	les	si,es:[si]		;es:si->cursor definition

	mov	ax,es:[si]		;get cursor width
	add	ax,7			;round up if necessary
	shr	ax,1			;AX = width / 2
	shr	ax,1			;AX = width / 4
	shr	ax,1			;AX = width / 8
	mov	BitmapWidth,ax		;save bitmap width in bytes
	inc	ax			;allow for an extra byte
	mov	bx,es:[si+2]		;get cursor height
	mov	BitmapHeight,bx		;save bitmap height in rasters
	mul	bx			;compute number of bytes
	shl	ax,1			;allow for mask and data
	mov	cx,ax			;save result in CX
	xor	al,al			;zero out AL
	shl	cx,1			;CX = bytes needed for 2 cursors
	shl	cx,1			;CX = bytes needed for 4 cursors
	shl	cx,1			;CX = bytes needed for 8 cursors
	push	di			;save target buffer pointer

gi1:	mov	ds:[di],al		;store a 0
	inc	di			;increment buffer pointer
	loop	gi1			;zero the next byte

	pop	di			;restore buffer pointer
	mov	cx,8			;prepare to define 8 cursors
	add	si,cx			;ES:SI -> cursor bitmap data
	xor	dl,dl			;zero out shift counter

gi2:	push	cx			;save definition counter
	push	si			;save bitmap pointer
	mov	cx,BitmapHeight		;set up bitmap height
	shl	cx,1			;allow for mask and data

gi3:	push	cx			;save raster counter
	mov	cx,BitmapWidth		;set up bitmap width

gi4:	push	cx			;save byte counter
	mov	cl,dl			;get shift counter
	mov	al,es:[si]		;get 1 byte from bitmap data
	xor	ah,ah			;zero out high byte
	ror	ax,cl			;rotate data into position
	or	ds:[di],ax		;turn on the 1 bits
	inc	si			;increment bitmap pointer
	inc	di			;increment buffer pointer
	pop	cx			;restore byte counter
	loop	gi4			;do the next byte

	inc	di			;increment buffer pointer
	pop	cx			;restore raster counter
	loop	gi3			;do the next raster

	inc	dl			;increment shift value
	pop	si			;restore bitmap pointer
	pop	cx			;restore definition counter
	loop	gi2			;do the next definition

	clc				;clear carry flag
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	ax
	mov	sp,bp
	pop	bp
	ret				;return far

gcur_init ENDP
;gcur_erase
;desc:	Routine to erase a graphics cursor.
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx	=	x coordinate to erase cursor
;	dx	=	y coordinate to erase cursor
;	di->		dw	cursor definition segment
;			dw	cursor definition offset
;			dw	segment id
;			dw	width
;			dw	height
;			dw	hotspot delta x
;			dw	hotspot delta y
;	es:si	->	cursor save buffer
;out:	none
;ret:	
;notes:	This routine has been updated to allow for cursors of any width and
;	any height.  It assumes that any cursor which has a width that is not
;	evenly divisable by eight will have its bitmap data padded with zeros
;	on the right side to always use an even number of bytes per raster.
;
;	NO memory allocation may be done in this routine!

gcur_erase PROC FAR
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	ds
	push	es
	call	wait_begin_vretrace	;wait for vertical retrace to begin
	sub	cx,ds:[di+10]		;subtract hotspot delta X from X
	mov	ax,cx			;save X coordinate in AX
	add	dx,ds:[di+12]		;add hotspot delta Y to Y
	mov	bx,dx			;save Y coordinate in BX
	mov	cx,ds:[di+6]		;get cursor width
	add	cx,7			;round up if necessary
	shr	cx,1			;CX = width / 2
	shr	cx,1			;CX = width / 4
	shr	cx,1			;CX = width / 5
	inc	cx			;allow for an extra byte
	mov	dx,ds:[di+8]		;get cursor height
	cmp	ax,0			;X coordinate too small?
	 jge	ge1			;jump if not
	mov	ax,0			;force it to 0

ge1:	cmp	bx,cs:max_y		;Y coordinate too big?
	jle	ge2			;jump if not
	mov	bx,cs:max_y		;force it to max_y

ge2:	mov	di,si			;ES:DI -> screen data buffer
	call	RestoreScreen		;restore the screen data

	clc
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret				;return far
gcur_erase	endp

RestoreScreen PROC NEAR

	shl	bx,1			;BX = Y * 2
	mov	si,cs:latable[bx]	;SI -> target screen raster
	shr	ax,1			;AX = X / 2
	shr	ax,1			;AX = X / 4
	shr	ax,1			;AX = X / 8
	add	si,ax			;SI -> target screen byte
	xchg	si,di			;exchange SI and DI
	mov	bx,VIDEO_ADDR		;get video segment address
	mov	ax,es			;get ES
	mov	ds,ax			;DS:SI -> screen data buffer
	mov	es,bx			;ES:DI -> frame buffer
	mov	bx,dx			;put bitmap height in BX

	mov	dx,03CEh		;DX = graphics controller port address
	mov	ax,0005			;AL = graphics mode register number
	out	dx,ax			;select write mode 0
	mov	ax,0003h		;AL = function select register
	out	dx,ax			;select overpaint function
	mov	ax,0001h		;AL = enable set/reset register
	out	dx,ax			;select byte-by-byte update
	mov	ax,0FF08h		;AL = bit mask register
	out	dx,ax			;select 8-bit bit mask
	mov	dx,03C4h		;DX = sequencer port address
	mov	ax,0802h		;AL = map mask register number

rs1:	out	dx,ax			;select memory map to write
	push	ax			;save memory map number
	push	bx			;save raster counter
	push	di			;save frame buffer offset

rs2:	push	cx			;save bytes-per-row counter
	push	di			;save raster offset
	rep	movsb			;display a raster
	pop	di			;restore raster address
	pop	cx			;restore bytes-per-row counter
	add	di,80			;SI = offset of next raster
	dec	bx			;decrement raster counter
	jnz	rs2			;loop back if counter > 0

	pop	di			;restore frame buffer offset
	pop	bx			;restore raster counter
	pop	ax			;restore memory map number
	shr	ah,1			;shift to next bitplane
	jnz	rs1			;loop back if plane number > 0

	mov	ax,0F02h		;AL = map mask register number
	out	dx,ax			;select default map mask
	mov	dx,03CEh		;DX = graphics controller port address

	mov	ax,0F07h		;AL = color compare register
	out	dx,ax			;select default

	ret				;return near

RestoreScreen ENDP
;gcur_write
;desc:	Routine to write a graphics cursor.
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx	=	x coordinate to write cursor
;	dx	=	y coordinate to write cursor
;	di->		dw	cursor definition segment
;			dw	cursor definition offset
;			dw	segment id
;			dw	width
;			dw	height
;			dw	hotspot delta x
;			dw	hotspot delta y
;			dw	cursor save area pid (if multiple active cursors)
;			dw	current x position of cursor
;			dw	current y position of cursor
;			dw	current left side of cursor bounding box
;			dw	current bottom side of cursor bounding box
;			dw	current right side of cursor bounding box
;			dw	current top side of cursor bounding box
;			db	cursor flag
;	es:si	->	cursor save buffer
;	ps.CrForeClrp->cursor foreground color
;	ps.CrBackClrp->cursor background color
;out:	
;ret:	
;notes:	This routine has been updated to allow for cursors of any width and
;	any height.  It assumes that any cursor which has a width that is not
;	evenly divisable by eight will have its bitmap data padded with zeros
;	on the right side to always use an even number of bytes per raster.
;
;	NO memory allocation may be done in this routine!

gcur_write PROC FAR
	push	bp
	mov	bp,sp
	sub	sp,18
CursFClr	equ by [bp-2]
CursBClr	equ by [bp-1]
CursSeg		equ wo [bp-4]
CursOff		equ wo [bp-6]
CursX		equ wo [bp-8]
CursY		equ wo [bp-10]
CursWidth	equ wo [bp-12]
CursHeight	equ wo [bp-14]
SkipX		equ wo [bp-16]
RastAddr	equ wo [bp-18]

	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	ds
	push	es

	mov	bx,ps.CrForeClrp	;get pointer to cursor foreground color
	mov	bx,[bx].ColorMP
	mov	al,by [bx].MIdx
	mov	CursFClr,al		;save it
	mov	bx,ps.CrBackClrp	;get pointer to cursor foreground color
	mov	bx,[bx].ColorMP
	mov	al,by [bx].MIdx		;get background color
	mov	CursBClr,al		;save it
	mov	ax,ds:[di]		;get cursor segment
	mov	CursSeg,ax		;save it
	mov	ax,ds:[di+2]		;get cursor offset
	mov	CursOff,ax		;save it
	sub	cx,ds:[di+10]		;subtract hotspot delta X from X
	mov	CursX,cx		;save X coordinate
	mov	ax,cx			;save X coordinate in AX
	add	dx,ds:[di+12]		;add hotspot delta Y to Y
	mov	CursY,dx		;save Y coordinate
	mov	bx,dx			;save Y coordinate in BX
	mov	cx,ds:[di+6]		;get cursor width in pixels
	add	cx,7			;round up if necessary
	shr	cx,1			;CX = width / 2
	shr	cx,1			;CX = width / 4
	shr	cx,1			;CX = width / 8
	inc	cx			;get cursor width in bytes
	mov	CursWidth,cx		;save it
	mov	dx,ds:[di+8]		;get cursor height in rasters
	mov	CursHeight,dx	;save it
	cmp	ax,0			;X coordinate too small?
	jge	gw1			;jump if not
	mov	ax,0			;force it to 0

gw1:	cmp	bx,cs:max_y		;Y coordinate too big?
	jle	gw2			;jump if not
	mov	bx,cs:max_y		;force it to max_y

gw2:	push	ax			;save left side of box
	mov	ds:[di+20],ax		;store left side of box
	add	ax,ds:[di+6]		;calc right side of box
	mov	ds:[di+24],ax		;store right side of box
	pop	ax			;restore left side of box

	push	bx			;save top of box
	mov	ds:[di+26],bx		;store top of box
	add	bx,CursHeight		;calc bottom of box
	mov	ds:[di+22],bx		;store bottom of box
	pop	bx			;restore bottom of box

	mov	di,si			;ES:DI -> screen data buffer
	call	SaveScreen		;save the screen data

	mov	ds,CursSeg		;get cursor segment
	mov	si,CursOff		;get cursor offset
	mov	ax,CursWidth		;get cursor width
	mov	bx,CursHeight		;get cursor height
	mul	bx			;get offset of cursor data
	push	ax			;save result
	shl	ax,1			;get offset of next cursor
	mov	cx,CursX		;get X coordinate
	and	cx,7			;get pixel position

gw3:	jcxz	gw4			;jump if CX is 0
	add	si,ax			;point to next cursor
	dec	cx			;decrement pixel position
	jmp	short gw3		;loop around

gw4:	mov	ax,VIDEO_ADDR		;get video segment address
	mov	es,ax			;ES -> frame buffer
	mov	bx,CursY		;get Y coordinate

gw5:	cmp	bx,cs:max_y		;Y out of bounds?
	jbe	gw6			;jump if not
	dec	bx			;decrement Y coordinate
	dec	CursHeight		;decrement cursor height
	add	si,CursWidth		;adjust source pointer
	jmp	short gw5		;loop back

gw6:	shl	bx,1			;get raster table offset
	mov	di,cs:latable[bx]	;ES:DI -> target raster
	mov	RastAddr,di		;save raster address
	add	RastAddr,80		;get raster limit in X
	mov	SkipX,0			;zero skip-byte counter
	mov	ax,CursX		;get X coordinate

gw7:	or	ax,ax			;X out of bounds?
	 jge	gw8			;jump if not
	add	ax,8			;adjust X
	inc	SkipX			;increment skip-byte counter
	jmp	short gw7		;loop back

gw8:	shr	ax,1			;AX = X / 2
	shr	ax,1			;AX = X / 4
	shr	ax,1			;AX = X / 8
	add	di,ax			;ES:DI -> target screen byte
	pop	bx			;BX = cursor data offset

	mov	dx,03CEh		;get controller port address
	mov	ax,0003h		;select register 3
	out	dx,ax			;set replace mode
	mov	ax,0A05h		;select register 5
	out	dx,ax			;set write mode 2, read mode 1
	mov	ax,0007h		;select register 7
	out	dx,ax			;set color don't care bits to 0
	mov	cx,CursHeight		;set up raster counter

gw9:	push	cx			;save raster counter
	push	di			;save screen pointer
	mov	cx,CursWidth		;set up byte counter
	mov	ax,SkipX		;get skip-byte counter
	cmp	ax,0			;is it 0?
	je	gwA			;jump if so
	add	si,ax			;increase source pointer
	sub	cx,ax			;decrease byte counter

gwA:	push	cx			;save byte counter
	cmp	di,RastAddr		;screen pointer out of bounds?
	jae	gwB			;jump if so
	mov	ch,CursFClr		;get foreground color
	mov	cl,CursBClr		;get background color
	mov	al,8			;select register 8
	mov	ah,ds:[si]		;get mask byte
	and	ah,ds:[si+bx]		;mix in data byte
	out	dx,ax			;set mask register
	and	es:[di],ch		;display foreground pixels
	mov	ah,ds:[si+bx]		;get data byte
	not	ah			;invert bits
	and	ah,ds:[si]		;mix in mask byte
	out	dx,ax			;set mask register
	and	es:[di],cl		;display background pixels

gwB:	inc	si			;increment buffer pointer
	inc	di			;increment screen pointer
	pop	cx			;restore byte counter
	loop	gwA			;loop around

	pop	di			;restore screen pointer
	add	di,80			;point to next raster
	add	RastAddr,80		;adjust raster limit in X
	pop	cx			;restore raster counter
	loop	gw9			;loop around

	mov	ax,0005h		;select register 5
	out	dx,ax			;set up default write mode
	mov	ax,0F07h		;select register 7
	out	dx,ax			;set up default color don't care
	mov	ax,0ff08h		;reset bit mask
	out	dx,ax

	clc
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
gcur_write ENDP

SaveScreen PROC NEAR

	shl	bx,1			;BX = Y * 2
	mov	si,cs:latable[bx]	;SI -> target screen raster
	shr	ax,1			;AX = X / 2
	shr	ax,1			;AX = X / 4
	shr	ax,1			;AX = X / 8
	add	si,ax			;SI -> target screen byte
	mov	ax,VIDEO_ADDR		;get video segment address
	mov	ds,ax			;DS:SI -> frame buffer byte
	mov	bx,dx			;put bitmap height in BX

	mov	dx,03CEh		;DX = graphics controller port address
	mov	ax,0005			;AL = graphics mode register number
	out	dx,ax			;select write mode 0
	mov	ax,0304h		;AL = read map select register number

ss1:	out	dx,ax			;select memory map to read
	push	ax			;save memory map number
	push	bx			;save raster counter
	push	si			;save frame buffer offset

ss2:	push	cx			;save bytes-per-row counter
	push	si			;save raster offset
	rep	movsb			;save a raster
	pop	si			;restore raster address
	pop	cx			;restore bytes-per-row counter
	add	si,80			;SI = offset of next raster
	dec	bx			;decrement raster counter
	jnz	ss2			;loop back if counter > 0

	pop	si			;restore frame buffer offset
	pop	bx			;restore raster counter
	pop	ax			;restore memory map number
	dec	ah			;decrement read bitplane number
	jge	ss1			;loop back if plane number >= 0

	mov	ax,0005			;AL = graphics mode register number
	out	dx,ax			;select write mode 0
	ret				;return near

SaveScreen ENDP
;size_bitblk
;desc:	determines and returns the number of bytes required to save a bitmap
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx,dx -> x1,Y1 point (lower left corner of bitmap)
;	ax,si -> x2,Y2 coordinate (upper right corner of bitmap)
;out:	dx:cx = size of memory block to save bitmap in bytes
;ret:
;notes:	This routine assumes that the width of all bitmaps will be evenly
;	divisable by eight.

size_bitblk PROC FAR
	push	ax
	push	bx
	push	si
	mov	bx,cx
	mov	cl,3
	shr	bx,cl			;calc starting byte
	shr	ax,cl			;calc ending byte
	sub	ax,bx			;calc number of bytes needed per raster
	inc	ax
	sub	si,dx			;calc number of rasters
	inc	si
	mul	si			;calc total bytes necessary
	shl	ax,1			;shift high bit into carry
	rcl	dx,1			;DX:AX = result * 2
	shl	ax,1			;shift high bit into carry
	rcl	dx,1			;DX:AX = result * 4
	add	ax,size BoundRect*2	;get enough for coordinates 
	adc	dx,0
	mov	cx,ax			;DX:CX = bytes needed
	pop	si
	pop	bx
	pop	ax
	ret				;
size_bitblk ENDP
;save_bitblk
;desc:	saves a bitmap from video RAM to system RAM
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx,dx -> x1,Y1 point (lower left corner of bitmap)
;	ax,si -> x2,Y2 coordinate (upper right corner of bitmap)
;	es:di ->dd->buffer in system RAM
;out:
;ret:	none
;notes:	This routine assumes that all bitmaps are byte aligned and their
;	widths are always a multiple of eight.

save_bitblk PROC FAR
	push	bp
	mov	bp,sp
	sub	sp,4
deltay	equ wo [bp-2]
shftcnt	equ wo [bp-4]
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di	
	push	ds
	push	es
	les	di,es:[di]
	mov	es:[di].BRLeft,cx	;save coordinates of rectangle for
	mov	es:[di].BRTop,si	;restore_bitblk
	mov	es:[di].BRRight,ax
	mov	es:[di].BRBottom,dx
	add	di,size BoundRect	;bump past saved coordinates
	mov	es:[di].BRLeft,0
	mov	es:[di].BRBottom,0
	push	si			;save starting raster #
	sub	si,dx			;calculate bitmap height
	mov	es:[di].BRTop,si	;save clip top
	inc	si
	mov	deltay,si		;save bitmap height
	pop	si
	push	ax			;save starting x
	sub	ax,cx			;calculate bitmap width (in pixels)
	mov	es:[di].BRRight,ax	;save clip right
	pop	ax
	add	di,size BoundRect	;bump past clip coordinates
	shl	si,1			;BX = Y * 2
	mov	si,cs:latable[si]	;si -> source screen raster
	mov	bx,cx			;get starting byte
	and	bx,7			;bx = x1 mod 8 - shift count
	mov	shftcnt,bx		;save shift count
	mov	bx,cx			;save x
	mov	cl,3
	shr	bx,cl			;calc starting byte
	shr	ax,cl			;calc ending byte
	add	si,bx			;DI -> source screen byte
	sub	ax,bx			;calc bytes per row
	inc	ax
	mov	bx,ax			;put bytes-per-row counter in BX
	mov	ax,VIDEO_ADDR		;get video segment address
	mov	ds,ax			;DS -> frame buffer

	mov	dx,03CEh		;DX = graphics controller port address
	mov	ax,0005h		;AL = graphics mode register number
	out	dx,ax			;select read/write mode 0
	mov	ax,0304h		;AL = read map select register number

sb1:	out	dx,ax			;select read bitplane number
	push	ax			;save bitplane counter
	push	si			;save screen pointer
	mov	cx,deltay		;CX = raster counter

sb2:	push	bx			;save bytes-per-row counter
	push	si			;save screen pointer

sb3:	cmp	shftcnt,0		;need to shift bits?
	 je	sb4			;  no
	lodsb				;get first byte
	mov	ah,al			;put in ah
	mov	al,[si]			;get next byte
	push	cx			;save raster count
	mov	cx,shftcnt		;get number of bits to shift
	shl	ax,cl			;byte align the data
	pop	cx			;restore raster count
	mov	al,ah			;al = byte aligned data
	stosb				;save it
	jmp	short sb5		;and go on
sb4:	movsb
sb5:	dec	bx			;decrement bytes-per-row counter
	 jnz	sb3			;loop around if BX > 0

	pop	si			;restore screen pointer
	pop	bx			;restore bytes-per-row counter
	add	si,BYTROW		;DI -> next raster
	loop	sb2			;loop around if CX > 0

	pop	si			;restore screen pointer
	pop	ax			;restore bitplane counter
	dec	ah			;decrement bitplane number
	 jge	sb1			;loop around if AH >= 0
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
save_bitblk ENDP
;restore_bitblk
;desc:	restores a bitmap from system RAM to video RAM
;in:	ds = presentation space segment
;	bx = presentation space handle
;	cx = x offset from position of saved rectangle
;	dx = y offset from position of saved rectangle
;	es:di->dd->buffer in system RAM filled by save_bitblk
;out:
;ret:	none
;notes:	The last FOUR entries in the temporary variable list must be
;	at the end and in that order, since they are considered a structure
rbmpblk	struc
	PlaneSz		dw	?
	RasterSz	dw	?
	ShiftCnt	db	?
	ShiftFlg	db	?
rbmpblk	ends

	SHIFTBITS	equ	1
	LEFTSIDE	equ	2
	RIGHTSIDE	equ	4

restore_bitblk PROC FAR
	push	bp
	mov	bp,sp
	sub	sp,22
r_remx	equ wo [bp-2]
r_remx1	equ wo [bp-4]
r_byte_x1 equ by [bp-6]
r_byte_x equ by [bp-5]
r_y	equ wo [bp-8]
r_DY	equ wo [bp-10]
r_DX	equ wo [bp-12]
r_off	equ wo [bp-14]
parmptr equ wo [bp-16]
sflg	equ by [bp-17]
scnt	equ by [bp-18]
rsz	equ wo [bp-20]
plsz	equ wo [bp-22]
	mov	parmptr,sp		;store pointer to parameter block

	push	ax
	push	bx
	push	cx
.cx	equ wo [bp-28]
	push	dx
	push	si
	push	di
.di	equ wo [bp-34]
	push	es
.es	equ wo [bp-36]
	push	ds
	lds	si,es:[di]		;point at data
	mov	di,si
	add	di,size BoundRect	;di->clip coordinates
	mov	bx,[si].BRTop
	mov	ax,[si].BRBottom	;org y bottom + new clip top
	add	ax,[di].BRTop
	cmp	ax,bx			;clip too big?
	jbe	rb_01			;no
	mov	ax,bx			;yes, take org y height
rb_01:	add	ax,dx			;add y offset
	mov	r_y,ax			;save starting raster for later

;--- setup shift count in case we are putting the rectangle back
;--- to coordinates that change the byte alignment of the pixels

	mov	ax,[si].BRLeft		;get original x
	add	ax,[di].BRLeft		;add clip offset
	add	cx,ax			;add move offset and clip offset
	mov	bx,cx			;save a copy of x
	and	cx,7			;new x mod 8
	mov	r_remx,cx		;save x mod 8
	mov	sflg,0			;assume no shift needed
	cmp	cl,0			;any shift needed?
	 je	rb_02			;  no
	mov	sflg,SHIFTBITS		;  yes
rb_02:	mov	scnt,cl			;set shift count
	mov	ax,[di].BRTop		
	sub	ax,[di].BRBottom	;compute delta y
	inc	ax
	mov	r_DY,ax
	mov	cl,3			;setup shift count
	shr	bx,cl			; x/8
	mov	r_byte_x,bl		; save in r_byte_x
	mov	bx,[di].BRLeft
	shr	bx,cl			;clip offset / 8
	mov	r_off,bx		;x offset into data
	mov	ax,[si].BRLeft		;get org x
	add	ax,[di].BRRight		;compute x1 from x and clip width
	sub	ax,[di].BRLeft
	mov	bx,[si].BRRight
	cmp	ax,bx			;is clipped x1 greater than possible?
	jbe	rb_03			;no
	mov	ax,bx			;yes, ignore clip width
rb_03:	add	ax,.cx			;add x offset
	mov	bx,ax			;save a copy of x1
	shr	ax,cl			;x1/8
	mov	r_byte_x1,al		;save in r_byte_x1
	sub	al,r_byte_x		;compute delta x in bytes
	inc	al
	xor	ah,ah
	mov	r_DX,ax

	mov	ax,[si].BRRight		;compute raster width of saved data
	mov	dx,[si].BRLeft
	shr	ax,cl
	shr	dx,cl
	sub	ax,dx
	inc	ax

	mov	rsz,ax
	mov	cx,[si].BRTop
	sub	cx,[si].BRBottom	;compute saved bit block height
	mov	dx,cx			;make a copy of height
	sub	dx,[di].BRTop		;find y rasters to skip at top
	mul	dx			;
	add	r_off,ax		;add y offset into data offset
	inc	cx			
	mov	ax,rsz
	mul	cx			;compute size of each plane's data
	mov	plsz,ax			;save
	and	bx,7			;x1 mod 8
	mov	r_remx1,bx		;save 
	mov	ax,VIDEO_ADDR		; get video buffer address
	mov	es,ax			;setup es->frame buffer address
	mov	si,di			;bump past saved coordinates
	add	si,size BoundRect	;bump past clip coordinates
	add	si,r_off		;bump past clipped out x and y data

	mov	dx,03CEh		;DX = graphics controller port address
	mov	ax,0005h		;AL = graphics mode register number
	out	dx,ax			;select read/write mode 0
	mov	ax,0003h		;AL = function select register number
	out	dx,ax			;select overpaint function
	mov	ax,0001h		;AL = enable reset register number
	out	dx,ax			;select byte-by-byte update

rb_05:	mov	bl,r_byte_x		;bl:=starting byte number on row
	mov	ax,r_DY			;ax:=delta y
	mov	cx,r_DX			;cx:=delta x in bytes
	mov	dx,r_y			;dx:=starting raster #
	mov	di,r_remx		;get non-byte aligned count
	cmp	bl,r_byte_x1		;see if starting byte same as ending byte number
	 je	rb_50			;if same then block is <= 1 byte wide
	or	di,di			;see if remx is zero
	 jz	rb_10			;yes jump
	mov	bh,cs:mtable[di]	;bh:=bit mask for non-byte aligned
	mov	di,parmptr		;di->parm block
	or	ss:[di].ShiftFlg,LEFTSIDE
	call	mrestore_bitblk_d
	and	ss:[di].ShiftFlg,not LEFTSIDE
	inc	bl			;bump starting byte number
	inc	si			;bump pointer to data
	dec	cx			;dec delta x
rb_10:	mov	di,r_remx1		;get right non-byte aligned part
	cmp	di,7			;see if right non-byte aligned part is 7
	 je	rb_30			;jump if yes
	push	bx			;save starting byte number,data pointer
	push	si
	mov	bl,r_byte_x1		;get starting byte number for right sliver
	mov	bh,cs:mtable1[di]	;bh:=bit mask for non-byte aligned
	mov	si,.di			;si->pointer to start of data
	mov	ds,.es
	lds	si,[si]
	add	si,size BoundRect*2	;bump past coordinates
	add	si,r_off		;bump past clipped out x and y data
	add	si,r_DX			;bump to byte at end
	dec	si
	mov	di,parmptr		;di->parm block
	or	ss:[di].ShiftFlg,RIGHTSIDE
	call	mrestore_bitblk_d
	and	ss:[di].ShiftFlg,not RIGHTSIDE
	pop	si			;recover starting byte number
	pop	bx
	dec	cx			;dec delta x
rb_30:	 jcxz	rb_60			;exit if no more to do
	mov	di,parmptr		;di->parm block
	call	restore_bitblk_d
	jmp	short rb_60		; done so jump

;--- this handles a block which is within a single byte
rb_50:	mov	bh,cs:mtable[di]	;get mask for left side
	mov	di,r_remx1		;get remainder for left side
	and	bh,cs:mtable1[di]	;finish making mask
	mov	di,parmptr		;di->parm block
	call	mrestore_bitblk_d
;--- exit
rb_60:	mov	dx,03C4h		;I/O sequencer port address
	mov	ax,0f02h		;reset default map mask value
	out	dx,ax
rb_98:	clc
	pop	ds
	pop	es
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
restore_bitblk ENDP
;mrestore_bitblk_d
;desc:	routine to restore saved data that is not a complete byte
;in:	ds:si->pointer to saved data
;	ss:di->pointer to parameter block
;	bh = bit mask for sliver
;	bl = starting byte # of raster
;	dx = starting y raster #
;	ax = # of rasters (delta y)
;	cx = # of bytes (not used in this routine)
;	es = frame buffer segment
;out:
;ret:
;notes:
mrestore_bitblk_d	proc	near
	push	bp
	mov	bp,sp
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
.di	equ wo [bp-12]
	mov	cx,ax			;cx:=delta y
	mov	ah,bh			;ah = bit mask
	xor	bh,bh			;bx:=byte number
	mov	di,dx			;get start of raster address
	shl	di,1			;*2 to index into table
	mov	di,cs:latable[di]	;di->start of raster
	add	di,bx			;di->byte on starting raster

	mov	dx,03ceh		;graphics address register
	mov	al,8			;AL = bit mask register select
	out	dx,ax			;select bit mask for this sliver
	mov	dx,03C4h		;I/O sequencer port address
	mov	al,2			;select map mask register
	out	dx,al
	inc	dx			;point dx at map mask register
	mov	bx,.di			;ss:bx->parm block
	test	ss:[bx].ShiftFlg,SHIFTBITS	;need to shift data?
	 jnz	mrb50			; yes
mrb10:	push	si			;save pointer to data
	mov	al,8			;start with plane 3
mrb20:	out	dx,al			;select plane to write
	mov	ah,es:[di]		;latch existing data
	mov	ah,[si]			;get saved plane data
	mov	es:[di],ah		;store saved plane data
	add	si,ss:[bx].PlaneSz	;bump to next plane's data
	shr	al,1			;get mask for selecting next plane
	 jnz	mrb20			;do next plane 
	pop	si			;restore pointer to plane data
	add	si,ss:[bx].RasterSz	;bump to next raster in plane
	add	di,BYTROW		;bump to next raster in frame buffer
	loop	mrb10			;go do next raster
	jmp	short mrb99

mrb50:	push	cx			;save raster count, data pointer
	push	si
	mov	ch,8			;init plane mask
	mov	cl,ss:[bx].ShiftCnt	;get amount to shift data by
mrb60:	mov	al,ch
	out	dx,al			;enable current plane
	mov	al,es:[di]		;latch exising data
	mov	al,[si]			;get saved data
	xor	ah,ah			;init ah
	test	ss:[bx].ShiftFlg,LEFTSIDE
	 jz	mrb65
;--- left side
	shr	ax,cl
	mov	es:[di],al		;write saved, shifted data	
	jmp	short mrb80

;--- right side
mrb65:	mov	ah,[si-1]
	shr	ax,cl
	mov	es:[di],al
mrb80:	add	si,ss:[bx].PlaneSz	;bump to next plane for this raster
	shr	ch,1			;get mask for next plane
	 jnz	mrb60			; do next plane
	pop	si			;restore raster count, data pointer
	pop	cx
	add	si,ss:[bx].RasterSz	;bump to next raster in plane
	add	di,BYTROW		;bump to next raster in frame buffer
	loop	mrb50			;go do next raster
mrb99:	mov	dx,3ceh			;reset bit mask
	mov	ax,0ff08h		;	\
	out	dx,ax			;	\
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
mrestore_bitblk_d	endp
;restore_bitblk_d
;desc:	routine to restore saved data that is in one or more complete bytes
;in:	ds:si->pointer to saved data
;	bl = starting byte # of raster
;	dx = starting y raster #
;	ax = # of rasters (delta y)
;	cx = # of bytes
;	es = frame buffer segment
;out:
;ret:
;notes:
restore_bitblk_d	proc	near
	push	bp
	mov	bp,sp
	push	ax
	push	bx
	push	cx
.cx	equ wo [bp-6]
.cl	equ by [bp-6]
	push	dx
	push	si
	push	di
.di	equ wo [bp-12]
	mov	cx,ax			;cx:=delta y
	xor	bh,bh			;bx:=byte number
	mov	di,dx			;get start of raster address
	shl	di,1			;*2 to index into table
	mov	di,cs:latable[di]	;di->start of raster
	add	di,bx			;di->byte on starting raster

	mov	dx,03ceh		;graphics address register
	mov	ax,0ff08h		;allow write on all bits
	out	dx,ax			;select bit mask
	mov	dx,03C4h		;I/O sequencer port address
	mov	al,2			;select map mask register
	out	dx,al
	inc	dx			;point dx at map mask register
	mov	bx,.di			;ss:bx->parm block
	test	ss:[bx].ShiftFlg,SHIFTBITS	;any shift needed
	 jnz	rb50			;  yes
rb10:	push	si			;save pointer to data,raster count
	push	cx
	mov	al,8			;start with plane 3
rb20:	out	dx,al			;select plane to write
	mov	cx,.cx			;
	push	si			;save pointer to frame buffer, data
	push	di
	rep	movsb			;write raster's plane data
	pop	di
	pop	si
	add	si,ss:[bx].PlaneSz	;bump to next plane's data
	shr	al,1			;get mask for selecting next plane
	 jnz	rb20			;do next plane 
	pop	cx			;restore pointer to plane data,raster count
	pop	si
	add	si,ss:[bx].RasterSz	;bump to next raster in plane
	add	di,BYTROW		;bump to next raster in frame buffer
	loop	rb10			;go do next raster
	jmp	short rb99

rb50:	push	si			;save data pointer, raster count
	push	cx
	mov	cl,ss:[bx].ShiftCnt	
	mov	ch,8			;init plane enable mask
rb60:	mov	al,ch
	out	dx,al			;enable current plane
	push	cx			;save current plane mask,pointers
	push	si
	push	di
	mov	ch,.cl			;get number of bytes to do
rb70:	mov	ah,[si-1]		;loop for data that must be right-shifted
	lodsb
	shr	ax,cl
	stosb
	dec	ch
	 jnz	rb70
	pop	di			;restore current plane mask,pointers
	pop	si
	pop	cx
	add	si,ss:[bx].PlaneSz	;bump to next plane's data
	shr	ch,1			;create next plane enable mask
	 jnz	rb60			;and do next plane
	pop	cx			;restore pointer to plane data,raster count
	pop	si
	add	si,ss:[bx].RasterSz	;bump to next raster in plane
	add	di,BYTROW		;bump to next raster in frame buffer
	loop	rb50			;go do next raster
rb99:	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
restore_bitblk_d	endp

;BuildPat
;desc:	Build a pattern from a 8 bits per pixel 8x8 to the easies way to use
;	for this device.
;in:	ds = presentation space segment
;	bx = presentation space handle
;	es:si -> pointer to color pattern
;	ds:si -> pointer to place to put new pattern
;out:
;ret:	none
;notes:
BuildPat	proc	far
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	mov	cx,8		; setup outer loop count
bpt01:	push	cx		; save for later
	mov	cx,8		; get inner loop count
	xor	bx,bx		; get zero in holding reg
	mov	dx,bx		; get zero in holding reg
bpt02:	mov	al,es:[si]	; get value
	rcr	al,1		; get bit into carry
	rcl	bh,1		; get carry into holding register
	rcr	al,1		; get bit into carry
	rcl	bl,1		; get carry into holding register
	rcr	al,1		; get bit into carry
	rcl	dh,1		; get carry into holding register
	rcr	al,1		; get bit into carry
	rcl	dl,1		; get carry into holding register
	inc	si		; point to next byte
	loop	bpt02		; loop back
	mov	[di],dl		; put byte in save area
	mov	[di+8],dh	; put byte in save area
	mov	[di+16],bl	; put byte in save area
	mov	[di+24],bh	; put byte in save area
	inc	di		; bump point to next position
	pop	cx		; get loop count back
	loop	bpt01		; go do it again
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax	
	ret
BuildPat	endp
;GetBitmap
;desc:	saves a bitmap from video RAM to system RAM in standard format
;in:	DS = presentation space segment
;	BX = presentation space handle
;	cx,dx = lower left corner of rectangle to get
;	ax,si = upper right corner of rectangle to get
;	es:di->dd->buffer in which to save bitmap data
;out:	ax = error code if error
;ret:	jc if error
;notes:

GetBitmap PROC FAR
	push	bp
	mov	bp,sp
	sub	sp,12
BitmapX	equ wo [bp-2]
BitmapY	equ wo [bp-4]
BitmapW	equ wo [bp-6]
BitmapH	equ wo [bp-8]
BitmapBh equ wo [bp-10]
BitmapBl equ wo [bp-12]

	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	ds
	push	es

	mov	BitmapX,cx		;save X coordinate
	mov	BitmapY,si		;save Y coordinate
	sub	ax,cx			;compute width
	inc	ax
	mov	BitmapW,ax		;save width
	sub	si,dx			;compute height
	inc	si
	mov	BitmapH,si		;save height
	les	di,es:[di]		;load pointer to buffer
	mov	BitmapBl,di		;save offset of buffer pointer
	mov	BitmapBh,es		;save segment of buffer pointer
	mov	ax,VIDEO_ADDR		;get video segment address
	mov	ds,ax			;DS -> frame buffer

gb1:	call	GetRaster		;get a raster of screen data
	call	PackPixels		;pack bitplane data into pixel data
	dec	BitmapY			;decrement Y coordinate
	dec	BitmapH			;decrement bitmap height
	jnz	gb1			;loop around if height > 0

	mov	dx,03CEh		;DX = graphics controller port address
	mov	ax,0005h		;AL = graphics mode register number
	out	dx,ax			;select read/write mode 0

	clc
	pop	es
	pop	ds
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
GetBitmap ENDP

;NOTE: this uses BP referenced vars from GetBitmap!
GetRaster PROC NEAR

	mov	bx,BitmapY		;get Y coordinate
	shl	bx,1			;BX = Y * 2
	mov	si,cs:latable[bx]	;DS:SI -> source raster
	mov	ax,BitmapX		;get X coordinate
	shr	ax,1			;AX = X / 2
	shr	ax,1			;AX = X / 4
	shr	ax,1			;AX = X / 8
	add	si,ax			;DS:SI -> source byte
	lea	di,Plane3		;CS:DI -> target bitplane buffer
	mov	cx,BitmapW		;get bitmap width
	shr	cx,1			;CX = width / 2
	shr	cx,1			;CX = width / 4
	shr	cx,1			;CX = width / 8
	add	cx,2			;allow for partial bytes
	mov	dx,03CEh		;get controller port address
	mov	ax,0005h		;select register 5
	out	dx,ax			;set read mode 0
	mov	ax,0304h		;select register 4

gr1:	out	dx,ax			;set read plane
	push	cx			;save byte count
	push	si			;save screen pointer
	push	di			;save bitplane pointer

gr2:	mov	bl,ds:[si]		;get a screen byte
	mov	cs:[di],bl		;store screen byte
	inc	si			;increment screen pointer
	inc	di			;increment bitplane pointer
	loop	gr2			;do the next byte

	pop	di			;reset bitplane pointer
	pop	si			;reset screen pointer
	pop	cx			;restore byte count
	add	di,80+2			;point to next bitplane buffer
	dec	ah			;decrement plane number
	jge	gr1			;loop around if plane >= 0

	ret				;return near

GetRaster ENDP

;NOTE: this uses BP referenced vars from GetBitmap!
PackPixels PROC NEAR

	mov	es,BitmapBh		;get target buffer segment
	mov	di,BitmapBl		;ES:DI -> target buffer
	mov	bx,BitmapX		;get X coordinate
	and	bx,7			;get pixel position
	mov	ah,cs:ltable[bx]	;get mask value
	xor	si,si			;zero out SI
	mov	cx,BitmapW		;get bitmap width

pp1:	mov	bl,cs:Plane3[si]	;get a byte from plane 3
	mov	bh,cs:Plane2[si]	;get a byte from plane 2
	mov	dl,cs:Plane1[si]	;get a byte from plane 1
	mov	dh,cs:Plane0[si]	;get a byte from plane 0
	inc	si			;increment source pointer

pp2:	xor	al,al			;zero out AL
	test	bl,ah			;bit set in plane 3?
	jz	pp3			;jump if not
	stc				;set carry flag

pp3:	rcl	al,1			;rotate carry into AL
	test	bh,ah			;bit set in plane 2?
	 jz	pp4			;jump if not
	stc				;set carry flag

pp4:	rcl	al,1			;rotate carry into AL
	test	dl,ah			;bit set in plane 1?
	 jz	pp5			;jump if not
	stc				;set carry flag

pp5:	rcl	al,1			;rotate carry into AL
	test	dh,ah			;bit set in plane 0?
	 jz	pp6			;jump if not
	stc				;set carry flag

pp6:	rcl	al,1			;rotate carry into AL
	mov	es:[di],al		;store result
	inc	di			;increment output pointer
	dec	cx			;decrement bitmap width
	 jz	ppx			;exit if width = 0

	ror	ah,1			;rotate bit mask
	cmp	ah,80h			;start of a new byte?
	 je	pp1			;jump if so
	jmp	short pp2		;do the next pixel

ppx:	mov	BitmapBl,di		;update target buffer offset
	ret				;return near

PackPixels ENDP
;PutBitmap
;desc:	restores a bitmap from system RAM in standard format to video RAM
;in:	DS = presentation space segment
;	BX = presentation space handle
;	cx,dx = lower left corner of rectangle to get
;	ax,si = upper right corner of rectangle to get
;	es:di->dd->buffer containing bitmap data
;out:	ax = error code if error
;ret:	jc if error
;notes:
PutBitmap PROC FAR
	push	bp
	mov	bp,sp
	sub	sp,22
BitmapX	equ wo [bp-2]
BitmapY	equ wo [bp-4]
BitmapW	equ wo [bp-6]
BitmapH	equ wo [bp-8]
BitmapBh equ wo [bp-10]
BitmapBl equ wo [bp-12]
Lbyte	equ wo [bp-14]
RByte	equ wo [bp-16]
LMask	equ by [bp-18]
RMask	equ by [bp-17]
RPlane	equ by [bp-20]
WPlane	equ by [bp-19]
TgtRast	equ wo [bp-22]

	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	es
	push	ds

	mov	BitmapX,cx		;save X coordinate
	mov	BitmapY,si		;save Y coordinate
	sub	ax,cx			;compute width
	inc	ax
	mov	BitmapW,ax		;save width
	sub	si,dx			;compute height
	inc	si
	mov	BitmapH,si		;save height
	les	di,es:[di]		;load pointer to buffer
	mov	BitmapBl,di		;save offset of buffer pointer
	mov	BitmapBh,es		;save segment of buffer pointer
	mov	bx,cx			;put X coordinate in BX
	and	bx,7			;get pixel position
	mov	dl,cs:mtable[bx]	;get left end bit mask
	mov	LMask,dl		;save it
	mov	bx,cx			;get X again
	shr	bx,1			;BX = X / 2
	shr	bx,1			;BX = X / 4
	shr	bx,1			;BX = X / 8
	mov	LByte,bx		;save result
	dec	ax			;decrement bitmap width
	add	cx,ax			;CX = X coordinate of right endpoint
	mov	bx,cx			;put X coordinate in BX
	and	bx,7			;get pixel position
	mov	dl,cs:mtable1[bx]	;get right end bit mask
	mov	RMask,dl		;save it
	mov	bx,cx			;get X again
	shr	bx,1			;BX = X / 2
	shr	bx,1			;BX = X / 4
	shr	bx,1			;BX = X / 8
	mov	RByte,bx		;save result
	mov	ax,VIDEO_ADDR		;get video segment address
	mov	es,ax			;ES -> frame buffer

pb1:	call	SplitPixels		;split pixel data into bitplane data
	call	PutRaster		;display a raster of data
	dec	BitmapY			;decrement Y coordinate
	dec	BitmapH			;decrement bitmap height
	 jnz	pb1			;loop around if height > 0

	mov	dx,03C4h
	mov	ax,0F02h		;default map mask value
	out	dx,ax			;select map mask
	mov	dx,03CEh		;DX = graphics controller port address

	mov	ax,0F07h		;default color compare
	out	dx,ax			;select color compare
	clc
	pop	ds
	pop	es
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	mov	sp,bp
	pop	bp
	ret
PutBitmap ENDP

;NOTE: this uses BP referenced vars from PutBitmap!

SplitPixels PROC NEAR

	mov	ds,BitmapBh		;get source buffer segment
	mov	si,BitmapBl		;DS:SI -> source buffer
	mov	bx,BitmapX		;get X coordinate
	and	bx,7			;get pixel position
	mov	ah,cs:ltable[bx]	;get mask value
	xor	di,di			;zero out DI
	mov	cx,BitmapW		;get bitmap width

sp1:	xor	bx,bx			;zero out BL and BH
	xor	dx,dx			;zero out DL and DH

sp2:	mov	al,ds:[si]		;get pixel data
	inc	si			;increment buffer pointer
	shr	al,1			;shift bitplane 0 into carry
	 jnc	sp3			;jump if carry is 0
	or	dh,ah			;turn on bit in DH

sp3:	shr	al,1			;shift bitplane 1 into carry
	 jnc	sp4			;jump if carry is 0
	or	dl,ah			;turn on bit in DL

sp4:	shr	al,1			;shift bitplane 2 into carry
	 jnc	sp5			;jump if carry is 0
	or	bh,ah			;turn on bit in BH

sp5:	shr	al,1			;shift bitplane 3 into carry
	 jnc	sp6			;jump if carry is 0
	or	bl,ah			;turn on bit in BL

sp6:	dec	cx			;decrement bitmap width
	 jz	sp7			;jump if width = 0
	ror	ah,1			;rotate bit mask
	cmp	ah,80h			;start of a new byte?
	 jne	sp2			;jump if not

sp7:	mov	cs:Plane0[di],dh	;update bitplane 0
	mov	cs:Plane1[di],dl	;update bitplane 1
	mov	cs:Plane2[di],bh	;update bitplane 2
	mov	cs:Plane3[di],bl	;update bitplane 3
	inc	di			;increment target pointer
	 jcxz	spx			;exit if width = 0
	jmp	short sp1		;do the next pixel

spx:	mov	BitmapBl,si		;update source buffer offset
	ret				;return near

SplitPixels ENDP

;NOTE: this uses BP referenced vars from PutBitmap!

PutRaster PROC NEAR

	mov	bx,BitmapY		;get Y coordinate
	shl	bx,1			;BX = Y * 2
	mov	di,cs:latable[bx]	;ES:DI -> target raster
	mov	TgtRast,di		;ES:TgtRast -> target raster
	add	di,LByte		;ES:DI -> target byte
	mov	ax,TgtRast
	add	ax,RByte		;ES:TgtRast -> stop byte
	mov	TgtRast,ax
	lea	si,Plane3		;CS:SI -> source bitplane data
	mov	dx,03CEh		;get controller port address
	mov	ax,0005h		;select register 5
	out	dx,ax			;set write mode 0
	mov	ax,0003h		;select register 3
	out	dx,ax			;set overpaint mix mode
	mov	ax,0001h		;select register 1
	out	dx,ax			;set byte-by-byte update
	mov	ax,0FF08h		;select register 8
	out	dx,ax			;set bit mask to FF
	mov	RPlane,03h		;set read plane value
	mov	WPlane,08h		;set write plane value

pr1:	mov	dx,03CEh		;get controller port address
	mov	al,04h			;select register 4
	mov	ah,RPlane		;get read plane value
	out	dx,ax			;set read plane
	mov	dx,03C4h		;get sequencer port address
	mov	al,02h			;select register 2
	mov	ah,WPlane		;get write plane value
	out	dx,ax			;set write plane
	push	si			;save bitplane data ptr and screen ptr
	push	di
	mov	al,cs:[si]		;get bitplane data
	mov	ah,LMask		;get mask for left endpoint
	mov	cx,1			;set multi-byte flag
	cmp	di,TgtRast		;one byte only?
	 jb	pr2			;jump if not
	and	ah,RMask		;get full mask in AH
	xor	cx,cx			;clean multi-byte flag

pr2:	not	ah			;invert mask
	mov	bl,es:[di]		;get screen value
	and	bl,ah			;zero out target bits
	or	bl,al			;turn on color bits
	mov	es:[di],bl		;display result
	jcxz	pr5			;jump if single-byte raster

pr3:	inc	si			;increment data pointer
	inc	di			;increment screen pointer
	cmp	di,TgtRast		;at right endpoint?
	 je	pr4			;jump if so
	mov	al,cs:[si]		;get bitplane data
	mov	es:[di],al		;display it
	jmp	short pr3		;do the next byte

pr4:	mov	al,cs:[si]		;get data byte
	mov	ah,RMask		;get mask for right end
	not	ah			;invert mask
	mov	bl,es:[di]		;get screen value
	and	bl,ah			;zero out target bits
	or	bl,al			;turn on color bits
	mov	es:[di],bl		;display result

pr5:	pop	di			;restore bitplane data ptr, and screen ptr
	pop	si
	add	si,80+2			;point to next bitplane
	dec	RPlane			;decrement read plane value
	shr	WPlane,1		;shift write plane value
	 jnz	pr1			;loop around if write plane > 0

	ret				;return near

PutRaster ENDP
;wait_begin_vretrace
;
; note: waits for vertical retrace to begin then returns.
;       all registers should be preserved
;
wait_begin_vretrace	proc near
	push	dx
	push	ax

	mov	dx,3dah
wbv_01:	in	al,dx
	test	al,8
	 jnz	wbv_01

wbv_02:	in	al,dx
	test	al,8
	 jz	wbv_02

	pop	ax
	pop	dx
	ret
wait_begin_vretrace	endp

CSEG2	ENDS
END
