;name	wpgidef.inc
;title	presentation space structure equates
;
;  Copyright (C) 1991 WordPerfect Corp., All Rights Reserved
;  COMPANY CONFIDENTIAL -- NOT FOR DISTRIBUTION
;------------------------------------------------------------
;description
;	Equates for GI, structure defs, etc.
;

IFNDEF	WPGIDEF			;if not already defined
WPGIDEF	equ	1		;define it for conditional nested include
ENDIF


IF1			;if pass 1
IFNDEF	GIQLINC1	;if wpgiequ.inc not already included
include	wpgiequ.inc	;then include it
ENDIF
ELSE			;if pass 2
IFNDEF GIQLINC2
include	wpgiequ.inc	;include wpgiequ.inc in second pass
ENDIF
ENDIF


;--------------------- structure definitions --------------------------------

;--- Device context required routines
;--- new required routines MUST be added to the bottom of this structure
DcRequiredR	struc
	DcCDriv 	dd	?	; Close graphics display driver
	DcDDot		dd	?	; Draw a dot
	DcDRect		dd	?	; Draw a rectangle
	DcHorLn		dd	?	; Draw a horizontal line
	DcVerLn		dd	?	; Draw a vertical line
	DcClrM		dd	?	; Set color map
	DcSVrt		dd	?	; Scroll vertically
	DcSHrz		dd	?	; Scroll horizontally
	DcCPixBlit	dd	?	; pixel blitter
	DcGCurSize	dd	?	; graphics curosr size
	DcGCurInit	dd	?	; graphics cursor init
	DcGCurErase	dd	?	; graphics cursor erase
	DcGCurWrite	dd	?	; graphics cursor write
	DcSizeBitmap	dd	?	; bitmap size
	DcSaveBitmap	dd	?	; bitmap save
	DcRestoreBitmap dd	?	; bitmap restore
	DcBuildPat	dd	?	; build a bitmap
	DcGetBitmap	dd	?	; get a standard format bitmap
	DcPutBitmap	dd	?	; put a standard format bitmap
DcRequiredR	ends

;--- Device context optional routines
;--- new optional routines MUST be added to the bottom of this structure
DcOptionalR	struc
	BegAreaA	dd	?	; BegArea routine
	EndAreaA	dd	?	; EndArea routine
	EraseA		dd	?	; Erase routine
	LineA		dd	?	; Unclipped, single pixel wide line routine
	PolylineA	dd	?	; Polyline routine
	PolySplineA	dd	?	; PolySpline routine
	PolygonA	dd	?	; Simple polygon routine
	BitmapA		dd	?	; bitmap routine
	BmClrRasA	dd	?	; Bitmap true color raster draw
	ArcA		dd	?	; Arc routine (information passed in world coords)
	BoxA		dd	?	; Rounded rectangle (information passed in world coords)
	ScrollBlkA	dd	?	; Scroll a block of video
	CopyRectA	dd	?	; Copy a rectangle from one video page to another
	PageNumA	dd	?	; Set video page number
	CallDCA		dd	?	; direct hook to the Device Context
	EncapFileA	dd	?	; do encapsulated file format
	DevOutCharA	dd	?	; Output a character		
	ClipRectA	dd	?	; Set clipping rectangle
	BeginClipPathA	dd	?	; Begin the clip path bracket
	EndClipPathA	dd	?	; End the clip path bracket
	ClipRegionA	dd	?	; Set clipping region
;//jbo*		ClipBitmapA	dd	?	; Set clipping bitmap
DcOptionalR	ends

;--- File I/O support routines
;--- new file I/O support routines MUST be added to the bottom
;--- of this structure
GIioSupport	struc
	GIfOpen		dd	?	;file open
	GIfClose	dd	?	;file close
	GIfRead		dd	?	;read from an open file
	GIfWrite	dd	?	;write to an open file
	GIfSeek		dd	?	;seek to a position in an open file
GIioSupport	ends

;--- Memory allocation support routines
;--- new memory allocation support routines MUST be added to the bottom
;--- of this structure.
GIMemSupport	struc
	GIAlloc		dd	?	;Allocate a packet
	GIDeAlloc	dd	?	;Deallocate a packet
	GITrackPacket	dd	?	;Track a packet
	GIUnTrackPacket	dd	?	;Untrack a packet
	GIGetPacket	dd	?	;Get a packet address
GIMemSupport	ends

;--- Fixed point arithmetic support routines
;--- new fixed point arithmetic support routines MUST be added to the bottom
;--- of this structure
GIfpSupport	struc
	GIfpMul		dd	?	;Fixed point multiply
	GIfpDiv		dd	?	;Fixed point divide
	GIfpAbs		dd	?	;Fixed point absolute value
	GIfpRnd		dd	?	;Fixed point round
	GITan		dd	?	;Fixed point tangent
	GIArcTan	dd	?	;Fixed point arctangent
	GISinCos	dd	?	;Fixed point sine and cosine
	GITransform	dd	?	;Point transformation routine
GIfpSupport	ends

;--- Application-supplied routines
;--- new application-supplied support routines MUST be added to the bottom
;--- of this structure
GIAppSupport	struc
	AppStream	dd	?	;write to application output stream
	AppGetRaster	dd	?	;routine to return an uncompressed raster
	AppPeriodic	dd	?	;routine to call periodically from GI
	AppRasterAddr	dd	?	;raster drivers call this to get a pointer
					;to a raster
	AppErrConvert	dd	?	;routine to convert error numbers, etc.
GIAppSupport	ends

;Color definition structure
;--- the short definition is used for character blitter color
;--- and for cursors (or anything that will never be dithered or have
;--- a pattern associated with it)
;--- the long definition is used for everything else (Area colors, line 
;--- colors, etc.)
pColorShort	struc
	ColorRIdx	dw	?	;color requested index
	ColorR		db	?	;red component of RGB
	ColorG		db	?	;green component of RGB
	ColorB		db	?	;blue component of RGB
	ColorT		db	?	;upper 8 bits of 32-bit color
	ColorFlag	db	?	;CLR_??? (describes what ColorMP points to)
	ColorMp		dw	?	;Color, Mapped pointer
pColorShort	ends

pColor	struc
			db	size pColorShort dup(?)
	ColorMM		db	?	;Mix mode for color
	ColorFPp	dw	?	;Fill Pattern pointer
pColor	ends

;--- fill pattern definition structure
;--- if .ColorFPp != 0, Then
;---	.ColorFPp->FPattern structure
FPattern	struc
	FPSet		db	?	;fill pattern set number
	FPIndex		db	?	;fill pattern index number
	FPWidth		db	?	;width of fill pattern in bits
	FPHeight	db	?	;height of fill pattern in bits
	FPWidthB	db	?	;width of fill pattern in bytes
FPattern	ends
	FPData	equ	FPWidthB+1	;start of fill pattern data

;--- half tone pattern definition structure
;---
HTPattern	struc
	HTWidth		db	?	;width of ht pattern in bits
	HTHeight	db	?	;height of ht pattern in bits
	HTWidthB	db	?	;width of ht pattern in bytes
HTPattern	ends
	HTData	equ	HTWidthB+1	;start of halftone pattern data

;--- If .ColorFlag == CLR_INDEX Then
;	.ColorMp->ColorMIdx structure
ColorMIdx	struc
	MIdx	dw	?		;mapped color index
ColorMIdx	ends

;--- If .ColorFlag == CLR_DITHER Then
;	.ColorMp->ColorDither structure
ColorDither	struc
	DVSDitherM db 64 dup(?)		;device specific dither matrix
	DitherM	   db 64 dup(?)		;device independent dither matrix
ColorDither	ends

;--- If .ColorFlag == CLR_HALFTONE Then
;	If ps.ColorModel == RGB Then
;	  .ColorMp->ColorRGBHT
;	Else If ps.ColorModel == CMYK Then
;	  .ColorMp->ColorCMYKHT structure
;	Else If ps.ColorModel == Monochrome Then
;	  .ColorMp->ColorMonoHT structure
ColorRGBHT	struc
	RHTPatternp	dw	?	;pointer to Red HtPattern structure
	GHTPatternp	dw	?	;pointer to Green HtPattern structure
	BHTPatternp	dw	?	;pointer to Blue HtPattern structure
ColorRGBHT	ends

ColorCMYKHT	struc
	CHTPatternp	dw	?	;pointer to Cyan HTPattern structure
	MHTPatternp	dw	?	;pointer to Magenta HTPattern structure
	YHTPatternp	dw	?	;pointer to Yellow HTPattern structure
	KHTPatternp	dw	?	;pointer to Black HTPattern structure
ColorCMYKHT	ends

ColorMonoHT	struc
	HTPatternp	dw	?	;pointer to HTPattern structure
ColorMonoHT	ends

;--- If .ColorFlag == CLR_RGB Then
;	.ColorMp->ColorRGB structure
ColorRGB	struc
	MColorR	db	?		;corrected red component
	MColorG	db	?		;corrected green component
	MColorB db	?		;corrected blue component
	MColorT	db	?		;upper 8 bits of 32-bit color
ColorRGB	ends	

;--- If .ColorFlag == CLR_CMYK Then
;	.ColorMp->ColorCMYK structure
ColorCMYK	struc
	MColorC	db	?		;cyan component
	MColorM	db	?		;magenta component
	MColorY db	?		;blue component
	MColorK	db	?		;black component
ColorCMYK	ends	

HTScreenDef	struc
	HTFrequency	db size FixedPoint dup(?);screen lpi
	HTAngle		db size FixedPoint dup(?);screen angle
	HTFlag		db	?		;flag defining what HTSpotF
						;points at
	HTSpotF		dd	?		;spot function or pointer 
						;to defining matrix
HTScreenDef	ends

;--- structure defining black generation and undercolor removal parms
CMYKGen	struc
	BGFactor	db size FixedPoint dup(?)
	UCRFactor	db size FixedPoint dup(?)
CMYKGen	ends

;--- structure defining a single region
RegionDef	struc
	RegionUseCnt	dw	?	;count of times region set as clip
	RegionRectCnt	dw	?	;count of region elements (rectangles)
	RegionRects	db	?	;start of region rectangles
RegionDef	ends


;--- structure defining attributes common between area and line
CommonAttr	struc
	ForeClrp	dw	?	;pointer to foreground color
	BackClrp	dw	?	;pointer to background color
	AttrFlg		dw	?	;Attribute change flag
CommonAttr	ends

GradientFill	struc
	GrXref		dw	?		;x reference into object
	GrYref		dw	?		;y reference into object
	GrStep		dw	?		;number of steps
	GrAngle		dw	?		;angle of gradient
	GrType		db	?		;gradient type
GradientFill	ends

;--- structure defining area attributes
;---
AreaAttr	struc
		db	size CommonAttr	dup(?)	;colors, change flags
	AaFilM		db	?	;Area fill method 0 = even/odd 1 = winding
	AaGFlg		db	?	;Area fill gradient flag 0 = no gradient fill 1 = gradient fill
	AaGr	db	size GradientFill dup(?)	;Gradient fill attributes
AreaAttr	ends

;--- structure defining line attributes
;---
LineAttr	struc
			db	size CommonAttr dup(?) ;colors, change flags	
	LnWdh		dw	?	; Line width (world units)
	LnWdhSqr	dw	?	; Line width (square, pseudo device units)
	LnStyPtr	dw	?	; If <> 0, this is ptr to info (otherwise solid)
	LnStyOfs	dw	?	; Offset into line style
	LnEnd		db	?	; Line end style
	LnJn		db	?	; Line join style
	LnSet		db	?	; Line Style Set number
	LnIndex		db	?	; Line Style Index number
LineAttr	ends


PSFixed	struc
;------ START Frozen area ---------
;------ NOTE: This is officially frozen, as of DDMMMYY

DcJmpTblp	dw	?	;pointer to required routines jump table
AJmpTblp	dw	?	;pointer to optional routines jump table
GIioJmpTblp	dw	?	;pointer to file i/o support routines jump table
GIMemJmpTblp	dw	?	;pointer to memory allocation support routines jump table
GIfpJmpTblp	dw	?	;pointer to fixed point support routines jump table
AppJmpTblp	dw	?	;pointer to application support routines
MasterTfmp	dw	?	;pointer to Master transformation matrix

CurForeClrp	dw	?	;pointer to current foreground color definition
CurBackClrp	dw	?	;pointer to current background color definition
AaAttrp		dw	?	;pointer to current area attributes
LnAttrp		dw	?	;pointer to current line attributes
CfAttrp		dw	?	;pointer to character fill attributes
CoAttrp		dw	?	;pointer to character outline attributes
CrForeClrp	dw	?	;pointer to cursor foreground color
CrBackClrp	dw	?	;pointer to cursor background color

;Resolution variables
DevBnds		db	size BoundRect dup(?)
DpiX		dw	?	; dots per inch in x
DpiY		dw	?	; dots per inch in y
MaxX		dw	?	; max x resolution
MaxY		dw	?	; max y resolution
NumClr		dw	?	; number of colors 0 = monochrome <>0 means colors
MemModel	dw	?	; Memory model of the driver
				;   Based on the VESA 1.2 standard
				;	00h = Text Mode
				;	01h = CGA graphics
				;	02h = Hercules Graphics
				;	03h = 4-plane planar
				;	04h = Packed Pixel
				;	05h = Non-chain 4 256-color
				;	06h = Direct Color
				;	07h = YUV
				;	08h-0feh = Reserved
				;	-1 = unknown
ClrRes		dw	?	; number of shades of each color
BitPrPx		db	?	; color info number of bits per pixel
NumPgs		db	?	; bits	0 - 2	Number of video pages supported
				;	3 - 4	Reserved must be 0
				;	6	0 = Alternate pages may be made active
				;		1 = Alternate page may not be made active
				; Indicates shades of gray rather than colors

;Pattern offset variables
AaXOf		dw	?	; Area pattern x offset
AaYOf		dw	?	; Area pattern y offset

;Color Model variables
;--- ColorModel defines what type of color is supported
;--- ColorEnhance defines what type of color enhancement method to use

ColorModel	db	?	;Monochrome,Indexed,RGB,CMYK
ColorEnhance	db	?	;None,Dither,Halftone,Grayshades
CMYKGenP	dw	?	;pointer to Black generation and undercolor
				;removal factors structure (if any)

;Halftone definition structure pointer
HTDefp		dw	?	;if != 0, points to a count byte and 1 or more
				;HTScreenDef structures (count byte has #)
HTMatLibp	dw	?	;if != 0, points to up to 16 words, each of
				;which points to a halftone pattern definition
				;matrix
;Current Position
CurXw	dw	?		; current x position (world coordinates)
CurYw	dw	?		; current y position (world coordinates)
CurX	dw	?		; current x position (device coordinates)
CurY	dw	?		; current y position (device coordinates)

;Scale factor to make device resolution square
DSclFlg	db	?		;which axis to scale (0 = don't scale, 1 = x, 2 = y)
DSclSqr	db	size	FixedPoint dup(?);

ColorOpt	db	?	; color table option
ColorTblp	dw	?	;pointer to logical color map (if any)
ColorDDXp	dw	?	;pointer to device dependent color correction
				;this points at 4 words, each of which
				;points to a color correction table for the
				;primaries, based on the color model.
ColorDIXp	dw	?	;pointer to device independent color transfer
				;this points at 3 words, each of which points
				;to a color transfer table that will be applied
				;to RGB values BEFORE conversion to device
				;color space

;--- Clipping Information
ClipRects	dw	?	;handle to GI clip rectangles

ClipRegionHnd	dw	?	;clip region handle -if -1 then no clip region

ClipPathHnd	dw	?	;clip path handle - if -1 then no clip path

ClipFlag	dw	?	;bit 0 set - clip
				;bit 1 set - use clip rectangle
				;bit 2 set - there is a clip path
				;bit 3 set - there is a clip region
				;bit 4 set - there is a clip bitmap
				;bit 5 set - use page viewport
				;bit 6 set - use model viewport
				;bit 7 set - use world viewport

;--- Clipping Information
ClipBounds	db	size BoundRect dup(?);

;Miscellaneous flags
GIFlags	dw	?	;bit 0 = 1 - don't transform coordinates
			;bit 1 = 1 - don't scale line styles based on line width
			;bit 2 = 1 - halftone bitmaps
			;bit 3 = 1 - allow multiple active cursors
			;bit 4 = 1 - do transforms using GTI master matrix
			;bit 5 = 1 - when increasing y is down
			;bit 6 = 1 - when increasing x is left
			;bit 7 = 1 - draw arcs counter clock wise
			;bit 8 = 1 - doing text path
			;bit 9 = 1 - doing generic path
			;bit 10 = 1 - output device fonts
			;bit 11 = 1 - device font encountered
			;bit 12 = 1 - device fonts enabled
			;bit 13 = 1 - use grey shades
			;bit 14 = 1 - use error diffusion
			;bit 15 = 1 - use ordered dither


DevErrMsgp	dd	?	; pointer to device-supplied error message

CrAttrFlg	dw	0	; Cursor attribute change flag
ClAttrFlg	dw	0	; clipping attribute change flag
HtAttrFlg	dw	0	; halftone attribute change flag
CtAttrFlg	dw	0	; color table change flag

;Device Context work space pointer
DevWorkp	dw 	?	; Work space for device contexts
GIDcWorkAlloc	dd	?	;Routine to allocate a small workspace
				;within PS
GIDfltClrs	dd	?	;Routine to return default GI color map

BzFactor	dd	?	; Bezier smoothness factor

FntDatFile	db	12 dup(0) ;area for font data filename

FntDatOfs	dd	0	;Offset of Embedded PRS/DRS file

FntFileChg	db	0	;Signal a font data filename change
	
;------ END Frozen Area

PSFixed	ends
