.model tiny
Code segment

assume cs:code	; We compile to .com, so only a code-segment available
Org 100h

; Here we go -----------------------------------[EIP]----------------------------------
start:

; --- Parse commandline
	xor ch, ch
	mov cl, es:[80h]	; Get command line length
	mov si, 81h		; Parse command line string
	lea di, BUFFER		; ..into buffer
	xor bx, bx
blank1:
	lodsb
	cmp al,' '
	loope blank1		; Skip first blanks
	jz usage		; No parameters = Error
	test cx, cx
	jz eocl
argv1:
	stosb
	lodsb
	cmp al,' '
	loopne argv1		; Skip to second parameter or end of cmdline
	jz nexttok		; Next parameter
eocl:
	stosb
nexttok:
	xor al,al
	stosb			; NULL-Terminate filename
	test bx, bx		; Need to read second param?
	jnz parseok
	test cx, cx		; If we have no second param, error
	jz usage
	mov bx, di		; Save ptr to dest file in bx
	jmp blank1

parseok:	
	test cx, cx		; No third parameter allowed
	jnz usage

; --- Read input font file to buffer, create output file
	mov ax, 3D00h		; Load input file
	mov dx, offset BUFFER
	int 21h
	jb  fileerr
	mov dx, bx
        mov bx, ax		; Open output file
	mov ah, 3Ch
	int 21h
	jb createrr
	push ax			; Save handle to output file to stack
	lea dx, BUFFER		; This allows us to reuse buffer for reading now
	mov cx, 01000H
	mov ah, 3Fh
	int 21h			; Read font to buffer
	Mov ah, 3eh 
	jb readerr
	int 21h			; Close input file

; --- Update buffer with underline
	mov cx, 0100h
	mov di, dx
	mov al, 0ffh
cloop:
	add di, 0Fh
	cmp cl, 050h		; 100-B0=50
	ja addchr		; Char 00-B0 -> Set FF underline
	cmp cl, 020h		; 100-E0=20
	jbe addchr		; Char E0-FF -> Set FF underline
	inc di
	jmp skip
addchr:
	stosb
skip:
	loop cloop

; --- Write buffer to output file
	mov ah, 040h		; Write modified buffer to output file
	pop bx
	mov cx, 01000h
	int 21h
	jb writerr
	Mov ah, 3eh 
	int 21h

; --- Terminate
	mov ax, 4C00h
	int 21h

; --- Error handling
usage:
	mov dx, offset TXTUSG
	jmp showerr
readerr:
	mov dx, offset RERROR
	int 21h
	pop bx
	jmp quitclose
writerr:
	mov dx, offset WERROR
	jmp quitclose
fileerr:
	mov dx, offset FERROR
	jmp showerr
createrr:
	mov dx, offset CERROR
quitclose:
	Mov ah, 3eh 
	int 21h
showerr:
	mov ah, 09h
	int 21h
bye:
	mov ax, 4C01h
	int 21h


TXTUSG 	db 'VGA font to WordPerfect Underline font converter (c) DI(FH) Ludwig Ertl 2015',13,10,13,10
	db 'Usage: crund <Font-Dump> <vgaund.frs>',13,10,13,10
	db '<Font-Dump> - Name of font file previously dumped with savefont',13,10,'$'
FERROR	db "Cannot open file!$"
CERROR	db "Cannot create file!$"
RERROR	db "Error reading file$"
WERROR	db "Error writing file$"
BUFFER  db 4096 dup(?)

Code ends
End start
