.model tiny
Code segment

assume cs:code	; We compile to .com, so only a code-segment available
Org 100h

; Here we go -----------------------------------[EIP]----------------------------------
start:

; --- Parse commandline
	xor ch, ch
	mov cl, es:[80h]	; Get command line length
	mov si, 81h		; Parse command line string
	lea di, BUFFER		; ..into buffer
blank1:
	lodsb
	cmp al,' '
	loope blank1		; Skip first blanks
	jz usage		; No parameters = Error
	test cx, cx
	jz eocl
argv1:
	stosb
	lodsb
	cmp al,' '
	loopne argv1		; Skip to second parameter or end of cmdline
	jz usage		; Second parameter is not allowed
eocl:
	stosb
	xor al,al
	stosb			; NULL-Terminate filename

; --- Open file
	mov ah, 3Ch
	mov dx, offset BUFFER
	xor cx, cx
	int 21h
	jb  fileerr
        mov bx, ax
	jmp openok

; --- Error handling (near)
fileerr:
	mov dx, offset FERROR
	jmp showerr
usage:
	mov dx, offset TXTUSG
showerr:
	mov ah, 09h
	int 21h
	mov ax, 4C01h
	int 21h
exit:
	mov ax, 4C00h
	int 21h

openok:
; --- Map VGA Font area
	cli
	mov dx, 03C4h		; VGA Sequence Register
	mov ax, 0402h		; Enable writing to Color Plane 2
	out dx, ax
	mov ax, 0704h		; Enable sequential memory access and extended mem
	out dx, ax
	mov dl, 0CEh		; Graphics controller address Register
	mov ax, 0005h		; Direct write
	out dx, ax
	mov ax, 0406h		; Plane 2 color don't care
	out dx, ax
	mov ax, 0204h		; Select read Plane 2
	out dx, ax
	sti

; --- Copy character map from mapped area to buffer
	push ds
	pop es
	lea di, BUFFER		; Destination is ds:BuFFER
	mov ax, 0A000h
	mov ds, ax
	xor si, si		; Source is A000:0000
	mov cx, 256		; 256 characters
	cld
@b:	movsw			; copy 16 bytes to bitmap
	movsw
	movsw
	movsw
	movsw
	movsw
	movsw
	movsw
	add si, 16		; skip another 16 bytes
	loop @b
	push es
	pop ds			; Restore ds

; --- Unmap memory area with font
	cli
	mov dx, 03C4h		; VGA Sequence Register
	mov ax, 0302h		; Plane 0+1 write enable
	out dx, ax
	mov ax, 0304h		; Enable extended memory mode
	out dx, ax
	mov dl, 0CEh		; Graphics controller address Register
	mov ax, 1005h		; Odd/even mode
	out dx, ax
	mov ax, 0004h		; Unselect planes for reading
	out dx, ax
        mov ah, 0Fh		; Get current video mode
        int 10h			; BIOS-call
        cmp al, 7		; Monochrome mode 7 is different!
        jne @skip
        mov ax, 0A06h		; Odd/even (text mode) @ B000h (Monochrome area)
	jmp @cont
@skip:	mov ax,0E06h		; Odd/even (text mode) @ B800h
@cont:  out dx,ax
	sti

; --- Save filled buffer to file
        mov cx, 01000H
        lea dx, BUFFER
	mov ah, 40h
	int 21h
	Mov ah, 3eh
	jb writeerr
	Int 21h

; --- Exit gracefully
	mov ax, 4C00h
	int 21h

; --- Error handling (near)
writeerr:
	Int 21h
	Mov dx, offset WERROR
	jmp showerr

TXTUSG 	db 'VGA Font saver V1.0 (c) DI(FH) Ludwig Ertl 2015',13,10,13,10
	db 'Usage: savefont <Filename>',13,10,13,10
	db '<Filename> - Name of font file to dump font to',13,10,'$'
FERROR	db "Cannot create file!$"
WERROR	db "Error writing to file$"
BUFFER  db 4096 dup(?)

Code ends
End start
