;------------------------------------------------------------
;  Copyright (C) 1987 WordPerfect Corp., All Rights Reserved
;------------------------------------------------------------

DATASEG	SEGMENT	BYTE PUBLIC 'DATA'

;*************************************
;The following is the WP character map for the extended 256 characters.
;There are 2 sections to this map.  The first half is the sorted list of WP
;characters.  The second half is the list of corresponding SCREEN characters.
;A binary search is done on the first half of this table.  If the WP
;character is found, it's offset in the first half is used to index
;into the second half of the table.
;These WP chars MUST be in sorted order.
;The SCREEN characters MUST correspond to these.  That means the first
;character of the WP table is going to be displayed using the first character
;of the SCREEN table.
;*************************************

;*************************************
;The following word is the number of enties in the table.
;*************************************
chars2	dw chmap_sz2

char_map2	label	word	;character map for second 256 characters

;multinational 1

	dw 0117h		;german double s
	dw 011ah		;A acute
	dw 011ch		;A circumflex
	dw 0120h		;A grave
	dw 012ah		;E circumflex
	dw 012ch		;E umlaut
	dw 012eh		;E grave
	dw 0130h		;I acute
	dw 0132h		;I circumflex
	dw 0134h		;I umlaut
	dw 0136h		;I grave
	dw 013ah		;O acute
	dw 013ch		;O circumflex
	dw 0140h		;O grave
	dw 0142h		;U acute
	dw 0144h		;U circumflex
	dw 0148h		;U grave
	dw 014ah		;Y umlaut
	dw 014ch		;A tilde
	dw 014dh		;a tilde
	dw 014eh		;D cross bar
	dw 014fh		;d cross bar
	dw 0150h		;O slash
	dw 0151h		;o slash
	dw 0152h		;O tilde
	dw 0153h		;o tilde
	dw 0154h		;Y acute   
	dw 0155h		;y acute   
	dw 0156h		;uppercase Eth
	dw 0157h		;lowercase eth
	dw 0158h		;lowercase thorn
	dw 0159h		;uppercase thorn
	dw 015ah		;A breve
	dw 015bh		;a breve
	dw 015ch		;A macron
	dw 015dh		;a macron
	dw 015eh		;A ogonek
	dw 015fh		;a ogonek
	dw 0160h		;C acute
	dw 0161h		;c acute
	dw 0162h		;C caron
	dw 0163h		;c caron
	dw 0164h		;C circumflex
	dw 0165h		;c circumflex
	dw 0166h		;C dot above
	dw 0167h		;c dot above
	dw 0168h		;D caron
	dw 0169h		;d caron
	dw 016ah		;E caron
	dw 016bh		;e caron
	dw 016ch		;E dot above
	dw 016dh		;e dot above
	dw 016eh		;E macron
	dw 016fh		;e macron
	dw 0170h		;E ogonek
	dw 0171h		;e ogonek
	dw 0172h		;G acute
	dw 0173h		;g acute
	dw 0174h		;G breve
	dw 0175h		;g breve
	dw 0176h		;G caron
	dw 0177h		;g caron
	dw 0178h		;G cedilla
	dw 0179h		;g cedilla
	dw 017ah		;G circumflex
	dw 017bh		;g circumflex
	dw 017ch		;G dot above
	dw 017dh		;g dot above
	dw 017eh		;H circumflex
	dw 017fh		;h circumflex
	dw 0180h		;H cross bar
	dw 0181h		;h cross bar
	dw 0182h		;I dot above
	dw 0184h		;I macron
	dw 0185h		;i macron
	dw 0186h		;I ogonek
	dw 0187h		;i ogonek
	dw 0188h		;I tilde
	dw 0189h		;i tilde
	dw 018ah		;IJ digraph
	dw 018bh		;ij digraph
	dw 018ch		;J circumflex
	dw 018dh		;j circumflex
	dw 018eh		;K cedilla
	dw 018fh		;k cedilla
	dw 0190h		;L acute
	dw 0191h		;l acute
	dw 0192h		;L caron
	dw 0193h		;l caron
	dw 0194h		;L cedilla
	dw 0195h		;l cedilla
	dw 0196h		;L center dot
	dw 0197h		;l center dot
	dw 0198h		;L stroke
	dw 0199h		;l stroke
	dw 019ah		;N acute
	dw 019bh		;n acute
	dw 019dh		;n apostrophe
	dw 019eh		;N caron
	dw 019fh		;n caron
	dw 01a0h		;N cedilla
	dw 01a1h		;n cedilla
	dw 01a2h		;O double acute
	dw 01a3h		;o double acute
	dw 01a4h		;O macron
	dw 01a5h		;o macron
	dw 01a6h		;OE digraph
	dw 01a7h		;oe digraph
	dw 01a8h		;R acute
	dw 01a9h		;r acute
	dw 01aah		;R caron
	dw 01abh		;r caron
	dw 01ach		;R cedilla
	dw 01adh		;r cedilla
	dw 01aeh		;S acute
	dw 01afh		;s acute
	dw 01b0h		;S caron
	dw 01b1h		;s caron
	dw 01b2h		;S cedilla
	dw 01b3h		;s cedilla
	dw 01b4h		;S circumflex
	dw 01b5h		;s circumflex
	dw 01b6h		;T caron
	dw 01b7h		;t caron
	dw 01b8h		;T cedilla
	dw 01b9h		;t cedilla
	dw 01bah		;T cross bar
	dw 01bbh		;t cross bar
	dw 01bch		;U breve
	dw 01bdh		;u breve
	dw 01beh		;U double acute
	dw 01bfh		;u double acute
	dw 01c0h		;U macron
	dw 01c1h		;u macron
	dw 01c2h		;U ogonek
	dw 01c3h		;u ogonek
	dw 01c4h		;U ring
	dw 01c5h		;u ring
	dw 01c6h		;U tilde
	dw 01c7h		;u tilde
	dw 01c8h		;W circumflex
	dw 01c9h		;w circumflex
	dw 01cah		;Y circumflex
	dw 01cbh		;y circumflex
	dw 01cch		;Z acute
	dw 01cdh		;z acute
	dw 01ceh		;Z caron
	dw 01cfh		;z caron
	dw 01d0h		;Z dot above
	dw 01d1h		;z dot above
	dw 01d2h		;uppercase Eng
	dw 01d3h		;lowercase eng

;multinational 2

	dw 0208h		;icelandic k

;line draw

	dw 0334h			;LEFT
	dw 0335h			;TOP
	dw 0336h			;RIGHT
	dw 0337h			;BOTTOM

;mchsbus	;Business Symbols

	dw 0416h		;register sign
	dw 0417h		;copyright sign
	dw 0418h		;general currency symbol
	dw 0419h		;3/4
	dw 041ah		;power of 3
	dw 041fh		;Double Quotes (99)
	dw 0420h		;Double Quotes (66)
	dw 0427h		;Dagger
	dw 0428h		;Double Dagger
	dw 0429h		;trademark sign
	dw 042ah		;servicemark sign
	dw 042bh		;Perscription (Rx)
	dw 0438h		;Ellipsis
	dw 043fh		;Baseline Double Quotes (99)

;mchsmath	;Math

	dw 0621h		;small circle
	dw 0628h		;integral
	dw 0629h		;product
	dw 062ah		;minus or plus
	dw 062bh		;nabla gradient
	dw 062ch		;partial derivative
	dw 0631h		;liter - script ell
	dw 0632h		;planck's constant
	dw 0633h		;Ifraktur
	dw 0634h		;Rfraktur
	dw 0636h		;right and left arrows
	dw 0638h		;double arrow right - implies
	dw 0639h		;double arrow left - is implied by
	dw 063ah		;double arrow up
	dw 063bh		;double arrow down
	dw 063ch		;double arrow left and right - iff
	dw 063dh		;double arrow up and down
	dw 063eh		;northeast arrow
	dw 063fh		;southeast arrow
	dw 0640h		;northwest arrow
	dw 0641h		;southwest arrow
	dw 0642h		;union
	dw 0643h		;proper subset
	dw 0644h		;proper superset
	dw 0645h		;reflex subset - contained in or equal
	dw 0646h		;reflex superset-contains or equal
	dw 0647h		;such that - contains as a member
	dw 0648h		;empty set
	dw 0649h		;Left Ceiling
	dw 064ah		;Right Ceiling
	dw 064bh		;Left Floor
	dw 064ch		;Right Floor
	dw 0650h		;circle multiply
	dw 0651h		;circle plus
	dw 0652h		;circle minus
	dw 0653h		;circle divide
	dw 0654h		;circle dot
	dw 0655h		;logical and
	dw 0656h		;logical or
	dw 0657h		;exclusive or
	dw 0658h		;top - perpendicular
	dw 0659h		;bottom
	dw 065bh		;assertion sign
	dw 065ch		;mirrored assertion
	dw 065dh		;square (shape)
	dw 0663h		;not equal to
	dw 0664h		;not equivalent
	dw 0665h		;because
	dw 0666h		;therefore
	dw 0667h		;identical 
	dw 0668h		;contour integral
	dw 066eh		;defined as
	dw 0673h		;similar or equal
	dw 0679h		;there exists
	dw 067ah		;universal - for all
	dw 06c7h		;not reflex subset
	dw 06c8h		;not reflex superset
	dw 06d1h		;not an element

;math extension

	dw 0700h		;Integral [Top]
	dw 0701h		;Integral [Bottom]
	dw 0703h		;Horizontal Baseline Bar [Extender]
	dw 0719h		;Left Brace [Top]
	dw 071ah		;Left Brace [Middle]
	dw 071bh		;Left Brace [Bottom]
	dw 0721h		;Right Brace [Top]
	dw 0722h		;Right Brace [Middle]
	dw 0723h		;Right Brace [Bottom]
	dw 0729h		;Left Floor [Bottom]
	dw 072fh		;Right Floor [Bottom]
	dw 0735h		;Left Ceiling [Top]
	dw 073bh		;Right Ceiling [Top]
	dw 073fh		;Contour Integral [Middle]
	dw 0768h		;Left Parenthesis [Top]
	dw 0769h		;Left Parenthesis [Bottom]
	dw 076fh		;Right Parenthesis [Top]
	dw 0770h		;Right Parenthesis [Bottom]
	dw 0776h		;Left Bracket [Top]
	dw 0777h		;Left Bracket [Bottom]
	dw 077dh		;Right Bracket [Top]
	dw 077eh		;Right Bracket [Bottom]

;mchsgrek	;Greek

	dw 0807h		;lowercase gamma
	dw 0808h		;uppercase delta
	dw 080dh		;lowercase zeta
	dw 080fh		;lowercase eta
	dw 0811h		;lowercase theta
	dw 0813h		;lowercase iota
	dw 0815h		;lowercase kappa
	dw 0816h		;uppercase lambda
	dw 0817h		;lowercase lambda
	dw 081bh		;lowercase nu
	dw 081ch		;uppercase xi
	dw 081dh		;lowercase xi
	dw 0820h		;uppercase pi
	dw 0823h		;lowercase rho
	dw 0827h		;lowercase sigma (terminal)
	dw 082ah		;uppercase upsilon
	dw 082bh		;lowercase upsilon
	dw 082fh		;lowercase chi
	dw 0830h		;uppercase psi
	dw 0831h		;lowercase psi
	dw 0833h		;lowercase omega

;mchsheb	;Hebrew

	dw 0900h		;Hebrew aleph
	dw 0901h		;Hebrew veth
	dw 0902h		;Hebrew gimel

;Make sure we have 300 or fewer entries in the table.
;We are only garanteed that there will be room for 300 entries.
;if (number of words from chmap_mid to char_map2 > 300) then
;     Display an error

chmap_mid	label	byte

if (((chmap_mid - char_map2) / 2) GT 300)
  if2
    .err
    %out "You have too many entries"
  endif
endif

public	chmap_sz2
chmap_sz2	equ	($ - char_map2)/2


;*********************************************************************
;These are the screen characters that the above WP characters map to
;Notice that the first byte is always a 1.  This is because these
;characters are to be selected from the 2nd font.
;The second byte is the index in that font of the character.
;*********************************************************************

	dw 01aah		;german double s
	dw 0142h		;A acute
	dw 0169h		;A circumflex
	dw 0155h		;A grave
	dw 016ch		;E circumflex
	dw 0140h		;E umlaut
	dw 0156h		;E grave
	dw 0147h		;I acute
	dw 0171h		;I circumflex
	dw 013fh		;I umlaut
	dw 0157h		;I grave
	dw 014bh		;O acute
	dw 0174h		;O circumflex
	dw 0158h		;O grave
	dw 0150h		;U acute
	dw 0177h		;U circumflex
	dw 0159h		;U grave
	dw 013eh		;Y umlaut
	dw 017dh		;A tilde
	dw 017ch		;a tilde
	dw 01f1h		;D cross bar
	dw 01f0h		;d cross bar
	dw 01aeh		;O slash
	dw 01adh		;o slash
	dw 0181h		;O tilde
	dw 0180h		;o tilde
	dw 0152h		;Y acute   
	dw 0151h		;y acute   
	dw 01f1h		;uppercase Eth
	dw 019ch		;lowercase eth
	dw 01fbh		;lowercase thorn
	dw 01fah		;uppercase thorn
	dw 0185h		;A breve
	dw 0184h		;a breve
	dw 01e0h		;A macron
	dw 01deh		;a macron
	dw 01e9h		;A ogonek
	dw 01e8h		;a ogonek
	dw 0144h		;C acute
	dw 0143h		;c acute
	dw 018bh		;C caron
	dw 018ah		;c caron
	dw 016bh		;C circumflex
	dw 016ah		;c circumflex
	dw 0161h		;C dot above
	dw 0160h		;c dot above
	dw 018dh		;D caron
	dw 018ch		;d caron
	dw 018fh		;E caron
	dw 018eh		;e caron
	dw 0163h		;E dot above
	dw 0162h		;e dot above
	dw 01e1h		;E macron
	dw 01dfh		;e macron
	dw 01ebh		;E ogonek
	dw 01eah		;e ogonek
	dw 01B2h		;G acute
	dw 0145h		;g acute
	dw 0187h		;G breve
	dw 0186h		;g breve
	dw 01b3h		;G caron
	dw 01c1h		;g caron
	dw 019dh		;G cedilla
	dw 01B0h		;g cedilla
	dw 016eh		;G circumflex
	dw 016dh		;g circumflex
	dw 0165h		;G dot above
	dw 0164h		;g dot above
	dw 0170h		;H circumflex
	dw 016fh		;h circumflex
	dw 01f3h		;H cross bar
	dw 01f2h		;h cross bar
	dw 0166h		;I dot above
	dw 01e3h		;I macron
	dw 01e2h		;i macron
	dw 01edh		;I ogonek
	dw 01ech		;i ogonek
	dw 017fh		;I tilde
	dw 017eh		;i tilde
	dw 01ach		;IJ digraph
	dw 01abh		;ij digraph
	dw 0173h		;J circumflex
	dw 0172h		;j circumflex
	dw 019fh		;K cedilla
	dw 019eh		;k cedilla
	dw 0148h		;L acute
	dw 0146h		;l acute
	dw 0191h		;L caron
	dw 0190h		;l caron
	dw 01a1h		;L cedilla
	dw 01a0h		;l cedilla
	dw 01f9h		;L center dot
	dw 01f8h		;l center dot
	dw 01f7h		;L stroke
	dw 01f6h		;l stroke
	dw 014ah		;N acute
	dw 0149h		;n acute
	dw 01feh		;n apostrophe
	dw 0193h		;N caron
	dw 0192h		;n caron
	dw 01a3h		;N cedilla
	dw 01a2h		;n cedilla
	dw 015bh		;O double acute
	dw 015ah		;o double acute
	dw 01e5h		;O macron
	dw 01e4h		;o macron
	dw 011dh		;OE digraph
	dw 011ch		;oe digraph
	dw 014dh		;R acute
	dw 014ch		;r acute
	dw 0195h		;R caron
	dw 0194h		;r caron
	dw 01a5h		;R cedilla
	dw 01a4h		;r cedilla
	dw 014fh		;S acute
	dw 014eh		;s acute
	dw 0197h		;S caron
	dw 0196h		;s caron
	dw 01a7h		;S cedilla
	dw 01a6h		;s cedilla
	dw 0176h		;S circumflex
	dw 0175h		;s circumflex
	dw 0199h		;T caron
	dw 0198h		;t caron
	dw 01a9h		;T cedilla
	dw 01a8h		;t cedilla
	dw 01f5h		;T cross bar
	dw 01f4h		;t cross bar
	dw 0189h		;U breve
	dw 0188h		;u breve
	dw 015dh		;U double acute
	dw 015ch		;u double acute
	dw 01e7h		;U macron
	dw 01e6h		;u macron
	dw 01efh		;U ogonek
	dw 01eeh		;u ogonek
	dw 015fh		;U ring
	dw 015eh		;u ring
	dw 0183h		;U tilde
	dw 0182h		;u tilde
	dw 0179h		;W circumflex
	dw 0178h		;w circumflex
	dw 017bh		;Y circumflex
	dw 017ah		;y circumflex
	dw 0154h		;Z acute
	dw 0153h		;z acute
	dw 019bh		;Z caron
	dw 019ah		;z caron
	dw 0168h		;Z dot above
	dw 0167h		;z dot above
	dw 01fch		;uppercase Eng
	dw 01fdh		;lowercase eng

;multinational 2

	dw 0137h		;icelandic k

;line draw

	dw 01d3h		;double arrow right
	dw 01d1h		;double arrow down
	dw 01d2h		;double arrow left
	dw 01d0h		;double arrow up

;Business symbol

	dw 0103h		;register sign
	dw 0104h		;copyright sign
	dw 0105h		;general currency symbol
	dw 011bh		;3/4
	dw 011ah		;power of 3
	dw 01dbh		;Double Quotes (99)
	dw 01dah		;Double Quotes (66)
	dw 01c2h		;Dagger
	dw 01c3h		;Double Dagger
	dw 0102h		;trademark sign
	dw 0101h		;servicemark sign
	dw 0100h		;Perscription (Rx)
	dw 01dch		;Ellipsis
	dw 01c4h		;Baseline Double Quotes (99)

;math characters

	dw 01afh		;small circle
	dw 01c5h		;integral
	dw 0128h		;product
	dw 0116h		;minus or plus
	dw 0124h		;nabla gradient
	dw 01b4h		;partial derivative
	dw 013bh		;liter - script ell
	dw 01f2h		;planck's constant
	dw 0121h		;Ifraktur
	dw 0122h		;Rfraktur
	dw 010dh		;right and left arrows
	dw 01d3h		;double arrow right - implies
	dw 01d2h		;double arrow left - is implied by
	dw 01d0h		;double arrow up
	dw 01d1h		;double arrow down
	dw 010ch		;double arrow left and right - iff
	dw 010bh		;double arrow up and down
	dw 0110h		;northeast arrow
	dw 010fh		;southeast arrow
	dw 010eh		;northwest arrow
	dw 0111h		;southwest arrow
	dw 01c6h		;union
	dw 01c7h		;proper subset
	dw 01c8h		;proper superset
	dw 01cbh		;reflex subset - contained in or equal
	dw 01cch		;reflex superset-contains in or equal
	dw 01cdh		;such that - contains as a member
	dw 01aeh		;empty set
	dw 01b8h		;Left Ceiling
	dw 01b7h		;Right Ceiling
	dw 01bah		;Left Floor
	dw 01b9h		;Right Floor
	dw 0108h		;circle multiply
	dw 0106h		;circle plus
	dw 0109h		;circle minus
	dw 010ah		;circle divide
	dw 0107h		;circle dot
	dw 0141h		;logical and
	dw 01d5h		;logical or
	dw 01d6h		;exclusive or
	dw 0112h		;top - perpendicular
	dw 0113h		;bottom
	dw 0114h		;assertion sign
	dw 0115h		;mirrored assertion
	dw 01d4h		;square (shape)
	dw 0118h		;not equal to
	dw 0119h		;not equivalent
	dw 01d8h		;because
	dw 01d7h		;therefore
	dw 01d9h		;identical 
	dw 013dh		;contour integral
	dw 0125h		;defined as
	dw 0117h		;similar or equal
	dw 01cfh		;there exists
	dw 0123h		;universal - for all
	dw 01c9h		;not reflex subset
	dw 01cah		;not reflex superset
	dw 01ceh		;not an element

;math extension

	dw 01bch		;Integral [Top]
	dw 01bdh		;Integral [Bottom]
	dw 01dch		;Horizontal Baseline Bar [Extender]
	dw 01bch		;Left Brace [Top]
	dw 01bfh		;Left Brace [Middle]
	dw 01beh		;Left Brace [Bottom]
	dw 01bbh		;Right Brace [Top]
	dw 01c0h		;Right Brace [Middle]
	dw 01bdh		;Right Brace [Bottom]
	dw 01bah		;Left Floor [Bottom]
	dw 01b9h		;Right Floor [Bottom]
	dw 01b8h		;Left Ceiling [Top]
	dw 01b7h		;Right Ceiling [Top]
	dw 01b6h		;Contour Integral [Middle]
	dw 01bch		;Left Parenthesis [Top]
	dw 01beh		;Left Parenthesis [Bottom]
	dw 01bbh		;Right Parenthesis [Top]
	dw 01bdh		;Right Parenthesis [Bottom]
	dw 01b8h		;Left Bracket [Top]
	dw 01bah		;Left Bracket [Bottom]
	dw 01b7h		;Right Bracket [Top]
	dw 01b9h		;Right Bracket [Bottom]

;Greek characters

	dw 012ch		;lowercase gamma
	dw 0126h		;uppercase delta
	dw 0136h		;lowercase zeta
	dw 012dh		;lowercase eta
	dw 01ddh		;lowercase theta
	dw 012eh		;lowercase iota
	dw 012fh		;lowercase kappa
	dw 0127h		;uppercase lambda
	dw 0130h		;lowercase lambda
	dw 0131h		;lowercase nu
	dw 0129h		;uppercase xi
	dw 0135h		;lowercase xi
	dw 0128h		;uppercase pi
	dw 0132h		;lowercase rho
	dw 013ah		;lowercase sigma (terminal)
	dw 0133h		;uppercase upsilon
	dw 0138h		;lowercase upsilon
	dw 013ch		;lowercase chi
	dw 012ah		;uppercase psi
	dw 0139h		;lowercase psi
	dw 0134h		;lowercase omega

;Hebrew characters

	dw 011eh		;Hebrew aleph
	dw 011fh		;Hebrew veth
	dw 012bh		;Hebrew gimel

;Make sure we have the same number of entries in the 2nd half as we do in
;the 1st half.

if chmap_sz2 - ($ - char_map2)/4
  if2
    .err
    %out "The two halves of the character map are not the same length"
  endif
endif

DATASEG	ENDS
END
