                         /* * * * * * * * * */
                         /* Control Styles. */
                         /* * * * * * * * * */

#define DBM_STYLE_FIRST			(WS_VISIBLE | WS_GROUP)
#define DBM_STYLE_GROUP         	(WS_VISIBLE)
#define DBM_STYLE_SINGLE        	(WS_VISIBLE | WS_GROUP | WS_TABSTOP)
#define DBM_STYLE_GROUPBOX      	(WS_VISIBLE | WS_GROUP)
#define DBM_STYLE_TEXT          	(WS_VISIBLE | WS_GROUP)
#define DBM_STYLE_STATIC        	(WS_VISIBLE | WS_GROUP)
#define DBM_STYLE_HORIZLINE     	(WS_VISIBLE | WS_GROUP | SS_GRAYRECT)
#define DBM_STYLE_VERTLINE      	(WS_VISIBLE | WS_GROUP | SS_GRAYRECT)
#define DBM_STYLE_HIERARCHYTEXT 	(WS_VISIBLE | WS_GROUP | SS_TEXT | DT_LEFT  | DT_TOP | DT_MNEMONIC)
#define DBM_STYLE_EXCLUDEDRTTEXT  	(WS_VISIBLE | WS_GROUP | SS_TEXT | DT_RIGHT | DT_TOP)
#define DBM_STYLE_EXCLUDEDTEXT  	(WS_VISIBLE | WS_GROUP | SS_TEXT | DT_LEFT  | DT_TOP)
#define DBM_STYLE_PUSHBUTTON    	(WS_VISIBLE | WS_GROUP | WS_TABSTOP | BS_PUSHBUTTON)
#define DBM_STYLE_FIRSTRADIO    	(WS_VISIBLE | WS_GROUP | BS_AUTORADIOBUTTON)
#define DBM_STYLE_INNERRADIO    	(WS_VISIBLE | BS_AUTORADIOBUTTON)
#define DBM_STYLE_ENTRYFIELD    	(WS_VISIBLE | WS_GROUP | WS_TABSTOP | ES_LEFT | ES_MARGIN | ES_AUTOSCROLL)


/* The following can be used as style flags on a group box to get  */
/* DBM to position it in other than the default (centered) manner. */

#define	DBM_GBOX_LEFTTEXT 			(BS_LEFTTEXT)
#define	DBM_GBOX_RIGHTTEXT			(0x40L)




                        /* * * * * * * * * * */
                        /* Custom controls.  */
                        /* * * * * * * * * * */

/* The following macros define the class names for the DBM supplied */
/* group box, recessed box, shadow box and static controls.         */

#define	DBM_WC_GROUPBOX_WP			"DBM_WPgroupboxWP"
#define	DBM_WC_RECESSEDBOX_WP			"DBM_WPrecessedboxWP"
#define	DBM_WC_SHADOWBOX_WP			"DBM_WPshadowboxWP"


/* The following macros can be used within a dialog box to provide */
/* a "Sculptured" looking line.                                    */

#define	DBM_SCULPTURED_HBAR_CLASS	"DBM_HBar"
#define	DBM_SCULPTURED_VBAR_CLASS	"DBM_VBar"

#define DBM_SCULPTURED_HBAR_STYLE	(WS_GROUP | WS_VISIBLE | WS_CHILD)
#define DBM_SCULPTURED_VBAR_STYLE	(WS_GROUP | WS_VISIBLE | WS_CHILD)

#define	DBM_SCULPTURED_HBAR_SZ		2 /* These is included for the macro below.   */
#define	DBM_SCULPTURED_VBAR_SZ		2 /* Changing these will have no effect on    */
					  /* your sculptured lines in the dialog box. */


#define	DBM_SCULPTURED_HBAR(nID, nX, nY, nCX)		\
	CONTROL 					\
		"", 					\
		nID,					\
		DBM_SCULPTURED_HBAR_CLASS,		\
		DBM_SCULPTURED_HBAR_STYLE,		\
		nX, nY, nCX, DBM_SCULPTURED_HBAR_SZ

#define	DBM_SCULPTURED_VBAR(nID, nX, nY, nCY)		\
	CONTROL 					\
		"",                      		\
		nID,					\
		DBM_SCULPTURED_VBAR_CLASS,		\
		DBM_SCULPTURED_VBAR_STYLE,		\
		nX, nY, DBM_SCULPTURED_VBAR_SZ, nCY




/* The following defines the window class names of the supported */
/* types of popup (and popdown) controls.                        */

/* With keyboard I/F. */

#define	DBM_POPDOWN_CONTROL			"DBM_PopDown"
#define	DBM_POPUP_CONTROL			"DBM_Popup"

#define	DBM_ICON_POPDOWN_CONTROL		"DBM_PopDownICON"
#define	DBM_ICON_POPUP_CONTROL			"DBM_PopupICON"

/* Without keyboard I/F. */

#define	DBM_WP_POPDOWN_COMBO			"DBM_WPPopdownCombo"
#define	DBM_WP_POPDOWN_CONTROL			"DBM_WPPopDown"
#define	DBM_WP_POPUP_CONTROL			"DBM_WPPopup"
#define	DBM_WP_ICON_POPDOWN_CONTROL		"DBM_WPPopDownICON"
#define	DBM_WP_ICON_POPUP_CONTROL		"DBM_WPPopupICON"


/* The following macros define the window classes used in name */
/* search list boxes.                                          */

#define DBM_WP_NAMESEARCH_LISTBOX		"DBM_WPNameSearchListBox"
#define DBM_WP_NAMESEARCH_LISTBOX_POPUP		"DBM_WPNameSearchListBoxPopup"


/* The following macros can be used within a dialog box to provide */
/* an DBM "Status Bar" control.                                    */

#define	IDSBAR			(0x0003)
#define	DBM_SBAR_CLASS		"DBM_Sbar"
#define DBM_SBAR_STYLE		(WS_GROUP | WS_VISIBLE | WS_CHILD)


/* The following macro is used to define a "Status Bar" control   */
/* within a dialog box.  All information about sizing the control */
/* is determined by the control when it's created.                */


#define	DBM_SBAR_CONTROL(szText, usMoreStyles)		\
	CONTROL 					\
		szText, 				\
		IDSBAR,					\
		DBM_SBAR_CLASS,				\
		DBM_SBAR_STYLE | (usMoreStyles),	\
		0, 0, 0, 0




              /* * * * * * * * * * * * * * * * * * * * */
              /* Misc. Manifest Constant Definitions.  */
              /* * * * * * * * * * * * * * * * * * * * */

/* The following flags are used as the 'Positioning' flags passed to */
/* the DBMPositionWindow API.  They can be OR'ed together to achieve */
/* various results.                                                  */


#define	DBMPOS_FROMDLG			0x0000	/* Use settings in .DLG file. */

#define	DBMPOS_LEFT			0x0001	/* Left edge of relative. */
#define	DBMPOS_RIGHT			0x0002	/* Right edge of relative. */
#define	DBMPOS_CENTER			0x0003	/* Horizontal center of relative. */

#define	DBMPOS_TOP			0x0004	/* Top edge of relative.  */
#define	DBMPOS_BOTTOM			0x0008	/* Bottom edge of relative. */
#define	DBMPOS_VCENTER			0x000c	/* Vertical center of relative. */

#define	DBMPOS_FULL_CENTER		0x000f	/* Horizontal and vertical center */
						/* of relative. */



                     /* * * * * * * * * * * * * */
                     /* Misc. Type Definitions. */
                     /* * * * * * * * * * * * * */

/* The following are the typdefs for the 'Callback' routine used */
/* by an DBM status bar window.                                  */

typedef VOID (FAR PASCAL DBM_SBAR_PAINT_PROC) (HWND, HDC, LPRECT);
typedef DBM_SBAR_PAINT_PROC FAR *LPDBM_SBAR_PAINT_PROC;



                      /* * * * * * * * * * * * */
                      /* Version Definitions.  */
                      /* * * * * * * * * * * * */

/* The following macros are used to build and access the version */
/* information used by DBM.                                      */

#define	DBM_MAKEVERSION(ucMajor, ucMinor)				\
	((WORD)(((WORD)ucMajor & 0xff) + (((WORD)ucMinor & 0xff) << 8)))

#define	DBM_GETMAJOR(usVersion)		((WORD)LOBYTE (usVersion))
#define	DBM_GETMINOR(usVersion)		((WORD)HIBYTE (usVersion))


/* The following macro defines the current version of DBM (1.0). */

#define	DBM_MAJOR_VERSION			1
#define	DBM_MINOR_VERSION			0

#define	DBM_VERSION	(			\
	DBM_MAKEVERSION (			\
			DBM_MAJOR_VERSION,	\
			DBM_MINOR_VERSION))	\




                   /* * * * * * * * * * * * * * * */
                   /* Popup Message Definitions.  */
                   /* * * * * * * * * * * * * * * */

/* The following defines the base of the internal messages passed */
/* between a popup control and its parent.                        */

#define	DBM_POPM_BASE				(WM_USER + 0x1000)
#define	DBM_POPN_BASE				(WM_USER + 0x1100)


/* The following messages can be sent to a "Popup" control. */

#define	DBM_POPM_BUTTON_GLYPH			(DBM_POPM_BASE + 0)
#define	DBM_POPM_ENABLE				(DBM_POPM_BASE + 1)
#define	DBM_POPM_SETBBITMAP			(DBM_POPM_BASE + 2)
#define	DBM_POPM_SETBSTRING			(DBM_POPM_BASE + 3)
#define	DBM_POPM_SETFOCUS			(DBM_POPM_BASE + 4)
#define	DBM_POPM_SHOW_GLYPH_ONLY		(DBM_POPM_BASE + 5)


                /* * * * * * * * * * * * * * * * * * */
                /* Popup 'Extra Space' Definitions.  */
                /* * * * * * * * * * * * * * * * * * */

/* The following defines the window extra space and layout of it for */
/* the edit/popdown combo control.                                   */

#define	DBM_POPDOWN_COMBO_EXTRA			8
#define	DBM_POPDOWN_COMBO_EDIT			0	/* 2 bytes. */
#define	DBM_POPDOWN_COMBO_POPDOWN		2	/* 2 bytes. */
#define	DBM_POPDOWN_COMBO_EDIT_PROC		4	/* 4 bytes. */


/* The following macros provide access to the window extra space for */
/* the edit/popdown combo control.                                   */

#define	GET_POPDOWN_COMBO_EDIT(hPDownCombo)		\
		(GetWindowWord (hPDownCombo, DBM_POPDOWN_COMBO_EDIT))

#define	GET_POPDOWN_COMBO_EDIT_PROC(hPDownCombo) 	\
		((FARPROC)(GetWindowLong (hPDownCombo, DBM_POPDOWN_COMBO_EDIT_PROC)))

#define	GET_POPDOWN_COMBO_POPDOWN(hPDownCombo)		\
		(GetWindowWord (hPDownCombo, DBM_POPDOWN_COMBO_POPDOWN))

#define	SET_POPDOWN_COMBO_EDIT(hPDownCombo, hEdit)	\
		(SetWindowWord (hPDownCombo, DBM_POPDOWN_COMBO_EDIT, (WORD)(hEdit)))

#define	SET_POPDOWN_COMBO_EDIT_PROC(hPDownCombo, lpfn)	\
		((FARPROC)(SetWindowLong (hPDownCombo, DBM_POPDOWN_COMBO_EDIT_PROC, (LONG)(lpfn))))

#define	SET_POPDOWN_COMBO_POPDOWN(hPDownCombo, hPDown)	\
		(SetWindowWord (hPDownCombo, DBM_POPDOWN_COMBO_POPDOWN, (WORD)(hPDown)))




                 /* * * * * * * * * * * * * * * * * */
                 /* Edit/PopDown Combo Definitions. */
                 /* * * * * * * * * * * * * * * * * */

/* The following defines the child IDs used for the edit control and */
/* popdown control children of an edit/popdown combo control.        */

#define	DBM_POPDOWN_COMBO_EDIT_ID		3000
#define	DBM_POPDOWN_COMBO_POPDOWN_ID		3001


/* The following defines the distance between the edit control and */
/* popdown control portions of an edit/popdown combo control.      */

#define	DBM_POPDOWN_COMBO_SPLIT			4




                /* * * * * * * * * * * * * * * * * * */
                /* Name Search ListBox Definitions.  */
                /* * * * * * * * * * * * * * * * * * */

/* The following define is used to distinguish a name search list */
/* box comparison from an insertion comparison.			  */

#define DBM_ODT_NAMESEARCHLISTBOX 		5




                /*************************************/
		/*    Counter Control Information    */
		/*************************************/

#define	COUNTER_CLASS	"WPCcounter"

#define CNT_DISP_NORM		0	// normal (this is the default)
#define CNT_DISP_WPU		1	// same as normal but appends "w"
#define CNT_DISP_POINTS 	2
#define CNT_DISP_CM		3
#define CNT_DISP_INCHES 	4
#define CNT_DISP_PERCENT	5	// same as normal but appends "%"
#define CNT_DISP_INCHES2	6	// inches, but with no trailing zeroes
					//   or decimal point
#define CNT_DISP_I_INCHES	7	// inches, but with "i" instead of "\""


/* The following are messages that can be sent to the 'COUNTER_CLASS' control. */
#define	CNT_GETVALUE		(WM_USER + 903)
#define	CNT_SETSTEPVALUE	(WM_USER + 906)
#define	CNT_SETVALUE		(WM_USER + 907)
#define CNT_SETFORMAT		(WM_USER + 908)
